/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.relay;

import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import com.maxmind.geoip.regionName;
import jadex.base.relay.RelayHandler;
import jadex.platform.service.message.transport.httprelaymtp.RelayConnectionManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;

public class GeoIPService {
    protected static final GeoIPService singleton = new GeoIPService();
    protected LookupService ls;
    protected long lastupdate;

    public static GeoIPService getGeoIPService() {
        return singleton;
    }

    public String getLocation(String ip) {
        this.updateDB();
        String ret = null;
        if (this.ls != null) {
            try {
                Location loc = this.ls.getLocation(ip);
                if (loc != null) {
                    ret = loc.city;
                    String reg = regionName.regionNameByCode((String)loc.countryCode, (String)loc.region);
                    if (ret == null) {
                        ret = reg;
                    } else if (!ret.equals(reg)) {
                        ret = ret + ", " + reg;
                    }
                    if (ret == null) {
                        ret = loc.countryName;
                    } else if (loc.countryName != null && !loc.countryName.equals(loc.city) && !loc.countryName.equals(reg)) {
                        ret = ret + ", " + loc.countryName;
                    }
                }
            }
            catch (Exception e) {
                RelayHandler.getLogger().warning("Warning: Could not get Geo location: " + e);
            }
        }
        if (ret == null) {
            ret = "unknown";
        }
        return ret;
    }

    public String getCountryCode(String ip) {
        this.updateDB();
        String ret = null;
        if (this.ls != null) {
            try {
                Location loc = this.ls.getLocation(ip);
                if (loc != null) {
                    ret = loc.countryCode.toLowerCase();
                }
            }
            catch (Exception e) {
                RelayHandler.getLogger().warning("Warning: Could not get Geo location: " + e);
            }
        }
        return ret;
    }

    public String getPosition(String ip) {
        this.updateDB();
        String ret = null;
        if (this.ls != null) {
            try {
                Location loc = this.ls.getLocation(ip);
                if (loc != null) {
                    ret = loc.latitude + "," + loc.longitude;
                }
            }
            catch (Exception e) {
                RelayHandler.getLogger().warning("Warning: Could not get Geo location: " + e);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDB() {
        long update = System.currentTimeMillis();
        if (update - this.lastupdate > 43200000L) {
            GeoIPService geoIPService = this;
            synchronized (geoIPService) {
                if (update - this.lastupdate > 43200000L) {
                    this.lastupdate = update;
                    File dbfile = new File(RelayHandler.SYSTEMDIR, "GeoLiteCity.dat");
                    try {
                        URL url = new URL("http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz");
                        HttpURLConnection con = (HttpURLConnection)url.openConnection();
                        if (con.getLastModified() > dbfile.lastModified()) {
                            int read;
                            if (this.ls != null) {
                                this.ls.close();
                                this.ls = null;
                            }
                            File tmpfile = new File(dbfile.getParentFile(), "GeoLiteCity.dat.tmp");
                            GZIPInputStream is = new GZIPInputStream(con.getInputStream());
                            FileOutputStream os = new FileOutputStream(tmpfile);
                            byte[] buf = new byte[8192];
                            while ((read = ((InputStream)is).read(buf)) != -1) {
                                ((OutputStream)os).write(buf, 0, read);
                            }
                            ((OutputStream)os).close();
                            ((InputStream)is).close();
                            if (dbfile.exists()) {
                                File oldfile = new File(dbfile.getParentFile(), "GeoLiteCity.dat.old");
                                if (oldfile.exists() && !oldfile.delete()) {
                                    RelayHandler.getLogger().info("Cannot delete GeoIP database: " + oldfile);
                                }
                                if (!dbfile.renameTo(oldfile)) {
                                    RelayHandler.getLogger().info("Cannot rename old GeoIP database to: " + oldfile);
                                }
                            }
                            if (!tmpfile.renameTo(dbfile)) {
                                RelayHandler.getLogger().info("Cannot rename GeoIP database to: " + dbfile);
                            } else {
                                RelayHandler.getLogger().info("Downloaded GeoIP database to: " + dbfile);
                            }
                        }
                    }
                    catch (Exception e) {
                        RelayHandler.getLogger().warning("Warning: Relay could not access GeoIP database: " + e);
                    }
                    if (this.ls == null) {
                        try {
                            RelayHandler.getLogger().info("Using GeoIP database from: " + dbfile);
                            this.ls = new LookupService(dbfile.getAbsolutePath(), 1);
                        }
                        catch (Exception e) {
                            RelayHandler.getLogger().warning("Warning: Relay could not initialize GeoIP service: " + e);
                        }
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws MalformedURLException {
        String address = "relay-http://www2.activecomponents.org/relay";
        String host = new URL(RelayConnectionManager.httpAddress((String)address)).getHost();
        System.out.println(host + ": " + GeoIPService.getGeoIPService().getLocation(host));
    }
}

