/*
 * Decompiled with CFR 0.152.
 */
package jadex.bpmn.model.io;

import jadex.bpmn.model.MActivity;
import jadex.bpmn.model.MBpmnModel;
import jadex.bpmn.model.MContextVariable;
import jadex.bpmn.model.MDataEdge;
import jadex.bpmn.model.MLane;
import jadex.bpmn.model.MMessagingEdge;
import jadex.bpmn.model.MNamedIdElement;
import jadex.bpmn.model.MParameter;
import jadex.bpmn.model.MPool;
import jadex.bpmn.model.MProperty;
import jadex.bpmn.model.MSequenceEdge;
import jadex.bpmn.model.MSubProcess;
import jadex.bpmn.model.io.IBpmnVisualModelWriter;
import jadex.bridge.ClassInfo;
import jadex.bridge.modelinfo.ConfigurationInfo;
import jadex.bridge.modelinfo.IArgument;
import jadex.bridge.modelinfo.SubcomponentTypeInfo;
import jadex.bridge.modelinfo.UnparsedExpression;
import jadex.bridge.service.ProvidedServiceInfo;
import jadex.bridge.service.RequiredServiceInfo;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.collection.IndexMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SBpmnModelWriter {
    public static final int BUILD = 46;
    public static final String INDENT_STRING = "  ";
    public static final String START_EVENT_TAG = "startEvent";
    public static final String INTERMEDIATE_EVENT_TAG = "intermediate";
    public static final String END_EVENT_TAG = "endEvent";
    public static final Map<String, String> ACT_TYPE_MAPPING = new HashMap<String, String>();
    private static final String CR;
    private static final String LF;

    public static final void writeModel(File outputfile, MBpmnModel mmodel, IBpmnVisualModelWriter vmodelwriter) throws IOException {
        File file = File.createTempFile(outputfile.getName(), ".bpmn2");
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        SBpmnModelWriter.writeModel(os, mmodel, vmodelwriter);
        ((OutputStream)os).close();
        SUtil.moveFile((File)file, (File)outputfile);
    }

    public static final void writeModel(OutputStream os, MBpmnModel mmodel, IBpmnVisualModelWriter vmodelwriter) throws IOException {
        PrintStream out = new PrintStream(os, false, "UTF-8");
        SBpmnModelWriter.writeInitialBoilerPlate(out);
        int ind = 1;
        SBpmnModelWriter.writeJadexModelInfo(out, ind, mmodel);
        List<MPool> pools = mmodel.getPools();
        SBpmnModelWriter.writePoolSemantics(out, ind, pools);
        if (vmodelwriter != null) {
            vmodelwriter.writeVisualModel(out);
        }
        out.println("</semantic:definitions>");
        out.println();
        out.flush();
    }

    protected static final void writeInitialBoilerPlate(PrintStream out) {
        String indent = "                      ";
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        out.print("<semantic:definitions ");
        out.println("targetNamespace=\"http://www.activecomponents.org/bpmn/\"");
        out.print(indent);
        out.println("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        out.print(indent);
        out.println("xmlns:di=\"http://www.omg.org/spec/DD/20100524/DI\"");
        out.print(indent);
        out.println("xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\"");
        out.print(indent);
        out.println("xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\"");
        out.print(indent);
        out.println("xmlns:semantic=\"http://www.omg.org/spec/BPMN/20100524/MODEL\"");
        out.print(indent);
        out.println("xmlns:jadex=\"http://www.activecomponents.org/bpmnextensions\"");
        out.print(indent);
        out.println("xmlns:jadexvisual=\"http://www.activecomponents.org/bpmnvisualextensions\">");
    }

    protected static final void writeJadexModelInfo(PrintStream out, int ind, MBpmnModel mmodel) {
        String pkg;
        String desc;
        out.print(SBpmnModelWriter.getIndent(ind));
        out.println("<semantic:extension>");
        ++ind;
        String name = mmodel.getModelInfo().getName();
        if (name != null && name.length() > 0) {
            out.print(SBpmnModelWriter.getIndent(ind));
            out.print("<jadex:modelname>");
            out.print(SBpmnModelWriter.escapeString(name));
            out.println("</jadex:modelname>");
        }
        if ((desc = mmodel.getModelInfo().getDescription()) != null && desc.length() > 0) {
            out.print(SBpmnModelWriter.getIndent(ind));
            out.print("<jadex:description>");
            out.print(SBpmnModelWriter.escapeString(desc));
            out.println("</jadex:description>");
        }
        if ((pkg = mmodel.getModelInfo().getPackage()) != null && pkg.length() > 0) {
            out.print(SBpmnModelWriter.getIndent(ind));
            out.print("<jadex:package>");
            out.print(SBpmnModelWriter.escapeString(pkg));
            out.println("</jadex:package>");
        }
        boolean suspend = Boolean.TRUE.equals(mmodel.getModelInfo().getSuspend(null));
        boolean master = Boolean.TRUE.equals(mmodel.getModelInfo().getMaster(null));
        boolean daemon = Boolean.TRUE.equals(mmodel.getModelInfo().getDaemon(null));
        boolean autoshutdown = Boolean.TRUE.equals(mmodel.getModelInfo().getAutoShutdown(null));
        boolean synchronous = Boolean.TRUE.equals(mmodel.getModelInfo().getSynchronous(null));
        boolean persistable = Boolean.TRUE.equals(mmodel.getModelInfo().getPersistable(null));
        String monitoring = mmodel.getModelInfo().getMonitoring(null) != null ? mmodel.getModelInfo().getMonitoring(null).toString() : null;
        boolean keepalive = Boolean.TRUE.equals(mmodel.isKeepAlive());
        if (suspend || master || daemon || autoshutdown || monitoring != null || synchronous || keepalive) {
            out.print(SBpmnModelWriter.getIndent(ind));
            out.print("<jadex:componentflags suspend=\"");
            out.print(SBpmnModelWriter.escapeString(String.valueOf(suspend)));
            out.print("\" master=\"");
            out.print(SBpmnModelWriter.escapeString(String.valueOf(master)));
            out.print("\" daemon=\"");
            out.print(SBpmnModelWriter.escapeString(String.valueOf(daemon)));
            out.print("\" autoshutdown=\"");
            out.print(SBpmnModelWriter.escapeString(String.valueOf(autoshutdown)));
            out.print("\" synchronous=\"");
            out.print(SBpmnModelWriter.escapeString(String.valueOf(synchronous)));
            out.print("\" persistable=\"");
            out.print(SBpmnModelWriter.escapeString(String.valueOf(persistable)));
            if (monitoring != null) {
                out.print("\" monitoring=\"");
                out.print(SBpmnModelWriter.escapeString(String.valueOf(monitoring)));
            }
            out.print("\" keepalive=\"");
            out.print(SBpmnModelWriter.escapeString(String.valueOf(keepalive)));
            out.println("\"/>");
        }
        SBpmnModelWriter.writeImports(out, ind, mmodel.getModelInfo().getImports());
        SBpmnModelWriter.writeSubcomponents(out, ind, mmodel.getModelInfo().getSubcomponentTypes());
        SBpmnModelWriter.writeArguments(out, ind, false, mmodel.getModelInfo().getArguments());
        SBpmnModelWriter.writeArguments(out, ind, true, mmodel.getModelInfo().getResults());
        SBpmnModelWriter.writeContextVariables(out, ind, mmodel);
        SBpmnModelWriter.writeProvidedServices(out, ind, mmodel);
        SBpmnModelWriter.writeRequiredServices(out, ind, mmodel);
        SBpmnModelWriter.writeConfigurations(out, ind, mmodel, mmodel.getModelInfo().getConfigurations());
        out.print(SBpmnModelWriter.getIndent(--ind));
        out.println("</semantic:extension>");
    }

    protected static final void writeImports(PrintStream out, int ind, String[] imports) {
        if (imports.length > 0) {
            out.print(SBpmnModelWriter.getIndent(ind));
            out.println("<jadex:imports>");
            ++ind;
            for (int i = 0; i < imports.length; ++i) {
                out.print(SBpmnModelWriter.getIndent(ind));
                out.print("<jadex:import>");
                out.print(SBpmnModelWriter.escapeString(imports[i]));
                out.println("</jadex:import>");
            }
            out.print(SBpmnModelWriter.getIndent(--ind));
            out.println("</jadex:imports>");
        }
    }

    protected static final void writeSubcomponents(PrintStream out, int ind, SubcomponentTypeInfo[] scti) {
        if (scti.length > 0) {
            out.print(SBpmnModelWriter.getIndent(ind));
            out.println("<jadex:subcomponents>");
            ++ind;
            for (int i = 0; i < scti.length; ++i) {
                out.print(SBpmnModelWriter.getIndent(ind));
                out.print("<jadex:subcomponent name=\"");
                out.print(SBpmnModelWriter.escapeString(scti[i].getName()));
                out.print("\">");
                out.print(SBpmnModelWriter.escapeString(scti[i].getFilename()));
                out.println("</jadex:subcomponent>");
            }
            out.print(SBpmnModelWriter.getIndent(--ind));
            out.println("</jadex:subcomponents>");
        }
    }

    protected static final void writeArguments(PrintStream out, int ind, boolean results, IArgument[] args) {
        String prefix;
        String string = prefix = results ? "result" : "argument";
        if (args.length > 0) {
            out.print(SBpmnModelWriter.getIndent(ind));
            out.print("<jadex:");
            out.print(prefix);
            out.println("s>");
            ++ind;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].getName() == null || args[i].getName().length() <= 0) continue;
                IArgument arg = args[i];
                boolean hasdesc = arg.getDescription() != null && arg.getDescription().length() > 0;
                boolean hasval = arg.getDefaultValue() != null && arg.getDefaultValue().getValue() != null && arg.getDefaultValue().getValue().length() > 0;
                out.print(SBpmnModelWriter.getIndent(ind));
                out.print("<jadex:");
                out.print(prefix);
                out.print(" name=\"");
                out.print(SBpmnModelWriter.escapeString(arg.getName()));
                out.print("\" type=\"");
                String type = arg.getClazz() != null ? (arg.getClazz().getGenericTypeName() != null ? arg.getClazz().getGenericTypeName() : "") : "";
                out.print(SBpmnModelWriter.escapeString(type));
                if (hasdesc || hasval) {
                    out.println("\">");
                    ++ind;
                    if (hasdesc) {
                        out.print(SBpmnModelWriter.getIndent(ind));
                        out.print("<jadex:description>");
                        out.print(SBpmnModelWriter.escapeString(arg.getDescription()));
                        out.println("</jadex:description>");
                    }
                    if (hasval) {
                        out.print(SBpmnModelWriter.getIndent(ind));
                        out.print("<jadex:value>");
                        out.print(SBpmnModelWriter.escapeString(arg.getDefaultValue().getValue()));
                        out.println("</jadex:value>");
                    }
                    out.print(SBpmnModelWriter.getIndent(--ind));
                    out.print("</jadex:");
                    out.print(prefix);
                    out.println(">");
                    continue;
                }
                out.println("\"/>");
            }
            out.print(SBpmnModelWriter.getIndent(--ind));
            out.print("</jadex:");
            out.print(prefix);
            out.println("s>");
        }
    }

    protected static final void writeContextVariables(PrintStream out, int ind, MBpmnModel mmodel) {
        List<MContextVariable> ctvs = mmodel.getContextVariables();
        if (ctvs.size() > 0) {
            out.print(SBpmnModelWriter.getIndent(ind));
            out.println("<jadex:contextvariables>");
            ++ind;
            for (MContextVariable ctv : ctvs) {
                ClassInfo ci = ctv.getClazz();
                String cn = ci != null ? ci.getGenericTypeName() : "";
                out.print(SBpmnModelWriter.getIndent(ind));
                out.print("<jadex:contextvariable name=\"");
                out.print(SBpmnModelWriter.escapeString(ctv.getName()));
                out.print("\" type=\"");
                out.print(SBpmnModelWriter.escapeString(cn));
                if (ctv.getValue() != null && ctv.getValue().length() > 0) {
                    out.println("\">");
                    out.print(SBpmnModelWriter.getIndent(++ind));
                    out.print("<jadex:value>");
                    out.print(SBpmnModelWriter.escapeString(ctv.getValue()));
                    out.println("</jadex:value>");
                    out.print(SBpmnModelWriter.getIndent(--ind));
                    out.println("</jadex:contextvariable>");
                    continue;
                }
                out.println("\"/>");
            }
            out.print(SBpmnModelWriter.getIndent(--ind));
            out.println("</jadex:contextvariables>");
        }
    }

    protected static final void writeProvidedServices(PrintStream out, int ind, MBpmnModel mmodel) {
        ProvidedServiceInfo[] pss = mmodel.getModelInfo().getProvidedServices();
        if (pss != null && pss.length > 0) {
            out.print(SBpmnModelWriter.getIndent(ind));
            out.println("<jadex:providedservices>");
            ++ind;
            for (ProvidedServiceInfo ps : pss) {
                String iface;
                out.print(SBpmnModelWriter.getIndent(ind));
                out.print("<jadex:providedservice name=\"");
                out.print(SBpmnModelWriter.escapeString(ps.getName()));
                String string = iface = ps.getType() != null ? ps.getType().getGenericTypeName() : null;
                if (iface != null) {
                    out.print("\" interface=\"");
                    out.print(SBpmnModelWriter.escapeString(ps.getType().getGenericTypeName()));
                }
                if (ps.getImplementation() != null) {
                    String impl;
                    String proxytype;
                    ClassInfo implclass = ps.getImplementation().getClazz();
                    if (implclass != null && implclass.getGenericTypeName() != null && implclass.getGenericTypeName().length() > 0) {
                        out.print("\" class=\"");
                        out.print(SBpmnModelWriter.escapeString(implclass.getGenericTypeName()));
                    }
                    if ((proxytype = ps.getImplementation().getProxytype()) != null && proxytype.length() > 0) {
                        out.print("\" proxytype=\"");
                        out.print(SBpmnModelWriter.escapeString(proxytype));
                    }
                    if ((impl = ps.getImplementation().getValue()) != null && impl.length() > 0) {
                        out.print("\" implementation=\"");
                        out.print(SBpmnModelWriter.escapeString(impl));
                    }
                }
                out.println("\"/>");
            }
            out.print(SBpmnModelWriter.getIndent(--ind));
            out.println("</jadex:providedservices>");
        }
    }

    protected static final void writeRequiredServices(PrintStream out, int ind, MBpmnModel mmodel) {
        RequiredServiceInfo[] rss = mmodel.getModelInfo().getRequiredServices();
        if (rss != null && rss.length > 0) {
            out.print(SBpmnModelWriter.getIndent(ind));
            out.println("<jadex:requiredservices>");
            ++ind;
            for (RequiredServiceInfo rs : rss) {
                String iface;
                out.print(SBpmnModelWriter.getIndent(ind));
                out.print("<jadex:requiredservice name=\"");
                out.print(SBpmnModelWriter.escapeString(rs.getName()));
                String string = iface = rs.getType() != null ? rs.getType().getGenericTypeName() : null;
                if (iface != null) {
                    out.print("\" interface=\"");
                    out.print(SBpmnModelWriter.escapeString(iface));
                }
                if (rs.isMultiple()) {
                    out.print("\" multi=\"");
                    out.print(SBpmnModelWriter.escapeString(String.valueOf(rs.isMultiple())));
                }
                if (rs.getDefaultBinding() != null) {
                    String scope = rs.getDefaultBinding().getScope();
                    if (scope != null && scope.length() > 0) {
                        out.print("\" scope=\"");
                        out.print(SBpmnModelWriter.escapeString(scope));
                    }
                    boolean dyn = rs.getDefaultBinding().isDynamic();
                    out.print("\" dynamic=\"");
                    out.print(dyn);
                    boolean create = rs.getDefaultBinding().isCreate();
                    out.print("\" create=\"");
                    out.print(create);
                }
                out.println("\"/>");
            }
            out.print(SBpmnModelWriter.getIndent(--ind));
            out.println("</jadex:requiredservices>");
        }
    }

    protected static final void writeConfigurations(PrintStream out, int ind, MBpmnModel mmodel, ConfigurationInfo[] configurations) {
        if (configurations.length > 0) {
            List<MContextVariable> ctvs = mmodel.getContextVariables();
            HashMap<String, HashMap<String, String>> ctvconfexp = new HashMap<String, HashMap<String, String>>();
            for (MContextVariable ctv : ctvs) {
                for (int i = 0; i < configurations.length; ++i) {
                    UnparsedExpression cexp = ctv.getConfigValue(configurations[i].getName());
                    if (cexp == null || cexp.getValue() == null || cexp.getValue().length() <= 0) continue;
                    HashMap<String, String> confctvs = (HashMap<String, String>)ctvconfexp.get(configurations[i].getName());
                    if (confctvs == null) {
                        confctvs = new HashMap<String, String>();
                        ctvconfexp.put(configurations[i].getName(), confctvs);
                    }
                    confctvs.put(ctv.getName(), cexp.getValue());
                }
            }
            out.print(SBpmnModelWriter.getIndent(ind));
            out.println("<jadex:configurations>");
            ++ind;
            for (int i = 0; i < configurations.length; ++i) {
                RequiredServiceInfo[] rss;
                ProvidedServiceInfo[] pss;
                UnparsedExpression[] res;
                List<MNamedIdElement> startelements;
                ConfigurationInfo conf = configurations[i];
                out.print(SBpmnModelWriter.getIndent(ind));
                out.print("<jadex:configuration name=\"");
                out.print(SBpmnModelWriter.escapeString(conf.getName()));
                out.print("\"");
                if (conf.getSuspend() != null) {
                    out.print(" suspend=\"");
                    out.print(conf.getSuspend());
                    out.print("\"");
                }
                if (conf.getMaster() != null) {
                    out.print(" master=\"");
                    out.print(conf.getMaster());
                    out.print("\"");
                }
                if (conf.getDaemon() != null) {
                    out.print(" daemon=\"");
                    out.print(conf.getDaemon());
                    out.print("\"");
                }
                if (conf.getAutoShutdown() != null) {
                    out.print(" autoshutdown=\"");
                    out.print(conf.getAutoShutdown());
                    out.print("\"");
                }
                if (conf.getSynchronous() != null) {
                    out.print(" synchronous=\"");
                    out.print(conf.getSynchronous());
                    out.print("\"");
                }
                if (conf.getPersistable() != null) {
                    out.print(" persistable=\"");
                    out.print(conf.getPersistable());
                    out.print("\"");
                }
                out.println(">");
                ++ind;
                if (conf.getDescription() != null && conf.getDescription().length() > 0) {
                    out.print(SBpmnModelWriter.getIndent(ind));
                    out.print("<jadex:description>");
                    out.print(SBpmnModelWriter.escapeString(conf.getDescription()));
                    out.println("</jadex:description>");
                }
                if ((startelements = mmodel.getStartElements(conf.getName())) != null && startelements.size() > 0) {
                    for (MNamedIdElement element : startelements) {
                        out.print(SBpmnModelWriter.getIndent(ind));
                        out.print("<jadex:startElement>");
                        out.print(SBpmnModelWriter.escapeString(element.getId()));
                        out.println("</jadex:startElement>");
                    }
                }
                if (conf.getArguments().length > 0 || conf.getResults().length > 0 || ctvconfexp.containsKey(conf.getName())) {
                    Map confctvmap;
                    UnparsedExpression[] args = conf.getArguments();
                    if (args.length > 0) {
                        out.print(SBpmnModelWriter.getIndent(ind));
                        out.println("<jadex:argumentvalues>");
                        ++ind;
                        for (int j = 0; j < args.length; ++j) {
                            if (args[j].getValue() == null || args[j].getValue().length() <= 0) continue;
                            out.print(SBpmnModelWriter.getIndent(ind));
                            out.print("<jadex:value name=\"");
                            out.print(SBpmnModelWriter.escapeString(args[j].getName()));
                            out.print("\">");
                            out.print(SBpmnModelWriter.escapeString(args[j].getValue()));
                            out.println("</jadex:value>");
                        }
                        out.print(SBpmnModelWriter.getIndent(--ind));
                        out.println("</jadex:argumentvalues>");
                    }
                    if ((res = conf.getResults()).length > 0) {
                        out.print(SBpmnModelWriter.getIndent(ind));
                        out.println("<jadex:resultvalues>");
                        ++ind;
                        for (int j = 0; j < res.length; ++j) {
                            if (res[j].getValue() == null || res[j].getValue().length() <= 0) continue;
                            out.print(SBpmnModelWriter.getIndent(ind));
                            out.print("<jadex:value name=\"");
                            out.print(SBpmnModelWriter.escapeString(res[j].getName()));
                            out.print("\">");
                            out.print(SBpmnModelWriter.escapeString(res[j].getValue()));
                            out.println("</jadex:value>");
                        }
                        out.print(SBpmnModelWriter.getIndent(--ind));
                        out.println("</jadex:resultvalues>");
                    }
                    if ((confctvmap = (Map)ctvconfexp.get(conf.getName())) != null && confctvmap.size() > 0) {
                        out.print(SBpmnModelWriter.getIndent(ind));
                        out.println("<jadex:contextvariablevalues>");
                        ++ind;
                        for (Map.Entry entry : confctvmap.entrySet()) {
                            if (entry.getValue() == null || ((String)entry.getValue()).length() <= 0) continue;
                            out.print(SBpmnModelWriter.getIndent(ind));
                            out.print("<jadex:value name=\"");
                            out.print(SBpmnModelWriter.escapeString((String)entry.getKey()));
                            out.print("\">");
                            out.print(SBpmnModelWriter.escapeString((String)entry.getValue()));
                            out.println("</jadex:value>");
                        }
                        out.print(SBpmnModelWriter.getIndent(--ind));
                        out.println("</jadex:contextvariablevalues>");
                    }
                }
                if ((pss = conf.getProvidedServices()) != null && pss.length > 0) {
                    out.print(SBpmnModelWriter.getIndent(ind));
                    out.println("<jadex:providedserviceconfigurations>");
                    ++ind;
                    res = pss;
                    int n = res.length;
                    for (int j = 0; j < n; ++j) {
                        UnparsedExpression ps = res[j];
                        if (ps.getImplementation() == null) continue;
                        out.print(SBpmnModelWriter.getIndent(ind));
                        out.print("<jadex:providedserviceconfiguration name=\"");
                        out.print(SBpmnModelWriter.escapeString(ps.getName()));
                        if (ps.getImplementation().getClazz() != null && ps.getImplementation().getClazz().getGenericTypeName() != null && ps.getImplementation().getClazz().getGenericTypeName().length() > 0) {
                            out.print("\" class=\"");
                            out.print(SBpmnModelWriter.escapeString(ps.getImplementation().getClazz().getGenericTypeName()));
                        }
                        if (ps.getImplementation().getProxytype() != null && ps.getImplementation().getProxytype().length() > 0) {
                            out.print("\" proxytype=\"");
                            out.print(SBpmnModelWriter.escapeString(ps.getImplementation().getProxytype()));
                        }
                        if (ps.getImplementation().getValue() != null && ps.getImplementation().getValue().length() > 0) {
                            out.print("\" implementation=\"");
                            out.print(SBpmnModelWriter.escapeString(ps.getImplementation().getValue()));
                        }
                        out.println("\"/>");
                    }
                    out.print(SBpmnModelWriter.getIndent(--ind));
                    out.println("</jadex:providedserviceconfigurations>");
                }
                if ((rss = conf.getRequiredServices()) != null && rss.length > 0) {
                    out.print(SBpmnModelWriter.getIndent(ind));
                    out.println("<jadex:requiredserviceconfigurations>");
                    ++ind;
                    for (RequiredServiceInfo rs : rss) {
                        if (rs.getDefaultBinding() == null) continue;
                        out.print(SBpmnModelWriter.getIndent(ind));
                        out.print("<jadex:requiredserviceconfiguration name=\"");
                        out.print(SBpmnModelWriter.escapeString(rs.getName()));
                        if (rs.getDefaultBinding().getScope() != null && rs.getDefaultBinding().getScope().length() > 0) {
                            out.print("\" scope=\"");
                            out.print(SBpmnModelWriter.escapeString(rs.getDefaultBinding().getScope()));
                        }
                        out.println("\"/>");
                    }
                    out.print(SBpmnModelWriter.getIndent(--ind));
                    out.println("</jadex:requiredserviceconfigurations>");
                }
                out.print(SBpmnModelWriter.getIndent(--ind));
                out.println("</jadex:configuration>");
            }
            out.print(SBpmnModelWriter.getIndent(--ind));
            out.println("</jadex:configurations>");
        }
    }

    protected static final void writePoolSemantics(PrintStream out, int ind, List<MPool> pools) {
        if (pools != null && pools.size() > 0) {
            for (MPool pool : pools) {
                out.print(SBpmnModelWriter.getIndent(ind) + "<semantic:process name=\"");
                out.print(pool.getName());
                out.print("\" id=\"");
                out.print(SBpmnModelWriter.escapeString(pool.getId()));
                out.println("\">");
                ++ind;
                List<MLane> lanes = pool.getLanes();
                if (lanes != null && lanes.size() > 0) {
                    SBpmnModelWriter.writeLaneSemantics(out, ind, lanes);
                }
                List<MActivity> activities = SBpmnModelWriter.getPoolActivities(pool);
                ArrayList<MSequenceEdge> seqedges = new ArrayList<MSequenceEdge>();
                ArrayList<MMessagingEdge> medges = new ArrayList<MMessagingEdge>();
                ArrayList<MDataEdge> dataedges = new ArrayList<MDataEdge>();
                SBpmnModelWriter.writeActivitySemantics(out, activities, null, ind, seqedges, medges, dataedges);
                SBpmnModelWriter.writeSequenceEdgeSemantics(out, seqedges, ind);
                SBpmnModelWriter.writeMessagingEdgeSemantics(out, medges, ind);
                SBpmnModelWriter.writePoolExtensions(out, ind, dataedges);
                out.println(SBpmnModelWriter.getIndent(--ind) + "</semantic:process>");
            }
        }
    }

    protected static final void writePoolExtensions(PrintStream out, int ind, List<MDataEdge> dataedges) {
        out.println(SBpmnModelWriter.getIndent(ind) + "<semantic:extensionElements>");
        ++ind;
        for (MDataEdge dedge : dataedges) {
            out.print(SBpmnModelWriter.getIndent(ind));
            out.print("<jadex:dataFlow ");
            if (dedge.getName() != null && dedge.getName().length() > 0) {
                out.print("name=\"");
                out.print(SBpmnModelWriter.escapeString(dedge.getName()));
                out.print("\" ");
            }
            out.print("id=\"");
            out.print(SBpmnModelWriter.escapeString(dedge.getId()));
            out.print("\" sourceRef=\"");
            out.print(SBpmnModelWriter.escapeString(dedge.getSource().getId()));
            out.print("\" sourceParam=\"");
            out.print(SBpmnModelWriter.escapeString(SBpmnModelWriter.handleNullStr(dedge.getSourceParameter())));
            out.print("\" targetRef=\"");
            out.print(SBpmnModelWriter.escapeString(dedge.getTarget().getId()));
            out.print("\" targetParam=\"");
            out.print(SBpmnModelWriter.escapeString(SBpmnModelWriter.handleNullStr(dedge.getTargetParameter())));
            if (dedge.getParameterMapping() != null && dedge.getParameterMapping().getValue() != null && dedge.getParameterMapping().getValue().length() > 0) {
                out.println("\">");
                out.print(SBpmnModelWriter.getIndent(++ind));
                out.print("<jadex:dataFlowValueMapping>");
                out.print(SBpmnModelWriter.escapeString(dedge.getParameterMapping().getValue()));
                out.println("</jadex:dataFlowValueMapping>");
                out.print(SBpmnModelWriter.getIndent(--ind));
                out.println("</jadex:dataFlow>");
                continue;
            }
            out.println("\"/>");
        }
        out.println(SBpmnModelWriter.getIndent(--ind) + "</semantic:extensionElements>");
    }

    protected static final void writeLaneSemantics(PrintStream out, int ind, List<MLane> lanes) {
        out.println(SBpmnModelWriter.getIndent(ind) + "<semantic:laneSet>");
        ++ind;
        for (MLane lane : lanes) {
            out.print(SBpmnModelWriter.getIndent(ind) + "<semantic:lane name=\"");
            out.print(lane.getName());
            out.print("\" id=\"");
            out.print(SBpmnModelWriter.escapeString(lane.getId()));
            out.println("\">");
            ++ind;
            List<MActivity> activities = lane.getActivities();
            for (MActivity activity : activities) {
                out.print(SBpmnModelWriter.getIndent(ind) + "<semantic:flowNodeRef>");
                out.print(SBpmnModelWriter.escapeString(activity.getId()));
                out.println("</semantic:flowNodeRef>");
            }
            out.println(SBpmnModelWriter.getIndent(--ind) + "</semantic:lane>");
        }
        out.println(SBpmnModelWriter.getIndent(--ind) + "</semantic:laneSet>");
    }

    protected static final void writeActivitySemantics(PrintStream out, List<MActivity> activities, String evthandlerref, int baseind, List<MSequenceEdge> seqedges, List<MMessagingEdge> medges, List<MDataEdge> dataedges) {
        for (MActivity activity : activities) {
            boolean hasprops;
            List<MSequenceEdge> edges;
            if (activity.isEventHandler() && evthandlerref == null) continue;
            if (activity.getOutgoingDataEdges() != null) {
                dataedges.addAll(activity.getOutgoingDataEdges());
            }
            if (activity.getOutgoingSequenceEdges() != null) {
                seqedges.addAll(activity.getOutgoingSequenceEdges());
            }
            if (activity.getOutgoingMessagingEdges() != null) {
                medges.addAll(activity.getOutgoingMessagingEdges());
            }
            out.print(SBpmnModelWriter.getIndent(baseind) + "<semantic:");
            String mappedacttype = ACT_TYPE_MAPPING.get(activity.getActivityType());
            boolean event = false;
            if (activity.getActivityType().startsWith("Event")) {
                event = true;
                if (activity.getActivityType().contains("Intermediate")) {
                    mappedacttype = activity.isEventHandler() ? "boundaryEvent" : (activity.isThrowing() ? mappedacttype + "ThrowEvent" : mappedacttype + "CatchEvent");
                }
            }
            out.print(mappedacttype);
            if (activity.getName() != null && activity.getName().length() > 0) {
                out.print(" name=\"");
                out.print(SBpmnModelWriter.escapeString(activity.getName()));
                out.print("\"");
            }
            out.print(" id=\"");
            out.print(activity.getId());
            if (activity instanceof MSubProcess && "event".equals(((MSubProcess)activity).getSubprocessType())) {
                out.print("\" triggeredByEvent=\"true");
            }
            if ((edges = activity.getOutgoingSequenceEdges()) != null) {
                for (MSequenceEdge edge : edges) {
                    if (!edge.isDefault()) continue;
                    out.print("\" default=\"");
                    out.print(SBpmnModelWriter.escapeString(edge.getId()));
                    break;
                }
            }
            if (activity.isEventHandler()) {
                out.print("\" attachedToRef=\"");
                out.print(SBpmnModelWriter.escapeString(evthandlerref));
            }
            out.println("\">");
            edges = activity.getIncomingSequenceEdges();
            if (edges != null) {
                for (MSequenceEdge edge : edges) {
                    out.print(SBpmnModelWriter.getIndent(baseind + 1) + "<semantic:incoming>");
                    out.print(SBpmnModelWriter.escapeString(edge.getId()));
                    out.println("</semantic:incoming>");
                }
            }
            if ((edges = activity.getOutgoingSequenceEdges()) != null) {
                for (MSequenceEdge edge : edges) {
                    out.print(SBpmnModelWriter.getIndent(baseind + 1) + "<semantic:outgoing>");
                    out.print(SBpmnModelWriter.escapeString(edge.getId()));
                    out.println("</semantic:outgoing>");
                }
            }
            if (event) {
                if (activity.getActivityType().contains("Message")) {
                    out.print(SBpmnModelWriter.getIndent(baseind + 1));
                    out.println("<semantic:messageEventDefinition/>");
                } else if (activity.getActivityType().contains("Timer")) {
                    out.print(SBpmnModelWriter.getIndent(baseind + 1));
                    out.print("<semantic:timerEventDefinition");
                    if (activity.hasPropertyValue("duration") && activity.getPropertyValue("duration").getValue().length() > 0) {
                        out.println(">");
                        out.print(SBpmnModelWriter.getIndent(baseind + 2));
                        out.print("<semantic:timeDuration>");
                        out.print(SBpmnModelWriter.escapeString(activity.getPropertyValue("duration").getValue()));
                        out.println("</semantic:timeDuration>");
                        out.print(SBpmnModelWriter.getIndent(baseind + 1));
                        out.println("</semantic:timerEventDefinition>");
                    } else {
                        out.println("/>");
                    }
                } else if (activity.getActivityType().contains("Rule")) {
                    out.print(SBpmnModelWriter.getIndent(baseind + 1));
                    out.println("<semantic:conditionalEventDefinition/>");
                } else if (activity.getActivityType().contains("Signal")) {
                    out.print(SBpmnModelWriter.getIndent(baseind + 1));
                    out.println("<semantic:signalEventDefinition/>");
                } else if (activity.getActivityType().contains("Error")) {
                    out.print(SBpmnModelWriter.getIndent(baseind + 1));
                    out.println("<semantic:errorEventDefinition/>");
                } else if (activity.getActivityType().contains("Compensation")) {
                    out.println("<semantic:compensateEventDefinition/>");
                } else if (activity.getActivityType().contains("Cancel")) {
                    out.print(SBpmnModelWriter.getIndent(baseind + 1));
                    out.println("<semantic:cancelEventDefinition/>");
                } else if (activity.getActivityType().contains("Terminate")) {
                    out.print(SBpmnModelWriter.getIndent(baseind + 1));
                    out.println("<semantic:terminateEventDefinition/>");
                } else if (activity.getActivityType().contains("Multipl")) {
                    out.print(SBpmnModelWriter.getIndent(baseind + 1));
                    out.println("<semantic:multipleEventDefinition/>");
                }
            }
            boolean issubproc = "SubProcess".equals(activity.getActivityType());
            String procref = null;
            boolean isprocrefexp = false;
            if (issubproc) {
                MSubProcess subproc = (MSubProcess)activity;
                String tp = subproc.getSubprocessType();
                if ("sequential".equals(tp) || "parallel".equals(tp)) {
                    out.print(SBpmnModelWriter.getIndent(baseind + 1));
                    out.println("<semantic:multiInstanceLoopCharacteristics isSequential=\"" + ("sequential".equals(tp) ? "true" : "false") + "\" />");
                }
                if (subproc.hasPropertyValue("file")) {
                    UnparsedExpression fileexp = subproc.getPropertyValue("file");
                    procref = fileexp.getValue();
                    isprocrefexp = true;
                } else if (subproc.hasPropertyValue("filename")) {
                    procref = subproc.getPropertyValue("filename").getValue();
                    if (procref != null && procref.length() >= 2) {
                        procref = procref.substring(1);
                        procref = procref.substring(0, procref.length() - 1);
                    }
                } else {
                    List<MActivity> subactivities = subproc.getActivities();
                    if (subactivities != null && subactivities.size() > 0) {
                        SBpmnModelWriter.writeActivitySemantics(out, subactivities, null, baseind + 1, seqedges, medges, dataedges);
                    }
                }
            }
            boolean hasclass = activity.getClazz() != null && activity.getClazz().getGenericTypeName() != null && activity.getClazz().getGenericTypeName().length() > 0;
            boolean hastaskparams = activity.getParameters() != null && activity.getParameters().size() > 0;
            boolean bl = hasprops = activity.getProperties() != null && activity.getProperties().size() > 0;
            if (hasclass || hastaskparams || hasprops || procref != null) {
                String inival;
                out.println(SBpmnModelWriter.getIndent(baseind + 1) + "<semantic:extensionElements>");
                if (hasclass) {
                    out.print(SBpmnModelWriter.getIndent(baseind + 2) + "<jadex:class>");
                    out.print(SBpmnModelWriter.escapeString(activity.getClazz().getGenericTypeName()));
                    out.println("</jadex:class>");
                }
                if (hastaskparams) {
                    IndexMap<String, MParameter> params = activity.getParameters();
                    for (String key : params.keySet()) {
                        MParameter param = (MParameter)params.get((Object)key);
                        out.print(SBpmnModelWriter.getIndent(baseind + 2) + "<jadex:parameter direction=\"");
                        out.print(SBpmnModelWriter.escapeString(param.getDirection()));
                        out.print("\" name=\"");
                        out.print(SBpmnModelWriter.escapeString(param.getName()));
                        out.print("\" type=\"");
                        out.print(SBpmnModelWriter.escapeString(param.getClazz().getGenericTypeName()));
                        out.print("\"");
                        String string = inival = param.getInitialValue() != null ? param.getInitialValue().getValue() : null;
                        if (inival != null && inival.length() > 0) {
                            out.print(">");
                            out.print(SBpmnModelWriter.escapeString(inival));
                            out.println("</jadex:parameter>");
                            continue;
                        }
                        out.println("/>");
                    }
                }
                if (hasprops) {
                    IndexMap<String, MProperty> props = activity.getProperties();
                    for (String key : props.keySet()) {
                        MProperty prop = (MProperty)props.get((Object)key);
                        out.print(SBpmnModelWriter.getIndent(baseind + 2) + "<jadex:property name=\"");
                        out.print(SBpmnModelWriter.escapeString(prop.getName()));
                        if (prop.getClazz() != null) {
                            out.print("\" type=\"");
                            out.print(SBpmnModelWriter.escapeString(prop.getClazz().getGenericTypeName()));
                        }
                        out.print("\"");
                        String string = inival = prop.getInitialValue() != null ? prop.getInitialValue().getValue() : null;
                        if (inival != null && inival.length() > 0) {
                            out.print(">");
                            out.print(SBpmnModelWriter.escapeString(inival));
                            out.println("</jadex:property>");
                            continue;
                        }
                        out.println("/>");
                    }
                }
                if (procref != null) {
                    String tagpart = "jadex:subprocessref>";
                    if (isprocrefexp) {
                        tagpart = "jadex:subprocessexpressionref>";
                    }
                    out.print(SBpmnModelWriter.getIndent(baseind + 2) + "<" + tagpart);
                    out.print(SBpmnModelWriter.escapeString(procref));
                    out.println("</" + tagpart);
                }
                out.println(SBpmnModelWriter.getIndent(baseind + 1) + "</semantic:extensionElements>");
            }
            out.print(SBpmnModelWriter.getIndent(baseind) + "</semantic:");
            out.print(mappedacttype);
            out.println(">");
            if (activity.getEventHandlers() == null || activity.getEventHandlers().size() <= 0) continue;
            SBpmnModelWriter.writeActivitySemantics(out, activity.getEventHandlers(), activity.getId(), baseind, seqedges, medges, dataedges);
        }
    }

    protected static final void writeSequenceEdgeSemantics(PrintStream out, List<MSequenceEdge> seqedges, int baseind) {
        for (MSequenceEdge edge : seqedges) {
            IndexMap<String, Tuple2<UnparsedExpression, UnparsedExpression>> mappings;
            String cond;
            out.print(SBpmnModelWriter.getIndent(baseind) + "<semantic:sequenceFlow ");
            if (edge.getName() != null && edge.getName().length() > 0) {
                out.print("name=\"");
                out.print(SBpmnModelWriter.escapeString(edge.getName()));
                out.print("\" ");
            }
            out.print("sourceRef=\"");
            out.print(SBpmnModelWriter.escapeString(edge.getSource().getId()));
            out.print("\" targetRef=\"");
            out.print(SBpmnModelWriter.escapeString(edge.getTarget().getId()));
            out.print("\" id=\"");
            out.print(SBpmnModelWriter.escapeString(edge.getId()));
            out.println("\">");
            if (edge.getCondition() != null && (cond = edge.getCondition().getValue()) != null && cond.length() > 0) {
                out.print(SBpmnModelWriter.getIndent(baseind + 1) + "<semantic:conditionExpression>");
                out.print(SBpmnModelWriter.escapeString(cond));
                out.println("</semantic:conditionExpression>");
            }
            if ((mappings = edge.getParameterMappings()) != null && mappings.size() > 0) {
                out.println(SBpmnModelWriter.getIndent(baseind + 1) + "<semantic:extensionElements>");
                for (Object key : mappings.keySet()) {
                    out.print(SBpmnModelWriter.getIndent(baseind + 2) + "<jadex:parametermapping name=\"");
                    out.print(SBpmnModelWriter.escapeString((String)key));
                    out.print("\">");
                    out.print(SBpmnModelWriter.escapeString(((UnparsedExpression)((Tuple2)mappings.get(key)).getFirstEntity()).getValue()));
                    out.println("</jadex:parametermapping>");
                }
                out.println(SBpmnModelWriter.getIndent(baseind + 1) + "</semantic:extensionElements>");
            }
            out.println(SBpmnModelWriter.getIndent(baseind) + "</semantic:sequenceFlow>");
        }
    }

    protected static final void writeMessagingEdgeSemantics(PrintStream out, List<MMessagingEdge> medges, int baseind) {
        for (MMessagingEdge edge : medges) {
            out.print(SBpmnModelWriter.getIndent(baseind) + "<semantic:messageFlow ");
            if (edge.getName() != null && edge.getName().length() > 0) {
                out.print("name=\"");
                out.print(SBpmnModelWriter.escapeString(edge.getName()));
                out.print("\" ");
            }
            out.print("sourceRef=\"");
            if (edge.getSource() == null) {
                System.out.println("IDD: " + edge.getId());
            }
            out.print(SBpmnModelWriter.escapeString(edge.getSource().getId()));
            out.print("\" targetRef=\"");
            out.print(SBpmnModelWriter.escapeString(edge.getTarget().getId()));
            out.print("\" id=\"");
            out.print(SBpmnModelWriter.escapeString(edge.getId()));
            out.println("\">");
            out.println(SBpmnModelWriter.getIndent(baseind) + "</semantic:messageFlow>");
        }
    }

    public static final List<MActivity> getPoolActivities(MPool pool) {
        List<MLane> lanes;
        ArrayList<MActivity> ret = new ArrayList<MActivity>();
        if (pool.getActivities() != null && pool.getActivities().size() > 0) {
            ret.addAll(pool.getActivities());
        }
        if ((lanes = pool.getLanes()) != null) {
            for (MLane lane : lanes) {
                if (lane.getActivities() == null || lane.getActivities().size() <= 0) continue;
                ret.addAll(lane.getActivities());
            }
        }
        return ret;
    }

    public static final String getIndent(int num) {
        StringBuilder sb = new StringBuilder();
        while (num-- > 0) {
            sb.append(INDENT_STRING);
        }
        return sb.toString();
    }

    public static final String handleNullStr(String input) {
        if (input == null) {
            input = "";
        } else if (input.length() == 0) {
            input = null;
        }
        return input;
    }

    private static final String escapeString(String string) {
        string = string.replace("&", "&amp;");
        string = string.replace("\"", "&quot;");
        string = string.replace("'", "&apos;");
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        string = string.replace("\\", "\\\\");
        string = string.replace(CR + LF, LF);
        string = string.replace(CR + CR, LF);
        string = string.replace(CR, LF);
        string = string.replace(LF, "\\n");
        string = string.replace("\n", "\\n");
        return string;
    }

    private static final String makeCharStringTrustMeJava(int num) {
        String ret = null;
        try {
            ret = new String(new byte[]{(byte)num}, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    static {
        ACT_TYPE_MAPPING.put("Task", "task");
        ACT_TYPE_MAPPING.put("SubProcess", "subProcess");
        ACT_TYPE_MAPPING.put("GatewayParallel", "parallelGateway");
        ACT_TYPE_MAPPING.put("GatewayDataBasedExclusive", "exclusiveGateway");
        ACT_TYPE_MAPPING.put("GatewayDataBasedInclusive", "inclusiveGateway");
        ACT_TYPE_MAPPING.put("EventStartEmpty", START_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventStartMessage", START_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventStartTimer", START_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventStartRule", START_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventStartSignal", START_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventStartMultiple", START_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventIntermediateEmpty", INTERMEDIATE_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventIntermediateError", INTERMEDIATE_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventIntermediateRule", INTERMEDIATE_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventIntermediateSignal", INTERMEDIATE_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventIntermediateMessage", INTERMEDIATE_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventIntermediateTimer", INTERMEDIATE_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventIntermediateMultiple", INTERMEDIATE_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventEndEmpty", END_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventEndError", END_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventEndMessage", END_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventEndSignal", END_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventEndCompensation", END_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventEndCancel", END_EVENT_TAG);
        ACT_TYPE_MAPPING.put("EventEndTerminate", END_EVENT_TAG);
        CR = SBpmnModelWriter.makeCharStringTrustMeJava(13);
        LF = SBpmnModelWriter.makeCharStringTrustMeJava(10);
    }
}

