/*
 * Decompiled with CFR 0.152.
 */
package jadex.bpmn.model.io;

import jadex.bpmn.model.MActivity;
import jadex.bpmn.model.MBpmnModel;
import jadex.bpmn.model.MContextVariable;
import jadex.bpmn.model.MDataEdge;
import jadex.bpmn.model.MIdElement;
import jadex.bpmn.model.MLane;
import jadex.bpmn.model.MMessagingEdge;
import jadex.bpmn.model.MNamedIdElement;
import jadex.bpmn.model.MParameter;
import jadex.bpmn.model.MPool;
import jadex.bpmn.model.MProperty;
import jadex.bpmn.model.MSequenceEdge;
import jadex.bpmn.model.MSubProcess;
import jadex.bpmn.model.MTask;
import jadex.bpmn.model.io.IBpmnVisualModelReader;
import jadex.bpmn.model.io.IPostProcessingVisualModelReader;
import jadex.bpmn.model.io.SBpmnModelWriter;
import jadex.bridge.ClassInfo;
import jadex.bridge.modelinfo.Argument;
import jadex.bridge.modelinfo.ConfigurationInfo;
import jadex.bridge.modelinfo.IArgument;
import jadex.bridge.modelinfo.ModelInfo;
import jadex.bridge.modelinfo.SubcomponentTypeInfo;
import jadex.bridge.modelinfo.UnparsedExpression;
import jadex.bridge.service.ProvidedServiceImplementation;
import jadex.bridge.service.ProvidedServiceInfo;
import jadex.bridge.service.RequiredServiceBinding;
import jadex.bridge.service.RequiredServiceInfo;
import jadex.bridge.service.types.monitoring.IMonitoringService;
import jadex.commons.SReflect;
import jadex.commons.Tuple2;
import jadex.javaparser.SJavaParser;
import jadex.xml.reader.IXMLReader;
import jadex.xml.stax.XmlTag;
import jadex.xml.stax.XmlUtil;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SBpmnModelReader {
    public static final String BOUNDS_KEY = "bounds";
    public static final String ALT_BOUNDS_KEY = "altbounds";
    public static final String WAYPOINTS_KEY = "waypoints";
    public static final String INTERNAL_PARAMETERS_KEY = "internalparameters";
    public static final Map<String, String> TAG_ALIASES;
    public static final Map<String, String> ACT_TYPE_MAPPING;

    public static final MBpmnModel readModel(File file, IBpmnVisualModelReader vreader) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        MBpmnModel ret = SBpmnModelReader.readModel(fis, file.getName(), vreader, null);
        fis.close();
        return ret;
    }

    public static final MBpmnModel readModel(InputStream in, String filename, IBpmnVisualModelReader vreader) throws Exception {
        return SBpmnModelReader.readModel(in, filename, vreader, null);
    }

    public static final MBpmnModel readModel(InputStream in, String filename, IBpmnVisualModelReader vreader, ClassLoader cl) throws Exception {
        Constructor con;
        Class clazz;
        IXMLReader reader = null;
        if (!SReflect.isAndroid()) {
            clazz = SReflect.classForName((String)"jadex.xml.stax.StaxReaderWrapper", (ClassLoader)SBpmnModelReader.class.getClassLoader());
            con = clazz.getConstructor(InputStream.class);
            reader = (IXMLReader)con.newInstance(in);
        } else {
            clazz = SReflect.classForName((String)"jadex.xml.reader.PullParserWrapper", (ClassLoader)SBpmnModelReader.class.getClassLoader());
            con = clazz.getConstructor(InputStream.class);
            reader = (IXMLReader)con.newInstance(in);
        }
        LinkedList<Map> attrstack = new LinkedList<Map>();
        LinkedList<String> contentstack = new LinkedList<String>();
        MBpmnModel ret = new MBpmnModel();
        ret.setClassLoader(cl);
        ret.setFilename(filename);
        ret.setName(new File(filename).getName().substring(0, new File(filename).getName().length() - 6));
        HashMap<String, MIdElement> bpmnelementmap = new HashMap<String, MIdElement>();
        HashMap<String, MLane> lanemap = new HashMap<String, MLane>();
        HashMap<String, String> laneparents = new HashMap<String, String>();
        HashMap<String, Object> buffer = new HashMap<String, Object>();
        buffer.put("subprocessstack", new LinkedList());
        buffer.put("subprocesselementmap", new HashMap());
        buffer.put("eventhandlerparentmap", new HashMap());
        buffer.put("unresolvedsequencesources", new HashMap());
        buffer.put("unresolvedsequencetargets", new HashMap());
        String semuri = null;
        String text = null;
        while (reader.hasNext()) {
            reader.next();
            if (reader.getEventType() == 1 && "definitions".equals(reader.getXmlTag().getLocalPart()) && reader.getXmlTag().getNamespace() != null && reader.getXmlTag().getNamespace().equals("http://www.omg.org/spec/BPMN/20100524/MODEL")) {
                semuri = "http://www.omg.org/spec/BPMN/20100524/MODEL";
                buffer.put("di", "http://www.omg.org/spec/DD/20100524/DI");
                buffer.put("dc", "http://www.omg.org/spec/DD/20100524/DC");
                buffer.put("bpmndi", "http://www.omg.org/spec/BPMN/20100524/DI");
                buffer.put("semantic", semuri);
                buffer.put("jadex", "http://www.activecomponents.org/bpmnextensions");
                buffer.put("jadexvisual", "http://www.activecomponents.org/bpmnvisualextensions");
            }
            if (reader.getEventType() == 1) {
                text = null;
                Map attrs = reader.getAttributes();
                attrstack.addFirst(attrs);
                if ("extension".equals(reader.getXmlTag().getLocalPart()) && semuri.equals(reader.getXmlTag().getNamespace())) {
                    buffer.put("extension", null);
                    continue;
                }
                if ("process".equals(reader.getXmlTag().getLocalPart()) && semuri.equals(reader.getXmlTag().getNamespace())) {
                    SBpmnModelReader.handlePool(ret, attrs, bpmnelementmap, buffer);
                    continue;
                }
                if (!"subProcess".equals(reader.getXmlTag().getLocalPart()) || !semuri.equals(reader.getXmlTag().getNamespace())) continue;
                LinkedList sps = (LinkedList)buffer.get("subprocessstack");
                sps.addFirst(new MSubProcess());
                continue;
            }
            if (reader.getEventType() == 4) {
                String moretext = reader.getText();
                if (moretext == null) continue;
                text = text != null ? text + moretext : moretext;
                continue;
            }
            if (reader.getEventType() != 2) continue;
            text = text != null && text.trim().length() > 0 ? text.trim() : null;
            text = text != null ? XmlUtil.unescapeString((String)text) : null;
            contentstack.addFirst(text);
            text = null;
            if (reader.getXmlTag() != null && "extension".equals(reader.getClosedTag().getLocalPart()) && semuri.equals(reader.getXmlTag().getNamespace())) {
                buffer.remove("extension");
            }
            SBpmnModelReader.handleElement(ret, bpmnelementmap, lanemap, laneparents, reader.getClosedTag(), reader.getXmlTagStack(), (Map)attrstack.removeFirst(), (String)contentstack.removeFirst(), buffer, vreader);
        }
        Map semap = (Map)buffer.get("startelementsmap");
        if (semap != null) {
            for (Map.Entry entry : semap.entrySet()) {
                for (String id : (List)entry.getValue()) {
                    ret.addStartElement((String)entry.getKey(), (MNamedIdElement)bpmnelementmap.get(id));
                }
            }
        }
        if (vreader instanceof IPostProcessingVisualModelReader) {
            ((IPostProcessingVisualModelReader)vreader).postProcess();
        }
        return ret;
    }

    protected static final void handlePool(MBpmnModel model, Map<String, String> attrs, Map<String, MIdElement> emap, Map<String, Object> buffer) {
        MPool currentpool = new MPool();
        currentpool.setName(attrs.get("name"));
        currentpool.setId(attrs.get("id"));
        emap.put(currentpool.getId(), currentpool);
        model.addPool(currentpool);
        buffer.put("lastobject", currentpool);
        buffer.put("pool", currentpool);
    }

    protected static final void handleElement(MBpmnModel model, Map<String, MIdElement> emap, Map<String, MLane> lanemap, Map<String, String> laneparents, XmlTag tag, LinkedList<XmlTag> tagstack, Map<String, String> attrs, String content, Map<String, Object> buffer, IBpmnVisualModelReader vreader) {
        if (buffer.get("semantic").equals(tag.getNamespace())) {
            SBpmnModelReader.handleSemanticElement(model, emap, lanemap, laneparents, tag, tagstack, attrs, content, buffer);
        } else if (buffer.get("jadex").equals(tag.getNamespace())) {
            SBpmnModelReader.handleJadexElement(model, tag, tagstack, attrs, content, buffer, emap);
        } else if (vreader != null && (buffer.get("bpmndi").equals(tag.getNamespace()) || buffer.get("dc").equals(tag.getNamespace()) || buffer.get("di").equals(tag.getNamespace()) || buffer.get("jadexvisual").equals(tag.getNamespace()))) {
            SBpmnModelReader.handleVisualElement(vreader, tag, attrs, content, laneparents, emap, buffer);
        }
    }

    protected static final void handleSemanticElement(MBpmnModel model, Map<String, MIdElement> emap, Map<String, MLane> lanemap, Map<String, String> laneparents, XmlTag tag, LinkedList<XmlTag> tagstack, Map<String, String> attrs, String content, Map<String, Object> buffer) {
        ClassLoader cl = model.getClassLoader();
        if ("multiInstanceLoopCharacteristics".equals(tag.getLocalPart())) {
            String seq = attrs.get("isSequential");
            buffer.put("multiInstance", seq != null ? new Boolean(seq) : Boolean.FALSE);
        } else if ("lane".equals(tag.getLocalPart())) {
            MLane lane = new MLane();
            lane.setName(attrs.get("name"));
            lane.setId(attrs.get("id"));
            emap.put(lane.getId(), lane);
            MPool pool = (MPool)buffer.get("pool");
            pool.addLane(lane);
            List noderefs = (List)buffer.remove("flownoderefs");
            if (noderefs != null) {
                for (String ref : noderefs) {
                    lanemap.put(ref, lane);
                }
            }
            laneparents.put(lane.getId(), pool.getId());
        } else if ("flowNodeRef".equals(tag.getLocalPart())) {
            ArrayList<String> noderefs = (ArrayList<String>)buffer.get("flownoderefs");
            if (noderefs == null) {
                noderefs = new ArrayList<String>();
                buffer.put("flownoderefs", noderefs);
            }
            noderefs.add(content);
        } else if (ACT_TYPE_MAPPING.containsKey(tag.getLocalPart())) {
            MActivity act;
            if ("SubProcess".equals(ACT_TYPE_MAPPING.get(tag.getLocalPart()))) {
                LinkedList sps = (LinkedList)buffer.get("subprocessstack");
                act = (MActivity)sps.removeFirst();
                String eventsp = attrs.get("triggeredByEvent");
                if (eventsp != null && eventsp.equalsIgnoreCase("true")) {
                    ((MSubProcess)act).setSubprocessType("event");
                }
            } else {
                act = "Task".equals(ACT_TYPE_MAPPING.get(tag.getLocalPart())) ? new MTask() : new MActivity();
            }
            if (attrs.containsKey("name")) {
                act.setName(attrs.get("name"));
            }
            act.setId(attrs.get("id"));
            if (attrs.containsKey("default")) {
                HashSet<String> de = (HashSet<String>)buffer.get("defaultedges");
                if (de == null) {
                    de = new HashSet<String>();
                    buffer.put("defaultedges", de);
                }
                de.add(attrs.get("default"));
            }
            act.setActivityType(ACT_TYPE_MAPPING.get(tag.getLocalPart()));
            if (buffer.containsKey("class")) {
                act.setClazz(new ClassInfo((String)buffer.remove("class")));
            }
            if (buffer.containsKey("parameters")) {
                List params = (List)buffer.remove("parameters");
                for (MParameter param : params) {
                    act.addParameter(param);
                }
            }
            if (buffer.containsKey("properties")) {
                List props = (List)buffer.remove("properties");
                for (MProperty prop : props) {
                    act.addProperty(prop);
                }
            }
            if (act instanceof MSubProcess && buffer.containsKey("multiInstance")) {
                Boolean seq = (Boolean)buffer.remove("multiInstance");
                if (seq.booleanValue()) {
                    ((MSubProcess)act).setSubprocessType("sequential");
                } else {
                    ((MSubProcess)act).setSubprocessType("parallel");
                }
            }
            SBpmnModelReader.connectActivityEdges(act, buffer, emap);
            SBpmnModelReader.insertActivity(act, buffer, lanemap, emap);
        } else if (tag.getLocalPart() != null && tag.getLocalPart().contains("Event") && !tag.getLocalPart().contains("Definition")) {
            MActivity evt = new MActivity();
            if (attrs.containsKey("name")) {
                evt.setName(attrs.get("name"));
            }
            evt.setId(attrs.get("id"));
            if (buffer.containsKey("class")) {
                evt.setClazz(new ClassInfo((String)buffer.remove("class")));
            }
            String acttype = "Event";
            if (tag.getLocalPart().startsWith("end") || tag.getLocalPart().contains("Throw")) {
                evt.setThrowing(true);
            }
            if (tag.getLocalPart().startsWith("start")) {
                acttype = acttype + "Start";
            } else if (tag.getLocalPart().startsWith("end")) {
                acttype = acttype + "End";
            } else {
                acttype = acttype + "Intermediate";
                if (tag.getLocalPart().startsWith("boundary")) {
                    evt.setEventHandler(true);
                    Map ehpm = (Map)buffer.get("eventhandlerparentmap");
                    ehpm.put(evt.getId(), attrs.get("attachedToRef"));
                }
            }
            List evttypes = (List)buffer.remove("evttypes");
            if (evttypes == null || evttypes.size() == 0) {
                acttype = acttype + "Empty";
            } else if (evttypes.size() == 1) {
                Tuple2 type = (Tuple2)evttypes.get(0);
                acttype = acttype + (String)type.getFirstEntity();
            }
            String dur = (String)buffer.remove("duration");
            if (dur != null) {
                UnparsedExpression exp = SBpmnModelReader.parseExp(new UnparsedExpression("duration", "java.lang.Number", dur, null), model.getModelInfo().getAllImports(), cl);
                MProperty mprop = new MProperty(exp.getClazz(), exp.getName(), exp);
                evt.addProperty(mprop);
            }
            if (buffer.containsKey("properties")) {
                List props = (List)buffer.remove("properties");
                for (MProperty prop : props) {
                    evt.addProperty(prop);
                }
            }
            if (buffer.containsKey("parameters")) {
                List params = (List)buffer.remove("parameters");
                for (MParameter param : params) {
                    evt.addParameter(param);
                }
            }
            evt.setActivityType(acttype);
            SBpmnModelReader.connectActivityEdges(evt, buffer, emap);
            SBpmnModelReader.insertActivity(evt, buffer, lanemap, emap);
        } else if (tag.getLocalPart() != null && tag.getLocalPart().endsWith("EventDefinition")) {
            ArrayList<Tuple2> evttypes = (ArrayList<Tuple2>)buffer.get("evttypes");
            if (evttypes == null) {
                evttypes = new ArrayList<Tuple2>();
                buffer.put("evttypes", evttypes);
            }
            if ("messageEventDefinition".equals(tag.getLocalPart())) {
                evttypes.add(new Tuple2((Object)"Message", null));
            } else if ("timerEventDefinition".equals(tag.getLocalPart())) {
                evttypes.add(new Tuple2((Object)"Timer", null));
            } else if ("conditionalEventDefinition".equals(tag.getLocalPart())) {
                evttypes.add(new Tuple2((Object)"Rule", null));
            } else if ("signalEventDefinition".equals(tag.getLocalPart())) {
                evttypes.add(new Tuple2((Object)"Signal", null));
            } else if ("errorEventDefinition".equals(tag.getLocalPart())) {
                evttypes.add(new Tuple2((Object)"Error", (Object)content));
            } else if ("compensateEventDefinition".equals(tag.getLocalPart())) {
                evttypes.add(new Tuple2((Object)"Compensation", null));
            } else if ("cancelEventDefinition".equals(tag.getLocalPart())) {
                evttypes.add(new Tuple2((Object)"Cancel", null));
            } else if ("multipleEventDefinition".equals(tag.getLocalPart())) {
                evttypes.add(new Tuple2((Object)"Multiple", null));
            } else if ("terminateEventDefinition".equals(tag.getLocalPart())) {
                evttypes.add(new Tuple2((Object)"Terminate", null));
            }
        } else if ("sequenceFlow".equals(tag.getLocalPart())) {
            Map mappings;
            String cond;
            MSequenceEdge edge = new MSequenceEdge();
            edge.setId(attrs.get("id"));
            String edgename = attrs.get("name");
            edgename = edgename != null ? XmlUtil.unescapeString((String)edgename) : null;
            edge.setName(edgename);
            MActivity src = (MActivity)emap.get(attrs.get("sourceRef"));
            MActivity tgt = (MActivity)emap.get(attrs.get("targetRef"));
            edge.setSource(src);
            edge.setTarget(tgt);
            Set de = (Set)buffer.get("defaultedges");
            if (de != null && de.contains(edge.getId())) {
                edge.setDefault(true);
            }
            if ((cond = (String)buffer.remove("condition")) != null) {
                edge.setCondition(SBpmnModelReader.parseExp(new UnparsedExpression("", "java.lang.Boolean", cond, null), model.getModelInfo().getAllImports(), cl));
            }
            if ((mappings = (Map)buffer.remove("parametermappings")) != null) {
                for (Map.Entry entry : mappings.entrySet()) {
                    String name = (String)entry.getKey();
                    String expstring = (String)entry.getValue();
                    UnparsedExpression exp = new UnparsedExpression(name, "java.lang.Object", expstring, null);
                    SBpmnModelReader.parseExp(exp, model.getModelInfo().getAllImports(), cl);
                    UnparsedExpression iexp = null;
                    if (name.endsWith("]") && name.indexOf("[") != -1) {
                        String itext = name.substring(name.indexOf("[") + 1, name.length() - 1);
                        name = name.substring(0, name.indexOf("["));
                        iexp = new UnparsedExpression(name, "java.lang.Object", itext, null);
                        SBpmnModelReader.parseExp(iexp, model.getModelInfo().getAllImports(), cl);
                    }
                    edge.addParameterMapping((String)entry.getKey(), exp, iexp);
                }
            }
            if (src != null) {
                src.addOutgoingSequenceEdge(edge);
            }
            if (tgt != null) {
                tgt.addIncomingSequenceEdge(edge);
            }
            emap.put(edge.getId(), edge);
        } else if ("messageFlow".equals(tag.getLocalPart())) {
            MMessagingEdge edge = new MMessagingEdge();
            edge.setId(attrs.get("id"));
            String edgename = attrs.get("name");
            edgename = edgename != null ? XmlUtil.unescapeString((String)edgename) : null;
            edge.setName(edgename);
            MActivity src = (MActivity)emap.get(attrs.get("sourceRef"));
            MActivity tgt = (MActivity)emap.get(attrs.get("targetRef"));
            if (src != null && tgt != null) {
                edge.setSource(src);
                edge.setTarget(tgt);
                src.addOutgoingMessagingEdge(edge);
                tgt.addIncomingMessagingEdge(edge);
                emap.put(edge.getId(), edge);
            } else {
                System.out.println("Warning: Ignoring message edge with missing endpoints: " + edge.getId() + " src=" + String.valueOf(src) + " tgt=" + String.valueOf(tgt));
            }
        } else if ("conditionExpression".equals(tag.getLocalPart())) {
            buffer.put("condition", content);
        } else if ("timeDuration".equals(tag.getLocalPart())) {
            buffer.put("duration", content);
        } else if ("incoming".equals(tag.getLocalPart())) {
            ArrayList<String> incoming = (ArrayList<String>)buffer.get("incoming");
            if (incoming == null) {
                incoming = new ArrayList<String>();
                buffer.put("incoming", incoming);
            }
            incoming.add(content);
        } else if ("outgoing".equals(tag.getLocalPart())) {
            ArrayList<String> outgoing = (ArrayList<String>)buffer.get("outgoing");
            if (outgoing == null) {
                outgoing = new ArrayList<String>();
                buffer.put("outgoing", outgoing);
            }
            outgoing.add(content);
        }
    }

    protected static final void handleJadexElement(MBpmnModel model, XmlTag tag, LinkedList<XmlTag> tagstack, Map<String, String> attrs, String content, Map<String, Object> buffer, Map<String, MIdElement> emap) {
        ClassLoader cl = model.getClassLoader();
        if ("description".equals(tag.getLocalPart())) {
            if (tagstack.size() > 0 && "extension".equals(tagstack.get(0).getLocalPart())) {
                ((ModelInfo)model.getModelInfo()).setDescription(content);
            } else {
                buffer.put(tag.getLocalPart(), content);
            }
        } else if ("poollane".equals(tag.getLocalPart())) {
            buffer.put(tag.getLocalPart(), content);
        } else if ("startElement".equals(tag.getLocalPart())) {
            ArrayList<String> startelements = (ArrayList<String>)buffer.get("startelements");
            if (startelements == null) {
                startelements = new ArrayList<String>();
                buffer.put("startelements", startelements);
            }
            startelements.add(content);
        } else if ("parametermapping".equals(tag.getLocalPart())) {
            HashMap<String, String> mappings = (HashMap<String, String>)buffer.get("parametermappings");
            if (mappings == null) {
                mappings = new HashMap<String, String>();
                buffer.put("parametermappings", mappings);
            }
            mappings.put(attrs.get("name"), content);
        } else if (SBpmnModelReader.matchLTag("class", tag)) {
            buffer.put("class", content);
        } else if ("modelname".equals(tag.getLocalPart())) {
            model.setName(content);
        } else if ("subprocessref".equals(tag.getLocalPart())) {
            ((MSubProcess)((LinkedList)buffer.get("subprocessstack")).peek()).addProperty("filename", content);
        } else if ("subprocessexpressionref".equals(tag.getLocalPart())) {
            UnparsedExpression fileexp = new UnparsedExpression("file", String.class, content, null);
            MProperty mprop = new MProperty(fileexp.getClazz(), fileexp.getName(), fileexp);
            ((MSubProcess)((LinkedList)buffer.get("subprocessstack")).peek()).addProperty(mprop);
        } else if ("parameter".equals(tag.getLocalPart())) {
            ArrayList<MParameter> params = (ArrayList<MParameter>)buffer.get("parameters");
            if (params == null) {
                params = new ArrayList<MParameter>();
                buffer.put("parameters", params);
            }
            ClassInfo clazz = new ClassInfo(attrs.get("type"));
            String name = attrs.get("name");
            UnparsedExpression exp = null;
            if (content != null && content.length() > 0) {
                exp = new UnparsedExpression(name, clazz.getTypeName(), content, null);
                SBpmnModelReader.parseExp(exp, model.getModelInfo().getAllImports(), cl);
            }
            MParameter param = new MParameter(attrs.get("direction"), clazz, name, exp);
            params.add(param);
        } else if ("property".equals(tag.getLocalPart())) {
            String type;
            ArrayList<MProperty> props = (ArrayList<MProperty>)buffer.get("properties");
            if (props == null) {
                props = new ArrayList<MProperty>();
                buffer.put("properties", props);
            }
            ClassInfo clazz = (type = attrs.get("type")) != null ? new ClassInfo(type) : null;
            String typename = clazz != null ? clazz.getTypeName() : null;
            String name = attrs.get("name");
            UnparsedExpression exp = null;
            if (content != null && content.length() > 0) {
                exp = new UnparsedExpression(name, typename, content, null);
                SBpmnModelReader.parseExp(exp, model.getModelInfo().getAllImports(), cl);
            }
            MProperty prop = new MProperty(clazz, name, exp);
            props.add(prop);
        } else if ("argumentvalues".equals(tag.getLocalPart())) {
            Object vals = buffer.remove("values");
            if (vals != null) {
                buffer.put("argvalues", vals);
            }
        } else if ("resultvalues".equals(tag.getLocalPart())) {
            Object vals = buffer.remove("values");
            if (vals != null) {
                buffer.put("resvalues", vals);
            }
        } else if ("contextvariablevalues".equals(tag.getLocalPart())) {
            Object vals = buffer.remove("values");
            if (vals != null) {
                buffer.put("ctvvalues", vals);
            }
        } else if ("value".equals(tag.getLocalPart())) {
            if (attrs != null && attrs.containsKey("name")) {
                HashMap<String, String> vals = (HashMap<String, String>)buffer.get("values");
                if (vals == null) {
                    vals = new HashMap<String, String>();
                    buffer.put("values", vals);
                }
                vals.put(attrs.get("name"), content);
            } else {
                buffer.put("value", content);
            }
        } else if (buffer.containsKey("extension")) {
            if ("package".equals(tag.getLocalPart())) {
                ((ModelInfo)model.getModelInfo()).setPackage(content);
            } else if ("componentflags".equals(tag.getLocalPart())) {
                if (attrs.containsKey("suspend")) {
                    ((ModelInfo)model.getModelInfo()).setSuspend(Boolean.valueOf(Boolean.parseBoolean(attrs.get("suspend"))));
                }
                if (attrs.containsKey("master")) {
                    ((ModelInfo)model.getModelInfo()).setMaster(Boolean.valueOf(Boolean.parseBoolean(attrs.get("master"))));
                }
                if (attrs.containsKey("daemon")) {
                    ((ModelInfo)model.getModelInfo()).setDaemon(Boolean.valueOf(Boolean.parseBoolean(attrs.get("daemon"))));
                }
                if (attrs.containsKey("autoshutdown")) {
                    ((ModelInfo)model.getModelInfo()).setAutoShutdown(Boolean.valueOf(Boolean.parseBoolean(attrs.get("autoshutdown"))));
                }
                if (attrs.containsKey("synchronous")) {
                    ((ModelInfo)model.getModelInfo()).setSynchronous(Boolean.valueOf(Boolean.parseBoolean(attrs.get("synchronous"))));
                }
                if (attrs.containsKey("persistable")) {
                    ((ModelInfo)model.getModelInfo()).setPersistable(Boolean.valueOf(Boolean.parseBoolean(attrs.get("persistable"))));
                }
                if (attrs.containsKey("keepalive")) {
                    model.setKeepAlive(Boolean.parseBoolean(attrs.get("keepalive")));
                }
                if (attrs.containsKey("monitoring")) {
                    String monattr = attrs.get("monitoring");
                    if (monattr != null && monattr.equalsIgnoreCase("true")) {
                        ((ModelInfo)model.getModelInfo()).setMonitoring(IMonitoringService.PublishEventLevel.MEDIUM);
                    } else if (monattr != null && monattr.equalsIgnoreCase("false")) {
                        ((ModelInfo)model.getModelInfo()).setMonitoring(IMonitoringService.PublishEventLevel.OFF);
                    } else {
                        ((ModelInfo)model.getModelInfo()).setMonitoring(IMonitoringService.PublishEventLevel.valueOf((String)attrs.get("monitoring")));
                    }
                }
            } else if ("import".equals(tag.getLocalPart())) {
                model.addImport(content);
            } else if ("subcomponent".equals(tag.getLocalPart())) {
                SubcomponentTypeInfo scti = new SubcomponentTypeInfo(attrs.get("name"), content);
                ((ModelInfo)model.getModelInfo()).addSubcomponentType(scti);
            } else if ("argument".equals(tag.getLocalPart())) {
                Argument arg = new Argument();
                arg.setName(attrs.get("name"));
                arg.setClazz(new ClassInfo(attrs.get("type")));
                if (buffer.containsKey("description")) {
                    arg.setDescription((String)buffer.remove("description"));
                }
                if (buffer.containsKey("value")) {
                    arg.setValue((String)buffer.remove("value"));
                }
                ((ModelInfo)model.getModelInfo()).addArgument((IArgument)arg);
            } else if ("result".equals(tag.getLocalPart())) {
                Argument arg = new Argument();
                arg.setName(attrs.get("name"));
                arg.setClazz(new ClassInfo(attrs.get("type")));
                if (buffer.containsKey("description")) {
                    arg.setDescription((String)buffer.remove("description"));
                }
                if (buffer.containsKey("value")) {
                    arg.setValue((String)buffer.remove("value"));
                }
                ((ModelInfo)model.getModelInfo()).addResult((IArgument)arg);
            } else if ("contextvariable".equals(tag.getLocalPart())) {
                String name = attrs.get("name");
                String type = attrs.get("type");
                MContextVariable var = new MContextVariable(name, null, type, (String)buffer.remove("value"));
                SBpmnModelReader.parseExp((UnparsedExpression)var, model.getModelInfo().getAllImports(), cl);
                model.addContextVariable(var);
            } else if ("providedservice".equals(tag.getLocalPart())) {
                String name = attrs.get("name");
                ClassInfo itrface = attrs.get("interface") != null ? new ClassInfo(attrs.get("interface")) : null;
                ClassInfo clazz = attrs.get("class") != null ? new ClassInfo(attrs.get("class")) : null;
                String proxytype = attrs.get("proxytype");
                String impl = attrs.get("implementation");
                ProvidedServiceInfo ps = new ProvidedServiceInfo();
                ps.setName(name);
                ps.setType(itrface);
                ps.setImplementation(new ProvidedServiceImplementation());
                ps.getImplementation().setClazz(clazz);
                ps.getImplementation().setProxytype(proxytype);
                ps.getImplementation().setValue(impl);
                ((ModelInfo)model.getModelInfo()).addProvidedService(ps);
            } else if ("providedserviceconfiguration".equals(tag.getLocalPart())) {
                ArrayList<ProvidedServiceInfo> vals = (ArrayList<ProvidedServiceInfo>)buffer.get("psconfs");
                if (vals == null) {
                    vals = new ArrayList<ProvidedServiceInfo>();
                    buffer.put("psconfs", vals);
                }
                String name = attrs.get("name");
                ClassInfo clazz = attrs.get("class") != null ? new ClassInfo(attrs.get("class")) : null;
                String proxytype = attrs.get("proxytype");
                String impl = attrs.get("implementation");
                ProvidedServiceInfo ps = new ProvidedServiceInfo();
                ps.setName(name);
                ps.setImplementation(new ProvidedServiceImplementation());
                ps.getImplementation().setClazz(clazz);
                ps.getImplementation().setProxytype(proxytype);
                ps.getImplementation().setValue(impl);
                vals.add(ps);
            } else if ("requiredservice".equals(tag.getLocalPart())) {
                String name = attrs.get("name");
                ClassInfo itrface = attrs.get("interface") != null ? new ClassInfo(attrs.get("interface")) : null;
                Boolean multi = attrs.get("multi") != null ? Boolean.valueOf(Boolean.parseBoolean(attrs.get("multi"))) : null;
                String scope = attrs.get("scope");
                String dyn = attrs.get("dynamic");
                String create = attrs.get("create");
                RequiredServiceInfo rs = new RequiredServiceInfo();
                rs.setName(name);
                rs.setType(itrface);
                if (multi != null) {
                    rs.setMultiple(multi.booleanValue());
                }
                rs.setDefaultBinding(new RequiredServiceBinding());
                rs.getDefaultBinding().setScope(scope);
                if (dyn != null) {
                    rs.getDefaultBinding().setDynamic(Boolean.parseBoolean(dyn));
                }
                if (create != null) {
                    rs.getDefaultBinding().setCreate(Boolean.parseBoolean(create));
                }
                ((ModelInfo)model.getModelInfo()).addRequiredService(rs);
            } else if ("requiredserviceconfiguration".equals(tag.getLocalPart())) {
                ArrayList<RequiredServiceInfo> vals = (ArrayList<RequiredServiceInfo>)buffer.get("rsconfs");
                if (vals == null) {
                    vals = new ArrayList<RequiredServiceInfo>();
                    buffer.put("rsconfs", vals);
                }
                String name = attrs.get("name");
                String scope = attrs.get("scope");
                RequiredServiceInfo rs = new RequiredServiceInfo();
                rs.setName(name);
                rs.setDefaultBinding(new RequiredServiceBinding());
                rs.getDefaultBinding().setScope(scope);
                vals.add(rs);
            } else if ("configuration".equals(tag.getLocalPart())) {
                List rsconfs;
                List psconfs;
                UnparsedExpression exp;
                Map vals;
                ConfigurationInfo conf = new ConfigurationInfo(attrs.get("name"));
                if (attrs.containsKey("suspend")) {
                    conf.setSuspend(Boolean.valueOf(Boolean.parseBoolean(attrs.get("suspend"))));
                }
                if (attrs.containsKey("master")) {
                    conf.setMaster(Boolean.valueOf(Boolean.parseBoolean(attrs.get("master"))));
                }
                if (attrs.containsKey("daemon")) {
                    conf.setDaemon(Boolean.valueOf(Boolean.parseBoolean(attrs.get("daemon"))));
                }
                if (attrs.containsKey("autoshutdown")) {
                    conf.setAutoShutdown(Boolean.valueOf(Boolean.parseBoolean(attrs.get("autoshutdown"))));
                }
                if (buffer.containsKey("description")) {
                    conf.setDescription((String)buffer.remove("description"));
                }
                if (buffer.containsKey("poollane")) {
                    buffer.remove("poollane");
                    System.out.println("Warning: Ignoring obsolete pool/lane element.");
                }
                if (buffer.containsKey("startelements")) {
                    List startelements = (List)buffer.remove("startelements");
                    Object startelementsmap = (Map)buffer.get("startelementsmap");
                    if (startelementsmap == null) {
                        startelementsmap = new HashMap<String, List>();
                        buffer.put("startelementsmap", startelementsmap);
                    }
                    startelementsmap.put(conf.getName(), startelements);
                }
                if ((vals = (Map)buffer.remove("argvalues")) != null) {
                    for (Map.Entry entry : vals.entrySet()) {
                        exp = new UnparsedExpression();
                        exp.setName((String)entry.getKey());
                        exp.setClazz(model.getModelInfo().getArgument(exp.getName()).getClazz());
                        exp.setValue((String)entry.getValue());
                        SBpmnModelReader.parseExp(exp, model.getModelInfo().getAllImports(), cl);
                        conf.addArgument(exp);
                    }
                }
                if ((vals = (Map)buffer.remove("resvalues")) != null) {
                    for (Map.Entry entry : vals.entrySet()) {
                        exp = new UnparsedExpression();
                        exp.setName((String)entry.getKey());
                        exp.setClazz(model.getModelInfo().getResult(exp.getName()).getClazz());
                        exp.setValue((String)entry.getValue());
                        SBpmnModelReader.parseExp(exp, model.getModelInfo().getAllImports(), cl);
                        conf.addResult(exp);
                    }
                }
                if ((vals = (Map)buffer.remove("ctvvalues")) != null) {
                    for (Map.Entry entry : vals.entrySet()) {
                        exp = new UnparsedExpression();
                        exp.setName((String)entry.getKey());
                        MContextVariable contextvar = model.getContextVariable((String)entry.getKey());
                        exp.setClazz(contextvar.getClazz());
                        exp.setValue((String)entry.getValue());
                        SBpmnModelReader.parseExp(exp, model.getModelInfo().getAllImports(), cl);
                        contextvar.setValue(conf.getName(), exp);
                    }
                }
                if ((psconfs = (List)buffer.remove("psconfs")) != null) {
                    conf.setProvidedServices(psconfs.toArray(new ProvidedServiceInfo[psconfs.size()]));
                }
                if ((rsconfs = (List)buffer.remove("rsconfs")) != null) {
                    conf.setRequiredServices(rsconfs.toArray(new RequiredServiceInfo[rsconfs.size()]));
                }
                ((ModelInfo)model.getModelInfo()).addConfiguration(conf);
            }
        } else if ("dataFlow".equals(tag.getLocalPart())) {
            MDataEdge edge = new MDataEdge();
            edge.setId(attrs.get("id"));
            String edgename = attrs.get("name");
            edgename = edgename != null ? XmlUtil.unescapeString((String)edgename) : null;
            edge.setName(edgename);
            MActivity src = (MActivity)emap.get(attrs.get("sourceRef"));
            MActivity tgt = (MActivity)emap.get(attrs.get("targetRef"));
            edge.setSource(src);
            edge.setTarget(tgt);
            edge.setSourceParameter(SBpmnModelWriter.handleNullStr(attrs.get("sourceParam")));
            edge.setTargetParameter(SBpmnModelWriter.handleNullStr(attrs.get("targetParam")));
            String expstr = (String)buffer.remove("dataFlowValueMapping");
            if (expstr != null && expstr.length() > 0) {
                UnparsedExpression exp = new UnparsedExpression(edge.getSourceParameter() + "-" + edge.getTargetParameter(), "java.lang.Object", expstr, null);
                SBpmnModelReader.parseExp(exp, model.getModelInfo().getAllImports(), cl);
                edge.setParameterMapping(exp);
            }
            if (src != null && tgt != null) {
                if (src != null) {
                    src.addOutgoingDataEdge(edge);
                }
                if (tgt != null) {
                    tgt.addIncomingDataEdge(edge);
                }
                emap.put(edge.getId(), edge);
            } else {
                System.err.println("Dangling data edge: " + edge.getId());
            }
        } else if ("dataFlowValueMapping".equals(tag.getLocalPart())) {
            buffer.put("dataFlowValueMapping", content);
        }
    }

    protected static final void handleVisualElement(IBpmnVisualModelReader vreader, XmlTag tag, Map<String, String> attrs, String content, Map<String, String> laneparents, Map<String, MIdElement> emap, Map<String, Object> buffer) {
        if (vreader != null) {
            HashMap<String, Cloneable> vbuffer = (HashMap<String, Cloneable>)buffer.get("vbuffer");
            if (vbuffer == null) {
                vbuffer = new HashMap<String, Cloneable>();
                buffer.put("vbuffer", vbuffer);
            }
            if ("Bounds".equals(tag.getLocalPart())) {
                if (vbuffer.containsKey(BOUNDS_KEY)) {
                    Rectangle2D.Double alt = new Rectangle2D.Double();
                    alt.width = Double.parseDouble(attrs.get("width"));
                    alt.height = Double.parseDouble(attrs.get("height"));
                    alt.x = Double.parseDouble(attrs.get("x"));
                    alt.y = Double.parseDouble(attrs.get("y"));
                    vbuffer.put(ALT_BOUNDS_KEY, alt);
                } else {
                    Rectangle2D.Double bounds = new Rectangle2D.Double();
                    bounds.setRect(Double.parseDouble(attrs.get("x")), Double.parseDouble(attrs.get("y")), Double.parseDouble(attrs.get("width")), Double.parseDouble(attrs.get("height")));
                    vbuffer.put(BOUNDS_KEY, bounds);
                }
            } else if ("BPMNShape".equals(tag.getLocalPart())) {
                String bpmnid = attrs.get("bpmnElement");
                MIdElement e = emap.get(bpmnid);
                String exp = attrs.get("isExpanded");
                Boolean expanded = exp != null ? Boolean.valueOf(Boolean.parseBoolean(exp)) : null;
                String eventparentid = e != null ? (String)((Map)buffer.get("eventhandlerparentmap")).get(e.getId()) : null;
                Map spem = (Map)buffer.get("subprocesselementmap");
                String subprocessparentid = e != null ? (spem.get(e.getId()) != null ? ((MSubProcess)spem.get(e.getId())).getId() : null) : null;
                String laneparentid = e != null ? laneparents.get(e.getId()) : null;
                Rectangle2D bounds = (Rectangle2D)vbuffer.remove(BOUNDS_KEY);
                Rectangle2D altbounds = (Rectangle2D)vbuffer.remove(ALT_BOUNDS_KEY);
                Set intparams = (Set)vbuffer.remove(INTERNAL_PARAMETERS_KEY);
                vreader.processBpmnShape(bpmnid, e, expanded, bounds, altbounds, intparams, eventparentid, subprocessparentid, laneparentid);
            } else if ("BPMNEdge".equals(tag.getLocalPart())) {
                String bpmnid = attrs.get("bpmnElement");
                MIdElement medge = emap.get(bpmnid);
                List waypoints = (List)vbuffer.remove(WAYPOINTS_KEY);
                vreader.processBpmnEdge(bpmnid, medge, waypoints);
            } else if ("Edge".equals(tag.getLocalPart())) {
                String type = attrs.get("type");
                List waypoints = (List)vbuffer.remove(WAYPOINTS_KEY);
                vreader.processGenericEdge(type, waypoints, attrs, emap);
            } else if ("waypoint".equals(tag.getLocalPart())) {
                ArrayList<Point2D.Double> waypoints = (ArrayList<Point2D.Double>)vbuffer.get(WAYPOINTS_KEY);
                if (waypoints == null) {
                    waypoints = new ArrayList<Point2D.Double>();
                    vbuffer.put(WAYPOINTS_KEY, waypoints);
                }
                Point2D.Double point = new Point2D.Double();
                point.x = Double.parseDouble(attrs.get("x"));
                point.y = Double.parseDouble(attrs.get("y"));
                waypoints.add(point);
            } else if ("internalParameter".equals(tag.getLocalPart())) {
                HashSet<String> intparams = (HashSet<String>)vbuffer.get(INTERNAL_PARAMETERS_KEY);
                if (intparams == null) {
                    intparams = new HashSet<String>();
                    vbuffer.put(INTERNAL_PARAMETERS_KEY, intparams);
                }
                intparams.add(content);
            }
        }
    }

    protected static final void insertActivity(MActivity act, Map<String, Object> buffer, Map<String, MLane> lanemap, Map<String, MIdElement> emap) {
        MPool pool = (MPool)buffer.get("pool");
        MLane lane = lanemap.get(act.getId());
        if (act.isEventHandler()) {
            act.setPool(pool);
            act.setLane(lane);
            Map ehpm = (Map)buffer.get("eventhandlerparentmap");
            ((MActivity)emap.get(ehpm.get(act.getId()))).addEventHandler(act);
        } else {
            LinkedList sps = (LinkedList)buffer.get("subprocessstack");
            if (!sps.isEmpty()) {
                act.setPool(pool);
                act.setLane(lane);
                ((MSubProcess)sps.peek()).addActivity(act);
                Map spem = (Map)buffer.get("subprocesselementmap");
                spem.put(act.getId(), sps.peek());
            } else if (lane != null) {
                lane.addActivity(act);
                act.setPool(pool);
                act.setLane(lane);
            } else {
                pool.addActivity(act);
                act.setPool(pool);
            }
        }
        emap.put(act.getId(), act);
    }

    protected static final void connectActivityEdges(MActivity act, Map<String, Object> buffer, Map<String, MIdElement> emap) {
        List incoming;
        List outgoing = (List)buffer.remove("outgoing");
        if (outgoing != null) {
            for (String outid : outgoing) {
                MSequenceEdge edge = (MSequenceEdge)emap.get(outid);
                if (edge == null) continue;
                edge.setSource(act);
                act.addOutgoingSequenceEdge(edge);
            }
        }
        if ((incoming = (List)buffer.remove("incoming")) != null) {
            for (String incid : incoming) {
                MSequenceEdge edge = (MSequenceEdge)emap.get(incid);
                if (edge == null) continue;
                edge.setTarget(act);
                act.addIncomingSequenceEdge(edge);
            }
        }
    }

    protected static final UnparsedExpression parseExp(UnparsedExpression exp, String[] imports, ClassLoader cl) {
        if (cl != null) {
            try {
                SJavaParser.parseExpression((UnparsedExpression)exp, (String[])imports, (ClassLoader)cl);
            }
            catch (Exception e) {
                System.err.println("Error parsing expression, name=" + exp.getName() + ", expstring=" + exp.getValue());
                throw new RuntimeException(e);
            }
        }
        return exp;
    }

    protected static final boolean matchLTag(String tagname, XmlTag tag) {
        String oltag = tag.getLocalPart();
        String ltag = TAG_ALIASES.get(oltag);
        if (ltag == null) {
            ltag = oltag;
        }
        return tagname.equals(ltag);
    }

    static {
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.put("taskclass", "class");
        TAG_ALIASES = Collections.unmodifiableMap(aliases);
        ACT_TYPE_MAPPING = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : SBpmnModelWriter.ACT_TYPE_MAPPING.entrySet()) {
            if (entry.getKey().contains("Event")) continue;
            ACT_TYPE_MAPPING.put(entry.getValue(), entry.getKey());
        }
        ACT_TYPE_MAPPING.put("userTask", "Task");
    }
}

