/*
 * Decompiled with CFR 0.152.
 */
package jadex.bpmn.model.io;

import jadex.commons.Base64;
import jadex.commons.IResultCommand;
import jadex.commons.SUtil;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class IdGenerator {
    protected static final int DEFAULT_ID_SIZE = 12;
    protected Random random = new Random();
    protected int idsize;
    protected IResultCommand<String, byte[]> encoder;
    protected Set<String> generatedIds;

    public IdGenerator() {
        this(12, false);
    }

    public IdGenerator(int idsize) {
        this(idsize, false);
    }

    public IdGenerator(boolean collisionfree) {
        this(12, collisionfree);
    }

    public IdGenerator(int idsize, boolean collisionfree) {
        this.idsize = idsize;
        if (collisionfree) {
            this.generatedIds = new HashSet<String>();
        }
        this.base64Mode();
    }

    public String generateId() {
        byte[] rawid = new byte[this.idsize];
        this.random.nextBytes(rawid);
        String id = (String)this.encoder.execute((Object)rawid);
        if (this.generatedIds != null) {
            while (this.generatedIds.contains(id)) {
                this.random.nextBytes(rawid);
                id = (String)this.encoder.execute((Object)rawid);
            }
            this.generatedIds.add(id);
        }
        return id;
    }

    public void addUsedId(String id) {
        if (this.generatedIds != null) {
            this.generatedIds.add(id);
        }
    }

    public void removeUsedId(String id) {
        if (this.generatedIds != null) {
            this.generatedIds.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void base64Mode() {
        IdGenerator idGenerator = this;
        synchronized (idGenerator) {
            this.encoder = new IResultCommand<String, byte[]>(){

                public String execute(byte[] args) {
                    String id = new String(Base64.toCharArray((byte[])args));
                    return id;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void base16Mode() {
        IdGenerator idGenerator = this;
        synchronized (idGenerator) {
            this.encoder = new IResultCommand<String, byte[]>(){

                public String execute(byte[] args) {
                    String id = SUtil.hex((byte[])args);
                    return id;
                }
            };
        }
    }

    public static void main(String[] args) {
        int i;
        IdGenerator idgen = new IdGenerator();
        for (i = 0; i < 100; ++i) {
            System.out.println(idgen.generateId());
        }
        idgen.base16Mode();
        for (i = 0; i < 100; ++i) {
            System.out.println(idgen.generateId());
        }
    }
}

