/*
 * Decompiled with CFR 0.152.
 */
package jadex.bpmn.model.io;

import jadex.bpmn.model.MActivity;
import jadex.bpmn.model.MBpmnModel;
import jadex.bpmn.model.MIdElement;
import jadex.bpmn.model.MLane;
import jadex.bpmn.model.MParameter;
import jadex.bpmn.model.MPool;
import jadex.bpmn.model.MSubProcess;
import jadex.bridge.ClassInfo;
import jadex.bridge.modelinfo.UnparsedExpression;
import jadex.xml.AccessInfo;
import jadex.xml.AttributeInfo;
import jadex.xml.IAttributeConverter;
import jadex.xml.IContext;
import jadex.xml.IPostProcessor;
import jadex.xml.MappingInfo;
import jadex.xml.ObjectInfo;
import jadex.xml.SubobjectInfo;
import jadex.xml.TypeInfo;
import jadex.xml.TypeInfoPathManager;
import jadex.xml.XMLInfo;
import jadex.xml.bean.BeanObjectReaderHandler;
import jadex.xml.reader.AReadContext;
import jadex.xml.reader.AReader;
import jadex.xml.reader.IObjectReaderHandler;
import jadex.xml.reader.XMLReaderFactory;
import jadex.xml.stax.QName;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BpmnModelReader {
    protected static final ElementMapper E_MAPPER = new ElementMapper();
    protected static final ActivityProcessor ACT_PROCESSOR = new ActivityProcessor();
    protected static final IAttributeConverter CLASS_INFO_CONVERTER = new ClassInfoConverter();
    protected static final ExpressionConverter EXP_CONVERTER = new ExpressionConverter();

    public void read(File file) throws Exception {
        FileInputStream is = new FileInputStream(file);
        AReader reader = XMLReaderFactory.getInstance().createReader(false, false, null);
        Set types = BpmnModelReader.getXMLMapping();
        reader.read(new TypeInfoPathManager(types), (IObjectReaderHandler)new BeanObjectReaderHandler(types){

            public void handleAttributeValue(Object object, QName xmlattrname, List attrpath, String attrval, Object attrinfo, AReadContext context) throws Exception {
                if (attrinfo != null) {
                    super.handleAttributeValue(object, xmlattrname, attrpath, attrval, attrinfo, context);
                }
            }
        }, (InputStream)is, BpmnModelReader.class.getClassLoader(), (Object)new BpmnReadContext());
    }

    protected static final Set getXMLMapping() {
        HashSet<TypeInfo> types = new HashSet<TypeInfo>();
        String semuri = "http://www.omg.org/spec/BPMN/20100524/MODEL";
        String exturi = "http://www.activecomponents.org/bpmnextensions";
        TypeInfo type = BpmnModelReader.createTypeInfo(MBpmnModel.class, semuri, "definitions", null, new AccessInfo[]{new AccessInfo("process", (Object)"pool")}, new QName[]{new QName("targetNamespace")}, new QName[]{new QName(semuri, "flowNodeRf"), new QName(semuri, "outgoing"), new QName(semuri, "incoming")});
        types.add(type);
        type = BpmnModelReader.createTypeInfo(MPool.class, null, semuri, "process", null, new Object[]{new AccessInfo(new QName(semuri, "sProcess"), (Object)"activity")}, null, null);
        types.add(type);
        type = BpmnModelReader.createTypeInfo(MLane.class, new ElementMapper(){

            @Override
            public Object postProcess(IContext context, Object object) {
                object = super.postProcess(context, object);
                BpmnReadContext rc = (BpmnReadContext)context.getUserContext();
                for (String flowref : rc.getFlowRefs()) {
                    System.out.println("Adding to map: " + flowref);
                    rc.lanemap.put(flowref, (MLane)object);
                }
                rc.getFlowRefs().clear();
                return object;
            }
        }, semuri, "lane", null, new Object[]{new AccessInfo(new QName(semuri, "subProcess"), (Object)"activity")}, null, null);
        types.add(type);
        type = BpmnModelReader.createTypeInfo(String.class, new IPostProcessor(){

            public Object postProcess(IContext context, Object object) {
                System.out.println("Triggered");
                BpmnReadContext rc = (BpmnReadContext)context.getUserContext();
                rc.getFlowRefs().add((String)object);
                return IPostProcessor.DISCARD_OBJECT;
            }

            public int getPass() {
                return 0;
            }
        }, semuri, "flowNodeRef", null, null, null, null);
        types.add(type);
        type = BpmnModelReader.createTypeInfo(MSubProcess.class, ACT_PROCESSOR, semuri, "subProcess", null, new Object[]{new AccessInfo(new QName(semuri, "task"), (Object)"activity")}, null, new QName[]{new QName(semuri, "incoming"), new QName(semuri, "outgoing")});
        types.add(type);
        type = BpmnModelReader.createTypeInfo(MActivity.class, ACT_PROCESSOR, semuri, "task", null, new Object[]{new AccessInfo(new QName(exturi, "taskclass"), (Object)"clazz")}, null, new QName[]{new QName(semuri, "incoming"), new QName(semuri, "outgoing")});
        types.add(type);
        type = BpmnModelReader.createTypeInfo(ClassInfo.class, null, exturi, "taskclass", null, null, "typeName", null, null);
        types.add(type);
        type = BpmnModelReader.createTypeInfo(MParameter.class, new IPostProcessor(){

            public Object postProcess(IContext context, Object object) {
                MParameter param = (MParameter)object;
                param.getInitialValue().setName(param.getName());
                param.getInitialValue().getClazz().setTypeName(param.getClazz().getTypeName());
                return object;
            }

            public int getPass() {
                return 0;
            }
        }, exturi, "parameter", new Object[]{new AttributeInfo(new AccessInfo("type", (Object)"clazz"), CLASS_INFO_CONVERTER)}, null, new AttributeInfo(new AccessInfo((String)null, (Object)"initialValue"), (IAttributeConverter)EXP_CONVERTER), null, null);
        types.add(type);
        return types;
    }

    protected static final TypeInfo createTypeInfo(Class<?> clazz, String uri, String localpart, Object[] attributemappings, Object[] soaccessmappings, QName[] ignoreattrs, QName[] ignoreso) {
        return BpmnModelReader.createTypeInfo(clazz, null, uri, localpart, attributemappings, soaccessmappings, ignoreattrs, ignoreso);
    }

    protected static final TypeInfo createTypeInfo(Class<?> clazz, IPostProcessor postproc, String uri, String localpart, Object[] attributemappings, Object[] soaccessmappings, QName[] ignoreattrs, QName[] ignoreso) {
        return BpmnModelReader.createTypeInfo(clazz, postproc, uri, localpart, attributemappings, soaccessmappings, null, ignoreattrs, ignoreso);
    }

    protected static final TypeInfo createTypeInfo(Class<?> clazz, IPostProcessor postproc, String uri, String localpart, Object[] attributemappings, Object[] soaccessmappings, Object contentinfo, QName[] ignoreattrs, QName[] ignoreso) {
        int i;
        int i2;
        XMLInfo xi = new XMLInfo(new QName(uri, localpart));
        ArrayList<AttributeInfo> ailist = new ArrayList<AttributeInfo>();
        for (i2 = 0; attributemappings != null && i2 < attributemappings.length; ++i2) {
            if (attributemappings[i2] instanceof AccessInfo) {
                ailist.add(new AttributeInfo((AccessInfo)attributemappings[i2]));
                continue;
            }
            if (!(attributemappings[i2] instanceof AttributeInfo)) continue;
            ailist.add((AttributeInfo)attributemappings[i2]);
        }
        for (i2 = 0; ignoreattrs != null && i2 < ignoreattrs.length; ++i2) {
            ailist.add(new AttributeInfo(new AccessInfo(ignoreattrs[i2], null, "ignore_read")));
        }
        AttributeInfo[] ais = ailist.toArray(new AttributeInfo[ailist.size()]);
        ArrayList<SubobjectInfo> solist = new ArrayList<SubobjectInfo>();
        for (i = 0; soaccessmappings != null && i < soaccessmappings.length; ++i) {
            if (soaccessmappings[i] instanceof AccessInfo) {
                solist.add(new SubobjectInfo((AccessInfo)soaccessmappings[i]));
                continue;
            }
            if (!(soaccessmappings[i] instanceof SubobjectInfo)) continue;
            solist.add((SubobjectInfo)soaccessmappings[i]);
        }
        for (i = 0; ignoreso != null && i < ignoreso.length; ++i) {
            solist.add(new SubobjectInfo(new AccessInfo(ignoreso[i], null, "ignore_read")));
        }
        SubobjectInfo[] soinfos = solist.toArray(new SubobjectInfo[solist.size()]);
        if (contentinfo instanceof String) {
            contentinfo = new AttributeInfo(new AccessInfo((String)null, contentinfo));
        }
        MappingInfo mi = new MappingInfo(null, null, contentinfo, ais, soinfos);
        ObjectInfo oi = postproc == null ? new ObjectInfo(clazz) : new ObjectInfo(clazz, postproc);
        TypeInfo ret = new TypeInfo(xi, oi, mi);
        return ret;
    }

    protected static <T> T[] concatArrays(Class<T> clazz, T[] array0, T[] array1) {
        Object[] ret = (Object[])Array.newInstance(clazz, array0.length + array1.length);
        System.arraycopy(array0, 0, ret, 0, array0.length);
        System.arraycopy(array1, 0, ret, array0.length, array1.length);
        return ret;
    }

    protected class BpmnReadContext {
        protected Map<String, MIdElement> elementmap = new HashMap<String, MIdElement>();
        protected List<String> flowrefs = new ArrayList<String>();
        protected Map<String, MLane> lanemap = new HashMap<String, MLane>();

        protected BpmnReadContext() {
        }

        public Map<String, MIdElement> getElementMap() {
            return this.elementmap;
        }

        public List<String> getFlowRefs() {
            return this.flowrefs;
        }

        public Map<String, MLane> getLaneMap() {
            return this.lanemap;
        }
    }

    protected static class ExpressionConverter
    implements IAttributeConverter {
        protected ExpressionConverter() {
        }

        public Object convertString(String val, Object context) throws Exception {
            return new UnparsedExpression(null, "java.lang.Object", val, null);
        }

        public String convertObject(Object val, Object context) {
            return ((UnparsedExpression)val).getValue();
        }
    }

    protected static class ClassInfoConverter
    implements IAttributeConverter {
        protected ClassInfoConverter() {
        }

        public Object convertString(String val, Object context) throws Exception {
            return new ClassInfo(val);
        }

        public String convertObject(Object val, Object context) {
            return ((ClassInfo)val).getTypeName();
        }
    }

    protected static class ElementMapper
    implements IPostProcessor {
        protected ElementMapper() {
        }

        public Object postProcess(IContext context, Object object) {
            System.out.println("EMapper got: " + String.valueOf(object));
            BpmnReadContext rc = (BpmnReadContext)context.getUserContext();
            if (object instanceof MIdElement) {
                MIdElement element = (MIdElement)object;
                rc.getElementMap().put(element.getId(), element);
            }
            return object;
        }

        public int getPass() {
            return 0;
        }
    }

    protected static class ActivityProcessor
    extends ElementMapper {
        protected ActivityProcessor() {
        }

        @Override
        public Object postProcess(IContext context, Object object) {
            object = super.postProcess(context, object);
            BpmnReadContext rc = (BpmnReadContext)context.getUserContext();
            MActivity act = (MActivity)object;
            MLane lane = rc.getLaneMap().get(act.getId());
            if (lane != null) {
                lane.addActivity(act);
                object = IPostProcessor.DISCARD_OBJECT;
            } else {
                System.out.println("Not found: " + act.getId());
            }
            return object;
        }
    }
}

