/*
 * Decompiled with CFR 0.152.
 */
package jadex.bpmn.model;

import jadex.bpmn.model.MActivity;
import jadex.bpmn.model.MArtifact;
import jadex.bpmn.model.MBpmnModel;
import jadex.bpmn.model.MEdge;
import java.util.ArrayList;
import java.util.List;

public class MSubProcess
extends MActivity {
    public static final String SUBPROCESSTYPE_NONE = "none";
    public static final String SUBPROCESSTYPE_PARALLEL = "parallel";
    public static final String SUBPROCESSTYPE_SEQUENTIAL = "sequential";
    public static final String SUBPROCESSTYPE_EVENT = "event";
    public static final String MULTIINSTANCE_ITERATOR = "iterator";
    protected List<MActivity> activities;
    protected List<MArtifact> artifacts;
    protected String subprocesstype;

    public List<MActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<MActivity> activities) {
        this.activities = activities;
    }

    public List<MEdge> getEdges() {
        ArrayList<MEdge> ret = new ArrayList<MEdge>();
        for (MActivity act : this.activities) {
            if (act.getOutgoingDataEdges() != null) {
                ret.addAll(act.getOutgoingDataEdges());
            }
            if (act.getOutgoingSequenceEdges() != null) {
                ret.addAll(act.getOutgoingSequenceEdges());
            }
            if (act.getOutgoingMessagingEdges() == null) continue;
            ret.addAll(act.getOutgoingMessagingEdges());
        }
        return ret;
    }

    public void addActivity(MActivity activity) {
        if (this.activities == null) {
            this.activities = new ArrayList<MActivity>();
        }
        if (this.activities.contains(activity)) {
            Thread.dumpStack();
            System.out.println("Duplicate Item:" + activity);
        }
        this.activities.add(activity);
    }

    public void removeActivity(MActivity vertex) {
        if (this.activities != null) {
            this.activities.remove(vertex);
        }
    }

    public MActivity getActivity(String id) {
        MActivity ret = null;
        if (this.activities != null) {
            for (MActivity act : this.activities) {
                if (!act.getId().equals(id)) continue;
                ret = act;
                break;
            }
        }
        return ret;
    }

    public List<MActivity> getStartActivities() {
        return MBpmnModel.getStartActivities(this.activities);
    }

    public List<MArtifact> getArtifacts() {
        return this.artifacts;
    }

    public void addArtifact(MArtifact artifact) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList<MArtifact>();
        }
        this.artifacts.add(artifact);
    }

    public void removeArtifact(MArtifact artifact) {
        if (this.artifacts != null) {
            this.artifacts.remove(artifact);
        }
    }

    public String getSubprocessType() {
        return this.subprocesstype != null ? this.subprocesstype : SUBPROCESSTYPE_NONE;
    }

    public void setSubprocessType(String subprocesstype) {
        assert (SUBPROCESSTYPE_NONE.equals(subprocesstype) || SUBPROCESSTYPE_PARALLEL.equals(subprocesstype) || SUBPROCESSTYPE_SEQUENTIAL.equals(subprocesstype) || SUBPROCESSTYPE_EVENT.equals(subprocesstype)) : subprocesstype + ", " + this;
        this.subprocesstype = subprocesstype;
    }
}

