/*
 * Decompiled with CFR 0.152.
 */
package jadex.bpmn.model;

import jadex.bpmn.model.MActivity;
import jadex.bpmn.model.MAnnotationElement;
import jadex.bpmn.model.MArtifact;
import jadex.bpmn.model.MAssociation;
import jadex.bpmn.model.MContextVariable;
import jadex.bpmn.model.MDataEdge;
import jadex.bpmn.model.MEdge;
import jadex.bpmn.model.MIdElement;
import jadex.bpmn.model.MLane;
import jadex.bpmn.model.MMessagingEdge;
import jadex.bpmn.model.MNamedIdElement;
import jadex.bpmn.model.MPool;
import jadex.bpmn.model.MSequenceEdge;
import jadex.bpmn.model.MSubProcess;
import jadex.bpmn.model.io.IdGenerator;
import jadex.bridge.IResourceIdentifier;
import jadex.bridge.modelinfo.ConfigurationInfo;
import jadex.bridge.modelinfo.IArgument;
import jadex.bridge.modelinfo.IModelInfo;
import jadex.bridge.modelinfo.ModelInfo;
import jadex.bridge.modelinfo.UnparsedExpression;
import jadex.bridge.service.ProvidedServiceImplementation;
import jadex.bridge.service.ProvidedServiceInfo;
import jadex.commons.ICacheableModel;
import jadex.commons.SReflect;
import jadex.commons.Tuple2;
import jadex.commons.collection.BiHashMap;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.commons.transformation.traverser.Traverser;
import jadex.javaparser.SJavaParser;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class MBpmnModel
extends MAnnotationElement
implements ICacheableModel {
    public static final String TASK = "Task";
    public static final String SUBPROCESS = "SubProcess";
    public static final String GATEWAY_PARALLEL = "GatewayParallel";
    public static final String GATEWAY_DATABASED_EXCLUSIVE = "GatewayDataBasedExclusive";
    public static final String GATEWAY_DATABASED_INCLUSIVE = "GatewayDataBasedInclusive";
    public static final String EVENT_START_EMPTY = "EventStartEmpty";
    public static final String EVENT_START_MESSAGE = "EventStartMessage";
    public static final String EVENT_START_TIMER = "EventStartTimer";
    public static final String EVENT_START_RULE = "EventStartRule";
    public static final String EVENT_START_SIGNAL = "EventStartSignal";
    public static final String EVENT_START_MULTIPLE = "EventStartMultiple";
    public static final String EVENT_END_EMPTY = "EventEndEmpty";
    public static final String EVENT_END_ERROR = "EventEndError";
    public static final String EVENT_END_MESSAGE = "EventEndMessage";
    public static final String EVENT_END_SIGNAL = "EventEndSignal";
    public static final String EVENT_END_COMPENSATION = "EventEndCompensation";
    public static final String EVENT_END_CANCEL = "EventEndCancel";
    public static final String EVENT_END_TERMINATE = "EventEndTerminate";
    public static final String EVENT_INTERMEDIATE_EMPTY = "EventIntermediateEmpty";
    public static final String EVENT_INTERMEDIATE_ERROR = "EventIntermediateError";
    public static final String EVENT_INTERMEDIATE_RULE = "EventIntermediateRule";
    public static final String EVENT_INTERMEDIATE_SIGNAL = "EventIntermediateSignal";
    public static final String EVENT_INTERMEDIATE_MESSAGE = "EventIntermediateMessage";
    public static final String EVENT_INTERMEDIATE_TIMER = "EventIntermediateTimer";
    public static final String EVENT_INTERMEDIATE_COMPENSATION = "EventIntermediateCompensation";
    public static final String EVENT_INTERMEDIATE_CANCEL = "EventIntermediateCancel";
    public static final String EVENT_INTERMEDIATE_MULTIPLE = "EventIntermediateMultiple";
    public static final String PROPERTY_EVENT_ERROR = "exception";
    public static final String PROPERTY_EVENT_RULE_CONDITION = "condition";
    public static final String PROPERTY_EVENT_RULE_EVENTTYPES = "eventtypes";
    public static final String SIGNAL_EVENT_TRIGGER = "signal_trigger";
    public static final String TRIGGER = "_process_trigger";
    protected List<MPool> pools;
    protected List<MArtifact> artifacts;
    protected List<MMessagingEdge> messages;
    protected List<MDataEdge> resultdataedges;
    protected List<MDataEdge> argdataedges;
    protected Map<String, MSequenceEdge> alledges;
    protected Map<String, MActivity> allactivities;
    protected Map<MSubProcess, List<MActivity>> eventsubprocessstartevents;
    protected List<MActivity> waitingevents;
    protected List<MActivity> typematchedstartevents;
    protected Map<MIdElement, MIdElement> parents;
    protected Map<String, MIdElement> associationsources;
    protected Map<String, MIdElement> associationtargets;
    protected Map<String, MMessagingEdge> allmessagingedges;
    protected Map<String, MDataEdge> alldataedges;
    protected Map<String, MContextVariable> variables;
    protected Map<String, List<MNamedIdElement>> configurations;
    protected boolean keepalive;
    protected long lastmodified;
    protected long lastchecked;
    protected ModelInfo modelinfo = new ModelInfo();

    public MBpmnModel() {
        this.modelinfo.internalSetRawModel((Object)this);
    }

    public void initModelInfo(ClassLoader cl) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator<MActivity> it = this.getAllActivities().values().iterator();
        while (it.hasNext()) {
            names.add(it.next().getId());
        }
        this.modelinfo.setBreakpoints(names.toArray(new String[names.size()]));
        String[] confignames = this.getConfigurations();
        if (confignames.length > 0) {
            ConfigurationInfo[] cinfo = new ConfigurationInfo[confignames.length];
            for (int i = 0; i < confignames.length; ++i) {
                cinfo[i] = new ConfigurationInfo(confignames[i]);
                this.modelinfo.addConfiguration(cinfo[i]);
            }
        }
        this.modelinfo.setStartable(true);
        Map<MSubProcess, List<MActivity>> evtsubstarts = this.getEventSubProcessStartEventMapping();
        if (evtsubstarts != null) {
            ProvidedServiceInfo[] psis = this.modelinfo.getProvidedServices();
            HashSet<Class> haspsis = new HashSet<Class>();
            if (psis != null) {
                for (ProvidedServiceInfo psi : psis) {
                    haspsis.add(psi.getType().getType(cl));
                }
            }
            for (Map.Entry entry : evtsubstarts.entrySet()) {
                Class iface = null;
                List macts = (List)entry.getValue();
                for (MActivity mact : macts) {
                    if (!EVENT_START_MESSAGE.equals(mact.getActivityType()) || !mact.hasPropertyValue("iface")) continue;
                    if (iface == null) {
                        UnparsedExpression uexp = mact.getPropertyValue("iface");
                        iface = (Class)SJavaParser.parseExpression((UnparsedExpression)uexp, (String[])this.getModelInfo().getAllImports(), (ClassLoader)cl).getValue(null);
                    }
                    if (iface == null || haspsis.contains(iface)) continue;
                    break;
                }
                if (iface == null || haspsis.contains(iface)) continue;
                String exp = "java.lang.reflect.Proxy.newProxyInstance($component.getClassLoader(),new Class[]{" + iface.getName() + ".class" + "}, new jadex.bpmn.runtime.ProcessServiceInvocationHandler($component, \"" + ((MSubProcess)entry.getKey()).getId() + "\"))";
                ProvidedServiceImplementation psim = new ProvidedServiceImplementation(null, exp, "decoupled", null, null);
                ProvidedServiceInfo psi = new ProvidedServiceInfo("internal_" + iface.getName(), iface, psim, null, null, null);
                this.modelinfo.addProvidedService(psi);
            }
        }
    }

    public List<MPool> getPools() {
        return this.pools;
    }

    public void addPool(MPool pool) {
        if (this.pools == null) {
            this.pools = new ArrayList<MPool>();
        }
        this.pools.add(pool);
    }

    public void removePool(MPool pool) {
        if (this.pools != null) {
            this.pools.remove(pool);
        }
    }

    public MPool getPool(String name) {
        MPool ret = name == null ? this.pools.get(0) : null;
        for (int i = 0; i < this.pools.size() && ret == null; ++i) {
            MPool tmp = this.pools.get(i);
            if (!tmp.getName().equals(name)) continue;
            ret = tmp;
        }
        return ret;
    }

    public List<MArtifact> getArtifacts() {
        return this.artifacts;
    }

    public void addArtifact(MArtifact artifact) {
        if (this.artifacts == null) {
            this.artifacts = new ArrayList<MArtifact>();
        }
        this.artifacts.add(artifact);
    }

    public void removeArtifact(MArtifact artifact) {
        if (this.artifacts != null) {
            this.artifacts.remove(artifact);
        }
    }

    public List<MMessagingEdge> getMessagingEdges() {
        return this.messages;
    }

    public void addMessagingEdge(MMessagingEdge message) {
        if (this.messages == null) {
            this.messages = new ArrayList<MMessagingEdge>();
        }
        this.messages.add(message);
    }

    public void removeMessagingEdge(MMessagingEdge message) {
        if (this.messages != null) {
            this.messages.remove(message);
        }
    }

    public Map<String, MEdge> getAllEdges() {
        Map<String, MDataEdge> datedges;
        Map<String, MMessagingEdge> mesedges;
        HashMap<String, MEdge> edges = new HashMap<String, MEdge>();
        Map<String, MSequenceEdge> seqedges = this.getAllSequenceEdges();
        if (seqedges != null) {
            edges.putAll(seqedges);
        }
        if ((mesedges = this.getAllMessagingEdges()) != null) {
            edges.putAll(mesedges);
        }
        if ((datedges = this.getAllDataEdges()) != null) {
            edges.putAll(datedges);
        }
        return edges;
    }

    public Map<String, MDataEdge> getAllDataEdges() {
        if (this.alldataedges == null) {
            Map<String, MActivity> acts = this.getAllActivities();
            for (MActivity act : acts.values()) {
                List<MDataEdge> inde = act.getIncomingDataEdges();
                List<MDataEdge> outde = act.getOutgoingDataEdges();
                if (inde != null) {
                    for (MDataEdge de : inde) {
                        this.alldataedges.put(de.getId(), de);
                    }
                }
                if (outde == null) continue;
                for (MDataEdge de : outde) {
                    this.alldataedges.put(de.getId(), de);
                }
            }
        }
        return this.alldataedges;
    }

    public Map<String, MMessagingEdge> getAllMessagingEdges() {
        if (this.allmessagingedges == null) {
            this.allmessagingedges = new HashMap<String, MMessagingEdge>();
            List<MMessagingEdge> messages = this.getMessagingEdges();
            if (messages != null) {
                for (int i = 0; i < messages.size(); ++i) {
                    MMessagingEdge msg = messages.get(i);
                    this.allmessagingedges.put(msg.getId(), msg);
                }
            }
        }
        return this.allmessagingedges;
    }

    public Map<String, MSequenceEdge> getAllSequenceEdges() {
        if (this.alledges == null) {
            this.alledges = new HashMap<String, MSequenceEdge>();
            List<MPool> pools = this.getPools();
            if (pools != null) {
                for (int i = 0; i < pools.size(); ++i) {
                    MPool tmp = pools.get(i);
                    List<MActivity> acts = tmp.getActivities();
                    if (acts == null) continue;
                    for (int j = 0; j < acts.size(); ++j) {
                        this.getAllEdges(acts.get(j), this.alledges);
                    }
                }
            }
        }
        return this.alledges;
    }

    public Map<String, MActivity> getAllActivities() {
        if (this.allactivities == null) {
            this.allactivities = new HashMap<String, MActivity>();
            this.parents = new HashMap<MIdElement, MIdElement>();
            List<MPool> pools = this.getPools();
            if (pools != null) {
                for (int i = 0; i < pools.size(); ++i) {
                    List<MActivity> acts;
                    MPool tmp = pools.get(i);
                    List<MLane> lanes = tmp.getLanes();
                    if (lanes != null) {
                        for (MLane lane : lanes) {
                            this.parents.put(lane, tmp);
                        }
                    }
                    if ((acts = tmp.getActivities()) == null) continue;
                    for (int j = 0; j < acts.size(); ++j) {
                        MActivity mact;
                        MLane lane = (mact = acts.get(j)).getLane();
                        this.parents.put(mact, lane != null ? lane : tmp);
                        this.allactivities.put(mact.getId(), acts.get(j));
                        if (mact instanceof MSubProcess) {
                            this.addAllSubActivities((MSubProcess)mact, this.allactivities);
                            continue;
                        }
                        List<MActivity> handlers = mact.getEventHandlers();
                        if (handlers == null) continue;
                        for (int k = 0; k < handlers.size(); ++k) {
                            MActivity mhact = handlers.get(k);
                            this.allactivities.put(mhact.getId(), mhact);
                            this.parents.put(mhact, mact);
                        }
                    }
                }
            }
        }
        return this.allactivities;
    }

    public void addAllSubActivities(MSubProcess proc, Map<String, MActivity> activities) {
        List<MActivity> handlers;
        List<MActivity> acts = proc.getActivities();
        if (acts != null) {
            for (int i = 0; i < acts.size(); ++i) {
                MActivity mact = acts.get(i);
                this.allactivities.put(mact.getId(), acts.get(i));
                this.parents.put(mact, proc);
                if (!(mact instanceof MSubProcess)) continue;
                this.addAllSubActivities((MSubProcess)mact, activities);
            }
        }
        if ((handlers = proc.getEventHandlers()) != null) {
            for (int i = 0; i < handlers.size(); ++i) {
                MActivity mact = handlers.get(i);
                this.allactivities.put(mact.getId(), handlers.get(i));
                this.parents.put(handlers.get(i), mact);
                if (!(mact instanceof MSubProcess)) continue;
                this.addAllSubActivities((MSubProcess)mact, activities);
            }
        }
    }

    protected void getAllEdges(MActivity act, Map<String, MSequenceEdge> edges) {
        List<MActivity> acts;
        this.addEdges(act.getIncomingSequenceEdges(), edges);
        this.addEdges(act.getOutgoingSequenceEdges(), edges);
        if (act instanceof MSubProcess && (acts = ((MSubProcess)act).getActivities()) != null) {
            for (int j = 0; j < acts.size(); ++j) {
                this.getAllEdges(acts.get(j), edges);
            }
        }
    }

    protected void addEdges(List<MSequenceEdge> tmp, Map<String, MSequenceEdge> edges) {
        if (tmp != null) {
            for (int i = 0; i < tmp.size(); ++i) {
                MSequenceEdge edge = tmp.get(i);
                edges.put(edge.getId(), edge);
            }
        }
    }

    public Map<String, MIdElement> getAllAssociationTargets() {
        if (this.associationtargets == null) {
            this.associationtargets = new HashMap<String, MIdElement>();
            List<MPool> pools = this.getPools();
            if (pools != null) {
                for (int i = 0; i < pools.size(); ++i) {
                    List<MActivity> acts;
                    MPool pool = pools.get(i);
                    this.addAssociations(pool.getAssociationsDescription(), pool, this.associationtargets);
                    List<MLane> lanes = pool.getLanes();
                    if (lanes != null) {
                        for (int j = 0; j < lanes.size(); ++j) {
                            MLane lane = lanes.get(j);
                            this.addAssociations(lane.getAssociationsDescription(), lane, this.associationtargets);
                        }
                    }
                    if ((acts = pool.getActivities()) == null) continue;
                    for (int j = 0; j < acts.size(); ++j) {
                        MActivity act = acts.get(j);
                        this.addActivityTargets(act);
                    }
                }
            }
            Map<String, MSequenceEdge> edges = this.getAllSequenceEdges();
            for (MSequenceEdge edge : edges.values()) {
                this.addAssociations(edge.getAssociationsDescription(), edge, this.associationtargets);
            }
        }
        return this.associationtargets;
    }

    protected void addActivityTargets(MActivity act) {
        List<MActivity> acts;
        this.addAssociations(act.getAssociationsDescription(), act, this.associationtargets);
        if (act instanceof MSubProcess && (acts = ((MSubProcess)act).getActivities()) != null) {
            for (int i = 0; i < acts.size(); ++i) {
                MActivity subact = acts.get(i);
                this.addActivityTargets(subact);
            }
        }
    }

    protected boolean addAssociations(String assosdesc, MIdElement target, Map<String, MIdElement> targets) {
        boolean ret = false;
        if (assosdesc != null) {
            StringTokenizer stok = new StringTokenizer(assosdesc);
            while (stok.hasMoreElements() && !ret) {
                String assoid = stok.nextToken();
                targets.put(assoid, target);
            }
        }
        return ret;
    }

    public Map<String, MIdElement> getAllAssociationSources() {
        if (this.associationsources == null) {
            this.associationsources = new HashMap<String, MIdElement>();
            this.addArtifacts(this.getArtifacts(), this.associationsources);
            List<MPool> pools = this.getPools();
            if (pools != null) {
                for (int i = 0; i < pools.size(); ++i) {
                    MPool pool = pools.get(i);
                    this.addArtifacts(pool.getArtifacts(), this.associationsources);
                    List<MActivity> acts = pool.getActivities();
                    if (acts == null) continue;
                    for (int j = 0; j < acts.size(); ++j) {
                        MActivity act = acts.get(j);
                        if (!(act instanceof MSubProcess)) continue;
                        this.addSubProcesses((MSubProcess)act, this.associationsources);
                    }
                }
            }
        }
        return this.associationsources;
    }

    protected void addSubProcesses(MSubProcess subproc, Map<String, MIdElement> sources) {
        List<MArtifact> artifacts = subproc.getArtifacts();
        this.addArtifacts(artifacts, sources);
        List<MActivity> acts = subproc.getActivities();
        if (acts != null) {
            for (int j = 0; j < acts.size(); ++j) {
                MActivity act = acts.get(j);
                if (!(act instanceof MSubProcess)) continue;
                this.addSubProcesses((MSubProcess)act, sources);
            }
        }
    }

    public void addResultDataEdge(MDataEdge edge) {
        if (this.resultdataedges == null) {
            this.resultdataedges = new ArrayList<MDataEdge>();
        }
        this.resultdataedges.add(edge);
    }

    public void removeResultDataEdge(MDataEdge edge) {
        if (this.resultdataedges != null) {
            this.resultdataedges.remove(edge);
        }
    }

    public void addArgumentDataEdge(MDataEdge edge) {
        if (this.argdataedges == null) {
            this.argdataedges = new ArrayList<MDataEdge>();
        }
        this.argdataedges.add(edge);
    }

    public void removeArgumentDataEdge(MDataEdge edge) {
        if (this.argdataedges != null) {
            this.argdataedges.remove(edge);
        }
    }

    public List<MDataEdge> getArgumentDataEdges() {
        return this.argdataedges;
    }

    public void setArgumentDataEdges(List<MDataEdge> indataedges) {
        this.argdataedges = indataedges;
    }

    public List<MDataEdge> getResultDataEdges() {
        return this.resultdataedges;
    }

    public void setResultDataEdges(List<MDataEdge> outdataedges) {
        this.resultdataedges = outdataedges;
    }

    protected MArtifact addArtifacts(List<MArtifact> artifacts, Map<String, MIdElement> sources) {
        MArtifact ret = null;
        if (artifacts != null) {
            for (int i = 0; i < artifacts.size() && ret == null; ++i) {
                MArtifact art = artifacts.get(i);
                List<MAssociation> assos = art.getAssociations();
                if (assos == null) continue;
                for (int j = 0; j < assos.size(); ++j) {
                    MAssociation asso = assos.get(j);
                    sources.put(asso.getId(), art);
                }
            }
        }
        return ret;
    }

    public String getName() {
        return this.modelinfo.getName();
    }

    public void setName(String name) {
        this.modelinfo.setName(name);
    }

    public List<MActivity> getStartActivities() {
        return this.getStartActivities(null, null);
    }

    public List<MActivity> getStartActivities(String poolname, String lanename) {
        List<MActivity> ret = null;
        for (int i = 0; this.pools != null && i < this.pools.size(); ++i) {
            List<MLane> lanes;
            MPool pool = this.pools.get(i);
            if (poolname != null && !poolname.equals(pool.getName())) continue;
            List<MActivity> tmp = pool.getStartActivities();
            if (tmp != null) {
                if (lanename == null) {
                    if (ret != null) {
                        ret.addAll(tmp);
                    } else {
                        ret = tmp;
                    }
                } else {
                    if (ret == null) {
                        ret = new ArrayList<MActivity>();
                    }
                    for (int j = 0; j < tmp.size(); ++j) {
                        MActivity act = tmp.get(j);
                        if (act.getLane() == null || !lanename.equals(act.getLane().getName())) continue;
                        ret.add(act);
                    }
                }
            }
            if ((lanes = pool.getLanes()) == null) continue;
            for (MLane lane : lanes) {
                if (lanename != null && !lanename.equals(lane.getName())) continue;
                tmp = lane.getStartActivities();
                if (ret != null) {
                    ret.addAll(tmp);
                    continue;
                }
                ret = tmp;
            }
        }
        return ret;
    }

    public void addStartElement(String config, MNamedIdElement element) {
        List<MNamedIdElement> elems;
        if (this.configurations == null) {
            this.configurations = new HashMap<String, List<MNamedIdElement>>();
        }
        if ((elems = this.configurations.get(config)) == null) {
            elems = new ArrayList<MNamedIdElement>();
            this.configurations.put(config, elems);
        }
        elems.add(element);
    }

    public List<MNamedIdElement> getStartElements(String config) {
        return this.configurations == null ? null : this.configurations.get(config);
    }

    public void removeStartElement(String config, MNamedIdElement element) {
        List<MNamedIdElement> elems;
        if (this.configurations != null && (elems = this.configurations.get(config)) != null) {
            elems.remove(element);
        }
    }

    public void removeConfiguration(String config) {
        if (this.configurations != null) {
            this.configurations.remove(config);
        }
    }

    public void addImport(String imp) {
        this.modelinfo.addImport(imp);
    }

    public void setPackage(String packagename) {
        this.modelinfo.setPackage(packagename);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(SReflect.getInnerClassName(this.getClass()));
        sbuf.append("(name=");
        sbuf.append(this.getName());
        sbuf.append(")");
        return sbuf.toString();
    }

    public static List<MActivity> getStartActivities(List<MActivity> activities) {
        ArrayList<MActivity> ret = null;
        if (activities != null) {
            for (MActivity activity : activities) {
                if (activity.getIncomingSequenceEdges() != null && !activity.getIncomingSequenceEdges().isEmpty() || activity instanceof MSubProcess && "event".equals(((MSubProcess)activity).getSubprocessType())) continue;
                if (ret == null) {
                    ret = new ArrayList<MActivity>();
                }
                ret.add(activity);
            }
        }
        return ret;
    }

    public void addContextVariable(MContextVariable variable) {
        if (this.variables == null) {
            this.variables = new HashMap<String, MContextVariable>();
        }
        this.variables.put(variable.getName(), variable);
    }

    public void removeContextVariable(String name) {
        if (this.variables != null) {
            this.variables.remove(name);
            if (this.variables.isEmpty()) {
                this.variables = null;
            }
        }
    }

    public void removeContextVariable(MContextVariable variable) {
        this.removeContextVariable(variable.getName());
    }

    public List<MContextVariable> getContextVariables() {
        return this.variables != null ? new ArrayList<MContextVariable>(this.variables.values()) : Collections.EMPTY_LIST;
    }

    public MContextVariable getContextVariable(String name) {
        return this.variables != null ? this.variables.get(name) : null;
    }

    public UnparsedExpression getContextVariableExpression(String name, String config) {
        MContextVariable variable = this.getContextVariable(name);
        return config != null ? variable.getValue(config) : variable;
    }

    public void setContextVariableExpression(String config, UnparsedExpression exp) {
        MContextVariable var;
        if (config == null && exp instanceof MContextVariable) {
            this.variables.put(exp.getName(), (MContextVariable)exp);
        } else if (config != null && (var = this.getContextVariable(exp.getName())) != null) {
            var.setValue(config, exp);
        }
    }

    public void setFilename(String filename) {
        this.modelinfo.setFilename(filename);
    }

    public long getLastModified() {
        return this.lastmodified;
    }

    public void setLastModified(long lastmodified) {
        this.lastmodified = lastmodified;
    }

    public long getLastChecked() {
        return this.lastchecked;
    }

    public void setLastChecked(long lastchecked) {
        this.lastchecked = lastchecked;
    }

    protected String[] getConfigurations() {
        return this.configurations == null ? new String[]{} : this.configurations.keySet().toArray(new String[this.configurations.size()]);
    }

    public void addArgument(IArgument argument) {
        this.modelinfo.addArgument(argument);
    }

    public void addProperty(String name, Object value) {
        this.modelinfo.addProperty(name, value);
    }

    public void addResult(IArgument result) {
        this.modelinfo.addResult(result);
    }

    public IModelInfo getModelInfo() {
        return this.modelinfo;
    }

    public boolean isKeepAlive() {
        return this.keepalive;
    }

    public void setKeepAlive(boolean keepalive) {
        this.keepalive = keepalive;
    }

    public ClassLoader getClassLoader() {
        return this.modelinfo.getClassLoader();
    }

    public void setClassLoader(ClassLoader classloader) {
        this.modelinfo.setClassloader(classloader);
    }

    public void setResourceIdentifier(IResourceIdentifier rid) {
        this.modelinfo.setResourceIdentifier(rid);
    }

    public IResourceIdentifier getResourceIdentifier() {
        return this.modelinfo.getResourceIdentifier();
    }

    public String getFilename() {
        return this.modelinfo.getFilename();
    }

    public MIdElement getParent(MIdElement element) {
        if (this.parents == null) {
            this.getAllActivities();
        }
        MIdElement ret = null;
        if (element instanceof MActivity || element instanceof MLane) {
            ret = this.parents.get(element);
        } else if (element instanceof MEdge) {
            element = ((MEdge)element).getSource();
            ret = this.parents.get(element);
        }
        return ret;
    }

    public List<MActivity> getTypeMatchedStartEvents() {
        if (this.typematchedstartevents == null) {
            this.initMatchedStartEventCache();
        }
        return this.typematchedstartevents;
    }

    public List<MActivity> getEventSubProcessStartEvents() {
        if (this.eventsubprocessstartevents == null) {
            this.initMatchedStartEventCache();
        }
        ArrayList<MActivity> ret = new ArrayList<MActivity>();
        for (List<MActivity> acts : this.eventsubprocessstartevents.values()) {
            ret.addAll(acts);
        }
        return ret;
    }

    public Map<MSubProcess, List<MActivity>> getEventSubProcessStartEventMapping() {
        if (this.eventsubprocessstartevents == null) {
            this.initMatchedStartEventCache();
        }
        return this.eventsubprocessstartevents;
    }

    public List<MActivity> getWaitingEvents() {
        if (this.waitingevents == null) {
            this.initMatchedStartEventCache();
        }
        return this.waitingevents;
    }

    protected void initMatchedStartEventCache() {
        this.eventsubprocessstartevents = new HashMap<MSubProcess, List<MActivity>>();
        this.typematchedstartevents = new ArrayList<MActivity>();
        this.waitingevents = new ArrayList<MActivity>();
        ArrayList<MActivity> starteventtriggers = new ArrayList<MActivity>();
        ArrayList<MSubProcess> subprocesses = new ArrayList<MSubProcess>();
        Map<String, MActivity> allactivities = this.getAllActivities();
        for (Map.Entry<String, MActivity> entry : allactivities.entrySet()) {
            if (EVENT_START_RULE.equals(entry.getValue().getActivityType()) || EVENT_START_TIMER.equals(entry.getValue().getActivityType()) || EVENT_START_MESSAGE.equals(entry.getValue().getActivityType())) {
                starteventtriggers.add(entry.getValue());
                continue;
            }
            if (EVENT_INTERMEDIATE_RULE.equals(entry.getValue().getActivityType()) || EVENT_INTERMEDIATE_TIMER.equals(entry.getValue().getActivityType()) || EVENT_INTERMEDIATE_MESSAGE.equals(entry.getValue().getActivityType())) {
                this.waitingevents.add(entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof MSubProcess) || ((MSubProcess)entry.getValue()).getActivities() == null || ((MSubProcess)entry.getValue()).getActivities().isEmpty()) continue;
            subprocesses.add((MSubProcess)entry.getValue());
        }
        for (MActivity startevent : starteventtriggers) {
            boolean contained = false;
            for (MSubProcess subproc : subprocesses) {
                if (!subproc.getActivities().contains(startevent)) continue;
                contained = true;
                if ("event".equals(subproc.getSubprocessType())) {
                    List<MActivity> acts = this.eventsubprocessstartevents.get(subproc);
                    if (acts == null) {
                        acts = new ArrayList<MActivity>();
                        this.eventsubprocessstartevents.put(subproc, acts);
                    }
                    acts.add(startevent);
                    break;
                }
                this.waitingevents.add(startevent);
                break;
            }
            if (contained) continue;
            this.typematchedstartevents.add(startevent);
        }
    }

    public Tuple2<BiHashMap<String, String>, List<MIdElement>> cloneElements(final Set<MIdElement> originals) {
        final BiHashMap idmap = new BiHashMap();
        final IdGenerator idgen = new IdGenerator();
        Traverser trav = new Traverser(){

            public Object doTraverse(Object object, Class<?> clazz, Map<Object, Object> traversed, List<ITraverseProcessor> processors, boolean clone, ClassLoader targetcl, Object context) {
                boolean istraversed = traversed.containsKey(object);
                Object ret = super.doTraverse(object, clazz, traversed, processors, clone, targetcl, context);
                if (!istraversed && object != ret && ret instanceof MIdElement) {
                    String oldid = ((MIdElement)ret).getId();
                    ((MIdElement)ret).setId(idgen.generateId());
                    idmap.put((Object)oldid, (Object)((MIdElement)ret).getId());
                }
                return ret;
            }
        };
        ArrayList<Object> procs = new ArrayList<Object>();
        procs.add(new ITraverseProcessor(){

            public Object process(Object object, Type type, List<ITraverseProcessor> processors, Traverser traverser, Map<Object, Object> traversed, boolean clone, ClassLoader targetcl, Object context) {
                return Traverser.IGNORE_RESULT;
            }

            public boolean isApplicable(Object object, Type type, boolean clone, ClassLoader targetcl) {
                MEdge medge;
                boolean ret = false;
                if (!(!(object instanceof MEdge) || MBpmnModel.this.isContainedInParentSet(originals, (medge = (MEdge)object).getSource()) && MBpmnModel.this.isContainedInParentSet(originals, medge.getTarget()))) {
                    ret = true;
                }
                return ret;
            }
        });
        procs.add(new ITraverseProcessor(){

            public Object process(Object object, Type type, List<ITraverseProcessor> processors, Traverser traverser, Map<Object, Object> traversed, boolean clone, ClassLoader targetcl, Object context) {
                return object;
            }

            public boolean isApplicable(Object object, Type type, boolean clone, ClassLoader targetcl) {
                return object instanceof MPool || object instanceof MLane || object instanceof MIdElement && !MBpmnModel.this.isContainedInParentSet(originals, (MIdElement)object);
            }
        });
        procs.addAll(Traverser.getDefaultProcessors());
        List<MIdElement> mclone = new ArrayList<MIdElement>(originals);
        mclone = (List)trav.traverse(mclone, null, new IdentityHashMap(), procs, true, null, null);
        this.clearCaches();
        return new Tuple2((Object)idmap, mclone);
    }

    public boolean isContainedInParentSet(Set<MIdElement> mmap, MIdElement idelem) {
        boolean ret = false;
        ret = mmap.contains(idelem);
        boolean running = true;
        while (!ret && running) {
            MIdElement parent = null;
            parent = this.getParent(idelem);
            if (parent == null) {
                running = false;
                continue;
            }
            if (mmap.contains(parent)) {
                ret = true;
                continue;
            }
            idelem = parent;
        }
        return ret;
    }

    public MActivity getActivityById(String id) {
        return this.getAllActivities().get(id);
    }

    public void clearCaches() {
        this.allactivities = null;
        this.eventsubprocessstartevents = null;
        this.waitingevents = null;
        this.typematchedstartevents = null;
        this.parents = null;
        this.alledges = null;
        this.allmessagingedges = null;
        this.alldataedges = null;
    }
}

