/*
 * Decompiled with CFR 0.152.
 */
package jadex.bpmn.model;

import jadex.bpmn.model.MAssociationTarget;
import jadex.bpmn.model.MDataEdge;
import jadex.bpmn.model.MLane;
import jadex.bpmn.model.MMessagingEdge;
import jadex.bpmn.model.MParameter;
import jadex.bpmn.model.MPool;
import jadex.bpmn.model.MProperty;
import jadex.bpmn.model.MSequenceEdge;
import jadex.bpmn.model.task.annotation.TaskArgument;
import jadex.bpmn.model.task.annotation.TaskBody;
import jadex.bpmn.model.task.annotation.TaskComponent;
import jadex.bpmn.model.task.annotation.TaskResult;
import jadex.bpmn.task.info.ParameterMetaInfo;
import jadex.bridge.ClassInfo;
import jadex.bridge.modelinfo.UnparsedExpression;
import jadex.commons.FieldInfo;
import jadex.commons.MethodInfo;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.collection.IndexMap;
import jadex.javaparser.IParsedExpression;
import jadex.javaparser.SJavaParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MActivity
extends MAssociationTarget {
    protected static final MethodInfo MI_NOTFOUND = new MethodInfo();
    public static final String RETURNPARAM = "returnparam";
    public static final String IFACE = "iface";
    public static final String METHOD = "method";
    public static final String ISSERVICE = "isService";
    public static final String ISSEQUENTIAL = "isSequential";
    public static final String RESULTNAME = "resultName";
    public static final String RESULTTYPE = "resultType";
    protected String lanedescription;
    protected String outgoingsequenceedgesdescription;
    protected String incomingsequenceedgesdescription;
    protected List<Object> incomingmessagesdescriptions;
    protected List<Object> outgoingmessagesdescriptions;
    protected List<MSequenceEdge> outseqedges;
    protected List<MSequenceEdge> inseqedges;
    protected List<MMessagingEdge> outmsgedges;
    protected List<MMessagingEdge> inmsgedges;
    protected List<MDataEdge> outdataedges;
    protected List<MDataEdge> indataedges;
    protected String type;
    protected String activitytype;
    protected boolean looping;
    protected boolean throwing;
    protected List<MActivity> eventhandlers;
    protected MPool pool;
    protected MLane lane;
    protected boolean eventhandler;
    protected IndexMap<String, MParameter> parameters;
    protected IndexMap<String, MProperty> properties;
    protected ClassInfo clazz;
    protected volatile MethodInfo bodymethod;
    protected volatile MethodInfo cancelmethod;
    protected volatile List<FieldInfo> componentinjections;
    protected volatile Map<String, List<FieldInfo>> argumentinjections;
    protected volatile Map<String, FieldInfo> resultinjections;

    public String getLaneDescription() {
        return this.lanedescription;
    }

    public void setLaneDescription(String lanedescription) {
        this.lanedescription = lanedescription;
    }

    public String getOutgoingSequenceEdgesDescription() {
        return this.outgoingsequenceedgesdescription;
    }

    public void setOutgoingSequenceEdgesDescription(String outgoingedges) {
        this.outgoingsequenceedgesdescription = outgoingedges;
    }

    public String getIncomingSequenceEdgesDescription() {
        return this.incomingsequenceedgesdescription;
    }

    public void setIncomingSequenceEdgesDescription(String incomingedges) {
        this.incomingsequenceedgesdescription = incomingedges;
    }

    public List<Object> getOutgoingMessagesDescriptions() {
        return this.outgoingmessagesdescriptions;
    }

    public void addOutgoingMessageDescription(Object desc) {
        if (this.outgoingmessagesdescriptions == null) {
            this.outgoingmessagesdescriptions = new ArrayList<Object>();
        }
        this.outgoingmessagesdescriptions.add(desc);
    }

    public void removeOutgoingMessageDescription(Object desc) {
        if (this.outgoingmessagesdescriptions != null) {
            this.outgoingmessagesdescriptions.remove(desc);
        }
    }

    public List<Object> getIncomingMessagesDescriptions() {
        return this.incomingmessagesdescriptions;
    }

    public void addIncomingMessageDescription(Object desc) {
        if (this.incomingmessagesdescriptions == null) {
            this.incomingmessagesdescriptions = new ArrayList<Object>();
        }
        this.incomingmessagesdescriptions.add(desc);
    }

    public void removeIncomingMessageDescription(Object desc) {
        if (this.incomingmessagesdescriptions != null) {
            this.incomingmessagesdescriptions.remove(desc);
        }
    }

    public List<MSequenceEdge> getOutgoingSequenceEdges() {
        return this.outseqedges;
    }

    public void setOutgoingSequenceEdges(List<MSequenceEdge> outseqedges) {
        this.outseqedges = outseqedges;
    }

    public void addOutgoingSequenceEdge(MSequenceEdge edge) {
        if (this.outseqedges == null) {
            this.outseqedges = new ArrayList<MSequenceEdge>();
        }
        this.outseqedges.add(edge);
    }

    public void removeOutgoingSequenceEdge(MSequenceEdge edge) {
        if (this.outseqedges != null) {
            this.outseqedges.remove(edge);
        }
    }

    public List<MSequenceEdge> getIncomingSequenceEdges() {
        return this.inseqedges;
    }

    public void getIncomingSequenceEdges(List<MSequenceEdge> inseqedges) {
        this.inseqedges = inseqedges;
    }

    public void addIncomingSequenceEdge(MSequenceEdge edge) {
        if (this.inseqedges == null) {
            this.inseqedges = new ArrayList<MSequenceEdge>();
        }
        this.inseqedges.add(edge);
    }

    public void removeIncomingSequenceEdge(MSequenceEdge edge) {
        if (this.inseqedges != null) {
            this.inseqedges.remove(edge);
        }
    }

    public List<MMessagingEdge> getOutgoingMessagingEdges() {
        return this.outmsgedges;
    }

    public void getOutgoingMessagingEdges(List<MMessagingEdge> outmsgedges) {
        this.outmsgedges = outmsgedges;
    }

    public void addOutgoingMessagingEdge(MMessagingEdge edge) {
        if (this.outmsgedges == null) {
            this.outmsgedges = new ArrayList<MMessagingEdge>();
        }
        this.outmsgedges.add(edge);
    }

    public void removeOutgoingMessagingEdge(MMessagingEdge edge) {
        if (this.outmsgedges != null) {
            this.outmsgedges.remove(edge);
        }
    }

    public List<MMessagingEdge> getIncomingMessagingEdges() {
        return this.inmsgedges;
    }

    public void setIncomingMessagingEdges(List<MMessagingEdge> inmsgedges) {
        this.inmsgedges = inmsgedges;
    }

    public void addIncomingMessagingEdge(MMessagingEdge edge) {
        if (this.inmsgedges == null) {
            this.inmsgedges = new ArrayList<MMessagingEdge>();
        }
        this.inmsgedges.add(edge);
    }

    public void removeIncomingMessagingEdge(MMessagingEdge edge) {
        if (this.inmsgedges != null) {
            this.inmsgedges.remove(edge);
        }
    }

    public void addOutgoingDataEdge(MDataEdge edge) {
        if (this.outdataedges == null) {
            this.outdataedges = new ArrayList<MDataEdge>();
        }
        this.outdataedges.add(edge);
    }

    public void removeOutgoingDataEdge(MDataEdge edge) {
        if (this.outdataedges != null) {
            this.outdataedges.remove(edge);
        }
    }

    public void addIncomingDataEdge(MDataEdge edge) {
        if (this.indataedges == null) {
            this.indataedges = new ArrayList<MDataEdge>();
        }
        this.indataedges.add(edge);
    }

    public void removeIncomingDataEdge(MDataEdge edge) {
        if (this.indataedges != null) {
            this.indataedges.remove(edge);
        }
    }

    public List<MDataEdge> getIncomingDataEdges() {
        return this.indataedges;
    }

    public void setIncomingDataEdges(List<MDataEdge> indataedges) {
        this.indataedges = indataedges;
    }

    public List<MDataEdge> getOutgoingDataEdges() {
        return this.outdataedges;
    }

    public void setOutgoingDataEdges(List<MDataEdge> outdataedges) {
        this.outdataedges = outdataedges;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getActivityType() {
        return this.activitytype;
    }

    public void setActivityType(String activitytype) {
        this.activitytype = activitytype;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setLooping(boolean looping) {
        this.looping = looping;
    }

    public boolean isThrowing() {
        return this.throwing;
    }

    public void setThrowing(boolean throwing) {
        this.throwing = throwing;
    }

    public List<MActivity> getEventHandlers() {
        return this.eventhandlers;
    }

    public void addEventHandler(MActivity eventhandler) {
        if (this.eventhandlers == null) {
            this.eventhandlers = new ArrayList<MActivity>();
        }
        this.eventhandlers.add(eventhandler);
    }

    public void removeEventHandler(MActivity eventhandler) {
        if (this.eventhandlers != null) {
            this.eventhandlers.remove(eventhandler);
        }
    }

    public IndexMap<String, MParameter> getParameters() {
        return this.parameters;
    }

    public MParameter getParameter(String name) {
        return this.parameters != null ? (MParameter)this.parameters.get((Object)name) : null;
    }

    public IndexMap<String, MParameter> getAllParameters(Map<String, Object> params, String[] imports, ClassLoader cl) {
        IndexMap ret;
        IndexMap indexMap = ret = this.parameters != null ? new IndexMap(this.parameters) : new IndexMap();
        if (this.clazz != null) {
            Class task = this.clazz.getType(cl, imports);
            try {
                ParameterMetaInfo[] ps;
                Method m = task.getMethod("getExtraParameters", Map.class);
                for (ParameterMetaInfo pmi : ps = (ParameterMetaInfo[])m.invoke(null, params)) {
                    MParameter mp = new MParameter(pmi.getDirection(), pmi.getClazz(), pmi.getName(), null);
                    ret.put((Object)mp.getName(), (Object)mp);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    public List<MParameter> getParameters(String[] dirs) {
        HashSet<String> test = new HashSet<String>();
        if (dirs != null) {
            for (int i = 0; i < dirs.length; ++i) {
                test.add(dirs[i]);
            }
        }
        ArrayList<MParameter> inparams = new ArrayList<MParameter>();
        if (this.parameters != null) {
            for (MParameter param : this.parameters.values()) {
                if (!test.contains(param.getDirection())) continue;
                inparams.add(param);
            }
        }
        return inparams;
    }

    public void setParameters(IndexMap<String, MParameter> parameters) {
        this.parameters = parameters;
    }

    public boolean hasParameter(String name) {
        return this.parameters != null && this.parameters.containsKey((Object)name);
    }

    public void addParameter(MParameter param) {
        if (this.parameters == null) {
            this.parameters = new IndexMap();
        }
        this.parameters.put((Object)param.getName(), (Object)param);
    }

    public void removeParameter(MParameter param) {
        if (this.parameters != null) {
            this.parameters.removeValue((Object)param.getName());
        }
    }

    public void removeParameter(String name) {
        if (this.parameters != null) {
            this.parameters.removeKey((Object)name);
        }
    }

    public void removeParameters() {
        if (this.parameters != null) {
            this.parameters.clear();
        }
    }

    public void setPropertyValue(String name, UnparsedExpression exp) {
        MProperty mprop = new MProperty();
        mprop.setName(name);
        mprop.setInitialValue(exp);
        this.addProperty(mprop);
    }

    public void setPropertyValue(String name, IParsedExpression exp) {
        if (exp != null) {
            MProperty mprop = new MProperty();
            mprop.setName(name);
            UnparsedExpression uexp = new UnparsedExpression(name, (String)null, exp.getExpressionText(), null);
            uexp.setParsedExp((Object)exp);
            mprop.setInitialValue(uexp);
            this.addProperty(mprop);
        } else {
            MProperty mprop = new MProperty();
            mprop.setName(name);
            UnparsedExpression uexp = new UnparsedExpression(name, (String)null, null, null);
            SJavaParser.parseExpression((UnparsedExpression)uexp, null, (ClassLoader)MActivity.class.getClassLoader());
            mprop.setInitialValue(uexp);
            this.addProperty(mprop);
        }
    }

    public String getPropertyValueString(String name) {
        UnparsedExpression exp = this.getPropertyValue(name);
        return exp != null ? exp.getValue() : null;
    }

    public UnparsedExpression getPropertyValue(String name) {
        UnparsedExpression ret = null;
        if (this.properties != null) {
            MProperty mprop = (MProperty)this.properties.get((Object)name);
            ret = mprop != null ? mprop.getInitialValue() : null;
        }
        return ret;
    }

    public Object getParsedPropertyValue(String name) {
        UnparsedExpression upex = this.getPropertyValue(name);
        Object val = ((IParsedExpression)upex.getParsed()).getValue(null);
        return val;
    }

    public String[] getPropertyNames() {
        return this.properties != null ? this.properties.keySet().toArray(new String[this.properties.size()]) : SUtil.EMPTY_STRING_ARRAY;
    }

    public boolean hasPropertyValue(String name) {
        return this.properties != null && this.properties.containsKey((Object)name) && this.getPropertyValue(name) != null;
    }

    public boolean hasInitialPropertyValue(String name) {
        return this.hasPropertyValue(name) && this.getPropertyValue(name).getValue() != null && this.getPropertyValue(name).getValue().length() > 0;
    }

    public IndexMap<String, MProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(IndexMap<String, MProperty> properties) {
        this.properties = properties;
    }

    public boolean hasProperty(String name) {
        return this.properties != null && this.properties.containsKey((Object)name);
    }

    public void addProperty(MProperty prop) {
        if (this.properties == null) {
            this.properties = new IndexMap();
        }
        this.properties.put((Object)prop.getName(), (Object)prop);
    }

    public void addProperty(String name, String value) {
        this.addProperty(name, value, true);
    }

    public void addProperty(String name, String value, boolean string) {
        MProperty mprop = new MProperty();
        mprop.setName(name);
        UnparsedExpression uexp = new UnparsedExpression(name, String.class, string ? "\"" + value + "\"" : value, null);
        SJavaParser.parseExpression((UnparsedExpression)uexp, null, (ClassLoader)MActivity.class.getClassLoader());
        mprop.setInitialValue(uexp);
        this.addProperty(mprop);
    }

    public void removeProperty(String propname) {
        if (this.properties != null) {
            this.properties.removeKey((Object)propname);
        }
    }

    public void removeProperty(MProperty prop) {
        if (this.properties != null) {
            this.removeProperty(prop.getName());
        }
    }

    public void setProperty(String name, String value, boolean string) {
        if (value == null) {
            this.removeProperty(name);
        } else {
            MProperty mprop;
            MProperty mProperty = mprop = this.getProperties() != null ? (MProperty)this.getProperties().get((Object)name) : null;
            if (mprop == null) {
                this.addProperty(name, value, string);
            } else {
                UnparsedExpression uexp = new UnparsedExpression(null, String.class, string ? "\"" + value + "\"" : value, null);
                mprop.setInitialValue(uexp);
            }
        }
    }

    public void setParameter(String name, String value, Class<?> type, boolean string, String direction) {
        if (value == null) {
            this.removeParameter(name);
        } else {
            MParameter mpara = this.getParameters() != null ? (MParameter)this.getParameters().get((Object)name) : null;
            UnparsedExpression uexp = new UnparsedExpression(null, String.class, string ? "\"" + value + "\"" : value, null);
            if (mpara == null) {
                this.addParameter(new MParameter(direction, new ClassInfo(type), name, uexp));
            } else {
                mpara.setInitialValue(uexp);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(SReflect.getInnerClassName(this.getClass()));
        buf.append("(name=");
        buf.append(this.getName());
        buf.append(", activityType=");
        buf.append(this.getActivityType());
        buf.append(")");
        return buf.toString();
    }

    public MPool getPool() {
        return this.pool;
    }

    public void setPool(MPool pool) {
        this.pool = pool;
    }

    public MLane getLane() {
        return this.lane;
    }

    public void setLane(MLane lane) {
        if (this.lane != null && lane != this.lane && lane != null) {
            throw new RuntimeException("Cannot add activity " + this + " to lane '" + lane.getName() + "'. Already contained in '" + this.lane.getName() + "'");
        }
        this.lane = lane;
    }

    public boolean isEventHandler() {
        return this.eventhandler;
    }

    public void setEventHandler(boolean eventhandler) {
        this.eventhandler = eventhandler;
    }

    public ClassInfo getClazz() {
        return this.clazz;
    }

    public void setClazz(ClassInfo clazz) {
        this.clazz = clazz;
    }

    public boolean isEvent() {
        return this.getActivityType().startsWith("Event");
    }

    public boolean isStartEvent() {
        return this.isEvent() && this.getActivityType().indexOf("Start") != -1;
    }

    public boolean isEndEvent() {
        return this.isEvent() && this.getActivityType().indexOf("End") != -1;
    }

    public boolean isIntermediateEvent() {
        return this.isEvent() && this.getActivityType().indexOf("Intermediate") != -1;
    }

    public boolean isMessageEvent() {
        return this.isEvent() && this.getActivityType().indexOf("Message") != -1;
    }

    public boolean isSignalEvent() {
        return this.isEvent() && this.getActivityType().indexOf("Signal") != -1;
    }

    public boolean isGateway() {
        return this.getActivityType().startsWith("Gateway");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodInfo getBodyMethod(ClassLoader cl) {
        if (this.clazz != null && this.bodymethod == null) {
            MActivity mActivity = this;
            synchronized (mActivity) {
                if (this.bodymethod == null) {
                    Class body = this.clazz.getType(cl);
                    this.bodymethod = MActivity.getMethod(body, TaskBody.class);
                    if (this.bodymethod == null) {
                        throw new RuntimeException("Task has no body method: " + body);
                    }
                }
            }
        }
        return this.bodymethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodInfo getCancelMethod(ClassLoader cl) {
        if (this.clazz != null && this.cancelmethod == null) {
            MActivity mActivity = this;
            synchronized (mActivity) {
                if (this.cancelmethod == null) {
                    Class body = this.clazz.getType(cl);
                    this.cancelmethod = MActivity.getMethod(body, TaskBody.class);
                    if (this.cancelmethod == null) {
                        this.cancelmethod = MI_NOTFOUND;
                    }
                }
            }
        }
        return this.bodymethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FieldInfo> getComponentInjections(ClassLoader cl) {
        if (this.clazz != null && this.componentinjections == null) {
            MActivity mActivity = this;
            synchronized (mActivity) {
                if (this.componentinjections == null) {
                    Class body = this.clazz.getType(cl);
                    this.componentinjections = MActivity.getFields(body, TaskComponent.class);
                }
            }
        }
        return this.componentinjections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<FieldInfo>> getArgumentInjections(ClassLoader cl) {
        if (this.clazz != null && this.argumentinjections == null) {
            MActivity mActivity = this;
            synchronized (mActivity) {
                if (this.argumentinjections == null) {
                    this.argumentinjections = new LinkedHashMap<String, List<FieldInfo>>();
                    Class body = this.clazz.getType(cl);
                    List<FieldInfo> fis = MActivity.getFields(body, TaskArgument.class);
                    for (FieldInfo fi : fis) {
                        Field f = fi.getField(cl);
                        TaskArgument arg = f.getAnnotation(TaskArgument.class);
                        String name = arg.value().length() > 0 ? arg.value() : f.getName();
                        List<FieldInfo> ais = this.argumentinjections.get(name);
                        if (ais == null) {
                            ais = new ArrayList<FieldInfo>();
                            this.argumentinjections.put(name, ais);
                        }
                        ais.add(fi);
                    }
                }
            }
        }
        return this.argumentinjections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, FieldInfo> getResultInjections(ClassLoader cl) {
        if (this.clazz != null && this.resultinjections == null) {
            MActivity mActivity = this;
            synchronized (mActivity) {
                if (this.resultinjections == null) {
                    this.resultinjections = new LinkedHashMap<String, FieldInfo>();
                    Class body = this.clazz.getType(cl);
                    List<FieldInfo> fis = MActivity.getFields(body, TaskResult.class);
                    for (FieldInfo fi : fis) {
                        Field f = fi.getField(cl);
                        TaskResult res = f.getAnnotation(TaskResult.class);
                        String name = res.value().length() > 0 ? res.value() : f.getName();
                        this.resultinjections.put(name, fi);
                    }
                }
            }
        }
        return this.resultinjections;
    }

    public static MethodInfo getMethod(Class<?> body, Class<? extends Annotation> type) {
        MethodInfo ret = null;
        Class<?> bcl = body;
        while (!Object.class.equals(bcl) && ret == null) {
            Method[] ms;
            for (Method m : ms = bcl.getDeclaredMethods()) {
                if (!m.isAnnotationPresent(type)) continue;
                ret = new MethodInfo(m);
                break;
            }
            bcl = bcl.getSuperclass();
        }
        return ret;
    }

    public static List<FieldInfo> getFields(Class<?> body, Class<? extends Annotation> type) {
        ArrayList<FieldInfo> ret = new ArrayList<FieldInfo>();
        Class<?> bcl = body;
        while (!Object.class.equals(bcl)) {
            Field[] fs;
            for (Field f : fs = bcl.getDeclaredFields()) {
                if (!f.isAnnotationPresent(type)) continue;
                ret.add(new FieldInfo(f));
            }
            bcl = bcl.getSuperclass();
        }
        return ret;
    }
}

