/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.features.impl;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.ComponentCreationInfo;
import jadex.bridge.component.IComponentFeatureFactory;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.component.IPojoComponentFeature;
import jadex.bridge.component.ISubcomponentsFeature;
import jadex.bridge.component.impl.AbstractComponentFeature;
import jadex.bridge.component.impl.ComponentFeatureFactory;
import jadex.bridge.service.RequiredServiceInfo;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.ServiceNotFoundException;
import jadex.commons.FieldInfo;
import jadex.commons.MethodInfo;
import jadex.commons.SReflect;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITerminableIntermediateFuture;
import jadex.micro.MicroModel;
import jadex.micro.annotation.AgentService;
import jadex.micro.features.IMicroServiceInjectionFeature;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MicroServiceInjectionComponentFeature
extends AbstractComponentFeature
implements IMicroServiceInjectionFeature {
    public static final IComponentFeatureFactory FACTORY = new ComponentFeatureFactory(IMicroServiceInjectionFeature.class, MicroServiceInjectionComponentFeature.class, new Class[]{ISubcomponentsFeature.class, IPojoComponentFeature.class}, null);

    public MicroServiceInjectionComponentFeature(IInternalAccess component, ComponentCreationInfo cinfo) {
        super(component, cinfo);
    }

    public IFuture<Void> init() {
        Future ret = new Future();
        MicroModel model = (MicroModel)((Object)this.getComponent().getModel().getRawModel());
        final Object agent = ((IPojoComponentFeature)this.getComponent().getComponentFeature(IPojoComponentFeature.class)).getPojoAgent();
        if (this.component.getComponentFeature(IRequiredServicesFeature.class) == null) {
            ret.setResult(null);
        } else {
            String[] sernames = model.getServiceInjectionNames();
            if (sernames.length > 0) {
                CounterResultListener lis = new CounterResultListener(sernames.length, (IResultListener)new DelegationResultListener(ret));
                for (int i = 0; i < sernames.length; ++i) {
                    IFuture sfut;
                    Object[] infos = model.getServiceInjections(sernames[i]);
                    final CounterResultListener lis2 = new CounterResultListener(infos.length, (IResultListener)lis);
                    RequiredServiceInfo info = model.getModelInfo().getRequiredService(sernames[i]);
                    if (info != null && info.isMultiple()) {
                        ITerminableIntermediateFuture ifut = ((IRequiredServicesFeature)this.component.getComponentFeature(IRequiredServicesFeature.class)).getRequiredServices(sernames[i]);
                        sfut = ifut;
                    } else {
                        sfut = ((IRequiredServicesFeature)this.component.getComponentFeature(IRequiredServicesFeature.class)).getRequiredService(sernames[i]);
                    }
                    for (int j = 0; j < infos.length; ++j) {
                        if (infos[j] instanceof FieldInfo) {
                            final Field f = ((FieldInfo)infos[j]).getField(this.component.getClassLoader());
                            if (SReflect.isSupertype(IFuture.class, f.getType())) {
                                try {
                                    f.setAccessible(true);
                                    f.set(agent, sfut);
                                    lis2.resultAvailable(null);
                                }
                                catch (Exception e) {
                                    this.component.getLogger().warning("Field injection failed: " + e);
                                    lis2.exceptionOccurred(e);
                                }
                                continue;
                            }
                            sfut.addResultListener((IResultListener)new IResultListener<Object>(){

                                public void resultAvailable(Object result) {
                                    try {
                                        f.setAccessible(true);
                                        f.set(agent, result);
                                        lis2.resultAvailable(null);
                                    }
                                    catch (Exception e) {
                                        MicroServiceInjectionComponentFeature.this.component.getLogger().warning("Field injection failed: " + e);
                                        lis2.exceptionOccurred(e);
                                    }
                                }

                                public void exceptionOccurred(Exception e) {
                                    if (!(e instanceof ServiceNotFoundException) || f.getAnnotation(AgentService.class).required()) {
                                        MicroServiceInjectionComponentFeature.this.component.getLogger().warning("Field injection failed: " + e);
                                        lis2.exceptionOccurred(e);
                                    } else if (SReflect.isSupertype(f.getType(), List.class)) {
                                        this.resultAvailable(Collections.EMPTY_LIST);
                                    } else {
                                        lis2.resultAvailable(null);
                                    }
                                }
                            });
                            continue;
                        }
                        if (!(infos[j] instanceof MethodInfo)) continue;
                        final Method m = SReflect.getMethod(agent.getClass(), (String)((MethodInfo)infos[j]).getName(), (Class[])((MethodInfo)infos[j]).getParameterTypes(this.component.getClassLoader()));
                        if (info.isMultiple()) {
                            lis2.resultAvailable(null);
                            IFuture tfut = sfut;
                            final IIntermediateFuture ifut = (IIntermediateFuture)tfut;
                            ifut.addResultListener((IResultListener)new IIntermediateResultListener<Object>(){

                                public void intermediateResultAvailable(final Object result) {
                                    if (SReflect.isSupertype(m.getParameterTypes()[0], result.getClass())) {
                                        ((IExecutionFeature)MicroServiceInjectionComponentFeature.this.component.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new IComponentStep<Void>(){

                                            public IFuture<Void> execute(IInternalAccess ia) {
                                                try {
                                                    m.setAccessible(true);
                                                    m.invoke(agent, result);
                                                }
                                                catch (Throwable t) {
                                                    t = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getTargetException() : t;
                                                    throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
                                                }
                                                return IFuture.DONE;
                                            }
                                        });
                                    }
                                }

                                public void resultAvailable(Collection<Object> result) {
                                    this.finished();
                                }

                                public void finished() {
                                    if (SReflect.isSupertype(m.getParameterTypes()[0], Collection.class)) {
                                        ((IExecutionFeature)MicroServiceInjectionComponentFeature.this.component.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new IComponentStep<Void>(){

                                            public IFuture<Void> execute(IInternalAccess ia) {
                                                try {
                                                    m.setAccessible(true);
                                                    m.invoke(agent, ifut.getIntermediateResults());
                                                }
                                                catch (Throwable t) {
                                                    t = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getTargetException() : t;
                                                    throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
                                                }
                                                return IFuture.DONE;
                                            }
                                        });
                                    }
                                }

                                public void exceptionOccurred(Exception e) {
                                    if (!(e instanceof ServiceNotFoundException) || m.getAnnotation(AgentService.class).required()) {
                                        MicroServiceInjectionComponentFeature.this.component.getLogger().warning("Method injection failed: " + e);
                                    } else {
                                        this.finished();
                                    }
                                }
                            });
                            continue;
                        }
                        sfut.addResultListener((IResultListener)new IResultListener<Object>(){

                            public void resultAvailable(final Object result) {
                                ((IExecutionFeature)MicroServiceInjectionComponentFeature.this.component.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new IComponentStep<Void>(){

                                    public IFuture<Void> execute(IInternalAccess ia) {
                                        try {
                                            m.setAccessible(true);
                                            m.invoke(agent, result);
                                            lis2.resultAvailable(null);
                                        }
                                        catch (Throwable t) {
                                            t = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getTargetException() : t;
                                            lis2.exceptionOccurred((Exception)(t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t)));
                                        }
                                        return IFuture.DONE;
                                    }
                                });
                            }

                            public void exceptionOccurred(Exception e) {
                                if (!(e instanceof ServiceNotFoundException) || m.getAnnotation(AgentService.class).required()) {
                                    MicroServiceInjectionComponentFeature.this.component.getLogger().warning("Method service injection failed: " + e);
                                }
                            }
                        });
                    }
                }
            } else {
                ret.setResult(null);
            }
        }
        return ret;
    }
}

