/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.features.impl;

import jadex.bridge.IInternalAccess;
import jadex.bridge.component.ComponentCreationInfo;
import jadex.bridge.component.IComponentFeatureFactory;
import jadex.bridge.component.IPojoComponentFeature;
import jadex.bridge.component.impl.AbstractComponentFeature;
import jadex.bridge.component.impl.ComponentFeatureFactory;
import jadex.commons.IParameterGuesser;
import jadex.commons.IValueFetcher;
import jadex.commons.SimpleParameterGuesser;
import jadex.micro.MicroModel;
import java.util.Collections;

public class MicroPojoComponentFeature
extends AbstractComponentFeature
implements IPojoComponentFeature,
IValueFetcher {
    public static final IComponentFeatureFactory FACTORY = new ComponentFeatureFactory(IPojoComponentFeature.class, MicroPojoComponentFeature.class, null, null);
    protected Object pojoagent;
    protected IParameterGuesser guesser;

    public MicroPojoComponentFeature(IInternalAccess component, ComponentCreationInfo cinfo) {
        super(component, cinfo);
        try {
            MicroModel model = (MicroModel)((Object)this.getComponent().getModel().getRawModel());
            this.pojoagent = model.getPojoClass().getType(model.getClassloader()).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object getPojoAgent() {
        return this.pojoagent;
    }

    public IValueFetcher getValueFetcher() {
        return this;
    }

    public Object fetchValue(String name) {
        if ("$pojoagent".equals(name)) {
            return this.getPojoAgent();
        }
        throw new RuntimeException("Value not found: " + name);
    }

    public IParameterGuesser getParameterGuesser() {
        if (this.guesser == null) {
            this.guesser = new SimpleParameterGuesser(super.getParameterGuesser(), Collections.singleton(this.pojoagent));
        }
        return this.guesser;
    }
}

