/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.features.impl;

import jadex.bridge.IInternalAccess;
import jadex.bridge.ServiceCallInfo;
import jadex.bridge.component.ComponentCreationInfo;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IComponentFeatureFactory;
import jadex.bridge.component.ILifecycleComponentFeature;
import jadex.bridge.component.IPojoComponentFeature;
import jadex.bridge.component.ISubcomponentsFeature;
import jadex.bridge.component.impl.AbstractComponentFeature;
import jadex.bridge.component.impl.ComponentFeatureFactory;
import jadex.bridge.service.IService;
import jadex.bridge.service.component.IProvidedServicesFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.FieldInfo;
import jadex.commons.IValueFetcher;
import jadex.commons.MethodInfo;
import jadex.commons.SReflect;
import jadex.commons.SimpleParameterGuesser;
import jadex.commons.Tuple3;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.IntermediateDefaultResultListener;
import jadex.javaparser.SJavaParser;
import jadex.javaparser.SimpleValueFetcher;
import jadex.micro.MicroModel;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.AgentCreated;
import jadex.micro.annotation.AgentKilled;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MicroLifecycleComponentFeature
extends AbstractComponentFeature
implements ILifecycleComponentFeature {
    public static final IComponentFeatureFactory FACTORY = new ComponentFeatureFactory(ILifecycleComponentFeature.class, MicroLifecycleComponentFeature.class, new Class[]{IPojoComponentFeature.class, IRequiredServicesFeature.class, IProvidedServicesFeature.class, ISubcomponentsFeature.class}, null, false);

    public MicroLifecycleComponentFeature(IInternalAccess component, ComponentCreationInfo cinfo) {
        super(component, cinfo);
    }

    public IFuture<Void> init() {
        return MicroLifecycleComponentFeature.invokeMethod(this.getComponent(), AgentCreated.class, null);
    }

    public IFuture<Void> body() {
        this.invokeServices();
        return MicroLifecycleComponentFeature.invokeMethod(this.getComponent(), AgentBody.class, null);
    }

    public IFuture<Void> shutdown() {
        final Future ret = new Future();
        MicroLifecycleComponentFeature.invokeMethod(this.getComponent(), AgentKilled.class, null).addResultListener((IResultListener)new IResultListener<Void>(){

            public void resultAvailable(Void result) {
                this.proceed(null);
            }

            public void exceptionOccurred(Exception exception) {
                this.proceed(exception);
            }

            protected void proceed(Exception e) {
                try {
                    MicroModel micromodel = (MicroModel)((Object)MicroLifecycleComponentFeature.this.getComponent().getModel().getRawModel());
                    Object agent = MicroLifecycleComponentFeature.this.getPojoAgent();
                    for (String name : micromodel.getResultInjectionNames()) {
                        Tuple3<FieldInfo, String, String> inj = micromodel.getResultInjection(name);
                        Field field = ((FieldInfo)inj.getFirstEntity()).getField(MicroLifecycleComponentFeature.this.getComponent().getClassLoader());
                        String convback = (String)inj.getThirdEntity();
                        field.setAccessible(true);
                        Object val = field.get(agent);
                        if (convback != null) {
                            SimpleValueFetcher fetcher = new SimpleValueFetcher(MicroLifecycleComponentFeature.this.getComponent().getFetcher());
                            fetcher.setValue("$value", val);
                            val = SJavaParser.evaluateExpression((String)convback, (String[])MicroLifecycleComponentFeature.this.getComponent().getModel().getAllImports(), (IValueFetcher)fetcher, (ClassLoader)MicroLifecycleComponentFeature.this.getComponent().getClassLoader());
                        }
                        ((IArgumentsResultsFeature)MicroLifecycleComponentFeature.this.getComponent().getComponentFeature(IArgumentsResultsFeature.class)).getResults().put(name, val);
                    }
                }
                catch (Exception e2) {
                    ret.setException(e2);
                }
                if (!ret.isDone()) {
                    if (e != null) {
                        ret.setException(e);
                    } else {
                        ret.setResult(null);
                    }
                }
            }
        });
        return ret;
    }

    public Object getPojoAgent() {
        return ((IPojoComponentFeature)this.getComponent().getComponentFeature(IPojoComponentFeature.class)).getPojoAgent();
    }

    protected void invokeServices() {
        MicroModel mm = (MicroModel)((Object)this.getComponent().getModel().getRawModel());
        List<ServiceCallInfo> calls = mm.getServiceCalls();
        if (calls != null) {
            for (final ServiceCallInfo call : calls) {
                IFuture fut = ((IRequiredServicesFeature)this.getComponent().getComponentFeature(IRequiredServicesFeature.class)).getRequiredService(call.getRequiredName());
                fut.addResultListener((IResultListener)new IResultListener<IService>(){

                    public void resultAvailable(IService service) {
                        MethodInfo mi = call.getServiceMethod();
                        Method method = null;
                        if (mi == null) {
                            Class iface = service.getServiceIdentifier().getServiceType().getType(MicroLifecycleComponentFeature.this.getComponent().getClassLoader());
                            Method[] methods = iface.getMethods();
                            if (methods != null) {
                                for (Method m : methods) {
                                    if (m.getParameterTypes().length != 0) continue;
                                    method = m;
                                }
                            }
                        } else {
                            method = mi.getMethod(MicroLifecycleComponentFeature.this.getComponent().getClassLoader());
                        }
                        if (method != null) {
                            try {
                                IIntermediateFuture sfut;
                                Object ret = method.invoke((Object)service, new Object[0]);
                                if (ret instanceof IIntermediateFuture) {
                                    sfut = (IIntermediateFuture)ret;
                                    sfut.addResultListener((IResultListener)new IntermediateDefaultResultListener<Object>(){

                                        public void intermediateResultAvailable(Object result) {
                                            MicroLifecycleComponentFeature.this.handleCallback(call, result);
                                        }

                                        public void finished() {
                                        }

                                        public void exceptionOccurred(Exception exception) {
                                            exception.printStackTrace();
                                        }
                                    });
                                } else if (ret instanceof IFuture) {
                                    sfut = (IFuture)ret;
                                    sfut.addResultListener((IResultListener)new IResultListener<Object>(){

                                        public void resultAvailable(Object result) {
                                            MicroLifecycleComponentFeature.this.handleCallback(call, result);
                                        }

                                        public void exceptionOccurred(Exception exception) {
                                            exception.printStackTrace();
                                        }
                                    });
                                } else {
                                    MicroLifecycleComponentFeature.this.handleCallback(call, ret);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    public void exceptionOccurred(Exception exception) {
                        exception.printStackTrace();
                    }
                });
            }
        }
    }

    protected void handleCallback(ServiceCallInfo call, Object result) {
        try {
            if (call.getCallbackMethod() != null) {
                Method m = call.getCallbackMethod().getMethod(this.getComponent().getClassLoader());
                m.setAccessible(true);
                m.invoke(this.getPojoAgent(), result);
            } else {
                Field f = call.getCallbackField().getField(this.getComponent().getClassLoader());
                f.setAccessible(true);
                Class<?> ft = f.getType();
                if (SReflect.isSupertype(ft, result.getClass())) {
                    f.set(this.getPojoAgent(), result);
                } else if (SReflect.isSupertype(Collection.class, ft)) {
                    Collection coll = (Collection)f.get(this.getPojoAgent());
                    coll.add(result);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static IFuture<Void> invokeMethod(IInternalAccess component, Class<? extends Annotation> ann, Object[] args) {
        IFuture ret;
        block10: {
            MicroModel model = (MicroModel)((Object)component.getModel().getRawModel());
            MethodInfo mi = model.getAgentMethod(ann);
            if (mi != null) {
                Method method = mi.getMethod(component.getClassLoader());
                SimpleParameterGuesser guesser = args != null ? new SimpleParameterGuesser(component.getParameterGuesser(), Arrays.asList(args)) : component.getParameterGuesser();
                Object[] iargs = new Object[method.getParameterTypes().length];
                for (int i = 0; i < method.getParameterTypes().length; ++i) {
                    iargs[i] = guesser.guessParameter(method.getParameterTypes()[i], false);
                }
                try {
                    method.setAccessible(true);
                    Object res = method.invoke(((IPojoComponentFeature)component.getComponentFeature(IPojoComponentFeature.class)).getPojoAgent(), iargs);
                    if (res instanceof IFuture) {
                        ret = (IFuture)res;
                        break block10;
                    }
                    ret = IFuture.DONE;
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException) {
                        if (((InvocationTargetException)e).getTargetException() instanceof Exception) {
                            e = (Exception)((InvocationTargetException)e).getTargetException();
                        } else if (((InvocationTargetException)e).getTargetException() instanceof Error) {
                            throw (Error)((InvocationTargetException)e).getTargetException();
                        }
                    }
                    ret = new Future(e);
                }
            } else {
                ret = IFuture.DONE;
            }
        }
        return ret;
    }
}

