/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro.features.impl;

import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.ComponentCreationInfo;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IComponentFeatureFactory;
import jadex.bridge.component.IPojoComponentFeature;
import jadex.bridge.component.impl.AbstractComponentFeature;
import jadex.bridge.component.impl.ComponentFeatureFactory;
import jadex.bridge.service.component.IProvidedServicesFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.FieldInfo;
import jadex.commons.IValueFetcher;
import jadex.commons.SReflect;
import jadex.commons.Tuple2;
import jadex.commons.Tuple3;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.javaparser.SJavaParser;
import jadex.javaparser.SimpleValueFetcher;
import jadex.micro.MicroModel;
import jadex.micro.features.IMicroInjectionFeature;
import java.lang.reflect.Field;
import java.util.Map;

public class MicroInjectionComponentFeature
extends AbstractComponentFeature
implements IMicroInjectionFeature {
    public static final IComponentFeatureFactory FACTORY = new ComponentFeatureFactory(IMicroInjectionFeature.class, MicroInjectionComponentFeature.class, new Class[]{IPojoComponentFeature.class, IArgumentsResultsFeature.class, IRequiredServicesFeature.class}, new Class[]{IProvidedServicesFeature.class});

    public MicroInjectionComponentFeature(IInternalAccess component, ComponentCreationInfo cinfo) {
        super(component, cinfo);
    }

    public IFuture<Void> init() {
        Object val;
        String[] names;
        int i;
        final Future ret = new Future();
        Map args = ((IArgumentsResultsFeature)this.getComponent().getComponentFeature(IArgumentsResultsFeature.class)).getArguments();
        Map results = ((IArgumentsResultsFeature)this.getComponent().getComponentFeature(IArgumentsResultsFeature.class)).getResults();
        MicroModel model = (MicroModel)((Object)this.getComponent().getModel().getRawModel());
        final Object agent = ((IPojoComponentFeature)this.getComponent().getComponentFeature(IPojoComponentFeature.class)).getPojoAgent();
        FieldInfo[] fields = model.getAgentInjections();
        for (i = 0; i < fields.length; ++i) {
            try {
                Field f = fields[i].getField(this.getComponent().getClassLoader());
                f.setAccessible(true);
                f.set(agent, this.getComponent());
                continue;
            }
            catch (Exception e) {
                this.getComponent().getLogger().warning("Agent injection failed: " + e);
            }
        }
        if (args != null && (names = model.getArgumentInjectionNames()).length > 0) {
            for (int i2 = 0; i2 < names.length; ++i2) {
                val = args.get(names[i2]);
                Tuple2<FieldInfo, String>[] infos = model.getArgumentInjections(names[i2]);
                try {
                    for (int j = 0; j < infos.length; ++j) {
                        Field field = ((FieldInfo)infos[j].getFirstEntity()).getField(this.getComponent().getClassLoader());
                        String convert = (String)infos[j].getSecondEntity();
                        this.setFieldValue(val, field, convert);
                    }
                    continue;
                }
                catch (Exception e) {
                    this.getComponent().getLogger().warning("Field injection failed: " + e);
                    if (ret.isDone()) continue;
                    ret.setException(e);
                }
            }
        }
        if (results != null && (names = model.getResultInjectionNames()).length > 0) {
            for (int i3 = 0; i3 < names.length; ++i3) {
                if (!results.containsKey(names[i3])) continue;
                val = results.get(names[i3]);
                Tuple3<FieldInfo, String, String> info = model.getResultInjection(names[i3]);
                try {
                    Field field = ((FieldInfo)info.getFirstEntity()).getField(this.getComponent().getClassLoader());
                    String convert = (String)info.getSecondEntity();
                    this.setFieldValue(val, field, convert);
                    continue;
                }
                catch (Exception e) {
                    this.getComponent().getLogger().warning("Field injection failed: " + e);
                    if (ret.isDone()) continue;
                    ret.setException(e);
                }
            }
        }
        fields = model.getFeatureInjections();
        for (i = 0; i < fields.length; ++i) {
            try {
                Class<?> iface = this.getComponent().getClassLoader().loadClass(fields[i].getTypeName());
                Object feat = this.getComponent().getComponentFeature(iface);
                Field f = fields[i].getField(this.getComponent().getClassLoader());
                f.setAccessible(true);
                f.set(agent, feat);
                continue;
            }
            catch (Exception e) {
                this.getComponent().getLogger().warning("Feature injection failed: " + e);
                if (ret.isDone()) continue;
                ret.setException(e);
            }
        }
        final FieldInfo[] pis = model.getParentInjections();
        if (pis.length > 0) {
            IComponentManagementService cms = (IComponentManagementService)SServiceProvider.getLocalService((IInternalAccess)this.getComponent(), IComponentManagementService.class, (String)"platform");
            cms.getExternalAccess(this.getComponent().getComponentIdentifier().getParent()).addResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, Void>(ret){

                public void customResultAvailable(IExternalAccess exta) {
                    final CounterResultListener lis = new CounterResultListener(pis.length, (IResultListener)new DelegationResultListener(ret));
                    for (int i = 0; i < pis.length; ++i) {
                        final Field f = pis[i].getField(MicroInjectionComponentFeature.this.getComponent().getClassLoader());
                        if (IExternalAccess.class.equals(f.getType())) {
                            try {
                                f.setAccessible(true);
                                f.set(agent, exta);
                                lis.resultAvailable(null);
                            }
                            catch (Exception e) {
                                this.exceptionOccurred(e);
                            }
                            continue;
                        }
                        if (MicroInjectionComponentFeature.this.getComponent().getComponentDescription().isSynchronous()) {
                            exta.scheduleStep((IComponentStep)new IComponentStep<Void>(){

                                public IFuture<Void> execute(IInternalAccess ia) {
                                    Object pagent = ((IPojoComponentFeature)ia.getComponentFeature(IPojoComponentFeature.class)).getPojoAgent();
                                    if (SReflect.isSupertype(f.getType(), pagent.getClass())) {
                                        try {
                                            f.setAccessible(true);
                                            f.set(agent, pagent);
                                            lis.resultAvailable(null);
                                        }
                                        catch (Exception e) {
                                            this.exceptionOccurred(e);
                                        }
                                    } else {
                                        throw new RuntimeException("Incompatible types for parent injection: " + pagent + ", " + f);
                                    }
                                    return IFuture.DONE;
                                }
                            });
                            continue;
                        }
                        this.exceptionOccurred(new RuntimeException("Non-external parent injection for non-synchronous subcomponent not allowed: " + f));
                    }
                }
            });
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    protected void setFieldValue(Object val, Field field, String convert) {
        if (val != null || !SReflect.isBasicType(field.getType())) {
            try {
                Object agent = ((IPojoComponentFeature)this.getComponent().getComponentFeature(IPojoComponentFeature.class)).getPojoAgent();
                if (convert != null) {
                    SimpleValueFetcher fetcher = new SimpleValueFetcher(this.getComponent().getFetcher());
                    fetcher.setValue("$value", val);
                    val = SJavaParser.evaluateExpression((String)convert, (String[])this.getComponent().getModel().getAllImports(), (IValueFetcher)fetcher, (ClassLoader)this.getComponent().getClassLoader());
                }
                field.setAccessible(true);
                field.set(agent, val);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

