/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro;

import jadex.bridge.ClassInfo;
import jadex.bridge.ServiceCallInfo;
import jadex.bridge.modelinfo.IModelInfo;
import jadex.commons.FieldInfo;
import jadex.commons.MethodInfo;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.Tuple3;
import jadex.commons.collection.MultiCollection;
import jadex.kernelbase.CacheableKernelModel;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MicroModel
extends CacheableKernelModel {
    protected ClassInfo pojoclass;
    protected List<FieldInfo> agentinjections;
    protected List<FieldInfo> parentinjections;
    protected MultiCollection<String, Tuple2<FieldInfo, String>> argumentinjections;
    protected Map<String, Tuple3<FieldInfo, String, String>> resultinjections;
    protected MultiCollection<String, Object> serviceinjections;
    protected List<FieldInfo> featureinjections;
    protected ClassLoader classloader;
    protected Map<Class<? extends Annotation>, MethodInfo> agentmethods;
    protected List<ServiceCallInfo> servicecalls;

    public MicroModel(IModelInfo modelinfo) {
        super(modelinfo);
    }

    public void addAgentInjection(FieldInfo field) {
        if (this.agentinjections == null) {
            this.agentinjections = new ArrayList<FieldInfo>();
        }
        this.agentinjections.add(field);
    }

    public FieldInfo[] getAgentInjections() {
        return this.agentinjections == null ? new FieldInfo[]{} : this.agentinjections.toArray(new FieldInfo[this.agentinjections.size()]);
    }

    public void addParentInjection(FieldInfo field) {
        if (this.parentinjections == null) {
            this.parentinjections = new ArrayList<FieldInfo>();
        }
        this.parentinjections.add(field);
    }

    public FieldInfo[] getParentInjections() {
        return this.parentinjections == null ? new FieldInfo[]{} : this.parentinjections.toArray(new FieldInfo[this.parentinjections.size()]);
    }

    public void addArgumentInjection(String name, FieldInfo field, String convert) {
        if (this.argumentinjections == null) {
            this.argumentinjections = new MultiCollection();
        }
        this.argumentinjections.add((Object)name, (Object)new Tuple2((Object)field, convert != null && convert.length() == 0 ? null : convert));
    }

    public Tuple2<FieldInfo, String>[] getArgumentInjections(String name) {
        Collection col = this.argumentinjections == null ? null : this.argumentinjections.get((Object)name);
        return col == null ? new Tuple2[]{} : col.toArray(new Tuple2[col.size()]);
    }

    public String[] getArgumentInjectionNames() {
        return this.argumentinjections == null ? SUtil.EMPTY_STRING_ARRAY : this.argumentinjections.keySet().toArray(new String[this.argumentinjections.size()]);
    }

    public void addResultInjection(String name, FieldInfo field, String convert, String convback) {
        if (this.resultinjections == null) {
            this.resultinjections = new HashMap<String, Tuple3<FieldInfo, String, String>>();
        }
        this.resultinjections.put(name, (Tuple3<FieldInfo, String, String>)new Tuple3((Object)field, convert != null && convert.length() == 0 ? null : convert, convback != null && convback.length() == 0 ? null : convback));
    }

    public Tuple3<FieldInfo, String, String> getResultInjection(String name) {
        return this.resultinjections == null ? null : this.resultinjections.get(name);
    }

    public String[] getResultInjectionNames() {
        return this.resultinjections == null ? SUtil.EMPTY_STRING_ARRAY : this.resultinjections.keySet().toArray(new String[this.resultinjections.size()]);
    }

    public void addServiceInjection(String name, FieldInfo field) {
        if (this.serviceinjections == null) {
            this.serviceinjections = new MultiCollection();
        }
        this.serviceinjections.add((Object)name, (Object)field);
    }

    public void addServiceInjection(String name, MethodInfo method) {
        if (this.serviceinjections == null) {
            this.serviceinjections = new MultiCollection();
        }
        this.serviceinjections.add((Object)name, (Object)method);
    }

    public Object[] getServiceInjections(String name) {
        Collection col = this.serviceinjections == null ? null : this.serviceinjections.get((Object)name);
        return col == null ? new Object[]{} : col.toArray(new Object[col.size()]);
    }

    public String[] getServiceInjectionNames() {
        return this.serviceinjections == null ? SUtil.EMPTY_STRING_ARRAY : this.serviceinjections.keySet().toArray(new String[this.serviceinjections.size()]);
    }

    public void addFeatureInjection(String name, FieldInfo field) {
        if (this.featureinjections == null) {
            this.featureinjections = new ArrayList<FieldInfo>();
        }
        this.featureinjections.add(field);
    }

    public FieldInfo[] getFeatureInjections() {
        return this.featureinjections == null ? new FieldInfo[]{} : this.featureinjections.toArray(new FieldInfo[this.featureinjections.size()]);
    }

    public void addServiceCall(ServiceCallInfo call) {
        if (this.servicecalls == null) {
            this.servicecalls = new ArrayList<ServiceCallInfo>();
        }
        this.servicecalls.add(call);
    }

    public List<ServiceCallInfo> getServiceCalls() {
        return this.servicecalls;
    }

    public void setServiceCalls(List<ServiceCallInfo> servicecalls) {
        this.servicecalls = servicecalls;
    }

    public ClassInfo getPojoClass() {
        return this.pojoclass;
    }

    public void setPojoClass(ClassInfo pojoclass) {
        this.pojoclass = pojoclass;
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public void setAgentMethod(Class<? extends Annotation> ann, MethodInfo mi) {
        if (this.agentmethods == null) {
            this.agentmethods = new HashMap<Class<? extends Annotation>, MethodInfo>();
        }
        if (!this.agentmethods.containsKey(ann)) {
            this.agentmethods.put(ann, mi);
        } else {
            MethodInfo prev = this.agentmethods.get(ann);
            if (SUtil.equals((Object)mi.getClassName(), (Object)prev.getClassName())) {
                throw new RuntimeException("Only one @" + ann.getSimpleName() + " method allowed in " + mi.getClassName());
            }
        }
    }

    public MethodInfo getAgentMethod(Class<? extends Annotation> ann) {
        return this.agentmethods != null ? this.agentmethods.get(ann) : null;
    }
}

