/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro;

import jadex.bridge.ClassInfo;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.ILocalResourceIdentifier;
import jadex.bridge.IResourceIdentifier;
import jadex.bridge.LocalResourceIdentifier;
import jadex.bridge.ResourceIdentifier;
import jadex.bridge.ServiceCallInfo;
import jadex.bridge.component.IComponentFeatureFactory;
import jadex.bridge.component.impl.ComponentFeatureFactory;
import jadex.bridge.modelinfo.Argument;
import jadex.bridge.modelinfo.ComponentInstanceInfo;
import jadex.bridge.modelinfo.ConfigurationInfo;
import jadex.bridge.modelinfo.IArgument;
import jadex.bridge.modelinfo.IModelInfo;
import jadex.bridge.modelinfo.ModelInfo;
import jadex.bridge.modelinfo.NFPropertyInfo;
import jadex.bridge.modelinfo.NFRPropertyInfo;
import jadex.bridge.modelinfo.SubcomponentTypeInfo;
import jadex.bridge.modelinfo.UnparsedExpression;
import jadex.bridge.nonfunctional.annotation.NFProperties;
import jadex.bridge.nonfunctional.annotation.NFProperty;
import jadex.bridge.nonfunctional.annotation.NFRProperty;
import jadex.bridge.service.ProvidedServiceImplementation;
import jadex.bridge.service.ProvidedServiceInfo;
import jadex.bridge.service.PublishInfo;
import jadex.bridge.service.RequiredServiceBinding;
import jadex.bridge.service.RequiredServiceInfo;
import jadex.bridge.service.annotation.GuiClass;
import jadex.bridge.service.annotation.GuiClassName;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.Value;
import jadex.bridge.service.types.factory.SComponentFactory;
import jadex.bridge.service.types.monitoring.IMonitoringService;
import jadex.commons.FieldInfo;
import jadex.commons.IValueFetcher;
import jadex.commons.MethodInfo;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.future.IFuture;
import jadex.javaparser.SJavaParser;
import jadex.micro.MicroModel;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentArgument;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.AgentBreakpoint;
import jadex.micro.annotation.AgentCreated;
import jadex.micro.annotation.AgentFeature;
import jadex.micro.annotation.AgentKilled;
import jadex.micro.annotation.AgentMessageArrived;
import jadex.micro.annotation.AgentResult;
import jadex.micro.annotation.AgentService;
import jadex.micro.annotation.AgentServiceValue;
import jadex.micro.annotation.AgentStreamArrived;
import jadex.micro.annotation.Arguments;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.Breakpoints;
import jadex.micro.annotation.Component;
import jadex.micro.annotation.ComponentType;
import jadex.micro.annotation.ComponentTypes;
import jadex.micro.annotation.Configuration;
import jadex.micro.annotation.Configurations;
import jadex.micro.annotation.CreationInfo;
import jadex.micro.annotation.Description;
import jadex.micro.annotation.Feature;
import jadex.micro.annotation.Features;
import jadex.micro.annotation.Implementation;
import jadex.micro.annotation.Imports;
import jadex.micro.annotation.NameValue;
import jadex.micro.annotation.Parent;
import jadex.micro.annotation.Properties;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.Publish;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import jadex.micro.annotation.Results;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MicroClassReader {
    public MicroModel read(String model, String[] imports, ClassLoader classloader, IResourceIdentifier rid, IComponentIdentifier root, List<IComponentFeatureFactory> features) {
        String clname = model;
        if (clname.endsWith(".class")) {
            clname = model.substring(0, model.indexOf(".class"));
        }
        clname = clname.replace('\\', '.');
        clname = clname.replace('/', '.');
        Class cma = this.getMicroAgentClass(clname, imports, classloader);
        return this.read(model, cma, classloader, rid, root, features);
    }

    protected MicroModel read(String model, Class<?> cma, ClassLoader classloader, IResourceIdentifier rid, IComponentIdentifier root, List<IComponentFeatureFactory> features) {
        ModelInfo modelinfo = new ModelInfo();
        MicroModel ret = new MicroModel((IModelInfo)modelinfo);
        ret.setPojoClass(new ClassInfo(cma.getName()));
        modelinfo.internalSetRawModel((Object)ret);
        String name = SReflect.getUnqualifiedClassName(cma);
        if (name.endsWith("Agent")) {
            name = name.substring(0, name.lastIndexOf("Agent"));
        }
        String packagename = cma.getPackage() != null ? cma.getPackage().getName() : null;
        modelinfo.setName(name);
        modelinfo.setPackage(packagename);
        URL sourceLocation = cma.getProtectionDomain() != null && cma.getProtectionDomain().getCodeSource().getLocation() != null ? cma.getProtectionDomain().getCodeSource().getLocation() : null;
        String src = sourceLocation != null ? SUtil.convertURLToString((URL)sourceLocation) + File.separator : "/";
        modelinfo.setFilename(src + SReflect.getClassName(cma).replace('.', cma.getProtectionDomain() != null ? File.separatorChar : (char)'/') + ".class");
        modelinfo.setType("Micro Agent");
        modelinfo.setStartable(true);
        if (features != null) {
            modelinfo.setFeatures(features.toArray(new IComponentFeatureFactory[features.size()]));
        }
        if (rid == null) {
            URL url = null;
            try {
                url = sourceLocation != null ? sourceLocation : new URL("file://" + cma.getPackage().getName().replace('.', '/') + '/');
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            rid = new ResourceIdentifier((ILocalResourceIdentifier)new LocalResourceIdentifier(root, url), null);
        }
        modelinfo.setResourceIdentifier(rid);
        modelinfo.setClassloader(classloader);
        ret.setClassloader(classloader);
        this.fillMicroModelFromAnnotations(ret, model, cma, classloader);
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    protected void fillMicroModelFromAnnotations(MicroModel micromodel, String model, Class<?> clazz, ClassLoader cl) {
        Map feats;
        Map cfs;
        Map cts;
        Map res;
        Map argus;
        Map psers;
        Map rsers;
        List nfprops;
        ModelInfo modelinfo = (ModelInfo)micromodel.getModelInfo();
        int cnt = 0;
        HashMap<String, Object> toset = new HashMap<String, Object>();
        boolean propdone = false;
        boolean reqsdone = false;
        boolean prosdone = false;
        boolean argsdone = false;
        boolean resudone = false;
        boolean confdone = false;
        boolean compdone = false;
        boolean breaksdone = false;
        boolean nfpropsdone = false;
        boolean featdone = false;
        boolean addfeat = false;
        HashSet<String> configdone = new HashSet<String>();
        HashSet serifaces = new HashSet();
        for (Class<?> cma = clazz; cma != null && !cma.equals(Object.class); cma = cma.getSuperclass()) {
            GuiClass gui;
            Object props;
            Object[] vals;
            Annotation val;
            Object tmp;
            LinkedHashSet imports;
            if (MicroClassReader.isAnnotationPresent(cma, Agent.class, cl)) {
                Class<?>[] ifaces;
                IMonitoringService.PublishEventLevel moni;
                Agent val2 = this.getAnnotation(cma, Agent.class, cl);
                Boolean susp = val2.suspend().toBoolean();
                Boolean mast = val2.master().toBoolean();
                Boolean daem = val2.daemon().toBoolean();
                Boolean auto = val2.autoshutdown().toBoolean();
                Boolean sync = val2.synchronous().toBoolean();
                Boolean persist = val2.persistable().toBoolean();
                NFRProperty[] keep = val2.keepalive().toBoolean();
                if (susp != null && modelinfo.getSuspend() == null) {
                    modelinfo.setSuspend(susp);
                }
                if (mast != null && modelinfo.getMaster() == null) {
                    modelinfo.setMaster(mast);
                }
                if (daem != null && modelinfo.getDaemon() == null) {
                    modelinfo.setDaemon(daem);
                }
                if (auto != null && modelinfo.getAutoShutdown() == null) {
                    modelinfo.setAutoShutdown(auto);
                }
                if (sync != null && modelinfo.getSynchronous() == null) {
                    modelinfo.setSynchronous(sync);
                }
                if (persist != null && modelinfo.getPersistable() == null) {
                    modelinfo.setPersistable(persist);
                }
                if (keep != null && modelinfo.getKeepalive() == null) {
                    modelinfo.setKeepalive((Boolean)keep);
                }
                if (!IMonitoringService.PublishEventLevel.NULL.equals((Object)(moni = val2.monitoring()))) {
                    modelinfo.setMonitoring(moni);
                }
                for (Class<?> clazz2 : ifaces = cma.getInterfaces()) {
                    if (!MicroClassReader.isAnnotationPresent(clazz2, Service.class, cl)) continue;
                    serifaces.add(clazz2);
                }
            }
            if (MicroClassReader.isAnnotationPresent(cma, Description.class, cl) && modelinfo.getDescription() == null) {
                Description val2 = this.getAnnotation(cma, Description.class, cl);
                modelinfo.setDescription(val2.value());
            }
            if (MicroClassReader.isAnnotationPresent(cma, Imports.class, cl)) {
                String[] tmp2 = this.getAnnotation(cma, Imports.class, cl).value();
                LinkedHashSet<String> imports2 = (LinkedHashSet<String>)toset.get("imports");
                if (imports2 == null) {
                    imports2 = new LinkedHashSet<String>();
                    toset.put("imports", imports2);
                }
                for (int i = 0; i < tmp2.length; ++i) {
                    imports2.add(tmp2[i]);
                }
            }
            if ((imports = (LinkedHashSet)toset.get("imports")) == null) {
                imports = new LinkedHashSet();
                toset.put("imports", imports);
            }
            if (!featdone && MicroClassReader.isAnnotationPresent(cma, Features.class, cl)) {
                Features fs = this.getAnnotation(cma, Features.class, cl);
                tmp = fs.value();
                featdone = fs.replace();
                HashMap features = (HashMap)toset.get("features");
                if (features == null) {
                    addfeat = fs.additional();
                    features = new HashMap();
                    toset.put("features", features);
                }
                for (int i = 0; i < ((Feature[])tmp).length; ++i) {
                    if (features.containsKey(tmp[i].type())) continue;
                    features.put(tmp[i].type(), new ComponentFeatureFactory(tmp[i].type(), tmp[i].clazz(), (Class[])tmp[i].predecessors(), (Class[])tmp[i].successors(), tmp[i].addlast()));
                }
            }
            if (!propdone && MicroClassReader.isAnnotationPresent(cma, Properties.class, cl)) {
                val = this.getAnnotation(cma, Properties.class, cl);
                vals = val.value();
                propdone = val.replace();
                props = (Map)toset.get("properties");
                if (props == null) {
                    props = new LinkedHashMap();
                    toset.put("properties", props);
                }
                for (int i = 0; i < vals.length; ++i) {
                    if (props.containsKey(vals[i].name())) continue;
                    props.put(vals[i].name(), new UnparsedExpression(vals[i].name(), vals[i].clazz().getName(), vals[i].value(), null));
                }
            }
            if (!nfpropsdone && MicroClassReader.isAnnotationPresent(cma, NFProperties.class, cl)) {
                val = this.getAnnotation(cma, NFProperties.class, cl);
                ArrayList<NFPropertyInfo> nfps = (ArrayList<NFPropertyInfo>)toset.get("nfproperties");
                if (nfps == null) {
                    nfps = new ArrayList<NFPropertyInfo>();
                    toset.put("nfproperties", nfps);
                }
                for (NFProperty prop : val.value()) {
                    nfps.add(new NFPropertyInfo(prop.name(), new ClassInfo(prop.value().getName())));
                }
            }
            if (MicroClassReader.isAnnotationPresent(cma, GuiClass.class, cl)) {
                gui = this.getAnnotation(cma, GuiClass.class, cl);
                Class gclazz = gui.value();
                props = (NFProperty[])toset.get("properties");
                if (props == null) {
                    props = new LinkedHashMap();
                    toset.put("properties", props);
                }
                if (!props.containsKey("componentviewer.viewerclass")) {
                    props.put("componentviewer.viewerclass", gclazz.getName());
                }
            } else if (MicroClassReader.isAnnotationPresent(cma, GuiClassName.class, cl)) {
                gui = this.getAnnotation(cma, GuiClassName.class, cl);
                String clazzname = gui.value();
                props = (Map)toset.get("properties");
                if (props == null) {
                    props = new LinkedHashMap();
                    toset.put("properties", props);
                }
                if (!props.containsKey("componentviewer.viewerclass")) {
                    props.put("componentviewer.viewerclass", clazzname);
                }
            }
            if (!breaksdone && MicroClassReader.isAnnotationPresent(cma, Breakpoints.class, cl)) {
                val = this.getAnnotation(cma, Breakpoints.class, cl);
                breaksdone = val.replace();
                vals = val.value();
                ArrayList<Object> bps = (ArrayList<Object>)toset.get("breakpoints");
                if (bps == null) {
                    bps = new ArrayList<Object>();
                    toset.put("breakpoints", bps);
                }
                for (int i = 0; i < vals.length; ++i) {
                    if (bps.contains(vals[i])) continue;
                    bps.add(vals[i]);
                }
            }
            if (!reqsdone && MicroClassReader.isAnnotationPresent(cma, RequiredServices.class, cl)) {
                val = this.getAnnotation(cma, RequiredServices.class, cl);
                vals = val.value();
                reqsdone = val.replace();
                LinkedHashMap<String, RequiredServiceInfo> rsers2 = (LinkedHashMap<String, RequiredServiceInfo>)toset.get("reqservices");
                if (rsers2 == null) {
                    rsers2 = new LinkedHashMap<String, RequiredServiceInfo>();
                    toset.put("reqservices", rsers2);
                }
                for (int i = 0; i < vals.length; ++i) {
                    RequiredServiceBinding binding = this.createBinding(vals[i].binding());
                    List<NFRPropertyInfo> nfprops2 = this.createNFRProperties(vals[i].nfprops());
                    for (NFRProperty prop : vals[i].nfprops()) {
                        nfprops2.add(new NFRPropertyInfo(prop.name(), new ClassInfo(prop.value().getName()), new MethodInfo(prop.methodname(), prop.methodparametertypes())));
                    }
                    RequiredServiceInfo rsis = new RequiredServiceInfo(vals[i].name(), vals[i].type(), vals[i].multiple(), Object.class.equals(vals[i].multiplextype()) ? null : vals[i].multiplextype(), binding, nfprops2);
                    if (rsers2.containsKey(vals[i].name())) {
                        RequiredServiceInfo old = (RequiredServiceInfo)rsers2.get(vals[i].name());
                        if (old.isMultiple() == rsis.isMultiple() && old.getType().getType(cl).equals(rsis.getType().getType(cl))) continue;
                        throw new RuntimeException("Extension hierarchy contains incompatible required service more than once: " + vals[i].name());
                    }
                    rsers2.put(vals[i].name(), rsis);
                }
            }
            if (!prosdone && MicroClassReader.isAnnotationPresent(cma, ProvidedServices.class, cl)) {
                val = this.getAnnotation(cma, ProvidedServices.class, cl);
                vals = val.value();
                prosdone = val.replace();
                LinkedHashMap<String, ProvidedServiceInfo> psers2 = (LinkedHashMap<String, ProvidedServiceInfo>)toset.get("proservices");
                if (psers2 == null) {
                    psers2 = new LinkedHashMap<String, ProvidedServiceInfo>();
                    toset.put("proservices", psers2);
                }
                for (int i = 0; i < vals.length; ++i) {
                    Implementation im = vals[i].implementation();
                    Value[] inters = im.interceptors();
                    UnparsedExpression[] interceptors = null;
                    if (inters.length > 0) {
                        interceptors = new UnparsedExpression[inters.length];
                        for (int j = 0; j < inters.length; ++j) {
                            interceptors[j] = new UnparsedExpression(null, inters[j].clazz(), inters[j].value(), null);
                        }
                    }
                    ProvidedServiceImplementation impl = this.createImplementation(im);
                    Publish p = vals[i].publish();
                    NameValue[] props2 = p.properties();
                    UnparsedExpression[] exps = this.createUnparsedExpressions(props2);
                    PublishInfo pi = p.publishid().length() == 0 ? null : new PublishInfo(p.publishid(), p.publishtype(), Object.class.equals(p.mapping()) ? null : p.mapping(), exps);
                    props2 = vals[i].properties();
                    ArrayList<UnparsedExpression> arrayList = props2 != null && props2.length > 0 ? new ArrayList<UnparsedExpression>(Arrays.asList(this.createUnparsedExpressions(props2))) : null;
                    ProvidedServiceInfo psis = new ProvidedServiceInfo(vals[i].name().length() > 0 ? vals[i].name() : null, vals[i].type(), impl, vals[i].scope(), pi, arrayList);
                    if (vals[i].name().length() != 0 && psers2.containsKey(vals[i].name())) continue;
                    psers2.put(vals[i].name().length() == 0 ? "#" + cnt++ : vals[i].name(), psis);
                }
            }
            if (!argsdone && MicroClassReader.isAnnotationPresent(cma, Arguments.class, cl)) {
                val = this.getAnnotation(cma, Arguments.class, cl);
                vals = val.value();
                argsdone = val.replace();
                LinkedHashMap<String, Argument> args = (LinkedHashMap<String, Argument>)toset.get("arguments");
                if (args == null) {
                    args = new LinkedHashMap<String, Argument>();
                    toset.put("arguments", args);
                }
                for (int i = 0; i < vals.length; ++i) {
                    Argument tmparg = new Argument(vals[i].name(), vals[i].description(), SReflect.getClassName(vals[i].clazz()), "".equals(vals[i].defaultvalue()) ? null : vals[i].defaultvalue());
                    if (args.containsKey(vals[i].name())) continue;
                    args.put(vals[i].name(), tmparg);
                }
            }
            if (!resudone && MicroClassReader.isAnnotationPresent(cma, Results.class, cl)) {
                val = this.getAnnotation(cma, Results.class, cl);
                vals = val.value();
                resudone = val.replace();
                LinkedHashMap<String, Argument> res2 = (LinkedHashMap<String, Argument>)toset.get("results");
                if (res2 == null) {
                    res2 = new LinkedHashMap<String, Argument>();
                    toset.put("results", res2);
                }
                IArgument[] tmpresults = new IArgument[vals.length];
                for (int i = 0; i < vals.length; ++i) {
                    Argument tmpresult = new Argument(vals[i].name(), vals[i].description(), SReflect.getClassName(vals[i].clazz()), "".equals(vals[i].defaultvalue()) ? null : vals[i].defaultvalue());
                    if (res2.containsKey(vals[i].name())) continue;
                    res2.put(vals[i].name(), tmpresult);
                }
            }
            if (!compdone && MicroClassReader.isAnnotationPresent(cma, ComponentTypes.class, cl)) {
                Object subinfos = null;
                tmp = this.getAnnotation(cma, ComponentTypes.class, cl);
                compdone = tmp.replace();
                ComponentType[] ctypes = tmp.value();
                Object res3 = (Configuration[])toset.get("componenttypes");
                if (res3 == null) {
                    res3 = new LinkedHashMap();
                    toset.put("componenttypes", res3);
                }
                for (int i = 0; i < ctypes.length; ++i) {
                    String val3 = ctypes[i].filename();
                    if (!Object.class.equals(ctypes[i].clazz())) {
                        val3 = ctypes[i].clazz().getName() + ".class";
                    }
                    SubcomponentTypeInfo subinfo = new SubcomponentTypeInfo(ctypes[i].name(), val3);
                    if (res3.containsKey(ctypes[i].name())) continue;
                    res3.put(ctypes[i].name(), subinfo);
                }
            }
            if (!confdone && MicroClassReader.isAnnotationPresent(cma, Configurations.class, cl)) {
                val = this.getAnnotation(cma, Configurations.class, cl);
                Configuration[] configs = val.value();
                confdone = val.replace();
                LinkedHashMap<String, ConfigurationInfo> confs = (LinkedHashMap<String, ConfigurationInfo>)toset.get("configurations");
                if (confs == null) {
                    confs = new LinkedHashMap<String, ConfigurationInfo>();
                    toset.put("configurations", confs);
                }
                for (Configuration config : configs) {
                    void var35_74;
                    if (configdone.contains(config.name())) continue;
                    ConfigurationInfo configinfo = (ConfigurationInfo)confs.get(config.name());
                    if (config.replace()) {
                        configdone.add(config.name());
                    }
                    if (configinfo == null) {
                        configinfo = new ConfigurationInfo(config.name());
                        confs.put(config.name(), configinfo);
                    }
                    if (configinfo.getMaster() == null) {
                        configinfo.setMaster(config.master().toBoolean());
                    }
                    if (configinfo.getDaemon() == null) {
                        configinfo.setDaemon(config.daemon().toBoolean());
                    }
                    if (configinfo.getAutoShutdown() == null) {
                        configinfo.setAutoShutdown(config.autoshutdown().toBoolean());
                    }
                    if (configinfo.getSynchronous() == null) {
                        configinfo.setSynchronous(config.synchronous().toBoolean());
                    }
                    if (configinfo.getPersistable() == null) {
                        configinfo.setPersistable(config.persistable().toBoolean());
                    }
                    if (configinfo.getSuspend() == null) {
                        configinfo.setSuspend(config.suspend().toBoolean());
                    }
                    if (configinfo.getScope() == null && !"global".equals(config.scope())) {
                        configinfo.setScope(config.scope());
                    }
                    NameValue[] argvals = config.arguments();
                    for (int j = 0; j < argvals.length; ++j) {
                        if (configinfo.hasArgument(argvals[j].name())) continue;
                        configinfo.addArgument(new UnparsedExpression(argvals[j].name(), argvals[j].clazz(), argvals[j].value(), null));
                    }
                    NameValue[] resvals = config.results();
                    for (int j = 0; j < resvals.length; ++j) {
                        if (configinfo.hasResult(resvals[j].name())) continue;
                        configinfo.addResult(new UnparsedExpression(resvals[j].name(), resvals[j].clazz(), resvals[j].value(), null));
                    }
                    ProvidedService[] provs = config.providedservices();
                    for (int j = 0; j < provs.length; ++j) {
                        if (configinfo.hasProvidedService(provs[j].name())) continue;
                        Implementation implementation = provs[j].implementation();
                        Value[] inters = implementation.interceptors();
                        UnparsedExpression[] interceptors = null;
                        if (inters.length > 0) {
                            interceptors = new UnparsedExpression[inters.length];
                            for (int k = 0; k < inters.length; ++k) {
                                interceptors[k] = new UnparsedExpression(null, inters[k].clazz(), inters[k].value(), null);
                            }
                        }
                        RequiredServiceBinding bind = this.createBinding(implementation.binding());
                        ProvidedServiceImplementation impl = new ProvidedServiceImplementation(!implementation.value().equals(Object.class) ? implementation.value() : null, implementation.expression().length() > 0 ? implementation.expression() : null, implementation.proxytype(), bind, interceptors);
                        Publish p = provs[j].publish();
                        PublishInfo pi = p.publishid().length() == 0 ? null : new PublishInfo(p.publishid(), p.publishtype(), p.mapping(), this.createUnparsedExpressions(p.properties()));
                        NameValue[] props3 = provs[j].properties();
                        ArrayList<UnparsedExpression> serprops = props3 != null && props3.length > 0 ? new ArrayList<UnparsedExpression>(Arrays.asList(this.createUnparsedExpressions(props3))) : null;
                        ProvidedServiceInfo psi = new ProvidedServiceInfo(provs[j].name().length() > 0 ? provs[j].name() : null, provs[j].type(), impl, provs[j].scope(), pi, serprops);
                        configinfo.addProvidedService(psi);
                    }
                    RequiredService[] reqs = config.requiredservices();
                    boolean bl = false;
                    while (var35_74 < reqs.length) {
                        if (!configinfo.hasRequiredService(reqs[var35_74].name())) {
                            RequiredServiceBinding binding = this.createBinding(reqs[var35_74].binding());
                            List<NFRPropertyInfo> nfprops3 = this.createNFRProperties(reqs[var35_74].nfprops());
                            RequiredServiceInfo rsi = new RequiredServiceInfo(reqs[var35_74].name(), reqs[var35_74].type(), reqs[var35_74].multiple(), Object.class.equals(reqs[var35_74].multiplextype()) ? null : reqs[var35_74].multiplextype(), binding, nfprops3);
                            configinfo.addRequiredService(rsi);
                        }
                        ++var35_74;
                    }
                    Component[] componentArray = config.components();
                    for (int j = 0; j < componentArray.length; ++j) {
                        if (configinfo.hasComponentInstance(componentArray[j].name(), componentArray[j].type())) continue;
                        configinfo.addComponentInstance(this.createComponentInstanceInfo(componentArray[j]));
                    }
                }
            }
            Field[] fields = cma.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                String name;
                Annotation ser;
                if (MicroClassReader.isAnnotationPresent(fields[i], Agent.class, cl)) {
                    micromodel.addAgentInjection(new FieldInfo(fields[i]));
                } else if (MicroClassReader.isAnnotationPresent(fields[i], Parent.class, cl)) {
                    micromodel.addParentInjection(new FieldInfo(fields[i]));
                } else if (MicroClassReader.isAnnotationPresent(fields[i], AgentService.class, cl)) {
                    ser = this.getAnnotation(fields[i], AgentService.class, cl);
                    name = ser.name().length() > 0 ? ser.name() : fields[i].getName();
                    micromodel.addServiceInjection(name, new FieldInfo(fields[i]));
                } else if (MicroClassReader.isAnnotationPresent(fields[i], AgentFeature.class, cl)) {
                    micromodel.addFeatureInjection(fields[i].getName(), new FieldInfo(fields[i]));
                } else {
                    if (MicroClassReader.isAnnotationPresent(fields[i], AgentArgument.class, cl)) {
                        AgentArgument arg = this.getAnnotation(fields[i], AgentArgument.class, cl);
                        name = arg.value().length() > 0 ? arg.value() : fields[i].getName();
                        micromodel.addArgumentInjection(name, new FieldInfo(fields[i]), arg.convert());
                    }
                    if (MicroClassReader.isAnnotationPresent(fields[i], AgentResult.class, cl)) {
                        AgentResult res2 = this.getAnnotation(fields[i], AgentResult.class, cl);
                        String string = name = res2.value().length() > 0 ? res2.value() : fields[i].getName();
                        if (micromodel.getResultInjection(name) == null) {
                            micromodel.addResultInjection(name, new FieldInfo(fields[i]), res2.convert(), res2.convertback());
                        }
                    }
                }
                if (!MicroClassReader.isAnnotationPresent(fields[i], AgentServiceValue.class, cl)) continue;
                ser = this.getAnnotation(fields[i], AgentServiceValue.class, cl);
                String reqname = ser.name();
                micromodel.addServiceCall(new ServiceCallInfo(reqname, null, new FieldInfo(fields[i])));
            }
            Method[] methods = cma.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Annotation ser;
                if (MicroClassReader.isAnnotationPresent(methods[i], AgentService.class, cl)) {
                    String name;
                    ser = this.getAnnotation(methods[i], AgentService.class, cl);
                    if (ser.name().length() > 0) {
                        name = ser.name();
                    } else {
                        name = methods[i].getName();
                        if ((name = name.toLowerCase()).startsWith("add")) {
                            name = name.substring(3);
                            name = SUtil.getPlural((String)name);
                        } else if (name.startsWith("set")) {
                            name = name.substring(3);
                        }
                    }
                    micromodel.addServiceInjection(name, new MethodInfo(methods[i]));
                }
                if (MicroClassReader.isAnnotationPresent(methods[i], AgentServiceValue.class, cl)) {
                    ser = this.getAnnotation(methods[i], AgentServiceValue.class, cl);
                    ConfigurationInfo[] reqname = ser.name();
                    micromodel.addServiceCall(new ServiceCallInfo((String)reqname, null, new MethodInfo(methods[i])));
                }
                if (MicroClassReader.isAnnotationPresent(methods[i], AgentCreated.class, cl)) {
                    this.checkMethodReturnType(AgentCreated.class, methods[i], cl);
                    micromodel.setAgentMethod(AgentCreated.class, new MethodInfo(methods[i]));
                }
                if (MicroClassReader.isAnnotationPresent(methods[i], AgentBody.class, cl)) {
                    this.checkMethodReturnType(AgentBody.class, methods[i], cl);
                    boolean isvoid = methods[i].getReturnType().equals(Void.TYPE);
                    if (!isvoid) {
                        if (modelinfo.getKeepalive() == null) {
                            modelinfo.setKeepalive(Boolean.FALSE);
                        }
                        for (ConfigurationInfo ci : modelinfo.getConfigurations()) {
                            if (ci.getKeepalive() != null) continue;
                            ci.setKeepalive(Boolean.FALSE);
                        }
                    }
                    micromodel.setAgentMethod(AgentBody.class, new MethodInfo(methods[i]));
                }
                if (MicroClassReader.isAnnotationPresent(methods[i], AgentKilled.class, cl)) {
                    this.checkMethodReturnType(AgentKilled.class, methods[i], cl);
                    micromodel.setAgentMethod(AgentKilled.class, new MethodInfo(methods[i]));
                }
                if (MicroClassReader.isAnnotationPresent(methods[i], AgentBreakpoint.class, cl)) {
                    micromodel.setAgentMethod(AgentBreakpoint.class, new MethodInfo(methods[i]));
                }
                if (MicroClassReader.isAnnotationPresent(methods[i], AgentStreamArrived.class, cl)) {
                    this.checkMethodReturnType(AgentStreamArrived.class, methods[i], cl);
                    micromodel.setAgentMethod(AgentStreamArrived.class, new MethodInfo(methods[i]));
                }
                if (!MicroClassReader.isAnnotationPresent(methods[i], AgentMessageArrived.class, cl)) continue;
                this.checkMethodReturnType(AgentMessageArrived.class, methods[i], cl);
                micromodel.setAgentMethod(AgentMessageArrived.class, new MethodInfo(methods[i]));
            }
        }
        Set imp = (Set)toset.get("imports");
        if (imp != null) {
            modelinfo.setImports(imp.toArray(new String[imp.size()]));
        }
        Map props = (Map)toset.get("properties");
        List bps = (List)toset.get("breakpoints");
        if (bps != null) {
            modelinfo.setBreakpoints(bps.toArray(new String[bps.size()]));
        }
        if (props != null) {
            modelinfo.setProperties(props);
        }
        if ((nfprops = (List)toset.get("nfproperties")) != null) {
            modelinfo.setNFProperties(nfprops);
        }
        if ((rsers = (Map)toset.get("reqservices")) != null) {
            modelinfo.setRequiredServices(rsers.values().toArray(new RequiredServiceInfo[rsers.size()]));
        }
        if ((psers = (Map)toset.get("proservices")) != null) {
            modelinfo.setProvidedServices(psers.values().toArray(new ProvidedServiceInfo[psers.size()]));
        }
        if ((argus = (Map)toset.get("arguments")) != null) {
            modelinfo.setArguments(argus.values().toArray(new IArgument[argus.size()]));
        }
        if ((res = (Map)toset.get("results")) != null) {
            modelinfo.setResults(res.values().toArray(new IArgument[res.size()]));
        }
        if ((cts = (Map)toset.get("componenttypes")) != null) {
            modelinfo.setSubcomponentTypes(cts.values().toArray(new SubcomponentTypeInfo[cts.size()]));
        }
        if ((cfs = (Map)toset.get("configurations")) != null) {
            modelinfo.setConfigurations(cfs.values().toArray(new ConfigurationInfo[cfs.size()]));
        }
        if ((feats = (Map)toset.get("features")) != null) {
            HashMap<Class, IComponentFeatureFactory> fs = new HashMap<Class, IComponentFeatureFactory>();
            IComponentFeatureFactory[] stdfeats = modelinfo.getFeatures();
            if (addfeat) {
                for (IComponentFeatureFactory feat : stdfeats) {
                    fs.put(feat.getType(), feat);
                }
            }
            for (IComponentFeatureFactory feat : feats.values()) {
                fs.put(feat.getType(), feat);
            }
            Collection collection = SComponentFactory.orderComponentFeatures((String)SReflect.getUnqualifiedClassName(this.getClass()), Arrays.asList(fs.values()));
            modelinfo.setFeatures(collection.toArray(new IComponentFeatureFactory[collection.size()]));
        }
        if (MicroClassReader.isAnnotationPresent(clazz, Agent.class, cl) && this.getAnnotation(clazz, Agent.class, cl).autoprovide() && !serifaces.isEmpty()) {
            ProvidedServiceInfo[] psis = modelinfo.getProvidedServices();
            for (ProvidedServiceInfo psi : psis) {
                String val = psi.getImplementation().getValue();
                if (psi.getImplementation().getClazz() == null && (val == null || val.length() == 0 || !val.equals("$pojoagent") && !val.equals("$pojoagent!=null? $pojoagent: $component"))) continue;
                Class tt = psi.getType().getType(cl);
                serifaces.remove(tt);
            }
            for (Class clazz3 : serifaces) {
                ProvidedServiceImplementation impl = new ProvidedServiceImplementation(null, "$pojoagent!=null? $pojoagent: $component", "decoupled", null, null);
                ProvidedServiceInfo psi = new ProvidedServiceInfo(null, clazz3, impl, null, null, null);
                modelinfo.addProvidedService(psi);
            }
        }
    }

    protected void checkMethodReturnType(Class<? extends Annotation> ann, Method m, ClassLoader cl) {
        boolean isfuture;
        boolean isvoid = m.getReturnType().equals(Void.TYPE);
        boolean bl = isfuture = !isvoid && SReflect.isSupertype(MicroClassReader.getClass(IFuture.class, cl), m.getReturnType());
        if (isfuture) {
            Type t = m.getGenericReturnType();
            boolean bl2 = isvoid = !(t instanceof ParameterizedType);
            if (!isvoid) {
                ParameterizedType p = (ParameterizedType)t;
                Type[] ts = p.getActualTypeArguments();
                boolean bl3 = isvoid = ts.length == 1 && ts[0].equals(Void.class);
            }
        }
        if (!isvoid) {
            throw new RuntimeException("@" + ann.getSimpleName() + " method requires return type 'void' or 'IFuture<Void>': " + m);
        }
    }

    protected Object evaluateExpression(String exp, String[] imports, IValueFetcher fetcher, ClassLoader classloader) {
        return exp.length() == 0 ? null : SJavaParser.evaluateExpression((String)exp, (String[])imports, null, (ClassLoader)classloader);
    }

    protected ProvidedServiceImplementation createImplementation(Implementation impl) {
        return new ProvidedServiceImplementation(!impl.value().equals(Object.class) ? impl.value() : null, impl.expression().length() > 0 ? impl.expression() : null, impl.proxytype(), this.createBinding(impl.binding()), this.createUnparsedExpressions(impl.interceptors()));
    }

    protected RequiredServiceBinding createBinding(Binding bd) {
        return bd == null || "null-binding".equals(bd.name()) ? null : new RequiredServiceBinding(bd.name(), bd.componentname().length() == 0 ? null : bd.componentname(), bd.componenttype().length() == 0 ? null : bd.componenttype(), bd.dynamic(), bd.scope(), bd.create(), bd.recover(), this.createUnparsedExpressions(bd.interceptors()), bd.proxytype(), bd.creationinfo().type().length() > 0 ? this.createComponentInstanceInfo(bd.creationinfo()) : null);
    }

    protected List<NFRPropertyInfo> createNFRProperties(NFRProperty[] nfrp) {
        ArrayList<NFRPropertyInfo> nfprops = new ArrayList<NFRPropertyInfo>();
        for (NFRProperty prop : nfrp) {
            nfprops.add(new NFRPropertyInfo(prop.name(), new ClassInfo(prop.value().getName()), new MethodInfo(prop.methodname(), prop.methodparametertypes())));
        }
        return nfprops;
    }

    protected ComponentInstanceInfo createComponentInstanceInfo(Component comp) {
        Binding[] binds;
        NameValue[] args;
        ComponentInstanceInfo ret = new ComponentInstanceInfo();
        ret.setSuspend(comp.suspend().toBoolean());
        ret.setMaster(comp.master().toBoolean());
        ret.setDaemon(comp.daemon().toBoolean());
        ret.setAutoShutdown(comp.autoshutdown().toBoolean());
        ret.setSynchronous(comp.synchronous().toBoolean());
        ret.setPersistable(comp.persistable().toBoolean());
        if (comp.name().length() > 0) {
            ret.setName(comp.name());
        }
        if (comp.type().length() > 0) {
            ret.setTypeName(comp.type());
        }
        if (comp.configuration().length() > 0) {
            ret.setConfiguration(comp.configuration());
        }
        if (comp.number().length() > 0) {
            ret.setNumber(comp.number());
        }
        if ((args = comp.arguments()).length > 0) {
            UnparsedExpression[] exps = this.createUnparsedExpressions(args);
            ret.setArguments(exps);
        }
        if ((binds = comp.bindings()).length > 0) {
            RequiredServiceBinding[] bds = new RequiredServiceBinding[binds.length];
            for (int k = 0; k < binds.length; ++k) {
                bds[k] = this.createBinding(binds[k]);
            }
            ret.setBindings(bds);
        }
        return ret;
    }

    protected ComponentInstanceInfo createComponentInstanceInfo(CreationInfo comp) {
        NameValue[] args;
        ComponentInstanceInfo ret = new ComponentInstanceInfo();
        ret.setSuspend(comp.suspend().toBoolean());
        ret.setMaster(comp.master().toBoolean());
        ret.setDaemon(comp.daemon().toBoolean());
        ret.setAutoShutdown(comp.autoshutdown().toBoolean());
        ret.setSynchronous(comp.synchronous().toBoolean());
        ret.setPersistable(comp.persistable().toBoolean());
        ret.setMonitoring(comp.monitoring());
        if (comp.name().length() > 0) {
            ret.setName(comp.name());
        }
        if (comp.type().length() > 0) {
            ret.setTypeName(comp.type());
        }
        if (comp.configuration().length() > 0) {
            ret.setConfiguration(comp.configuration());
        }
        if (comp.number().length() > 0) {
            ret.setNumber(comp.number());
        }
        if ((args = comp.arguments()).length > 0) {
            UnparsedExpression[] exps = this.createUnparsedExpressions(args);
            ret.setArguments(exps);
        }
        return ret;
    }

    protected UnparsedExpression[] createUnparsedExpressions(Value[] values) {
        UnparsedExpression[] ret = null;
        if (values.length > 0) {
            ret = new UnparsedExpression[values.length];
            for (int i = 0; i < values.length; ++i) {
                ret[i] = new UnparsedExpression(null, values[i].clazz().getName(), values[i].value(), null);
            }
        }
        return ret;
    }

    protected UnparsedExpression[] createUnparsedExpressions(NameValue[] values) {
        UnparsedExpression[] ret = null;
        if (values.length > 0) {
            ret = new UnparsedExpression[values.length];
            for (int i = 0; i < values.length; ++i) {
                String val = values[i].value();
                String clname = values[i].clazz().getName();
                ret[i] = new UnparsedExpression(values[i].name(), clname, (val == null || val.length() == 0) && clname != null ? clname + ".class" : val, null);
            }
        }
        return ret;
    }

    protected List<UnparsedExpression> createUnparsedExpressionsList(NameValue[] values) {
        ArrayList<UnparsedExpression> ret = null;
        if (values.length > 0) {
            ret = new ArrayList<UnparsedExpression>();
            for (int i = 0; i < values.length; ++i) {
                String val = values[i].value();
                String clname = values[i].clazz().getName();
                String v = (val == null || val.length() == 0) && clname != null ? clname + ".class" : val;
                ret.add(new UnparsedExpression(values[i].name(), (String)null, v, null));
            }
        }
        return ret;
    }

    protected Class getMicroAgentClass(String clname, String[] imports, ClassLoader classloader) {
        int idx;
        String oclname = clname;
        Class ret = SReflect.findClass0((String)clname, (String[])imports, (ClassLoader)classloader);
        while (ret == null && (idx = clname.indexOf(46)) != -1) {
            clname = clname.substring(idx + 1);
            try {
                ret = SReflect.findClass0((String)clname, (String[])imports, (ClassLoader)classloader);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (ret == null) {
            throw new RuntimeException("Micro agent class not found: " + oclname + ", " + SUtil.arrayToString((Object)imports) + ", " + classloader);
        }
        boolean found = false;
        for (Class cma = ret; !found && cma != null; cma = cma.getSuperclass()) {
            found = MicroClassReader.isAnnotationPresent(cma, Agent.class, classloader);
        }
        if (!found) {
            throw new RuntimeException("Not a Micro agent class: " + clname);
        }
        return ret;
    }

    public static boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> anclazz, ClassLoader cl) {
        return clazz.isAnnotationPresent(MicroClassReader.getClass(anclazz, cl));
    }

    public static boolean isAnnotationPresent(Field f, Class<? extends Annotation> anclazz, ClassLoader cl) {
        return f.isAnnotationPresent(MicroClassReader.getClass(anclazz, cl));
    }

    public static boolean isAnnotationPresent(Method m, Class<? extends Annotation> anclazz, ClassLoader cl) {
        return m.isAnnotationPresent(MicroClassReader.getClass(anclazz, cl));
    }

    public static boolean isAnnotationPresent(Constructor<?> con, Class<? extends Annotation> anclazz, ClassLoader cl) {
        return con.isAnnotationPresent(MicroClassReader.getClass(anclazz, cl));
    }

    public <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> anclazz, ClassLoader cl) {
        ClassLoader cl2 = cl instanceof DummyClassLoader ? ((DummyClassLoader)cl).getOriginal() : cl;
        return (T)this.getProxyAnnotation((T)clazz.getAnnotation(MicroClassReader.getClass(anclazz, cl)), cl2);
    }

    public <T extends Annotation> T getAnnotation(Field f, Class<T> anclazz, ClassLoader cl) {
        ClassLoader cl2 = cl instanceof DummyClassLoader ? ((DummyClassLoader)cl).getOriginal() : cl;
        return (T)this.getProxyAnnotation((T)f.getAnnotation(MicroClassReader.getClass(anclazz, cl)), cl2);
    }

    public <T extends Annotation> T getAnnotation(Method m, Class<T> anclazz, ClassLoader cl) {
        ClassLoader cl2 = cl instanceof DummyClassLoader ? ((DummyClassLoader)cl).getOriginal() : cl;
        return (T)this.getProxyAnnotation((T)m.getAnnotation(MicroClassReader.getClass(anclazz, cl)), cl2);
    }

    public <T extends Annotation> T getAnnotation(Constructor<?> c, Class<T> anclazz, ClassLoader cl) {
        ClassLoader cl2 = cl instanceof DummyClassLoader ? ((DummyClassLoader)cl).getOriginal() : cl;
        return (T)this.getProxyAnnotation((T)c.getAnnotation(MicroClassReader.getClass(anclazz, cl)), cl2);
    }

    public Annotation[][] getParameterAnnotations(Method m, ClassLoader cl) {
        Annotation[][] ret = null;
        ClassLoader cl2 = cl instanceof DummyClassLoader ? ((DummyClassLoader)cl).getOriginal() : cl;
        Annotation[][] annos = m.getParameterAnnotations();
        if (annos.length > 0 && annos[0].length > 0) {
            ret = new Annotation[annos.length][annos[0].length];
            for (int i = 0; i < annos.length; ++i) {
                for (int j = 0; j < annos[0].length; ++j) {
                    ret[i][j] = this.getProxyAnnotation(annos[i][j], cl2);
                }
            }
        }
        return ret;
    }

    public Annotation[][] getParameterAnnotations(Constructor c, ClassLoader cl) {
        Annotation[][] ret = null;
        ClassLoader cl2 = cl instanceof DummyClassLoader ? ((DummyClassLoader)cl).getOriginal() : cl;
        Annotation[][] annos = c.getParameterAnnotations();
        if (annos.length > 0 && annos[0].length > 0) {
            ret = new Annotation[annos.length][annos[0].length];
            for (int i = 0; i < annos.length; ++i) {
                for (int j = 0; j < annos[0].length; ++j) {
                    ret[i][j] = this.getProxyAnnotation(annos[i][j], cl2);
                }
            }
        }
        return ret;
    }

    public <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> anclazz, ClassLoader cl1, ClassLoader cl2) {
        return (T)this.getProxyAnnotation((T)clazz.getAnnotation(MicroClassReader.getClass(anclazz, cl1)), cl2);
    }

    public static Class<?> getClass(Class<?> clazz, ClassLoader cl) {
        Class<?> ret = clazz;
        try {
            if (!clazz.getClassLoader().equals(cl)) {
                ret = cl.loadClass(clazz.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return ret;
    }

    public static Class<?>[] getClassArray(Class<?>[] clazzes, ClassLoader cl) {
        Class[] ret = new Class[clazzes.length];
        for (int i = 0; i < clazzes.length; ++i) {
            ret[i] = MicroClassReader.getClass(clazzes[i], cl);
        }
        return ret;
    }

    public <T extends Annotation> T getProxyAnnotation(final T an, final ClassLoader cl) {
        Annotation ret = null;
        if (MicroClassReader.isClassLoaderCompatible(an.getClass(), cl)) {
            ret = an;
        } else {
            try {
                Class<?>[] in = an.getClass().getInterfaces();
                Class[] nin = new Class[in.length];
                for (int i = 0; i < in.length; ++i) {
                    nin[i] = MicroClassReader.getClass(in[i], cl);
                }
                ret = (Annotation)Proxy.newProxyInstance(cl, nin, new InvocationHandler(){

                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        Object[] nargs = args == null ? new Object[]{} : args;
                        Class<?>[] cls = method.getParameterTypes();
                        Method m = an.getClass().getMethod(method.getName(), MicroClassReader.getClassArray(method.getParameterTypes(), cl));
                        Object ret = m.invoke((Object)an, nargs);
                        if (ret != null && !MicroClassReader.isClassLoaderCompatible(ret.getClass(), cl)) {
                            if (ret instanceof Annotation) {
                                ret = MicroClassReader.this.getProxyAnnotation((Annotation)ret, cl);
                            } else if (ret.getClass().isArray() && ret.getClass().getComponentType().isAnnotation()) {
                                int len = Array.getLength(ret);
                                Class<?> arclazz = MicroClassReader.getClass(ret.getClass().getComponentType(), cl);
                                Object nret = Array.newInstance(arclazz, len);
                                for (int i = 0; i < len; ++i) {
                                    Array.set(nret, i, MicroClassReader.this.getProxyAnnotation((Annotation)Array.get(ret, i), cl));
                                }
                                ret = nret;
                            } else if (ret.getClass().isEnum()) {
                                ret = Enum.valueOf(SReflect.classForName((String)ret.getClass().getName(), (ClassLoader)cl), ret.toString());
                            }
                        }
                        return ret;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return (T)ret;
    }

    protected static boolean isClassLoaderCompatible(Class<?> clazz, ClassLoader cl) {
        boolean ret;
        ClassLoader clcl = clazz.getClassLoader();
        boolean bl = ret = clcl == null || clcl.equals(cl);
        if (!ret) {
            for (ClassLoader tst = cl.getParent(); tst != null && !ret; tst = tst.getParent()) {
                ret = clcl.equals(tst);
            }
            if (!ret) {
                try {
                    Method m = cl.getClass().getMethod("isClassLoaderCompatible", Class.class);
                    ret = (Boolean)m.invoke((Object)cl, clazz);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ret;
    }

    public static class DummyClassLoader
    extends URLClassLoader {
        protected ClassLoader orig;

        public DummyClassLoader(URL[] urls, ClassLoader parent, ClassLoader orig) {
            super(urls, parent);
            this.orig = orig;
        }

        public ClassLoader getOriginal() {
            return this.orig;
        }

        public void setOriginal(ClassLoader orig) {
            this.orig = orig;
        }

        public String toString() {
            String ret = super.toString();
            for (ClassLoader pa = this.getParent(); pa != null; pa = pa.getParent()) {
                ret = ret + " " + pa.toString();
            }
            return ret;
        }
    }
}

