/*
 * Decompiled with CFR 0.152.
 */
package jadex.micro;

import jadex.bridge.BasicComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.IResourceIdentifier;
import jadex.bridge.component.IComponentFeatureFactory;
import jadex.bridge.modelinfo.IModelInfo;
import jadex.bridge.service.BasicService;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.factory.IComponentFactory;
import jadex.bridge.service.types.factory.SComponentFactory;
import jadex.bridge.service.types.library.ILibraryService;
import jadex.bridge.service.types.library.ILibraryServiceListener;
import jadex.commons.LazyResource;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.kernelbase.IBootstrapFactory;
import jadex.micro.MicroModel;
import jadex.micro.MicroModelLoader;
import jadex.micro.features.impl.MicroInjectionComponentFeature;
import jadex.micro.features.impl.MicroLifecycleComponentFeature;
import jadex.micro.features.impl.MicroMessageComponentFeature;
import jadex.micro.features.impl.MicroPojoComponentFeature;
import jadex.micro.features.impl.MicroServiceInjectionComponentFeature;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;

public class MicroAgentFactory
extends BasicService
implements IComponentFactory,
IBootstrapFactory {
    public static final String[] FILETYPES = new String[]{"Agent.class"};
    public static final String FILETYPE_MICROAGENT = "Micro Agent";
    protected static final LazyResource ICON = new LazyResource(MicroAgentFactory.class, "/jadex/micro/images/micro_agent.png");
    public static final Collection<IComponentFeatureFactory> MICRO_FEATURES = Collections.unmodifiableCollection(Arrays.asList(MicroPojoComponentFeature.FACTORY, MicroInjectionComponentFeature.FACTORY, MicroServiceInjectionComponentFeature.FACTORY, MicroLifecycleComponentFeature.FACTORY, MicroMessageComponentFeature.FACTORY));
    protected MicroModelLoader loader;
    protected IInternalAccess provider;
    protected Map<String, Object> fproperties;
    protected ILibraryServiceListener libservicelistener;
    protected Collection<IComponentFeatureFactory> features;

    public MicroAgentFactory(IInternalAccess provider, Map<String, Object> properties) {
        super(provider.getComponentIdentifier(), IComponentFactory.class, null);
        this.provider = provider;
        this.fproperties = properties;
        this.loader = new MicroModelLoader();
        this.libservicelistener = new ILibraryServiceListener(){

            public IFuture<Void> resourceIdentifierRemoved(IResourceIdentifier parid, IResourceIdentifier rid) {
                MicroAgentFactory.this.loader.clearModelCache();
                return IFuture.DONE;
            }

            public IFuture<Void> resourceIdentifierAdded(IResourceIdentifier parid, IResourceIdentifier rid, boolean rem) {
                MicroAgentFactory.this.loader.clearModelCache();
                return IFuture.DONE;
            }
        };
        ILibraryService ls = this.getLibraryService();
        if (ls != null) {
            ls.addLibraryServiceListener(this.libservicelistener);
        }
        this.features = SComponentFactory.orderComponentFeatures((String)SReflect.getUnqualifiedClassName(((Object)((Object)this)).getClass()), Arrays.asList(SComponentFactory.DEFAULT_FEATURES, MICRO_FEATURES));
    }

    public MicroAgentFactory(String providerid) {
        super((IComponentIdentifier)new BasicComponentIdentifier(providerid), IComponentFactory.class, null);
        this.loader = new MicroModelLoader();
        this.features = SComponentFactory.orderComponentFeatures((String)SReflect.getUnqualifiedClassName(((Object)((Object)this)).getClass()), Arrays.asList(SComponentFactory.DEFAULT_FEATURES, MICRO_FEATURES));
    }

    public IFuture<Void> startService(IInternalAccess component, IResourceIdentifier rid) {
        this.provider = component;
        this.providerid = this.provider.getComponentIdentifier();
        this.createServiceIdentifier("BootstrapFactory", IComponentFactory.class, rid, IComponentFactory.class, null);
        return this.startService();
    }

    public synchronized IFuture<Void> shutdownService() {
        final Future ret = new Future();
        if (this.libservicelistener != null) {
            this.getLibraryService().removeLibraryServiceListener(this.libservicelistener).addResultListener((IResultListener)new DelegationResultListener<Void>(ret){

                public void customResultAvailable(Void result) {
                    MicroAgentFactory.super.shutdownService().addResultListener((IResultListener)new DelegationResultListener(ret));
                }
            });
        }
        return ret;
    }

    public IFuture<IModelInfo> loadModel(final String model, final String[] imports, final IResourceIdentifier rid) {
        final Future ret = new Future();
        MicroModel cached = (MicroModel)this.loader.getCachedModel(model, "Agent.class", imports, rid);
        if (cached != null) {
            ret.setResult((Object)cached.getModelInfo());
        } else {
            ILibraryService libservice = this.getLibraryService();
            if (libservice != null) {
                libservice.getClassLoader(rid).addResultListener((IResultListener)new ExceptionDelegationResultListener<ClassLoader, IModelInfo>(ret){

                    public void customResultAvailable(ClassLoader cl) {
                        try {
                            IModelInfo mi = MicroAgentFactory.this.loader.loadComponentModel(model, imports, rid, cl, new Object[]{rid, MicroAgentFactory.this.getProviderId().getRoot(), MicroAgentFactory.this.features}).getModelInfo();
                            ret.setResult((Object)mi);
                        }
                        catch (Exception e) {
                            ret.setException(e);
                        }
                    }
                });
            } else {
                try {
                    ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
                    IModelInfo mi = this.loader.loadComponentModel(model, imports, rid, cl, new Object[]{rid, this.getProviderId().getRoot(), this.features}).getModelInfo();
                    ret.setResult((Object)mi);
                }
                catch (Exception e) {
                    ret.setException(e);
                }
            }
        }
        return ret;
    }

    public IFuture<Boolean> isLoadable(String model, String[] imports, IResourceIdentifier rid) {
        boolean ret = model.toLowerCase().endsWith("agent.class");
        return ret ? IFuture.TRUE : IFuture.FALSE;
    }

    public IFuture<Boolean> isStartable(String model, String[] imports, final IResourceIdentifier rid) {
        IFuture ret;
        if (((Boolean)this.isLoadable(model, imports, rid).get()).booleanValue()) {
            final Future fut = new Future();
            ret = fut;
            this.loadModel(model, imports, rid).addResultListener((IResultListener)new IResultListener<IModelInfo>(){

                public void resultAvailable(final IModelInfo mi) {
                    ILibraryService libservice = MicroAgentFactory.this.getLibraryService();
                    if (libservice != null) {
                        libservice.getClassLoader(rid).addResultListener((IResultListener)new ExceptionDelegationResultListener<ClassLoader, Boolean>(fut){

                            public void customResultAvailable(ClassLoader cl) {
                                try {
                                    Class<?> clazz = MicroAgentFactory.this.getMicroAgentClass(mi.getFullName() + "Agent", null, cl);
                                    fut.setResult((Object)(!Modifier.isInterface(clazz.getModifiers()) && !Modifier.isAbstract(clazz.getModifiers()) ? 1 : 0));
                                }
                                catch (Exception e) {
                                    fut.setResult((Object)Boolean.FALSE);
                                }
                            }
                        });
                    } else {
                        try {
                            ClassLoader cl = this.getClass().getClassLoader();
                            Class<?> clazz = MicroAgentFactory.this.getMicroAgentClass(mi.getFullName() + "Agent", null, cl);
                            fut.setResult((Object)(!Modifier.isAbstract(clazz.getModifiers()) ? 1 : 0));
                        }
                        catch (Exception e) {
                            fut.setResult((Object)Boolean.FALSE);
                        }
                    }
                }

                public void exceptionOccurred(Exception exception) {
                    Logger.getLogger(MicroAgentFactory.class.toString()).warning(exception.toString());
                    fut.setResult((Object)Boolean.FALSE);
                }
            });
        } else {
            ret = IFuture.FALSE;
        }
        return ret;
    }

    public String[] getComponentTypes() {
        return new String[]{FILETYPE_MICROAGENT};
    }

    public IFuture<byte[]> getComponentTypeIcon(String type) {
        Future ret = new Future();
        if (type.equals(FILETYPE_MICROAGENT)) {
            try {
                ret.setResult((Object)ICON.getData());
            }
            catch (IOException e) {
                e.printStackTrace();
                ret.setException((Exception)e);
            }
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    public IFuture<String> getComponentType(String model, String[] imports, IResourceIdentifier rid) {
        return new Future((Object)(model.toLowerCase().endsWith("agent.class") ? FILETYPE_MICROAGENT : null));
    }

    public IFuture<Collection<IComponentFeatureFactory>> getComponentFeatures(IModelInfo model) {
        return new Future((Object)(model.getFeatures().length == 0 ? this.features : SUtil.arrayToList((Object)model.getFeatures())));
    }

    public Map<String, Object> getProperties(String type) {
        return FILETYPE_MICROAGENT.equals(type) ? this.fproperties : null;
    }

    protected Class<?> getMicroAgentClass(String clname, String[] imports, ClassLoader classloader) {
        int idx;
        Class ret = SReflect.findClass0((String)clname, (String[])imports, (ClassLoader)classloader);
        while (ret == null && (idx = clname.indexOf(46)) != -1) {
            clname = clname.substring(idx + 1);
            ret = SReflect.findClass0((String)clname, (String[])imports, (ClassLoader)classloader);
        }
        if (ret == null) {
            throw new RuntimeException("No micro agent file: " + clname);
        }
        return ret;
    }

    protected ILibraryService getLibraryService() {
        return this.internalaccess == null ? null : (ILibraryService)SServiceProvider.getLocalService((IInternalAccess)this.internalaccess, ILibraryService.class, (String)"platform");
    }
}

