/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.agr;

import jadex.application.IExtensionInstance;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IMonitoringComponentFeature;
import jadex.bridge.service.types.cms.IComponentDescription;
import jadex.bridge.service.types.monitoring.IMonitoringEvent;
import jadex.bridge.service.types.monitoring.IMonitoringService;
import jadex.commons.IFilter;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFutureCommandResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.extension.agr.Group;
import jadex.extension.agr.MAGRSpaceInstance;
import jadex.extension.agr.MGroupInstance;
import jadex.extension.agr.MPosition;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AGRSpace
implements IExtensionInstance {
    protected Map<String, Group> groups;
    protected IExternalAccess exta;
    protected MAGRSpaceInstance config;

    public AGRSpace(IExternalAccess exta, MAGRSpaceInstance config) {
        this.exta = exta;
        this.config = config;
    }

    public synchronized void addGroup(Group group) {
        if (this.groups == null) {
            this.groups = new HashMap<String, Group>();
        }
        this.groups.put(group.getName(), group);
    }

    public synchronized Group getGroup(String name) {
        return this.groups != null ? this.groups.get(name) : null;
    }

    public synchronized void componentAdded(IComponentDescription desc) {
        if (this.groups != null) {
            for (Group group : this.groups.values()) {
                String type = desc.getLocalType();
                String[] roles = group.getRolesForType(type);
                for (int r = 0; roles != null && r < roles.length; ++r) {
                    group.assignRole(desc.getName(), roles[r]);
                }
            }
        }
    }

    public synchronized void componentRemoved(IComponentDescription cid) {
    }

    public IFuture<Void> init() {
        final Future ret = new Future();
        try {
            MGroupInstance[] mgroups = this.config.getMGroupInstances();
            for (int g = 0; g < mgroups.length; ++g) {
                Group group = new Group(mgroups[g].getName());
                this.addGroup(group);
                MPosition[] positions = mgroups[g].getMPositions();
                for (int p = 0; positions != null && p < positions.length; ++p) {
                    String at = positions[p].getComponentType();
                    String rt = positions[p].getRoleType();
                    group.addRoleForType(at, rt);
                }
            }
            this.exta.scheduleStep((IComponentStep)new IComponentStep<Void>(){

                public IFuture<Void> execute(IInternalAccess ia) {
                    ISubscriptionIntermediateFuture sub = ((IMonitoringComponentFeature)ia.getComponentFeature(IMonitoringComponentFeature.class)).subscribeToEvents((IFilter)new IFilter<IMonitoringEvent>(){

                        public boolean filter(IMonitoringEvent obj) {
                            return obj.getType().endsWith("Component") || obj.getType().equals("created.subscription");
                        }
                    }, false, IMonitoringService.PublishEventLevel.COARSE);
                    sub.addResultListener((IResultListener)new IIntermediateFutureCommandResultListener<IMonitoringEvent>(){

                        public void resultAvailable(Collection<IMonitoringEvent> result) {
                        }

                        public void intermediateResultAvailable(IMonitoringEvent result) {
                            if (result.getType().equals("created.subscription")) {
                                ret.setResult(null);
                            } else if (result.getType().startsWith("created")) {
                                AGRSpace.this.componentAdded((IComponentDescription)result.getProperty("details"));
                            } else if (result.getType().startsWith("disposed")) {
                                AGRSpace.this.componentRemoved((IComponentDescription)result.getProperty("details"));
                            }
                        }

                        public void finished() {
                        }

                        public void exceptionOccurred(Exception e) {
                            e.printStackTrace();
                        }

                        public void commandAvailable(Object command) {
                        }
                    });
                    return IFuture.DONE;
                }
            });
        }
        catch (Exception e) {
            ret.setException(e);
        }
        return ret;
    }

    public IFuture<Void> terminate() {
        return IFuture.DONE;
    }
}

