/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.agr;

import jadex.bridge.IComponentIdentifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Group {
    protected String name;
    protected Map positions;
    protected Map roles;

    public Group(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void addRoleForType(String typename, String rolename) {
        HashSet<String> set;
        if (this.roles == null) {
            this.roles = new HashMap();
        }
        if ((set = (HashSet<String>)this.roles.get(typename)) == null) {
            set = new HashSet<String>();
            this.roles.put(typename, set);
        }
        set.add(rolename);
    }

    public synchronized void removeRoleForType(String typename, String rolename) {
        Set set;
        if (this.roles != null && (set = (Set)this.roles.get(typename)) != null) {
            set.remove(rolename);
            if (set.isEmpty()) {
                this.roles.remove(typename);
                if (this.roles.isEmpty()) {
                    this.roles = null;
                }
            }
        }
    }

    public synchronized String[] getRolesForType(String typename) {
        Set ret = this.roles != null ? (Set)this.roles.get(typename) : null;
        return ret != null ? ret.toArray(new String[ret.size()]) : null;
    }

    public synchronized void assignRole(IComponentIdentifier aid, String rolename) {
        HashSet<IComponentIdentifier> rpos;
        if (this.positions == null) {
            this.positions = new HashMap();
        }
        if ((rpos = (HashSet<IComponentIdentifier>)this.positions.get(rolename)) == null) {
            rpos = new HashSet<IComponentIdentifier>();
            this.positions.put(rolename, rpos);
        }
        rpos.add(aid);
    }

    public synchronized void unassignRole(IComponentIdentifier aid, String rolename) {
        Set rpos;
        if (this.positions != null && (rpos = (Set)this.positions.get(rolename)) != null) {
            rpos.remove(aid);
            if (rpos.isEmpty()) {
                this.positions.remove(rolename);
                if (this.positions.isEmpty()) {
                    this.positions = null;
                }
            }
        }
    }

    public synchronized IComponentIdentifier[] getAgentsForRole(String rolename) {
        Set ret = this.positions != null ? (Set)this.positions.get(rolename) : null;
        return ret != null ? ret.toArray(new IComponentIdentifier[ret.size()]) : null;
    }
}

