/*
 * Decompiled with CFR 0.152.
 */
package jadex.kernelbase;

import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.IMultiKernelListener;
import jadex.bridge.IResourceIdentifier;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IComponentFeatureFactory;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.modelinfo.IModelInfo;
import jadex.bridge.service.IService;
import jadex.bridge.service.IServiceIdentifier;
import jadex.bridge.service.annotation.Excluded;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.ServiceComponent;
import jadex.bridge.service.annotation.ServiceIdentifier;
import jadex.bridge.service.annotation.ServiceShutdown;
import jadex.bridge.service.annotation.ServiceStart;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.search.ServiceNotFoundException;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.bridge.service.types.factory.IComponentFactory;
import jadex.bridge.service.types.factory.IMultiKernelNotifierService;
import jadex.bridge.service.types.library.ILibraryService;
import jadex.bridge.service.types.library.ILibraryServiceListener;
import jadex.commons.IFilter;
import jadex.commons.IResultCommand;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.collection.MultiCollection;
import jadex.commons.future.CallMultiplexer;
import jadex.commons.future.CollectionResultListener;
import jadex.commons.future.CounterResultListener;
import jadex.commons.future.DefaultResultListener;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITerminableIntermediateFuture;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@Service
public class MultiFactory
implements IComponentFactory,
IMultiKernelNotifierService {
    protected static final String KERNEL_EXTENSIONS = "kernel.types";
    @ServiceComponent
    protected IInternalAccess ia;
    protected MultiCollection<String, String> kerneldefaultlocations;
    protected Map<String, IComponentFactory> factorycache = new HashMap<String, IComponentFactory>();
    protected MultiCollection<String, String> kernellocationcache = new MultiCollection();
    protected MultiCollection<URI, String> kerneluris = new MultiCollection();
    protected Set<URI> potentialuris = new LinkedHashSet<URI>();
    protected Set<URI> validuris = new HashSet<URI>();
    protected Set<String> activatedkernels;
    protected boolean activekernelsdirty = true;
    protected Set<String> componenttypes;
    protected Map<String, byte[]> iconcache;
    protected Set<String> baseextensionblacklist;
    protected Set<String> kernelblacklist;
    protected Set<String> potentialkernellocations;
    protected CallMultiplexer multiplexer = new CallMultiplexer();
    protected List<IMultiKernelListener> listeners;
    @ServiceIdentifier(value=IComponentFactory.class)
    protected IServiceIdentifier sid;
    protected boolean started;
    protected ILibraryServiceListener liblistener;
    protected ILibraryService libservice;
    public static final String MULTIFACTORY = "multifactory";
    public static final Map<String, Object> props = SUtil.createHashMap((Object[])new String[]{"multifactory"}, (Object[])new Object[]{Boolean.TRUE});

    public MultiFactory(String[] defaultLocations, String[] kernelblacklist, String[] extensionblacklist) {
        this.baseextensionblacklist = new HashSet<String>();
        this.kerneldefaultlocations = new MultiCollection();
        if (defaultLocations != null) {
            for (int i = 0; i < defaultLocations.length; ++i) {
                this.kerneldefaultlocations.add(null, (Object)defaultLocations[i]);
            }
        }
        this.activatedkernels = new HashSet<String>();
        this.componenttypes = new HashSet<String>();
        this.iconcache = new HashMap<String, byte[]>();
        this.kernelblacklist = new HashSet<String>();
        if (kernelblacklist != null) {
            this.kernelblacklist.addAll(Arrays.asList(kernelblacklist));
        }
        this.potentialkernellocations = new HashSet<String>();
        this.listeners = new ArrayList<IMultiKernelListener>();
        this.started = false;
    }

    @ServiceStart
    public IFuture<Void> startService() {
        if (this.started) {
            return IFuture.DONE;
        }
        String[] blarray = (String[])((IArgumentsResultsFeature)this.ia.getComponentFeature(IArgumentsResultsFeature.class)).getArguments().get("ignoreextensions");
        if (blarray != null) {
            this.baseextensionblacklist.addAll(Arrays.asList(blarray));
        }
        final Future ret = new Future(){

            public void setResult(Object result) {
                MultiFactory.this.started = true;
                super.setResult(result);
            }
        };
        this.libservice = (ILibraryService)SServiceProvider.getLocalService((IInternalAccess)this.ia, ILibraryService.class, (String)"platform");
        final IExternalAccess exta = this.ia.getExternalAccess();
        this.liblistener = new ILibraryServiceListener(){

            public IFuture resourceIdentifierRemoved(IResourceIdentifier parid, final IResourceIdentifier rid) {
                exta.scheduleStep((IComponentStep)new IComponentStep<Void>(){

                    public IFuture<Void> execute(IInternalAccess ia) {
                        URI uri = rid.getLocalIdentifier().getUri();
                        Collection affectedkernels = MultiFactory.this.kerneluris.remove((Object)uri);
                        if (affectedkernels != null) {
                            String[] keys = MultiFactory.this.kernellocationcache.keySet().toArray(new String[0]);
                            for (int i = 0; i < keys.length; ++i) {
                                Iterator it = affectedkernels.iterator();
                                while (it.hasNext()) {
                                    MultiFactory.this.kernellocationcache.removeObject((Object)keys[i], it.next());
                                }
                            }
                        }
                        MultiFactory.this.potentialuris.remove(uri);
                        MultiFactory.this.validuris.remove(uri);
                        return IFuture.DONE;
                    }
                });
                return IFuture.DONE;
            }

            public IFuture resourceIdentifierAdded(IResourceIdentifier parid, IResourceIdentifier rid, boolean rem) {
                final URI uri = rid.getLocalIdentifier().getUri();
                String regex = (String)((IArgumentsResultsFeature)MultiFactory.this.ia.getComponentFeature(IArgumentsResultsFeature.class)).getArguments().get("kerneluriregex");
                if (Pattern.matches(regex != null ? regex : "", uri.toString())) {
                    exta.scheduleStep((IComponentStep)new IComponentStep<Void>(){

                        public IFuture<Void> execute(IInternalAccess ia) {
                            MultiFactory.this.validuris.add(uri);
                            MultiFactory.this.potentialuris.add(uri);
                            return IFuture.DONE;
                        }
                    });
                }
                return IFuture.DONE;
            }
        };
        this.libservice.addLibraryServiceListener(this.liblistener);
        for (ClassLoader basecl = MultiFactory.class.getClassLoader(); basecl != null; basecl = basecl.getParent()) {
            URL[] urls;
            if (!(basecl instanceof URLClassLoader)) continue;
            for (URL url : urls = ((URLClassLoader)basecl).getURLs()) {
                if (url.toString().contains("jre/lib/ext")) continue;
                try {
                    URI uri = url.toURI();
                    this.potentialuris.add(uri);
                    this.validuris.add(uri);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        this.libservice.getAllURLs().addResultListener(((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

            public void customResultAvailable(Object result) {
                String regexstr = (String)((IArgumentsResultsFeature)MultiFactory.this.ia.getComponentFeature(IArgumentsResultsFeature.class)).getArguments().get("kerneluriregex");
                Pattern regex = Pattern.compile(regexstr != null ? regexstr : "");
                if (result != null) {
                    for (URL url : (Collection)result) {
                        try {
                            URI uri = url.toURI();
                            if (!regex.matcher(uri.toString()).matches()) continue;
                            MultiFactory.this.potentialuris.add(uri);
                            MultiFactory.this.validuris.add(uri);
                        }
                        catch (URISyntaxException uri) {}
                    }
                }
                if (MultiFactory.this.kerneldefaultlocations.isEmpty()) {
                    ret.setResult(null);
                } else {
                    String[] dl = MultiFactory.this.kerneldefaultlocations.get(null) == null ? new String[]{} : MultiFactory.this.kerneldefaultlocations.get(null).toArray(new String[MultiFactory.this.kerneldefaultlocations.size()]);
                    MultiFactory.this.kerneldefaultlocations.clear();
                    IResultListener loccounter = ((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new CounterResultListener(dl.length, ((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

                        public void customResultAvailable(Object result) {
                            ret.setResult(null);
                        }
                    })){

                        public void intermediateResultAvailable(Object result) {
                            final IModelInfo kernel = (IModelInfo)result;
                            MultiFactory.this.libservice.getClassLoader(kernel.getResourceIdentifier()).addResultListener((IResultListener)new IResultListener<ClassLoader>(){

                                public void resultAvailable(ClassLoader result) {
                                    String[] exts = (String[])kernel.getProperty(MultiFactory.KERNEL_EXTENSIONS, result);
                                    if (exts != null) {
                                        for (int i = 0; i < exts.length; ++i) {
                                            MultiFactory.this.kerneldefaultlocations.add((Object)exts[i], (Object)kernel.getFilename());
                                        }
                                    }
                                }

                                public void exceptionOccurred(Exception exception) {
                                }
                            });
                        }
                    });
                    for (int i = 0; i < dl.length; ++i) {
                        MultiFactory.this.loadModel(dl[i], null, null).addResultListener(loccounter);
                    }
                }
            }
        }));
        return ret;
    }

    @ServiceShutdown
    public IFuture<Void> shutdownService() {
        final Future ret = new Future();
        ((IRequiredServicesFeature)this.ia.getComponentFeature(IRequiredServicesFeature.class)).searchService(ILibraryService.class, "platform").addResultListener((IResultListener)new ExceptionDelegationResultListener<ILibraryService, Void>(ret){

            public void customResultAvailable(ILibraryService ls) {
                ls.removeLibraryServiceListener(MultiFactory.this.liblistener).addResultListener((IResultListener)new DelegationResultListener(ret));
            }
        });
        return ret;
    }

    public IFuture<IModelInfo> loadModel(String model, String[] imports, IResourceIdentifier rid) {
        return this.loadModel(model, imports, rid, false);
    }

    public IFuture<IModelInfo> loadModel(final String model, final String[] imports, final IResourceIdentifier rid, boolean isrecur) {
        final Future ret = new Future();
        this.findKernel(model, imports, rid, isrecur).addResultListener(((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                if (result != null) {
                    ((IComponentFactory)result).loadModel(model, imports, rid).addResultListener(((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
                } else {
                    ret.setException((Exception)new RuntimeException("Factory not found: " + model));
                }
            }

            public void exceptionOccurred(Exception exception) {
                ret.setException(exception);
            }
        }));
        return ret;
    }

    public IFuture<Boolean> isLoadable(String model, String[] imports, IResourceIdentifier rid) {
        final Future ret = new Future();
        this.findKernel(model, imports, rid).addResultListener(((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                if (result != null) {
                    ret.setResult((Object)true);
                } else {
                    ret.setResult((Object)false);
                }
            }

            public void exceptionOccurred(Exception exception) {
                ret.setResult((Object)false);
            }
        }));
        return ret;
    }

    public IFuture<Boolean> isStartable(final String model, final String[] imports, final IResourceIdentifier rid) {
        final Future ret = new Future();
        this.findKernel(model, imports, rid).addResultListener(((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                if (result != null) {
                    ((IComponentFactory)result).isStartable(model, imports, rid).addResultListener(((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
                } else {
                    ret.setResult((Object)false);
                }
            }

            public void exceptionOccurred(Exception exception) {
                ret.setResult((Object)false);
            }
        }));
        return ret;
    }

    public IFuture<String> getComponentType(final String model, final String[] imports, final IResourceIdentifier rid) {
        final Future ret = new Future();
        this.findKernel(model, imports, rid).addResultListener(((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                if (result != null) {
                    ((IComponentFactory)result).getComponentType(model, imports, rid).addResultListener(((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
                } else {
                    ret.setException((Exception)new ServiceNotFoundException("Factory not found: " + model));
                }
            }

            public void exceptionOccurred(Exception exception) {
                ret.setException(exception);
            }
        }));
        return ret;
    }

    public IFuture<byte[]> getComponentTypeIcon(String type) {
        ITerminableIntermediateFuture ffut;
        Collection facs;
        byte[] icon = this.iconcache.get(type);
        if (icon == null && (facs = (Collection)(ffut = SServiceProvider.getServices((IInternalAccess)this.ia, IComponentFactory.class, (String)"application")).get()) != null) {
            for (IComponentFactory fac : facs) {
                if (((IService)fac).getServiceIdentifier().equals(this.sid) || (icon = (byte[])fac.getComponentTypeIcon(type).get()) == null) continue;
                this.iconcache.put(type, icon);
                break;
            }
        }
        return new Future((Object)icon);
    }

    public String[] getComponentTypes() {
        return this.componenttypes.toArray(new String[this.componenttypes.size()]);
    }

    public Map getProperties(String type) {
        return props;
    }

    @Excluded
    public IFuture<Collection<IComponentFeatureFactory>> getComponentFeatures(final IModelInfo model) {
        IComponentFactory fac = (IComponentFactory)this.getCacheResultForModel(model.getFilename(), this.factorycache);
        if (fac != null) {
            return fac.getComponentFeatures(model);
        }
        final Future res = new Future();
        this.findKernel(model.getFilename(), null, model.getResourceIdentifier()).addResultListener(((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(res){

            public void customResultAvailable(IComponentFactory result) {
                result.getComponentFeatures(model).addResultListener((IResultListener)new DelegationResultListener(res));
            }
        }));
        return res;
    }

    public IFuture addKernelListener(IMultiKernelListener listener) {
        this.listeners.add(listener);
        return IFuture.DONE;
    }

    public IFuture removeKernelListener(IMultiKernelListener listener) {
        this.listeners.remove(listener);
        return IFuture.DONE;
    }

    public IFuture fireTypesAdded(String[] types) {
        Future ret = new Future();
        IMultiKernelListener[] ls = this.listeners.toArray(new IMultiKernelListener[this.listeners.size()]);
        IResultListener counter = ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new CounterResultListener(ls.length, true, ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret))));
        for (int i = 0; i < ls.length; ++i) {
            ls[i].componentTypesAdded(types).addResultListener(counter);
        }
        return ret;
    }

    public IFuture fireTypesRemoved(String[] types) {
        Future ret = new Future();
        IMultiKernelListener[] ls = this.listeners.toArray(new IMultiKernelListener[this.listeners.size()]);
        IResultListener counter = ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new CounterResultListener(ls.length, true, ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret))));
        for (int i = 0; i < ls.length; ++i) {
            ls[i].componentTypesAdded(types).addResultListener(counter);
        }
        return ret;
    }

    protected IFuture<IComponentFactory> findKernel(String model, String[] imports, IResourceIdentifier rid) {
        return this.findKernel(model, imports, rid, false);
    }

    protected IFuture findKernel(final String model, final String[] imports, final IResourceIdentifier rid, final boolean isrecur) {
        if (this.isInExtensionBlacklist(model, this.baseextensionblacklist)) {
            return IFuture.DONE;
        }
        IComponentFactory fac = (IComponentFactory)this.getCacheResultForModel(model, this.factorycache);
        if (fac != null) {
            return new Future((Object)fac);
        }
        final Future ret = new Future();
        this.findActiveKernel(model, imports, rid).addResultListener(((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener(new IResultListener(){

            public void resultAvailable(Object result) {
                if (result != null) {
                    ret.setResult(result);
                } else {
                    MultiFactory.this.findLoadableKernel(model, imports, rid, isrecur).addResultListener(((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

                        public void customResultAvailable(Object result) {
                            if (result != null) {
                                ret.setResult(result);
                            } else {
                                ret.setResult(null);
                            }
                        }
                    }));
                }
            }

            public void exceptionOccurred(Exception exception) {
                this.resultAvailable(null);
            }
        }));
        return ret;
    }

    protected IFuture findActiveKernel(final String model, final String[] imports, final IResourceIdentifier rid) {
        final Future ret = new Future();
        SServiceProvider.getServices((IInternalAccess)this.ia, IComponentFactory.class, (String)"application").addResultListener(((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

            public void exceptionOccurred(Exception exception) {
                super.exceptionOccurred(exception);
            }

            public void customResultAvailable(Object result) {
                Collection factories = (Collection)result;
                final IResultListener factorypicker = ((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new CollectionResultListener(factories.size(), true, ((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DefaultResultListener(){

                    public void resultAvailable(Object result) {
                        Collection viablefactories = (Collection)result;
                        if (!viablefactories.isEmpty()) {
                            ret.setResult(viablefactories.iterator().next());
                        } else {
                            ret.setResult(null);
                        }
                    }
                })));
                for (final IComponentFactory factory : factories) {
                    if (((IService)factory).getServiceIdentifier().equals(MultiFactory.this.sid)) {
                        factorypicker.exceptionOccurred((Exception)new RuntimeException());
                        continue;
                    }
                    factory.isLoadable(model, imports, rid).addResultListener(((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener(new IResultListener(){

                        public void resultAvailable(Object result) {
                            if (Boolean.TRUE.equals(result)) {
                                factorypicker.resultAvailable((Object)factory);
                            } else {
                                factorypicker.exceptionOccurred((Exception)new RuntimeException());
                            }
                        }

                        public void exceptionOccurred(Exception exception) {
                            exception.printStackTrace();
                            factorypicker.exceptionOccurred(exception);
                        }
                    }));
                }
            }
        }));
        return ret;
    }

    protected IFuture findLoadableKernel(String model, String[] imports, IResourceIdentifier rid, boolean isrecur) {
        String dl = (String)this.getCacheResultForModel(model, (Map)this.kerneldefaultlocations);
        IFuture ret = dl != null ? this.startLoadableKernel(model, imports, rid, dl) : this.findKernelInCache(model, imports, rid, isrecur);
        return ret;
    }

    protected IFuture findKernelInCache(final String model, final String[] imports, final IResourceIdentifier rid, final boolean isrecur) {
        final Future ret = new Future();
        Tuple2<String, Object> cachedkernels = this.getCacheKeyValueForModel(model, (Map<String, Object>)this.kernellocationcache);
        final String kernelsext = cachedkernels != null ? (String)cachedkernels.getFirstEntity() : null;
        Collection kernels = cachedkernels != null ? (Collection)cachedkernels.getSecondEntity() : null;
        String cachedresult = null;
        if (kernels != null && !kernels.isEmpty()) {
            cachedresult = (String)kernels.iterator().next();
        }
        if (cachedresult != null) {
            final String kernelmodel = cachedresult;
            this.startLoadableKernel(model, imports, rid, kernelmodel).addResultListener(((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

                public void exceptionOccurred(Exception exception) {
                    MultiFactory.this.kernellocationcache.removeObject(kernelsext, (Object)kernelmodel);
                    MultiFactory.this.findKernelInCache(model, imports, rid, isrecur).addResultListener(((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
                }
            }));
        } else if (this.potentialuris.isEmpty() && !this.hasLoadablePotentialKernels() || isrecur) {
            ret.setResult(null);
        } else {
            this.multiplexer.doCall(new IResultCommand(){

                public Object execute(Object args) {
                    return MultiFactory.this.searchPotentialUrls(rid);
                }
            }).addResultListener(((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

                public void customResultAvailable(Object result) {
                    MultiFactory.this.findKernelInCache(model, imports, rid, isrecur).addResultListener(((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
                }
            }));
        }
        return ret;
    }

    protected boolean hasLoadablePotentialKernels() {
        String loc;
        boolean ret = false;
        Iterator<String> iterator = this.potentialkernellocations.iterator();
        while (iterator.hasNext() && !(ret = this.getCacheKeyValueForModel(loc = iterator.next(), (Map<String, Object>)this.kernellocationcache) != null)) {
        }
        return ret;
    }

    protected IFuture startLoadableKernel(final String model, final String[] imports, final IResourceIdentifier rid, final String kernelmodel) {
        return this.multiplexer.doCall((Object)kernelmodel, new IResultCommand(){

            public Object execute(Object args) {
                final Future ret = new Future();
                MultiFactory.this.findActiveKernel(kernelmodel, null, rid).addResultListener(((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

                    public void customResultAvailable(Object result) {
                        IComponentFactory fac = (IComponentFactory)result;
                        fac.loadModel(kernelmodel, null, rid).addResultListener(((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

                            public void customResultAvailable(Object result) {
                                final IModelInfo info = (IModelInfo)result;
                                SServiceProvider.getService((IInternalAccess)MultiFactory.this.ia, IComponentManagementService.class, (String)"platform").addResultListener(((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

                                    public void exceptionOccurred(Exception exception) {
                                        super.exceptionOccurred(exception);
                                    }

                                    public void customResultAvailable(Object result) {
                                        final IComponentManagementService cms = (IComponentManagementService)result;
                                        final CreationInfo ci = new CreationInfo(MultiFactory.this.ia.getComponentIdentifier());
                                        String name = info.getName().toLowerCase();
                                        if (name.startsWith("kernel")) {
                                            name = name.substring(6);
                                        }
                                        final String fname = "kernel_" + name;
                                        MultiFactory.this.libservice.getClassLoader(info.getResourceIdentifier()).addResultListener((IResultListener)new DelegationResultListener<ClassLoader>(ret){

                                            public void customResultAvailable(ClassLoader result) {
                                                final String[] kexts = (String[])info.getProperty(MultiFactory.KERNEL_EXTENSIONS, result) == null ? new String[]{} : (String[])info.getProperty(MultiFactory.KERNEL_EXTENSIONS, result);
                                                cms.createComponent(fname, kernelmodel, ci, ((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener(new IResultListener(){

                                                    public void resultAvailable(Object result) {
                                                        MultiFactory.this.activekernelsdirty = true;
                                                        for (int i = 0; i < kexts.length; ++i) {
                                                            MultiFactory.this.factorycache.remove(kexts[i]);
                                                        }
                                                    }

                                                    public void exceptionOccurred(Exception exception) {
                                                        this.resultAvailable(null);
                                                    }
                                                })).addResultListener(((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener(new IResultListener(){

                                                    public void resultAvailable(Object result) {
                                                        MultiFactory.this.findActiveKernel(model, imports, rid).addResultListener(((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DefaultResultListener(){

                                                            public void resultAvailable(Object result) {
                                                                final IComponentFactory kernel = (IComponentFactory)result;
                                                                if (kernel == null) {
                                                                    ret.setResult(null);
                                                                    return;
                                                                }
                                                                for (int i = 0; i < kexts.length; ++i) {
                                                                    MultiFactory.this.factorycache.put(kexts[i], kernel);
                                                                }
                                                                if (!MultiFactory.this.activatedkernels.contains(kernelmodel)) {
                                                                    final String[] types = kernel.getComponentTypes();
                                                                    MultiFactory.this.componenttypes.addAll(Arrays.asList(types));
                                                                    MultiFactory.this.activatedkernels.add(kernelmodel);
                                                                    if (SReflect.HAS_GUI) {
                                                                        final IResultListener typecounter = ((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new CounterResultListener(types.length, true, ((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

                                                                            public void customResultAvailable(Object result) {
                                                                                SServiceProvider.getService((IInternalAccess)MultiFactory.this.ia, IMultiKernelNotifierService.class, (String)"application").addResultListener(((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

                                                                                    public void customResultAvailable(Object result) {
                                                                                        MultiFactory.this.fireTypesAdded(types).addResultListener(((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

                                                                                            public void customResultAvailable(Object result) {
                                                                                                ret.setResult((Object)kernel);
                                                                                            }
                                                                                        }));
                                                                                    }
                                                                                }));
                                                                            }
                                                                        })));
                                                                        for (int i = 0; i < types.length; ++i) {
                                                                            final int fi = i;
                                                                            kernel.getComponentTypeIcon(types[i]).addResultListener((IResultListener)new IResultListener<byte[]>(){

                                                                                public void resultAvailable(byte[] result) {
                                                                                    MultiFactory.this.iconcache.put(types[fi], result);
                                                                                    typecounter.resultAvailable(null);
                                                                                }

                                                                                public void exceptionOccurred(Exception exception) {
                                                                                    typecounter.exceptionOccurred(exception);
                                                                                }
                                                                            });
                                                                        }
                                                                    } else {
                                                                        ret.setResult((Object)kernel);
                                                                    }
                                                                } else {
                                                                    ret.setResult((Object)kernel);
                                                                }
                                                            }
                                                        }));
                                                    }

                                                    public void exceptionOccurred(Exception exception) {
                                                        ret.setException(exception);
                                                    }
                                                }));
                                            }
                                        });
                                    }
                                }));
                            }
                        }));
                    }
                }));
                return ret;
            }
        });
    }

    protected IFuture searchPotentialUrls(final IResourceIdentifier rid) {
        final Future ret = new Future();
        final IResultListener reslis = ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret){

            public void customResultAvailable(Object result) {
                Map kernellocs = (Map)result;
                if (kernellocs != null && !kernellocs.isEmpty()) {
                    MultiFactory.this.kernellocationcache.addAll(kernellocs);
                    MultiFactory.this.activekernelsdirty = true;
                    ret.setResult(null);
                } else {
                    final URI uri = MultiFactory.this.potentialuris.iterator().next();
                    MultiFactory.this.quickKernelSearch(uri, rid).addResultListener(((IExecutionFeature)MultiFactory.this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<Map<String, String>>(){

                        public void resultAvailable(Map<String, String> kernelmap) {
                            if (kernelmap != null && MultiFactory.this.validuris.contains(uri)) {
                                MultiFactory.this.kernellocationcache.addAll(kernelmap);
                                MultiFactory.this.activekernelsdirty = true;
                                Iterator<String> it = kernelmap.values().iterator();
                                while (it.hasNext()) {
                                    MultiFactory.this.kerneluris.add((Object)uri, (Object)it.next());
                                }
                            }
                            MultiFactory.this.potentialuris.remove(uri);
                            ret.setResult(null);
                        }

                        public void exceptionOccurred(Exception exception) {
                            MultiFactory.this.potentialuris.remove(uri);
                            this.resultAvailable(null);
                        }
                    }));
                }
            }
        });
        this.ia.getExternalAccess().scheduleStep((IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                if (MultiFactory.this.activekernelsdirty) {
                    MultiFactory.this.activekernelsdirty = false;
                    MultiFactory.this.examineKernelModels(new ArrayList<String>(MultiFactory.this.potentialkernellocations), rid).addResultListener(reslis);
                } else {
                    reslis.resultAvailable(null);
                }
                return IFuture.DONE;
            }
        });
        return ret;
    }

    protected IFuture<Map<String, String>> quickKernelSearch(URI uri, IResourceIdentifier rid) {
        return this.kernelSearch(uri, new IFilter(){

            public boolean filter(Object obj) {
                String loc = (String)obj;
                return loc.substring(loc.lastIndexOf("/") + 1).toLowerCase().startsWith("kernel");
            }
        }, rid);
    }

    protected IFuture<Map<String, String>> kernelSearch(URI uri, final IFilter prefilter, IResourceIdentifier rid) {
        List<String> modellocs = this.searchUri(uri, new IFilter(){

            public boolean filter(Object obj) {
                if (obj instanceof String) {
                    String blstr;
                    String loc = (String)obj;
                    Iterator<String> iterator = MultiFactory.this.baseextensionblacklist.iterator();
                    while (iterator.hasNext()) {
                        String oblstr;
                        blstr = oblstr = iterator.next();
                        if (!loc.toLowerCase().endsWith(blstr)) continue;
                        return false;
                    }
                    for (String oblstr : MultiFactory.this.kernelblacklist) {
                        blstr = oblstr;
                        if (!loc.endsWith(blstr)) continue;
                        return false;
                    }
                    if (!MultiFactory.this.isInExtensionBlacklist(obj, MultiFactory.this.baseextensionblacklist) && !MultiFactory.this.kernelblacklist.contains(loc.substring(loc.lastIndexOf(File.separatorChar) + 1)) && prefilter.filter(obj)) {
                        return true;
                    }
                }
                return false;
            }
        });
        return this.examineKernelModels(modellocs, rid);
    }

    protected IFuture<Map<String, String>> examineKernelModels(List<String> modellocs, IResourceIdentifier rid) {
        final HashMap kernellocs = new HashMap();
        if (modellocs.isEmpty()) {
            return new Future(kernellocs);
        }
        Future ret = new Future();
        final IResultListener kernelCounter = ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new CounterResultListener(modellocs.size(), true, (IResultListener)new DelegationResultListener(ret){

            public void customResultAvailable(Object result) {
                super.customResultAvailable((Object)kernellocs);
            }

            public void exceptionOccurred(Exception e) {
                super.exceptionOccurred(e);
            }
        }));
        for (final String kernelloc : modellocs) {
            this.loadModel(kernelloc, null, rid, true).addResultListener(((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<IModelInfo>(){

                public void resultAvailable(final IModelInfo modelinfo) {
                    if (modelinfo != null) {
                        MultiFactory.this.potentialkernellocations.remove(kernelloc);
                        MultiFactory.this.libservice.getClassLoader(modelinfo.getResourceIdentifier()).addResultListener((IResultListener)new IResultListener<ClassLoader>(){

                            public void resultAvailable(ClassLoader result) {
                                String[] exts = (String[])modelinfo.getProperty(MultiFactory.KERNEL_EXTENSIONS, result);
                                if (exts != null) {
                                    for (int i = 0; i < exts.length; ++i) {
                                        kernellocs.put(exts[i], modelinfo.getFilename());
                                    }
                                }
                                kernelCounter.resultAvailable((Object)result);
                            }

                            public void exceptionOccurred(Exception exception) {
                                MultiFactory.this.potentialkernellocations.add(kernelloc);
                                kernelCounter.exceptionOccurred((Exception)new RuntimeException());
                            }
                        });
                    } else {
                        MultiFactory.this.potentialkernellocations.add(kernelloc);
                        kernelCounter.exceptionOccurred((Exception)new RuntimeException());
                    }
                }

                public void exceptionOccurred(Exception exception) {
                    this.resultAvailable(null);
                }
            }));
        }
        return ret;
    }

    protected List<String> searchUri(URI uri, IFilter filter) {
        try {
            File file = new File(uri);
            if (file.isDirectory()) {
                return this.searchDirectory(file, filter, false);
            }
            if (file.getName().endsWith(".jar")) {
                return this.searchJar(file, filter);
            }
            if (file.getName().endsWith(".apk")) {
                return this.searchApk(file, filter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.EMPTY_LIST;
    }

    protected List<String> searchDirectory(File dir, IFilter filter, boolean prependDir) {
        ArrayList<String> ret = new ArrayList<String>();
        File[] content = dir.listFiles();
        for (int i = 0; i < content.length; ++i) {
            if (content[i].isDirectory()) {
                List<String> subList = this.searchDirectory(content[i], filter, true);
                Iterator<String> it = subList.iterator();
                while (it.hasNext()) {
                    if (prependDir) {
                        ret.add(dir.getName().concat(File.separator).concat(it.next()));
                        continue;
                    }
                    ret.add(it.next());
                }
                continue;
            }
            if (!filter.filter((Object)content[i].getName())) continue;
            if (prependDir) {
                ret.add(dir.getName().concat(File.separator).concat(content[i].getName()));
                continue;
            }
            ret.add(content[i].getName());
        }
        return ret;
    }

    protected List<String> searchJar(File jar, IFilter filter) {
        ArrayList<String> ret = new ArrayList<String>();
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!filter.filter((Object)entry.getName())) continue;
                ret.add(entry.getName());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ret;
    }

    protected List<String> searchApk(File apk, IFilter filter) {
        ArrayList<String> ret = new ArrayList<String>();
        try {
            ZipFile zip = new ZipFile(apk);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String entry = entries.nextElement().getName();
                if (!filter.filter((Object)entry)) continue;
                ret.add(entry);
            }
            Enumeration dexentries = SUtil.androidUtils().getDexEntries(apk);
            while (dexentries.hasMoreElements()) {
                String entry = (String)dexentries.nextElement();
                if (!filter.filter((Object)(entry = entry.replace('.', '/') + ".class"))) continue;
                ret.add(entry);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    protected boolean isInExtensionBlacklist(Object model, Set blacklist) {
        return false;
    }

    protected Object getCacheResultForModel(String model, Map map) {
        Tuple2<String, Object> ret = this.getCacheKeyValueForModel(model, map);
        return ret != null ? ret.getSecondEntity() : null;
    }

    protected Tuple2<String, Object> getCacheKeyValueForModel(String model, Map<String, Object> map) {
        Tuple2 ret = null;
        if (model != null && map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String ext = entry.getKey();
                if (!model.endsWith(ext)) continue;
                ret = new Tuple2((Object)entry.getKey(), entry.getValue());
                break;
            }
        }
        return ret;
    }

    public int hashCode() {
        return this.sid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IService) {
            return this.sid.equals(((IService)obj).getServiceIdentifier());
        }
        return false;
    }
}

