/*
 * Decompiled with CFR 0.152.
 */
package jadex.kernelbase;

import jadex.base.Starter;
import jadex.bridge.ComponentPersistedException;
import jadex.bridge.ComponentTerminatedException;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.ImmediateComponentStep;
import jadex.bridge.component.IArgumentsResultsFeature;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.component.IMonitoringComponentFeature;
import jadex.bridge.component.ISubcomponentsFeature;
import jadex.bridge.modelinfo.ComponentInstanceInfo;
import jadex.bridge.modelinfo.IModelInfo;
import jadex.bridge.nonfunctional.INFProperty;
import jadex.bridge.nonfunctional.INFPropertyMetaInfo;
import jadex.bridge.service.component.interceptors.FutureFunctionality;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.clock.IClockService;
import jadex.bridge.service.types.clock.ITimedObject;
import jadex.bridge.service.types.monitoring.IMonitoringEvent;
import jadex.bridge.service.types.monitoring.IMonitoringService;
import jadex.commons.IFilter;
import jadex.commons.SReflect;
import jadex.commons.Tuple2;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.ITerminableIntermediateFuture;
import jadex.commons.future.SubscriptionIntermediateDelegationFuture;
import jadex.commons.future.TerminableIntermediateDelegationFuture;
import jadex.commons.future.TerminableIntermediateDelegationResultListener;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;

public class ExternalAccess
implements IExternalAccess {
    protected boolean valid = true;
    protected boolean terminated;
    protected IComponentIdentifier cid;
    protected IInternalAccess ia;
    protected String tostring;
    protected IModelInfo model;
    protected Map<String, Object> results;
    protected volatile Future<Map<String, Object>> killfut;

    public ExternalAccess(IInternalAccess ia) {
        this.ia = ia;
        this.cid = ia.getComponentIdentifier();
        this.tostring = this.cid.getLocalName();
    }

    public IModelInfo getModel() {
        if (this.terminated) {
            throw new ComponentTerminatedException(this.cid);
        }
        if (!this.valid) {
            return this.model;
        }
        return this.ia.getModel();
    }

    public IComponentIdentifier getComponentIdentifier() {
        return this.cid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture<Map<String, Object>> killComponent() {
        boolean kill = false;
        ExternalAccess externalAccess = this;
        synchronized (externalAccess) {
            if (this.killfut == null) {
                kill = true;
                this.killfut = new Future();
            }
        }
        if (kill) {
            if (!this.valid) {
                this.killfut.setException((Exception)(this.terminated ? new ComponentTerminatedException(this.cid) : new ComponentPersistedException(this.cid)));
            } else if (!((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).isComponentThread()) {
                try {
                    ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new IComponentStep<Void>(){

                        public IFuture<Void> execute(IInternalAccess ia) {
                            if (!ExternalAccess.this.valid) {
                                ExternalAccess.this.killfut.setException((Exception)(ExternalAccess.this.terminated ? new ComponentTerminatedException(ExternalAccess.this.cid) : new ComponentPersistedException(ExternalAccess.this.cid)));
                            } else {
                                ia.killComponent().addResultListener((IResultListener)new DelegationResultListener<Map<String, Object>>(ExternalAccess.this.killfut){

                                    public void customResultAvailable(Map<String, Object> result) {
                                        super.customResultAvailable(result);
                                    }

                                    public void exceptionOccurred(Exception exception) {
                                        super.exceptionOccurred(exception);
                                    }
                                });
                            }
                            return IFuture.DONE;
                        }
                    });
                }
                catch (Exception e) {
                    Starter.scheduleRescueStep((IComponentIdentifier)this.cid, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ExternalAccess.this.killfut.setException(e);
                        }
                    });
                }
            } else {
                this.ia.killComponent().addResultListener((IResultListener)new DelegationResultListener(this.killfut));
            }
        }
        return this.killfut;
    }

    public IFuture<IComponentIdentifier[]> getChildren(final String type) {
        final Future ret = new Future();
        if (!this.valid) {
            ret.setException((Exception)(this.terminated ? new ComponentTerminatedException(this.cid) : new ComponentPersistedException(this.cid)));
        } else if (this.isExternalThread()) {
            try {
                ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new IComponentStep<Void>(){

                    public IFuture<Void> execute(IInternalAccess ia) {
                        ia.getChildren(type).addResultListener((IResultListener)new DelegationResultListener(ret));
                        return IFuture.DONE;
                    }
                });
            }
            catch (Exception e) {
                Starter.scheduleRescueStep((IComponentIdentifier)this.cid, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ret.setException(e);
                    }
                });
            }
        } else {
            this.ia.getChildren(type).addResultListener((IResultListener)new DelegationResultListener(ret));
        }
        return ret;
    }

    public IFuture<IComponentIdentifier> createChild(final ComponentInstanceInfo component) {
        final Future ret = new Future();
        if (!this.valid) {
            ret.setException((Exception)(this.terminated ? new ComponentTerminatedException(this.cid) : new ComponentPersistedException(this.cid)));
        } else if (this.isExternalThread()) {
            try {
                ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new IComponentStep<Void>(){

                    public IFuture<Void> execute(IInternalAccess ia) {
                        ((ISubcomponentsFeature)ia.getComponentFeature(ISubcomponentsFeature.class)).createChild(component).addResultListener((IResultListener)new DelegationResultListener(ret));
                        return IFuture.DONE;
                    }
                });
            }
            catch (Exception e) {
                Starter.scheduleRescueStep((IComponentIdentifier)this.cid, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ret.setException(e);
                    }
                });
            }
        } else {
            ((ISubcomponentsFeature)this.ia.getComponentFeature(ISubcomponentsFeature.class)).createChild(component).addResultListener((IResultListener)new DelegationResultListener(ret));
        }
        return ret;
    }

    public IFuture<String> getFileName(final String ctype) {
        final Future ret = new Future();
        if (!this.valid) {
            ret.setException((Exception)(this.terminated ? new ComponentTerminatedException(this.cid) : new ComponentPersistedException(this.cid)));
        } else if (this.isExternalThread()) {
            try {
                ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new IComponentStep<Void>(){

                    public IFuture<Void> execute(IInternalAccess ia) {
                        String fn = ((ISubcomponentsFeature)ia.getComponentFeature(ISubcomponentsFeature.class)).getComponentFilename(ctype);
                        if (fn != null) {
                            ret.setResult((Object)fn);
                        } else {
                            ret.setException((Exception)new RuntimeException("Unknown component type: " + ctype));
                        }
                        return IFuture.DONE;
                    }
                });
            }
            catch (Exception e) {
                Starter.scheduleRescueStep((IComponentIdentifier)this.cid, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ret.setException(e);
                    }
                });
            }
        } else {
            String fn = ((ISubcomponentsFeature)this.ia.getComponentFeature(ISubcomponentsFeature.class)).getComponentFilename(ctype);
            if (fn != null) {
                ret.setResult((Object)fn);
            } else {
                ret.setException((Exception)new RuntimeException("Unknown component type: " + ctype));
            }
        }
        return ret;
    }

    public String getLocalType() {
        if (this.terminated) {
            throw new ComponentTerminatedException(this.cid);
        }
        return ((ISubcomponentsFeature)this.ia.getComponentFeature(ISubcomponentsFeature.class)).getLocalType();
    }

    public <T> IFuture<T> scheduleStep(IComponentStep<T> step) {
        Future ret;
        if (step == null) {
            throw new NullPointerException("No step. Maybe decoding error?");
        }
        Method m = SReflect.getMethod(step.getClass(), (String)"execute", (Class[])new Class[]{IInternalAccess.class});
        Future future = ret = m != null ? FutureFunctionality.getDelegationFuture(m.getReturnType(), (FutureFunctionality)new FutureFunctionality((Logger)null)) : new Future();
        if (!this.valid) {
            ret.setException((Exception)(this.terminated ? new ComponentTerminatedException(this.cid) : new ComponentPersistedException(this.cid)));
        } else {
            IFuture fut = ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).scheduleStep(step);
            FutureFunctionality.connectDelegationFuture((Future)ret, (IFuture)fut);
        }
        return ret;
    }

    public <T> IFuture<T> scheduleStep(int priority, IComponentStep<T> step) {
        Future ret;
        if (step == null) {
            throw new NullPointerException("No step. Maybe decoding error?");
        }
        Method m = SReflect.getMethod(step.getClass(), (String)"execute", (Class[])new Class[]{IInternalAccess.class});
        Future future = ret = m != null ? FutureFunctionality.getDelegationFuture(m.getReturnType(), (FutureFunctionality)new FutureFunctionality((Logger)null)) : new Future();
        if (!this.valid) {
            ret.setException((Exception)(this.terminated ? new ComponentTerminatedException(this.cid) : new ComponentPersistedException(this.cid)));
        } else {
            IFuture fut = ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).scheduleStep(priority, step);
            FutureFunctionality.connectDelegationFuture((Future)ret, (IFuture)fut);
        }
        return ret;
    }

    public <T> IFuture<T> scheduleStep(final IComponentStep<T> step, final long delay) {
        final Future ret = new Future();
        if (!this.valid) {
            ret.setException((Exception)(this.terminated ? new ComponentTerminatedException(this.cid) : new ComponentPersistedException(this.cid)));
        } else {
            SServiceProvider.getService((IInternalAccess)this.ia, IClockService.class, (String)"platform").addResultListener(this.createResultListener((IResultListener<T>)new ExceptionDelegationResultListener<IClockService, T>(ret){

                public void customResultAvailable(IClockService cs) {
                    cs.createTimer(delay, new ITimedObject(){

                        public void timeEventOccurred(long currenttime) {
                            ExternalAccess.this.scheduleStep(step).addResultListener((IResultListener)new DelegationResultListener(ret));
                        }
                    });
                }
            }));
        }
        return ret;
    }

    public <T> IFuture<T> scheduleStep(final int priority, final IComponentStep<T> step, final long delay) {
        final Future ret = new Future();
        if (!this.valid) {
            ret.setException((Exception)(this.terminated ? new ComponentTerminatedException(this.cid) : new ComponentPersistedException(this.cid)));
        } else {
            SServiceProvider.getService((IInternalAccess)this.ia, IClockService.class, (String)"platform").addResultListener(this.createResultListener((IResultListener<T>)new ExceptionDelegationResultListener<IClockService, T>(ret){

                public void customResultAvailable(IClockService cs) {
                    cs.createTimer(delay, new ITimedObject(){

                        public void timeEventOccurred(long currenttime) {
                            ExternalAccess.this.scheduleStep(step, priority).addResultListener((IResultListener)new DelegationResultListener(ret));
                        }
                    });
                }
            }));
        }
        return ret;
    }

    public ISubscriptionIntermediateFuture<IMonitoringEvent> subscribeToEvents(final IFilter<IMonitoringEvent> filter, final boolean initial, final IMonitoringService.PublishEventLevel elm) {
        final SubscriptionIntermediateDelegationFuture ret = new SubscriptionIntermediateDelegationFuture();
        if (!this.valid) {
            ret.setException((Exception)(this.terminated ? new ComponentTerminatedException(this.cid) : new ComponentPersistedException(this.cid)));
        } else if (this.isExternalThread()) {
            try {
                ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new ImmediateComponentStep<Void>(){

                    public IFuture<Void> execute(IInternalAccess ia) {
                        ISubscriptionIntermediateFuture fut = ((IMonitoringComponentFeature)ia.getComponentFeature(IMonitoringComponentFeature.class)).subscribeToEvents(filter, initial, elm);
                        TerminableIntermediateDelegationResultListener lis = new TerminableIntermediateDelegationResultListener((TerminableIntermediateDelegationFuture)ret, (ITerminableIntermediateFuture)fut);
                        fut.addResultListener((IResultListener)lis);
                        return IFuture.DONE;
                    }
                }).addResultListener((IResultListener)new ExceptionDelegationResultListener<Void, Collection<IMonitoringEvent>>((Future)ret){

                    public void customResultAvailable(Void result) {
                    }
                });
            }
            catch (Exception e) {
                Starter.scheduleRescueStep((IComponentIdentifier)this.cid, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ret.setException(e);
                    }
                });
            }
        } else {
            ISubscriptionIntermediateFuture fut = ((IMonitoringComponentFeature)this.ia.getComponentFeature(IMonitoringComponentFeature.class)).subscribeToEvents(filter, initial, elm);
            TerminableIntermediateDelegationResultListener lis = new TerminableIntermediateDelegationResultListener((TerminableIntermediateDelegationFuture)ret, (ITerminableIntermediateFuture)fut);
            fut.addResultListener((IResultListener)lis);
        }
        return ret;
    }

    public ISubscriptionIntermediateFuture<Tuple2<String, Object>> subscribeToResults() {
        final SubscriptionIntermediateDelegationFuture ret = new SubscriptionIntermediateDelegationFuture();
        if (!this.valid) {
            ret.setException((Exception)(this.terminated ? new ComponentTerminatedException(this.cid) : new ComponentPersistedException(this.cid)));
        } else if (this.isExternalThread()) {
            try {
                ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new IComponentStep<Void>(){

                    public IFuture<Void> execute(IInternalAccess ia) {
                        ISubscriptionIntermediateFuture fut = ((IArgumentsResultsFeature)ia.getComponentFeature(IArgumentsResultsFeature.class)).subscribeToResults();
                        TerminableIntermediateDelegationResultListener lis = new TerminableIntermediateDelegationResultListener((TerminableIntermediateDelegationFuture)ret, (ITerminableIntermediateFuture)fut);
                        fut.addResultListener((IResultListener)lis);
                        return IFuture.DONE;
                    }
                });
            }
            catch (Exception e) {
                Starter.scheduleRescueStep((IComponentIdentifier)this.cid, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ret.setException(e);
                    }
                });
            }
        } else {
            ISubscriptionIntermediateFuture fut = ((IArgumentsResultsFeature)this.ia.getComponentFeature(IArgumentsResultsFeature.class)).subscribeToResults();
            TerminableIntermediateDelegationResultListener lis = new TerminableIntermediateDelegationResultListener((TerminableIntermediateDelegationFuture)ret, (ITerminableIntermediateFuture)fut);
            fut.addResultListener((IResultListener)lis);
        }
        return ret;
    }

    public IFuture<Map<String, Object>> getArguments() {
        final Future ret = new Future();
        if (!this.valid) {
            ret.setException((Exception)(this.terminated ? new ComponentTerminatedException(this.cid) : new ComponentPersistedException(this.cid)));
        } else if (this.isExternalThread()) {
            try {
                ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new IComponentStep<Void>(){

                    public IFuture<Void> execute(IInternalAccess ia) {
                        ret.setResult((Object)((IArgumentsResultsFeature)ia.getComponentFeature(IArgumentsResultsFeature.class)).getArguments());
                        return IFuture.DONE;
                    }
                });
            }
            catch (Exception e) {
                Starter.scheduleRescueStep((IComponentIdentifier)this.cid, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ret.setException(e);
                    }
                });
            }
        } else {
            ret.setResult((Object)((IArgumentsResultsFeature)this.ia.getComponentFeature(IArgumentsResultsFeature.class)).getArguments());
        }
        return ret;
    }

    public IFuture<Map<String, Object>> getResults() {
        final Future ret = new Future();
        if (!this.valid) {
            ret.setResult(this.results);
        } else if (this.isExternalThread()) {
            try {
                ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new IComponentStep<Void>(){

                    public IFuture<Void> execute(IInternalAccess ia) {
                        ret.setResult((Object)((IArgumentsResultsFeature)ia.getComponentFeature(IArgumentsResultsFeature.class)).getResults());
                        return IFuture.DONE;
                    }
                });
            }
            catch (Exception e) {
                Starter.scheduleRescueStep((IComponentIdentifier)this.cid, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ret.setResult((Object)((IArgumentsResultsFeature)ExternalAccess.this.ia.getComponentFeature(IArgumentsResultsFeature.class)).getResults());
                    }
                });
            }
        } else {
            ret.setResult((Object)((IArgumentsResultsFeature)this.ia.getComponentFeature(IArgumentsResultsFeature.class)).getResults());
        }
        return ret;
    }

    public IFuture<Map<String, INFPropertyMetaInfo>> getNFPropertyMetaInfos() {
        Future ret = new Future();
        ret.setException((Exception)new UnsupportedOperationException());
        return ret;
    }

    public IFuture<String[]> getNFPropertyNames() {
        Future ret = new Future();
        ret.setException((Exception)new UnsupportedOperationException());
        return ret;
    }

    public IFuture<String[]> getNFAllPropertyNames() {
        Future ret = new Future();
        ret.setException((Exception)new UnsupportedOperationException());
        return ret;
    }

    public IFuture<INFPropertyMetaInfo> getNFPropertyMetaInfo(String name) {
        Future ret = new Future();
        ret.setException((Exception)new UnsupportedOperationException());
        return ret;
    }

    public <T> IFuture<T> getNFPropertyValue(String name) {
        Future ret = new Future();
        ret.setException((Exception)new UnsupportedOperationException());
        return ret;
    }

    public <T, U> IFuture<T> getNFPropertyValue(String name, U unit) {
        Future ret = new Future();
        ret.setException((Exception)new UnsupportedOperationException());
        return ret;
    }

    public IFuture<Void> addNFProperty(INFProperty<?, ?> nfprop) {
        return IFuture.DONE;
    }

    public IFuture<Void> removeNFProperty(String name) {
        return IFuture.DONE;
    }

    public IFuture<Void> shutdownNFPropertyProvider() {
        Future ret = new Future();
        return IFuture.DONE;
    }

    public boolean isExternalThread() {
        if (!this.valid) {
            throw this.terminated ? new ComponentTerminatedException(this.cid) : new ComponentPersistedException(this.cid);
        }
        return !((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).isComponentThread();
    }

    public boolean isValid() {
        return this.valid;
    }

    public <T> IResultListener<T> createResultListener(IResultListener<T> listener) {
        return ((IExecutionFeature)this.ia.getComponentFeature(IExecutionFeature.class)).createResultListener(listener);
    }

    public IInternalAccess getInternalAccess() {
        return this.ia;
    }

    public String toString() {
        return "ExternalAccess(comp=" + this.tostring + ")";
    }
}

