/*
 * Decompiled with CFR 0.152.
 */
package jadex.javaparser.javaccimpl;

import jadex.commons.IValueFetcher;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.javaparser.javaccimpl.ExpressionNode;
import jadex.javaparser.javaccimpl.ParseException;
import jadex.javaparser.javaccimpl.ParserImpl;

public class TypeNode
extends ExpressionNode {
    protected ClassLoader classloader;

    public TypeNode(ParserImpl p, int id) {
        super(p, id);
        this.setStaticType(Class.class);
        this.classloader = p.getClassLoader();
    }

    @Override
    public void appendText(String text) {
        super.appendText(text);
        if (text.equals("[]")) {
            this.precompile();
        }
    }

    @Override
    public void precompile() {
        String name = this.getText();
        Class clazz = SReflect.findClass0((String)this.getText(), (String[])this.imports, (ClassLoader)this.classloader);
        if (clazz == null) {
            throw new ParseException("Class not found: " + name);
        }
        this.setConstantValue(clazz);
        this.setConstant(true);
    }

    @Override
    public Object getValue(IValueFetcher fetcher) {
        if (this.getConstantValue() == null) {
            this.precompile();
        }
        return this.getConstantValue();
    }

    @Override
    public String toPlainString() {
        return this.getText();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && SUtil.equals((Object)this.getValue(null), (Object)((TypeNode)o).getValue(null));
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + (this.getValue(null) != null ? this.getValue(null).hashCode() : 1);
    }
}

