/*
 * Decompiled with CFR 0.152.
 */
package jadex.javaparser.javaccimpl;

import jadex.commons.IValueFetcher;
import jadex.commons.SReflect;
import jadex.javaparser.javaccimpl.ExpressionNode;
import jadex.javaparser.javaccimpl.ParseException;
import jadex.javaparser.javaccimpl.ParserImpl;
import java.io.Serializable;
import java.lang.constant.Constable;

public class MathNode
extends ExpressionNode {
    public static final int ADD = 1;
    public static final int SUBSTRACT = 2;
    public static final int MULTIPLY = 3;
    public static final int DIVIDE = 4;
    public static final int MODULO = 5;
    public static final int AND = 6;
    public static final int OR = 7;
    public static final int XOR = 8;
    public static final int NOT = 9;
    public static final int LSHIFT = 10;
    public static final int RSHIFT = 11;
    public static final int URSHIFT = 12;
    protected int op;

    public MathNode(ParserImpl p, int id) {
        super(p, id);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.op = MathNode.fromString(text);
    }

    @Override
    public void precompile() {
        if (this.jjtGetNumChildren() == 1) {
            this.precompileUnary();
        } else if (this.jjtGetNumChildren() == 2) {
            Class cright;
            switch (this.op) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                default: {
                    throw new ParseException("Unsupported binary operator: " + this);
                }
            }
            ExpressionNode left = (ExpressionNode)this.jjtGetChild(0);
            ExpressionNode right = (ExpressionNode)this.jjtGetChild(1);
            Class cleft = left.getStaticType() != null ? SReflect.getWrappedType(left.getStaticType()) : null;
            Class clazz = cright = right.getStaticType() != null ? SReflect.getWrappedType(right.getStaticType()) : null;
            if (cleft != null || cright != null) {
                if ((cleft == null || Number.class.isAssignableFrom(cleft)) && (cright == null || Number.class.isAssignableFrom(cright))) {
                    if (cleft != null && cright != null) {
                        if (cleft == Double.class || cright == Double.class) {
                            switch (this.op) {
                                case 6: 
                                case 7: 
                                case 8: 
                                case 10: 
                                case 11: 
                                case 12: {
                                    throw new ParseException("Operator " + MathNode.toString(this.op) + " cannot be applied to floats: " + this);
                                }
                            }
                            this.setStaticType(Double.class);
                        } else if (cleft == Float.class || cright == Float.class) {
                            switch (this.op) {
                                case 6: 
                                case 7: 
                                case 8: 
                                case 10: 
                                case 11: 
                                case 12: {
                                    throw new ParseException("Operator " + MathNode.toString(this.op) + " cannot be applied to floats: " + this);
                                }
                            }
                            this.setStaticType(Float.class);
                        } else if (cleft == Long.class || cright == Long.class) {
                            this.setStaticType(Long.class);
                        } else {
                            this.setStaticType(Integer.class);
                        }
                    }
                } else if (!(cleft != null && Boolean.class != cleft || cright != null && Boolean.class != cright)) {
                    if (cleft != null && cright != null) {
                        this.setStaticType(Boolean.class);
                    }
                } else if (!(cleft != null && Character.class != cleft || cright != null && Character.class != cright)) {
                    if (cleft != null && cright != null) {
                        this.setStaticType(Integer.class);
                    }
                } else if ((cleft == null || String.class == cleft) && this.op == 1) {
                    this.setStaticType(String.class);
                } else {
                    throw new ParseException("Incompatible types of subterms: " + this);
                }
            }
            if (left.isConstant() && right.isConstant()) {
                try {
                    this.setConstantValue(this.getValue(null));
                    this.setConstant(true);
                    if (this.getStaticType() == null && this.getConstantValue() != null) {
                        this.setStaticType(this.getConstantValue().getClass());
                    }
                }
                catch (Exception exception) {}
            }
        } else {
            throw new ParseException("Wrong number of subterms: " + this);
        }
    }

    @Override
    public Object getValue(IValueFetcher fetcher) {
        if (this.isConstant()) {
            return this.getConstantValue();
        }
        if (this.jjtGetNumChildren() == 1) {
            return this.getUnaryValue(fetcher);
        }
        Object left = ((ExpressionNode)this.jjtGetChild(0)).getValue(fetcher);
        Object right = ((ExpressionNode)this.jjtGetChild(1)).getValue(fetcher);
        if (left instanceof String && this.op == 1) {
            return (String)left + right;
        }
        if (left == null && right instanceof String && this.op == 1) {
            return (String)left + right;
        }
        boolean bool = false;
        if (left instanceof Boolean && right instanceof Boolean && (this.op == 6 || this.op == 7 || this.op == 8)) {
            left = (Boolean)left != false ? 1 : 0;
            right = (Boolean)right != false ? 1 : 0;
            bool = true;
        }
        if (left instanceof Character) {
            left = (int)((Character)left).charValue();
        }
        if (right instanceof Character) {
            right = (int)((Character)right).charValue();
        }
        if (!(left instanceof Number) && left != null) {
            throw new RuntimeException("Left hand side of expression not number: " + this);
        }
        if (!(right instanceof Number) && right != null) {
            throw new RuntimeException("Right hand side of expression not number: " + this);
        }
        Number numleft = left != null ? (Number)((Number)left) : (Number)0;
        Number numright = right != null ? (Number)((Number)right) : (Number)0;
        Constable value = null;
        if (numleft instanceof Double || numright instanceof Double) {
            switch (this.op) {
                case 1: {
                    value = numleft.doubleValue() + numright.doubleValue();
                    break;
                }
                case 2: {
                    value = numleft.doubleValue() - numright.doubleValue();
                    break;
                }
                case 3: {
                    value = numleft.doubleValue() * numright.doubleValue();
                    break;
                }
                case 4: {
                    value = numleft.doubleValue() / numright.doubleValue();
                    break;
                }
                case 5: {
                    value = numleft.doubleValue() % numright.doubleValue();
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    throw new RuntimeException("Operator " + MathNode.toString(this.op) + " cannot be applied to floats: " + this);
                }
            }
        } else if (numleft instanceof Float || numright instanceof Float) {
            switch (this.op) {
                case 1: {
                    value = Float.valueOf(numleft.floatValue() + numright.floatValue());
                    break;
                }
                case 2: {
                    value = Float.valueOf(numleft.floatValue() - numright.floatValue());
                    break;
                }
                case 3: {
                    value = Float.valueOf(numleft.floatValue() * numright.floatValue());
                    break;
                }
                case 4: {
                    value = Float.valueOf(numleft.floatValue() / numright.floatValue());
                    break;
                }
                case 5: {
                    value = Float.valueOf(numleft.floatValue() % numright.floatValue());
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: {
                    throw new RuntimeException("Operator " + MathNode.toString(this.op) + " cannot be applied to floats: " + this);
                }
            }
        } else if (numleft instanceof Long || numright instanceof Long) {
            switch (this.op) {
                case 1: {
                    value = numleft.longValue() + numright.longValue();
                    break;
                }
                case 2: {
                    value = numleft.longValue() - numright.longValue();
                    break;
                }
                case 3: {
                    value = numleft.longValue() * numright.longValue();
                    break;
                }
                case 4: {
                    value = numleft.longValue() / numright.longValue();
                    break;
                }
                case 5: {
                    value = numleft.longValue() % numright.longValue();
                    break;
                }
                case 6: {
                    value = numleft.longValue() & numright.longValue();
                    break;
                }
                case 7: {
                    value = numleft.longValue() | numright.longValue();
                    break;
                }
                case 8: {
                    value = numleft.longValue() ^ numright.longValue();
                    break;
                }
                case 10: {
                    value = numleft.longValue() << (int)numright.longValue();
                    break;
                }
                case 11: {
                    value = numleft.longValue() >> (int)numright.longValue();
                    break;
                }
                case 12: {
                    value = numleft.longValue() >>> (int)numright.longValue();
                }
            }
        } else {
            switch (this.op) {
                case 1: {
                    value = numleft.intValue() + numright.intValue();
                    break;
                }
                case 2: {
                    value = numleft.intValue() - numright.intValue();
                    break;
                }
                case 3: {
                    value = numleft.intValue() * numright.intValue();
                    break;
                }
                case 4: {
                    value = numleft.intValue() / numright.intValue();
                    break;
                }
                case 5: {
                    value = numleft.intValue() % numright.intValue();
                    break;
                }
                case 6: {
                    value = numleft.intValue() & numright.intValue();
                    break;
                }
                case 7: {
                    value = numleft.intValue() | numright.intValue();
                    break;
                }
                case 8: {
                    value = numleft.intValue() ^ numright.intValue();
                    break;
                }
                case 10: {
                    value = numleft.intValue() << numright.intValue();
                    break;
                }
                case 11: {
                    value = numleft.intValue() >> numright.intValue();
                    break;
                }
                case 12: {
                    value = numleft.intValue() >>> numright.intValue();
                }
            }
        }
        if (bool) {
            value = Boolean.valueOf(((Number)((Object)value)).intValue() == 1);
        }
        return value;
    }

    protected void precompileUnary() {
        switch (this.op) {
            case 1: 
            case 2: 
            case 9: {
                break;
            }
            default: {
                throw new ParseException("Unsupported unary operator: " + MathNode.toString(this.op));
            }
        }
        ExpressionNode child = (ExpressionNode)this.jjtGetChild(0);
        if (child.getStaticType() != null) {
            Class<Serializable> clazz = child.getStaticType();
            if (clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Float.class)) {
                if (this.op == 9) {
                    throw new ParseException("Operator ~ cannot be applied to floats: " + this);
                }
                this.setStaticType(child.getStaticType());
            } else if (clazz.isAssignableFrom(Long.class) || clazz.isAssignableFrom(Integer.class)) {
                this.setStaticType(child.getStaticType());
            } else if (clazz.isAssignableFrom(Short.class) || clazz.isAssignableFrom(Byte.class) || clazz.isAssignableFrom(Character.class)) {
                this.setStaticType(Integer.class);
            } else {
                throw new ParseException("Incompatible type of subterm: " + this);
            }
        }
        if (child.isConstant()) {
            try {
                this.setConstantValue(this.getValue(null));
                this.setConstant(true);
                if (this.getStaticType() == null && this.getConstantValue() != null) {
                    this.setStaticType(this.getConstantValue().getClass());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object getUnaryValue(IValueFetcher fetcher) {
        Object val = ((ExpressionNode)this.jjtGetChild(0)).getValue(fetcher);
        if (!(val instanceof Number)) {
            throw new RuntimeException("Left hand side of expression not number: " + this);
        }
        Number numval = (Number)val;
        Number value = null;
        switch (this.op) {
            case 1: {
                value = numval;
                break;
            }
            case 2: {
                if (numval instanceof Double) {
                    value = -numval.doubleValue();
                    break;
                }
                if (numval instanceof Float) {
                    value = Float.valueOf(-numval.floatValue());
                    break;
                }
                if (numval instanceof Long) {
                    value = -numval.longValue();
                    break;
                }
                value = -numval.intValue();
                break;
            }
            case 9: {
                if (val instanceof Double || val instanceof Float) {
                    throw new RuntimeException("Operator ~ cannot be applied to floats: " + this);
                }
                value = numval instanceof Long ? (Number)(numval.longValue() ^ 0xFFFFFFFFFFFFFFFFL) : (Number)(~numval.intValue());
            }
        }
        return value;
    }

    @Override
    public String toPlainString() {
        if (this.jjtGetNumChildren() == 2) {
            return this.subnodeToString(0) + MathNode.toString(this.op) + this.subnodeToString(1);
        }
        return MathNode.toString(this.op) + this.subnodeToString(0);
    }

    public static String toString(int operator) {
        switch (operator) {
            case 1: {
                return "+";
            }
            case 2: {
                return "-";
            }
            case 3: {
                return "*";
            }
            case 4: {
                return "/";
            }
            case 5: {
                return "%";
            }
            case 6: {
                return "&";
            }
            case 7: {
                return "|";
            }
            case 8: {
                return "^";
            }
            case 9: {
                return "~";
            }
            case 10: {
                return "<<";
            }
            case 11: {
                return ">>";
            }
            case 12: {
                return ">>>";
            }
        }
        return "" + operator;
    }

    public static int fromString(String operator) {
        if ("+".equals(operator)) {
            return 1;
        }
        if ("-".equals(operator)) {
            return 2;
        }
        if ("*".equals(operator)) {
            return 3;
        }
        if ("/".equals(operator)) {
            return 4;
        }
        if ("%".equals(operator)) {
            return 5;
        }
        if ("&".equals(operator)) {
            return 6;
        }
        if ("|".equals(operator)) {
            return 7;
        }
        if ("^".equals(operator)) {
            return 8;
        }
        if ("~".equals(operator)) {
            return 9;
        }
        if ("<<".equals(operator)) {
            return 10;
        }
        if (">>".equals(operator)) {
            return 11;
        }
        if (">>>".equals(operator)) {
            return 12;
        }
        throw new ParseException("Unknown operator: " + operator);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.op == ((MathNode)o).op;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.op;
    }
}

