/*
 * Decompiled with CFR 0.152.
 */
package jadex.javaparser.javaccimpl;

import jadex.commons.IValueFetcher;
import jadex.commons.SUtil;
import jadex.javaparser.javaccimpl.ExpressionNode;
import jadex.javaparser.javaccimpl.ParserImpl;
import jadex.javaparser.javaccimpl.ParserImplTreeConstants;

public class ConstantNode
extends ExpressionNode {
    public ConstantNode(ParserImpl p, int id) {
        super(p, id);
        this.setConstant(true);
    }

    public void setValue(Object value) {
        this.setConstantValue(value);
        if (value != null) {
            this.setStaticType(value.getClass());
        }
    }

    @Override
    public Object getValue(IValueFetcher fetcher) {
        return this.getConstantValue();
    }

    @Override
    public String toPlainString() {
        if (this.getConstantValue() instanceof String) {
            return "\"" + this.getConstantValue() + "\"";
        }
        if (this.getConstantValue() instanceof Character) {
            return "'" + this.getConstantValue() + "'";
        }
        return "" + this.getConstantValue();
    }

    @Override
    public String toString(String prefix) {
        return prefix + ParserImplTreeConstants.jjtNodeName[this.id] + "(" + this.getConstantValue() + ")";
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && SUtil.equals((Object)this.getConstantValue(), (Object)((ConstantNode)o).getConstantValue());
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + (this.getConstantValue() != null ? this.getConstantValue().hashCode() : 1);
    }
}

