/*
 * Decompiled with CFR 0.152.
 */
package jadex.javaparser.javaccimpl;

import jadex.commons.IValueFetcher;
import jadex.commons.SReflect;
import jadex.javaparser.javaccimpl.ExpressionNode;
import jadex.javaparser.javaccimpl.ParserImpl;

public class CastNode
extends ExpressionNode {
    public CastNode(ParserImpl p, int id) {
        super(p, id);
    }

    @Override
    public void precompile() {
        ExpressionNode type = (ExpressionNode)this.jjtGetChild(0);
        ExpressionNode expression = (ExpressionNode)this.jjtGetChild(1);
        if (type.isConstant()) {
            try {
                this.setStaticType((Class)type.getValue(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (type.isConstant() && expression.isConstant()) {
            try {
                this.setConstantValue(this.getValue(null));
                this.setConstant(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getValue(IValueFetcher fetcher) {
        if (!this.isConstant()) {
            Object value = ((ExpressionNode)this.jjtGetChild(1)).getValue(fetcher);
            if (value != null) {
                Class type = this.getStaticType() != null ? this.getStaticType() : (Class)((ExpressionNode)this.jjtGetChild(0)).getValue(null);
                if (!SReflect.isSupertype(type, value.getClass()) && SReflect.isSupertype(Number.class, (Class)type) && value instanceof Number) {
                    if ((type = SReflect.getWrappedType((Class)type)) == Float.class) {
                        value = Float.valueOf(((Number)value).floatValue());
                    } else if (type == Long.class) {
                        value = ((Number)value).longValue();
                    } else if (type == Integer.class) {
                        value = ((Number)value).intValue();
                    } else if (type == Short.class) {
                        value = ((Number)value).shortValue();
                    } else if (type == Byte.class) {
                        value = ((Number)value).byteValue();
                    } else if (type == Character.class) {
                        value = Character.valueOf((char)((Number)value).intValue());
                    }
                } else if (!SReflect.isSupertype((Class)type, value.getClass())) {
                    throw new ClassCastException(value.toString() + " cannot be cast to " + type.getName());
                }
            }
            return value;
        }
        return this.getConstantValue();
    }

    @Override
    public String toPlainString() {
        return "((" + this.jjtGetChild(0).toPlainString() + ")" + this.jjtGetChild(1).toPlainString() + ")";
    }
}

