/*
 * Decompiled with CFR 0.152.
 */
package jadex.javaparser.javaccimpl;

import jadex.commons.IValueFetcher;
import jadex.commons.SReflect;
import jadex.javaparser.javaccimpl.ExpressionNode;
import jadex.javaparser.javaccimpl.Node;
import jadex.javaparser.javaccimpl.ParseException;
import jadex.javaparser.javaccimpl.ParserImpl;
import java.lang.reflect.Array;

public class ArrayNode
extends ExpressionNode {
    public static final int ARRAY = 1;
    public static final int ARRAY_DIMENSION = 2;
    protected int type;

    public ArrayNode(ParserImpl p, int id) {
        super(p, id);
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void precompile() {
        block9: {
            ExpressionNode argsnode;
            block8: {
                if (this.jjtGetNumChildren() != 2) {
                    throw new ParseException("Wrong number of child nodes: " + this);
                }
                if (this.type != 1 && this.type != 2) {
                    throw new ParseException("Unknown node type " + this.type + ": " + this);
                }
                ExpressionNode typenode = (ExpressionNode)this.jjtGetChild(0);
                argsnode = (ExpressionNode)this.jjtGetChild(1);
                Class clazz = null;
                if (typenode.isConstant()) {
                    try {
                        clazz = (Class)typenode.getValue(null);
                        this.setStaticType(clazz);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.type != 1 || clazz == null) break block8;
                if (clazz.getComponentType() == null) {
                    throw new ParseException("Type not array: " + this);
                }
                for (int i = 0; i < argsnode.jjtGetNumChildren(); ++i) {
                    ExpressionNode node = (ExpressionNode)argsnode.jjtGetChild(i);
                    if (node.getStaticType() == null || SReflect.isSupertype(clazz.getComponentType(), node.getStaticType())) continue;
                    throw new ParseException("Content does not match array type: " + this);
                }
                break block9;
            }
            if (this.type != 2) break block9;
            for (int i = 0; i < argsnode.jjtGetNumChildren(); ++i) {
                ExpressionNode node = (ExpressionNode)argsnode.jjtGetChild(i);
                if (node.getStaticType() == null || SReflect.isSupertype(Integer.class, node.getStaticType())) continue;
                throw new ParseException("Dimension specification must be int: " + this);
            }
        }
    }

    @Override
    public Object getValue(IValueFetcher fetcher) {
        ExpressionNode typenode = (ExpressionNode)this.jjtGetChild(0);
        ExpressionNode argsnode = (ExpressionNode)this.jjtGetChild(1);
        Class<?> clazz = (Class<?>)typenode.getValue(fetcher);
        Object value = null;
        if (this.type == 1) {
            if (clazz.getComponentType() == null) {
                throw new RuntimeException("Type not array: " + this);
            }
            value = Array.newInstance(clazz.getComponentType(), argsnode.jjtGetNumChildren());
            for (int i = 0; i < argsnode.jjtGetNumChildren(); ++i) {
                ExpressionNode node = (ExpressionNode)argsnode.jjtGetChild(i);
                Object val = node.getValue(fetcher);
                if (val != null && !SReflect.isSupertype(clazz.getComponentType(), val.getClass())) {
                    throw new RuntimeException("Content does not match array type: " + this);
                }
                if (val == null && clazz.getComponentType().isPrimitive()) {
                    throw new RuntimeException("Cannot put null into basic type array: " + this);
                }
                Array.set(value, i, val);
            }
        } else if (this.type == 2) {
            int[] dims = new int[argsnode.jjtGetNumChildren()];
            for (int i = 0; i < argsnode.jjtGetNumChildren(); ++i) {
                clazz = clazz.getComponentType();
                ExpressionNode node = (ExpressionNode)argsnode.jjtGetChild(i);
                Object val = node.getValue(fetcher);
                if (!(val instanceof Number)) {
                    throw new ParseException("Dimension specification must be int: " + this);
                }
                dims[i] = ((Number)val).intValue();
            }
            value = Array.newInstance(clazz, dims);
        }
        return value;
    }

    @Override
    public String toPlainString() {
        String ret = "new " + this.jjtGetChild(0).toPlainString();
        Node argsnode = this.jjtGetChild(1);
        if (this.type == 1) {
            ret = ret + "{";
            for (int i = 0; i < argsnode.jjtGetNumChildren(); ++i) {
                ret = ret + argsnode.jjtGetChild(i).toPlainString();
                if (i >= argsnode.jjtGetNumChildren() - 1) continue;
                ret = ret + ", ";
            }
            ret = ret + "}";
        } else {
            int idx = ret.indexOf("[");
            int dims = ret.substring(idx).length() / 2;
            ret = ret.substring(0, idx);
            for (int i = 0; i < dims; ++i) {
                ret = ret + "[";
                if (i < argsnode.jjtGetNumChildren()) {
                    ret = ret + argsnode.jjtGetChild(i).toPlainString();
                }
                ret = ret + "]";
            }
        }
        return ret;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.type == ((ArrayNode)o).getType();
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.type;
    }
}

