/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.presentationtimer.remotecontrol;

import jadex.base.PlatformConfiguration;
import jadex.base.RootComponentConfiguration;
import jadex.base.Starter;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.ITuple2Future;
import jadex.commons.future.SResultListener;
import jadex.examples.presentationtimer.remotecontrol.ClientAgent;

public class ClientMain {
    public static boolean startedWithMain;

    public static void main(String[] args) {
        Future.DEBUG = true;
        ClientMain countDownClient = new ClientMain();
        countDownClient.setUp();
        startedWithMain = true;
    }

    public void setUp() {
        PlatformConfiguration config = PlatformConfiguration.getMinimalRelayAwareness();
        RootComponentConfiguration rootConfig = config.getRootConfig();
        config.setPlatformName("presentationtimer-*");
        rootConfig.setNetworkName("jadexnetwork");
        rootConfig.setNetworkPass("laxlax");
        IFuture fut = Starter.createPlatform((PlatformConfiguration)config);
        fut.addResultListener(access -> access.scheduleStep(ia -> {
            System.out.println("Got external platform access");
            IComponentManagementService cms = (IComponentManagementService)this.getCMS((IExternalAccess)access).get();
            System.out.println("Got cms");
            ITuple2Future fut2 = cms.createComponent("CDClient", ClientAgent.class.getName() + ".class", null);
            fut2.addTuple2ResultListener(cid -> System.out.println("Client Agent created"), SResultListener.ignoreResults());
            return Future.getEmptyFuture();
        }));
    }

    private IFuture<IComponentManagementService> getCMS(IExternalAccess access) {
        return access.scheduleStep(ia -> SServiceProvider.getService((IExternalAccess)access, IComponentManagementService.class, (String)"platform"));
    }
}

