/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.presentationtimer.display;

import jadex.bridge.IInternalAccess;
import jadex.bridge.SFuture;
import jadex.bridge.service.annotation.Reference;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.SubscriptionIntermediateFuture;
import jadex.commons.future.TerminableIntermediateFuture;
import jadex.examples.presentationtimer.common.ICountdownController;
import jadex.examples.presentationtimer.common.ICountdownGUIService;
import jadex.examples.presentationtimer.common.ICountdownService;
import jadex.examples.presentationtimer.common.State;
import jadex.examples.presentationtimer.display.ui.ConfigureFrame;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentCreated;
import jadex.micro.annotation.AgentService;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.ProvidedService;
import jadex.micro.annotation.ProvidedServices;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

@Agent
@ProvidedServices(value={@ProvidedService(type=ICountdownService.class), @ProvidedService(type=ICountdownGUIService.class)})
@RequiredServices(value={@RequiredService(type=IComponentManagementService.class, name="cms", binding=@Binding(scope="platform"))})
public class CountdownAgent
implements ICountdownService,
ICountdownGUIService {
    private Set<ICountdownService.ICountdownListener> listeners;
    private ICountdownController controller;
    private Set<SubscriptionIntermediateFuture<State>> stateFutures;
    private Set<SubscriptionIntermediateFuture<String>> timeFutures;
    @AgentService
    private IComponentManagementService cms;
    @Agent
    private IInternalAccess agent;
    private String lastTime = "00:00";
    private State lastState = new State();

    public CountdownAgent() {
        this.listeners = new HashSet<ICountdownService.ICountdownListener>();
        this.stateFutures = new HashSet<SubscriptionIntermediateFuture<State>>();
        this.timeFutures = new HashSet<SubscriptionIntermediateFuture<String>>();
    }

    @Override
    public IFuture<Void> addListener(@Reference ICountdownService.ICountdownListener l) {
        System.out.println("Received addListener()");
        this.listeners.add(l);
        return Future.DONE;
    }

    @Override
    public ISubscriptionIntermediateFuture<State> registerForState() {
        System.out.println("Register for state");
        SubscriptionIntermediateFuture intermediateFuture = (SubscriptionIntermediateFuture)SFuture.getNoTimeoutFuture(SubscriptionIntermediateFuture.class, (IInternalAccess)this.agent);
        this.stateFutures.add((SubscriptionIntermediateFuture<State>)intermediateFuture);
        return intermediateFuture;
    }

    @Override
    public ISubscriptionIntermediateFuture<String> registerForTime() {
        System.out.println("Register for time");
        SubscriptionIntermediateFuture intermediateFuture = (SubscriptionIntermediateFuture)SFuture.getNoTimeoutFuture(SubscriptionIntermediateFuture.class, (IInternalAccess)this.agent);
        this.timeFutures.add((SubscriptionIntermediateFuture<String>)intermediateFuture);
        return intermediateFuture;
    }

    @Override
    public IFuture<State> getState() {
        return new Future((Object)this.lastState);
    }

    @Override
    public IFuture<String> getTime() {
        return new Future((Object)this.lastTime);
    }

    @Override
    public IFuture<Void> start() {
        System.out.println("Received start()");
        this.controller.start();
        IComponentManagementService cms = (IComponentManagementService)SServiceProvider.getDeclaredService((IInternalAccess)this.agent, IComponentManagementService.class).get();
        System.out.println(cms);
        cms.createComponent("jadex.examples.presentationtimer.display.CountdownAgent.class", null).addTuple2ResultListener(t -> System.out.println(t), ex -> System.out.println(ex));
        return Future.DONE;
    }

    @Override
    public IFuture<Void> stop() {
        System.out.println("Received stop()");
        this.controller.stop();
        return Future.DONE;
    }

    @Override
    public IFuture<Void> reset() {
        System.out.println("Received reset()");
        return Future.DONE;
    }

    @Override
    public synchronized void informTimeUpdated(String timeString) {
        this.lastTime = timeString;
        for (ICountdownService.ICountdownListener l : this.listeners) {
            l.timeChanged(timeString);
        }
        ArrayList<SubscriptionIntermediateFuture<String>> terminated = new ArrayList<SubscriptionIntermediateFuture<String>>();
        for (SubscriptionIntermediateFuture<String> subscriptionIntermediateFuture : this.timeFutures) {
            if (!subscriptionIntermediateFuture.isDone()) {
                subscriptionIntermediateFuture.addIntermediateResult((Object)timeString);
                continue;
            }
            System.out.println("Found terminated future, removing");
            terminated.add(subscriptionIntermediateFuture);
        }
        for (SubscriptionIntermediateFuture subscriptionIntermediateFuture : terminated) {
            this.timeFutures.remove(subscriptionIntermediateFuture);
        }
    }

    @Override
    public synchronized void informStateUpdated(State state) {
        this.lastState = state;
        for (ICountdownService.ICountdownListener l : this.listeners) {
            l.stateChanged(state);
        }
        ArrayList<TerminableIntermediateFuture> terminated = new ArrayList<TerminableIntermediateFuture>();
        for (TerminableIntermediateFuture terminableIntermediateFuture : this.stateFutures) {
            if (!terminableIntermediateFuture.isDone()) {
                terminableIntermediateFuture.addIntermediateResult((Object)state);
                continue;
            }
            terminated.add(terminableIntermediateFuture);
        }
        for (TerminableIntermediateFuture terminableIntermediateFuture : terminated) {
            this.stateFutures.remove(terminableIntermediateFuture);
        }
    }

    @Override
    public void setController(ICountdownController controller) {
        this.controller = controller;
    }

    @AgentCreated
    public void agentCreated() {
        System.out.println("Countdown agent created!");
        ConfigureFrame configureFrame = new ConfigureFrame(this);
        configureFrame.setLocationRelativeTo(null);
        configureFrame.setVisible(true);
    }
}

