/*
 * Decompiled with CFR 0.152.
 */
package monads;

import jadex.commons.IResultCommand;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFunctionalResultListener;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.IntermediateFuture;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

public class Test {
    public static void main(String[] args) {
        IIntermediateFuture inf2 = Test.$$$(Test.getABC(), x -> Test.getE(x));
        System.out.println("result is: " + Test.$(inf2));
    }

    public static void abc(String a) {
        System.out.println("abc: " + a);
    }

    public static IFuture<String> getHelloWorld() {
        return Test.$(Test.getHello(), x -> Test.getWorld(x));
    }

    public static IFuture<String> getHello() {
        return new Future((Object)"hello");
    }

    public static IFuture<String> getWorld(String hello) {
        return new Future((Object)(hello + " world"));
    }

    public static IIntermediateFuture<String> getABC() {
        return new IntermediateFuture(Arrays.asList("a", "b", "c"));
    }

    public static IFuture<String> getD(String arg) {
        Future ret = new Future();
        ret.setResult((Object)(arg + "_1"));
        return ret;
    }

    public static IIntermediateFuture<String> getE(String arg) {
        IntermediateFuture ret = new IntermediateFuture();
        ret.addIntermediateResult((Object)(arg + "_1"));
        ret.addIntermediateResult((Object)(arg + "_2"));
        ret.addIntermediateResult((Object)(arg + "_3"));
        ret.setFinished();
        return ret;
    }

    public static <V, R> void test(IFunctionalResultListener<R> function) {
        function.resultAvailable((Object)"hsa");
    }

    public static <V, R> IFuture<R> $(IFuture<V> orig, final IResultCommand<IFuture<R>, V> function) {
        final Future ret = new Future();
        orig.addResultListener(new IResultListener<V>(){

            public void resultAvailable(V result) {
                IFuture res = (IFuture)function.execute(result);
                res.addResultListener((IResultListener)new DelegationResultListener(ret));
            }

            public void exceptionOccurred(Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    public static <V, R> IIntermediateFuture<R> $$(IIntermediateFuture<V> orig, final Function<V, IFuture<R>> function) {
        final IntermediateFuture ret = new IntermediateFuture();
        orig.addIntermediateResultListener(new IIntermediateResultListener<V>(){

            public void resultAvailable(Collection<V> result) {
                for (Object v : result) {
                    this.intermediateResultAvailable(v);
                }
                this.finished();
            }

            public void intermediateResultAvailable(V result) {
                IFuture res = (IFuture)function.apply(result);
                res.addResultListener(new IResultListener<R>(){

                    public void resultAvailable(R result) {
                        ret.addIntermediateResult(result);
                    }

                    public void exceptionOccurred(Exception exception) {
                        ret.setExceptionIfUndone(exception);
                    }
                });
            }

            public void finished() {
                ret.setFinished();
            }

            public void exceptionOccurred(Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    public static <R, E> IIntermediateFuture<R> $$$(IIntermediateFuture<E> orig, final IResultCommand<IIntermediateFuture<R>, E> function) {
        final IntermediateFuture ret = new IntermediateFuture();
        orig.addIntermediateResultListener(new IIntermediateResultListener<E>(){
            boolean fin = false;
            int cnt = 0;
            int num = 0;

            public void resultAvailable(Collection<E> result) {
                for (Object v : result) {
                    this.intermediateResultAvailable(v);
                }
                this.finished();
            }

            public void intermediateResultAvailable(E result) {
                ++this.cnt;
                IIntermediateFuture res = (IIntermediateFuture)function.execute(result);
                res.addResultListener((IResultListener)new IIntermediateResultListener<R>(){

                    public void intermediateResultAvailable(R result) {
                        ret.addIntermediateResult(result);
                    }

                    public void finished() {
                        if (++num == cnt && fin) {
                            ret.setFinished();
                        }
                    }

                    public void resultAvailable(Collection<R> result) {
                        for (Object r : result) {
                            this.intermediateResultAvailable(r);
                        }
                        this.finished();
                    }

                    public void exceptionOccurred(Exception exception) {
                        ret.setExceptionIfUndone(exception);
                    }
                });
            }

            public void finished() {
                this.fin = true;
                if (this.num == this.cnt) {
                    ret.setFinished();
                }
            }

            public void exceptionOccurred(Exception exception) {
                ret.setException(exception);
            }
        });
        return ret;
    }

    public static <T> T $(IFuture<T> fut) {
        return (T)fut.get();
    }
}

