/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.presentationtimer.display.ui;

import jadex.examples.presentationtimer.common.ICountdownController;
import jadex.examples.presentationtimer.common.ICountdownService;
import jadex.examples.presentationtimer.common.State;
import jadex.examples.presentationtimer.display.Main;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class CountDownView
extends JFrame {
    protected JLabel countdownLabel;
    private Timer timer;
    private ICountdownService.ICountdownListener listener;
    private int countDownTime;
    protected int infoTimeLeft;
    protected int warningTimeLeft;
    private State state;
    protected JButton startStopButton;
    private DecimalFormat formatter;
    private ICountdownController controller = new ICountdownController(){

        @Override
        public void start() {
            if (!((CountDownView)CountDownView.this).state.isRunning) {
                SwingUtilities.invokeLater(() -> CountDownView.this.toggleButton());
            }
        }

        @Override
        public void stop() {
            if (((CountDownView)CountDownView.this).state.isRunning) {
                SwingUtilities.invokeLater(() -> CountDownView.this.toggleButton());
            }
        }

        @Override
        public void reset() {
        }
    };

    public CountDownView(int countDownTime, int infoTimeLeft, int warningTimeLeft) {
        this.countDownTime = countDownTime;
        this.infoTimeLeft = infoTimeLeft;
        this.warningTimeLeft = warningTimeLeft;
        this.state = new State(false, false, false);
        this.setSize(300, 300);
        this.formatter = new DecimalFormat("00");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)new JLabel("00:00"){
            {
                this.setForeground(Color.WHITE);
                this.setBackground(Color.BLACK);
                this.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent e) {
                        super.componentResized(e);
                        int stringWidth = this.getFontMetrics(this.getFont()).stringWidth("00:00");
                        int componentWidth = this.getWidth();
                        double ratio = (double)componentWidth / (double)stringWidth;
                        int newFontSize = (int)((double)this.getFont().getSize() * ratio);
                        int height = this.getHeight();
                        int fontSizeToUse = Math.min(newFontSize, height);
                        this.setFont(new Font(this.getFont().getName(), 0, fontSizeToUse));
                        this.setOpaque(true);
                    }
                });
                CountDownView.this.countdownLabel = this;
            }
        }, "Center");
        contentPane.add((Component)new JButton("Start"){
            {
                this.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 40) {
                            CountDownView.this.toggleButton();
                        }
                    }
                });
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CountDownView.this.toggleButton();
                    }
                });
                CountDownView.this.startStopButton = this;
            }
        }, "South");
        this.setLocationRelativeTo(null);
        this.setTitle("Countdown (" + countDownTime + "s, Warnung bei " + infoTimeLeft + " und " + warningTimeLeft + "s)");
        this.setBackground(Color.BLACK);
        if (Main.startedWithMain) {
            this.setDefaultCloseOperation(3);
        }
    }

    private void toggleButton() {
        this.startStopButton.setEnabled(false);
        if (this.state.isRunning) {
            this.stopCountDown();
            this.startStopButton.setText("Reset and Start");
        } else {
            this.startCountDown();
            this.startStopButton.setText("Stop");
        }
        this.startStopButton.setEnabled(true);
    }

    private void startCountDown() {
        this.countdownLabel.setForeground(Color.WHITE);
        this.countdownLabel.setBackground(Color.BLACK);
        this.refreshView(this.countDownTime);
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(this.createCountDownTask(this.countDownTime), 1000L, 1000L);
        this.state.isRunning = true;
        this.state.isInfo = false;
        this.state.isWarn = false;
        this.informStatus(this.state);
    }

    private void stopCountDown() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.state.isRunning = false;
        this.informStatus(this.state);
    }

    public ICountdownService.ICountdownListener getListener() {
        return this.listener;
    }

    public void setListener(ICountdownService.ICountdownListener listener) {
        this.listener = listener;
    }

    private TimerTask createCountDownTask(final int countDownTime) {
        return new TimerTask(){
            boolean blinking;
            int timeLeft;
            {
                this.timeLeft = countDownTime;
            }

            @Override
            public void run() {
                --this.timeLeft;
                if (this.timeLeft > 0) {
                    CountDownView.this.refreshView(this.timeLeft);
                    if (this.timeLeft < CountDownView.this.infoTimeLeft) {
                        if (this.timeLeft < CountDownView.this.warningTimeLeft) {
                            ((CountDownView)CountDownView.this).state.isWarn = true;
                            CountDownView.this.informStatus(CountDownView.this.state);
                            CountDownView.this.countdownLabel.setBackground(Color.RED);
                            CountDownView.this.countdownLabel.setForeground(Color.black);
                        } else {
                            ((CountDownView)CountDownView.this).state.isInfo = true;
                            CountDownView.this.informStatus(CountDownView.this.state);
                            CountDownView.this.countdownLabel.setBackground(Color.YELLOW);
                            CountDownView.this.countdownLabel.setForeground(Color.black);
                        }
                    }
                } else {
                    if (this.timeLeft == 0) {
                        // empty if block
                    }
                    if (this.blinking) {
                        CountDownView.this.countdownLabel.setBackground(Color.RED);
                        CountDownView.this.countdownLabel.setForeground(Color.BLACK);
                    } else {
                        CountDownView.this.countdownLabel.setForeground(Color.WHITE);
                        CountDownView.this.countdownLabel.setBackground(Color.BLACK);
                    }
                    this.blinking = !this.blinking;
                    CountDownView.this.refreshView(0);
                }
            }
        };
    }

    protected void refreshView(int timeLeft) {
        String timeString = this.formatter.format(timeLeft / 60) + ":" + this.formatter.format(timeLeft % 60);
        this.countdownLabel.setText(timeString);
        this.informTime(timeString);
    }

    protected void informTime(String timeString) {
        if (this.listener != null) {
            this.listener.timeChanged(timeString);
        }
    }

    protected void informStatus(State state) {
        if (this.listener != null) {
            this.listener.stateChanged(state);
        }
    }

    public ICountdownController getController() {
        return this.controller;
    }
}

