/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.presentationtimer.display.ui;

import jadex.examples.presentationtimer.common.ICountdownGUIService;
import jadex.examples.presentationtimer.common.ICountdownService;
import jadex.examples.presentationtimer.common.State;
import jadex.examples.presentationtimer.display.Main;
import jadex.examples.presentationtimer.display.ui.CountDownView;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfigureFrame
extends JFrame {
    protected JTextField countDownTimeTF;
    protected JTextField infoTimeTF;
    protected JTextField warningTimeTF;
    protected JLabel fehlerLabel;
    private ICountdownGUIService guiService;
    private ActionListener onOkClickListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int cdTime = this.parseTimeString(ConfigureFrame.this.countDownTimeTF.getText());
                int infoTime = this.parseTimeString(ConfigureFrame.this.infoTimeTF.getText());
                int warnTime = this.parseTimeString(ConfigureFrame.this.warningTimeTF.getText());
                if (cdTime > infoTime && infoTime > warnTime) {
                    ConfigureFrame.this.dispose();
                    CountDownView countDownView = new CountDownView(cdTime, infoTime, warnTime);
                    ConfigureFrame.this.guiService.setController(countDownView.getController());
                    countDownView.setListener(new ICountdownService.ICountdownListener(){

                        @Override
                        public void timeChanged(String timeString) {
                            ConfigureFrame.this.guiService.informTimeUpdated(timeString);
                        }

                        @Override
                        public void stateChanged(State state) {
                            ConfigureFrame.this.guiService.informStateUpdated(state);
                        }
                    });
                    countDownView.setVisible(true);
                } else {
                    ConfigureFrame.this.fehlerLabel.setText("info und warnzeit m\u00fcssen gr\u00f6\u00dfer als Gesamtzeit sein!");
                }
            }
            catch (NumberFormatException nfe) {
                ConfigureFrame.this.fehlerLabel.setText("Fehler beim parsen der Werte!");
            }
        }

        private int parseTimeString(String text) {
            String[] timeArr = text.split(":");
            if (timeArr.length != 2) {
                throw new NumberFormatException("");
            }
            int minutes = Integer.parseInt(timeArr[0]);
            int seconds = Integer.parseInt(timeArr[1]);
            return minutes * 60 + seconds;
        }
    };

    public ConfigureFrame(ICountdownGUIService guiService) {
        this.guiService = guiService;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridLayout(4, 2));
        contentPane.add(new JLabel("Countdownzeit (mm:ss): "));
        contentPane.add(new JTextField("08:00"){
            {
                ConfigureFrame.this.countDownTimeTF = this;
            }
        });
        contentPane.add(new JLabel("Zeit f\u00fcr gelbe Ansicht (mm:ss): "));
        contentPane.add(new JTextField("01:00"){
            {
                ConfigureFrame.this.infoTimeTF = this;
            }
        });
        contentPane.add(new JLabel("Zeit f\u00fcr rote Ansicht (mm:ss): "));
        contentPane.add(new JTextField("00:15"){
            {
                ConfigureFrame.this.warningTimeTF = this;
            }
        });
        contentPane.add(new JLabel(){
            {
                ConfigureFrame.this.fehlerLabel = this;
            }
        });
        contentPane.add(new JButton("Starten"){
            {
                this.addActionListener(ConfigureFrame.this.onOkClickListener);
            }
        });
        this.pack();
        this.setTitle("Countdown konfigurieren");
        if (Main.startedWithMain) {
            this.setDefaultCloseOperation(3);
        }
    }
}

