/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.presentationtimer.remotecontrol.ui;

import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.ITerminableIntermediateFuture;
import jadex.commons.future.SResultListener;
import jadex.commons.gui.future.SwingIntermediateResultListener;
import jadex.examples.presentationtimer.common.ICountdownService;
import jadex.examples.presentationtimer.common.State;
import jadex.examples.presentationtimer.remotecontrol.ClientMain;
import jadex.examples.presentationtimer.remotecontrol.ui.CDListCellRenderer;
import jadex.examples.presentationtimer.remotecontrol.ui.CDListItem;
import jadex.examples.presentationtimer.remotecontrol.ui.CDListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class ClientFrame
extends JFrame {
    private JList<CDListItem> list;
    private JLabel timeLabel;
    private JLabel stateLabel;
    private CDListModel listmodel;
    private ITerminableIntermediateFuture<State> stateFut;
    private ITerminableIntermediateFuture<String> timeFut;
    private CDListItem selectedElement;

    public ClientFrame() {
        if (ClientMain.startedWithMain) {
            this.setDefaultCloseOperation(3);
        }
        this.setSize(new Dimension(600, 450));
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)new JPanel(){
            {
                this.setLayout(new BorderLayout());
                this.add((Component)new JScrollPane(){
                    {
                        this.setHorizontalScrollBarPolicy(31);
                        this.setViewportView(new JList<CDListItem>(){
                            {
                                this.setBorder(new TitledBorder("Available Countdown Services: "));
                                ClientFrame.this.listmodel = new CDListModel();
                                this.setModel(ClientFrame.this.listmodel);
                                this.setSelectionMode(0);
                                this.setCellRenderer(new CDListCellRenderer());
                                ClientFrame.this.list = this;
                            }
                        });
                    }
                }, "Center");
                this.add((Component)new JPanel(){
                    {
                        this.add(new JLabel("searching..."));
                    }
                }, "Last");
            }
        }, "Center");
        contentPane.add((Component)new JPanel(){
            {
                this.setLayout(new BorderLayout());
                this.add((Component)new JPanel(){
                    {
                        this.setLayout(new BoxLayout(this, 1));
                        this.add(Box.createGlue());
                        this.add(new JLabel("currentTime"){
                            {
                                ClientFrame.this.timeLabel = this;
                                this.setAlignmentX(0.5f);
                                this.setFont(this.getFont().deriveFont(20.0f));
                            }
                        });
                        this.add(new JLabel("currentState"){
                            {
                                ClientFrame.this.stateLabel = this;
                                this.setAlignmentX(0.5f);
                            }
                        });
                        this.add(Box.createGlue());
                    }
                }, "Center");
                this.add((Component)new JPanel(){
                    {
                        this.setLayout(new FlowLayout());
                        this.add(new JButton("Start"){
                            {
                                this.addActionListener(action -> {
                                    if (ClientFrame.this.selectedElement != null) {
                                        ClientFrame.this.selectedElement.getService().start();
                                    }
                                });
                            }
                        });
                        this.add(new JButton("Stop"){
                            {
                                this.addActionListener(action -> {
                                    if (ClientFrame.this.selectedElement != null) {
                                        ClientFrame.this.selectedElement.getService().stop();
                                    }
                                });
                            }
                        });
                        this.add(new JButton("Reset"){
                            {
                                this.addActionListener(action -> {
                                    if (ClientFrame.this.selectedElement != null) {
                                        ClientFrame.this.selectedElement.getService().reset();
                                    }
                                });
                            }
                        });
                    }
                }, "Last");
            }
        }, "After");
        this.setLocationRelativeTo(null);
        this.list.addListSelectionListener(selEvent -> {
            int firstIndex = selEvent.getFirstIndex();
            if (this.list.isSelectionEmpty()) {
                if (this.stateFut != null && !this.timeFut.isDone()) {
                    System.out.println("Selection Empty, terminating");
                    this.stateFut.terminate();
                    this.stateFut = null;
                }
                if (this.timeFut != null && !this.timeFut.isDone()) {
                    this.timeFut.terminate();
                    this.stateFut = null;
                }
            } else if (!selEvent.getValueIsAdjusting()) {
                CDListItem element;
                this.selectedElement = element = this.list.getSelectedValue();
                ICountdownService service = element.getService();
                if (this.stateFut != null && !this.timeFut.isDone()) {
                    this.stateFut.terminate();
                }
                if (this.timeFut != null && !this.timeFut.isDone()) {
                    this.timeFut.terminate();
                }
                System.out.println("Subscribing");
                service.getTime().addResultListener(timeString -> this.timeLabel.setText((String)timeString));
                service.getState().addResultListener(state -> this.stateLabel.setText(state.toString()));
                this.stateFut = service.registerForState();
                this.timeFut = service.registerForTime();
                this.stateFut.addIntermediateResultListener((IIntermediateResultListener)new SwingIntermediateResultListener(state -> this.stateLabel.setText(state.toString()), SResultListener.ignoreResults(), ex -> {
                    if (this.stateFut != null) {
                        this.stateFut.terminate();
                    }
                }));
                this.timeFut.addIntermediateResultListener((IIntermediateResultListener)new SwingIntermediateResultListener(timeString -> this.timeLabel.setText((String)timeString), SResultListener.ignoreResults(), ex -> {
                    if (this.timeFut != null) {
                        this.timeFut.terminate();
                    }
                }));
            }
        });
        this.setTitle("Presentationtimer Client");
    }

    public CDListModel getListmodel() {
        return this.listmodel;
    }
}

