/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.presentationtimer.remotecontrol.ui;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.ITransportComponentIdentifier;
import jadex.bridge.service.component.BasicServiceInvocationHandler;
import jadex.examples.presentationtimer.common.State;
import jadex.examples.presentationtimer.remotecontrol.ui.CDListItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class CDListCellRenderer
extends JPanel
implements ListCellRenderer<CDListItem> {
    protected JLabel platformLabel;
    protected JTextArea platformAddresses;
    protected JLabel stateLabel;
    protected JLabel timeLabel;

    public CDListCellRenderer() {
        this.setOpaque(true);
        BoxLayout mgr = new BoxLayout(this, 1);
        this.setLayout(mgr);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(new JLabel("platformname"){
            {
                this.setAlignmentX(0.0f);
                CDListCellRenderer.this.platformLabel = this;
            }
        });
        this.add(new JPanel(){
            {
                this.setLayout(new FlowLayout(0, 0, 0));
                this.setOpaque(false);
                this.setAlignmentX(0.0f);
                this.add(new JLabel("state"){
                    {
                        this.setForeground(Color.gray);
                        CDListCellRenderer.this.stateLabel = this;
                        this.setAlignmentX(0.0f);
                    }
                });
                this.add(Box.createRigidArea(new Dimension(10, 0)));
                this.add(new JLabel("time"){
                    {
                        this.setForeground(Color.gray);
                        CDListCellRenderer.this.timeLabel = this;
                        this.setAlignmentX(0.0f);
                    }
                });
            }
        });
        this.add(new JTextArea("addrs"){
            {
                Font font = this.getFont();
                this.setFont(font.deriveFont((float)((double)font.getSize() * 0.85)));
                this.setAlignmentX(0.0f);
                CDListCellRenderer.this.platformAddresses = this;
                this.setEditable(false);
                this.setOpaque(false);
            }
        });
        this.add(Box.createRigidArea(new Dimension(0, 5)));
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends CDListItem> list, CDListItem value, int index, boolean isSelected, boolean cellHasFocus) {
        CDListItem item = list.getModel().getElementAt(index);
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(item.getService());
        if (invocationHandler instanceof BasicServiceInvocationHandler) {
            BasicServiceInvocationHandler sih = (BasicServiceInvocationHandler)invocationHandler;
            IComponentIdentifier providerId = sih.getServiceIdentifier().getProviderId();
            String platformName = providerId.getName();
            String[] addr = providerId instanceof ITransportComponentIdentifier ? ((ITransportComponentIdentifier)providerId).getAddresses() : new String[]{};
            this.platformLabel.setText(platformName);
            this.platformAddresses.setText(this.formatAddrs(addr));
        }
        State state = item.getStatus();
        String time = item.getTime();
        if (state != null) {
            this.stateLabel.setText(state.toString());
        } else {
            this.stateLabel.setText("State unknown");
        }
        if (time != null) {
            this.timeLabel.setText(time);
        } else {
            this.timeLabel.setText("??:??");
        }
        if (isSelected) {
            this.setForeground(UIManager.getColor("List.selectionForeground"));
            this.setBackground(UIManager.getColor("List.selectionBackground"));
        } else {
            this.setForeground(UIManager.getColor("List.foreground"));
            this.setBackground(UIManager.getColor("List.background"));
        }
        return this;
    }

    private String formatAddrs(String[] addr) {
        StringBuilder stringBuilder = new StringBuilder("");
        for (String string : addr) {
            stringBuilder.append("\n");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

