/*
 * Decompiled with CFR 0.152.
 */
package jadex.examples.presentationtimer.remotecontrol;

import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.ISubscriptionIntermediateFuture;
import jadex.commons.future.SubscriptionIntermediateFuture;
import jadex.examples.presentationtimer.common.ICountdownService;
import jadex.examples.presentationtimer.common.State;
import jadex.examples.presentationtimer.remotecontrol.ui.CDListItem;
import jadex.examples.presentationtimer.remotecontrol.ui.CDListModel;
import jadex.examples.presentationtimer.remotecontrol.ui.ClientFrame;
import jadex.micro.annotation.Agent;
import jadex.micro.annotation.AgentBody;
import jadex.micro.annotation.AgentCreated;
import jadex.micro.annotation.Binding;
import jadex.micro.annotation.RequiredService;
import jadex.micro.annotation.RequiredServices;
import javax.swing.SwingUtilities;

@Agent
@RequiredServices(value={@RequiredService(type=ICountdownService.class, name="cds", binding=@Binding(scope="global"))})
public class ClientAgent {
    private ICountdownService cds;
    @Agent
    private IInternalAccess access;
    SubscriptionIntermediateFuture<ICountdownService> subscription = new SubscriptionIntermediateFuture();

    @AgentCreated
    public void onCreate() {
        System.out.println("Client Agent created");
    }

    public void injectService(ICountdownService cds) {
        System.out.println("Service injected: " + cds);
    }

    @AgentBody
    public void body() {
        ClientFrame clientFrame = new ClientFrame();
        clientFrame.setVisible(true);
        CDListModel listmodel = clientFrame.getListmodel();
        this.searchCdServices().addIntermediateResultListener(cdService -> {
            System.out.println("Service found: " + cdService + " of class: " + cdService.getClass().getName());
            CDListItem item = new CDListItem((ICountdownService)cdService);
            item.setStatus((State)cdService.getState().get());
            item.setTime((String)cdService.getTime().get());
            SwingUtilities.invokeLater(() -> listmodel.addElement(item));
        });
    }

    private ISubscriptionIntermediateFuture<ICountdownService> searchCdServices() {
        IIntermediateFuture searchServices = ((IRequiredServicesFeature)this.access.getComponentFeature(IRequiredServicesFeature.class)).searchServices(ICountdownService.class, "global");
        searchServices.addIntermediateResultListener(cdService -> this.subscription.addIntermediateResult(cdService), finished -> {
            System.out.println("Search finished. Re-scheduling search.");
            this.access.getExternalAccess().scheduleStep((IComponentStep)new IComponentStep<Void>(){

                public IFuture<Void> execute(IInternalAccess ia) {
                    ClientAgent.this.searchCdServices();
                    return Future.DONE;
                }
            }, 10000L);
        });
        return this.subscription;
    }
}

