/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib.messaging;

import jadex.bdi.planlib.messaging.EmailAccount;
import jadex.bdiv3x.runtime.Plan;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SendEmailPlan
extends Plan {
    public void body() {
        EmailAccount account = (EmailAccount)this.getParameter("account").getValue();
        if (account == null) {
            this.fail();
        }
        String content = (String)this.getParameter("content").getValue();
        String subject = (String)this.getParameter("subject").getValue();
        String[] receivers = (String[])this.getParameterSet("receivers").getValues();
        String[] ccs = (String[])this.getParameterSet("ccs").getValues();
        String[] bccs = (String[])this.getParameterSet("bccs").getValues();
        Properties props = new Properties();
        props.setProperty("mail.smtp.auth", "true");
        props.setProperty("mail.smtps.auth", "true");
        Session sess = Session.getDefaultInstance((Properties)props, null);
        sess.setDebug(true);
        try {
            int i;
            MimeMessage message = new MimeMessage(sess);
            message.setFrom((Address)new InternetAddress(account.getSender()));
            message.setContent((Object)content, "text/ plain");
            message.setSubject(subject);
            for (i = 0; i < receivers.length; ++i) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(receivers[i]));
            }
            for (i = 0; i < ccs.length; ++i) {
                message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(ccs[i]));
            }
            for (i = 0; i < bccs.length; ++i) {
                message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bccs[i]));
            }
            Transport tr = account.isSsl() ? sess.getTransport("smtps") : sess.getTransport("smtp");
            if (account.getPort() != null) {
                tr.connect(account.getHost(), account.getPort().intValue(), account.getUser(), account.getPassword());
            } else {
                tr.connect(account.getHost(), account.getUser(), account.getPassword());
            }
            message.saveChanges();
            tr.sendMessage((Message)message, message.getAllRecipients());
            tr.close();
        }
        catch (MessagingException e) {
            e.printStackTrace();
            this.fail(e);
        }
    }
}

