/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib.watchdog;

import jadex.bdi.planlib.watchdog.ContactData;
import jadex.bdi.planlib.watchdog.ObservationDescription;
import jadex.bdiv3.runtime.IGoal;
import jadex.bdiv3.runtime.impl.GoalFailureException;
import jadex.bdiv3x.runtime.Plan;

public class NotifyAdminPlan
extends Plan {
    public void body() {
        ObservationDescription desc = (ObservationDescription)this.getParameter("description").getValue();
        boolean success = false;
        ContactData[] contacts = desc.getContacts();
        for (int i = 0; i < contacts.length; ++i) {
            if (contacts[i].getEmail() != null && this.getBeliefbase().getBelief("emailaccount").getFact() != null) {
                try {
                    IGoal sendemail = this.createGoal("send_email");
                    sendemail.getParameter("subject").setValue((Object)"Watchdog warning message.");
                    sendemail.getParameter("content").setValue((Object)("Application problem with: " + desc.getComponentIdentifier()));
                    sendemail.getParameterSet("receivers").addValue((Object)contacts[i].getEmail());
                    this.dispatchSubgoalAndWait(sendemail);
                    success = true;
                }
                catch (GoalFailureException e) {
                    this.getLogger().info("Could not notify via email: " + contacts[i].getEmail());
                }
            }
            if (contacts[i].getIcq() != null && this.getBeliefbase().getBelief("icqaccount").getFact() != null) {
                try {
                    IGoal sendim = this.createGoal("send_im");
                    sendim.getParameter("content").setValue((Object)("Application problem with: " + desc.getComponentIdentifier()));
                    sendim.getParameterSet("receivers").addValue((Object)contacts[i].getIcq());
                    this.dispatchSubgoalAndWait(sendim);
                    success = true;
                }
                catch (GoalFailureException e) {
                    this.getLogger().info("Could not notify via im: " + contacts[i].getIcq());
                }
            }
            if (contacts[i].getPhone() == null) continue;
            try {
                IGoal sendsms = this.createGoal("send_sms");
                sendsms.getParameter("content").setValue((Object)("Application problem with: " + desc.getComponentIdentifier()));
                sendsms.getParameterSet("receivers").addValue((Object)contacts[i].getPhone());
                this.dispatchSubgoalAndWait(sendsms);
                success = true;
                continue;
            }
            catch (GoalFailureException e) {
                this.getLogger().info("Could not notify via sms: " + contacts[i].getEmail());
            }
        }
        if (!success) {
            this.fail();
        }
    }
}

