/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib.protocols.contractnet;

import jadex.bdi.planlib.protocols.AbstractReceiverPlan;
import jadex.bdiv3.runtime.IGoal;
import jadex.bdiv3x.runtime.IMessageEvent;
import jadex.bridge.IComponentIdentifier;
import jadex.commons.collection.SCollection;
import java.util.ArrayList;

public class CNPReceiverPlan
extends AbstractReceiverPlan {
    @Override
    public void body() {
        IMessageEvent reply;
        super.body();
        long timeout = this.getBeliefbase().containsBelief("timeout") && this.getBeliefbase().getBelief("timeout").getFact() != null ? (Long)this.getBeliefbase().getBelief("timeout").getFact() : -1L;
        IMessageEvent me = (IMessageEvent)this.getParameter("message").getValue();
        IComponentIdentifier initiator = (IComponentIdentifier)me.getParameter("sender").getValue();
        ArrayList records = SCollection.createArrayList();
        Object[] proposal = null;
        for (int i = 0; me.getType().equals(this.getShortProtocolName() + "_cfp") && (i == 0 || this.isIterated()); ++i) {
            this.getLogger().info("Negotiation round: " + i + " receiver got cfp: " + me);
            records.add(me);
            Object cfp = me.getParameter("content").getValue();
            Exception ex = null;
            try {
                proposal = this.makeProposal(cfp, initiator);
            }
            catch (Exception e) {
                ex = e;
                this.getLogger().info("No proposal made due to exception: " + e);
            }
            if (ex != null || proposal == null || proposal[0] == null) {
                reply = this.getEventbase().createReply(me, this.getShortProtocolName() + "_refuse");
                this.getLogger().info("No proposal made. Finished.");
                this.sendMessage(reply);
                return;
            }
            reply = this.getEventbase().createReply(me, this.getShortProtocolName() + "_propose");
            reply.getParameter("content").setValue(proposal[0]);
            this.getLogger().info("Receiver sent proposal: " + reply);
            me = this.sendMessageAndWait(reply, timeout);
        }
        if (me.getType().equals(this.getShortProtocolName() + "_accept")) {
            this.getLogger().info(this.getComponentName() + " excuting the cnp task.");
            try {
                Object result = this.executeTask(proposal[0], proposal[1], initiator);
                reply = this.getEventbase().createReply(me, this.getShortProtocolName() + "_inform");
                reply.getParameter("content").setValue(result);
                this.getLogger().info("Receiver sent done: " + reply);
                this.sendMessage(reply);
                this.getParameter("result").setValue(result);
            }
            catch (Exception e) {
                reply = this.getEventbase().createReply(me, this.getShortProtocolName() + "_failure");
                this.getLogger().info("Receiver sent failure: " + reply);
                this.sendMessage(reply);
            }
        } else {
            this.getLogger().info("Proposal rejected. Finished.");
        }
    }

    protected boolean isIterated() {
        return (Boolean)this.getParameter("iterated").getValue();
    }

    protected String getShortProtocolName() {
        String ret = "cnp";
        if (this.isIterated()) {
            ret = "icnp";
        }
        return ret;
    }

    public Object[] makeProposal(Object cfp, IComponentIdentifier initiator) {
        IGoal make_proposal = this.createGoal(this.getShortProtocolName() + "_make_proposal");
        make_proposal.getParameter("cfp").setValue(cfp);
        make_proposal.getParameter("initiator").setValue((Object)initiator);
        this.dispatchSubgoalAndWait(make_proposal);
        return new Object[]{make_proposal.getParameter("proposal").getValue(), make_proposal.getParameter("proposal_info").getValue()};
    }

    public Object executeTask(Object proposal, Object proposal_info, IComponentIdentifier initiator) {
        IGoal execute_task = this.createGoal(this.getShortProtocolName() + "_execute_task");
        execute_task.getParameter("proposal").setValue(proposal);
        execute_task.getParameter("proposal_info").setValue(proposal_info);
        execute_task.getParameter("initiator").setValue((Object)initiator);
        this.dispatchSubgoalAndWait(execute_task);
        return execute_task.getParameter("result").getValue();
    }
}

