/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib.protocols;

import jadex.bridge.IComponentIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class InteractionState {
    public static final String INTERACTION_INITIAL = "initial";
    public static final String INTERACTION_RUNNING = "running";
    public static final String INTERACTION_CANCELLED = "cancelled";
    public static final String INTERACTION_FINISHED = "finished";
    public static final String CANCELLATION_SUCCEEDED = "cancellation-succeeded";
    public static final String CANCELLATION_FAILED = "cancellation-failed";
    public static final String CANCELLATION_UNKNOWN = "cancellation-unknown";
    protected String interaction_state = "initial";
    protected Object failure;
    protected Map cancel_responses;
    protected Map cancel_response_contents;

    public Object getFailure() {
        return this.failure;
    }

    public void setFailure(Object failure) {
        this.failure = failure;
    }

    public String getInteractionState() {
        return this.interaction_state;
    }

    public void setInteractionState(String interaction_state) {
        this.interaction_state = interaction_state;
    }

    public void addCancelResponse(IComponentIdentifier responder, String response, Object content) {
        if (this.cancel_responses == null) {
            assert (this.cancel_response_contents == null);
            this.cancel_responses = new HashMap();
            this.cancel_response_contents = new HashMap();
        }
        this.cancel_responses.put(responder, response);
        this.cancel_response_contents.put(responder, content);
    }

    public IComponentIdentifier[] getCancelResponders(String response) {
        IComponentIdentifier[] ret;
        if (this.cancel_responses != null) {
            ArrayList list = new ArrayList();
            for (Object agent : this.cancel_responses.keySet()) {
                if (!response.equals(this.cancel_responses.get(agent))) continue;
                list.add(agent);
            }
            ret = list.toArray(new IComponentIdentifier[list.size()]);
        } else {
            ret = new IComponentIdentifier[]{};
        }
        return ret;
    }

    public String getCancelResponse(IComponentIdentifier responder) {
        String ret = null;
        if (this.cancel_responses != null) {
            ret = (String)this.cancel_responses.get(responder);
        }
        return ret;
    }

    public Object getCancelResponseContent(IComponentIdentifier responder) {
        Object ret = null;
        if (this.cancel_response_contents != null) {
            ret = this.cancel_response_contents.get(responder);
        }
        return ret;
    }
}

