/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib.protocols;

import jadex.bdi.planlib.protocols.IProposalEvaluator;
import jadex.bdi.planlib.protocols.NegotiationRecord;
import jadex.bdi.planlib.protocols.ParticipantProposal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ProposalEvaluator
implements IProposalEvaluator {
    public static final String EVALUATION_INACCEPTABLE = "evaluation-inacceptable";
    public static final String EVALUATION_ACCEPTABLE = "evaluation-acceptable";
    protected Comparator evaluation_comparator;
    protected Object evaluation_limit;
    protected boolean ascending;

    protected ProposalEvaluator() {
    }

    public ProposalEvaluator(Object evaluation_limit, boolean ascending) {
        this.evaluation_limit = evaluation_limit;
        this.ascending = ascending;
    }

    public ProposalEvaluator(Comparator evaluation_comparator, Object evaluation_limit, boolean ascending) {
        this.evaluation_comparator = evaluation_comparator;
        this.evaluation_limit = evaluation_limit;
        this.ascending = ascending;
    }

    @Override
    public ParticipantProposal[] evaluateProposals(Object cfp, Object cfp_info, NegotiationRecord[] history, ParticipantProposal[] proposals) {
        for (int i = 0; i < proposals.length; ++i) {
            proposals[i].setEvaluation(this.evaluateProposal(cfp, cfp_info, history, proposals[i]));
        }
        ArrayList<ParticipantProposal> acceptables = new ArrayList<ParticipantProposal>();
        for (int i = 0; i < proposals.length; ++i) {
            if (!this.isProposalAcceptable(cfp, cfp_info, history, proposals[i])) continue;
            acceptables.add(proposals[i]);
        }
        ParticipantProposal[] ordered = this.orderAcceptables(cfp, cfp_info, history, acceptables.toArray(new ParticipantProposal[acceptables.size()]));
        return ordered;
    }

    protected Object evaluateProposal(Object cfp, Object cfp_info, NegotiationRecord[] history, ParticipantProposal proposal) {
        Object ret = null;
        if (this.isValueComparable(proposal.getProposal())) {
            ret = proposal.getProposal();
        }
        return ret;
    }

    protected boolean isProposalAcceptable(Object cfp, Object cfp_info, NegotiationRecord[] history, ParticipantProposal proposal) {
        boolean ret;
        if (EVALUATION_ACCEPTABLE.equals(proposal.getEvaluation()) || EVALUATION_INACCEPTABLE.equals(proposal.getEvaluation())) {
            ret = !EVALUATION_INACCEPTABLE.equals(proposal.getEvaluation());
        } else if (proposal.getEvaluation() != null && this.evaluation_limit != null) {
            int eval = this.evaluation_comparator != null ? this.evaluation_comparator.compare(proposal.getEvaluation(), this.evaluation_limit) : ((Comparable)proposal.getEvaluation()).compareTo(this.evaluation_limit);
            ret = this.ascending ? eval <= 0 : eval >= 0;
        } else {
            ret = false;
        }
        return ret;
    }

    protected ParticipantProposal[] orderAcceptables(Object cfp, Object cfp_info, NegotiationRecord[] history, ParticipantProposal[] proposals) {
        ArrayList<ParticipantProposal> comparables = new ArrayList<ParticipantProposal>();
        ArrayList<ParticipantProposal> uncomparables = new ArrayList<ParticipantProposal>();
        for (int i = 0; i < proposals.length; ++i) {
            if (this.isValueComparable(proposals[i].getEvaluation())) {
                comparables.add(proposals[i]);
                continue;
            }
            uncomparables.add(proposals[i]);
        }
        Collections.sort(comparables, new Comparator(){

            public int compare(Object o1, Object o2) {
                ParticipantProposal prop1 = (ParticipantProposal)o1;
                ParticipantProposal prop2 = (ParticipantProposal)o2;
                int ret = ProposalEvaluator.this.evaluation_comparator != null ? ProposalEvaluator.this.evaluation_comparator.compare(prop1.getEvaluation(), prop2.getEvaluation()) : ((Comparable)prop1.getEvaluation()).compareTo(prop2.getEvaluation());
                return ProposalEvaluator.this.ascending ? ret : -ret;
            }
        });
        comparables.addAll(uncomparables);
        return comparables.toArray(new ParticipantProposal[comparables.size()]);
    }

    private boolean isValueComparable(Object value) {
        boolean ret;
        if (this.evaluation_comparator != null) {
            try {
                this.evaluation_comparator.compare(value, value);
                ret = true;
            }
            catch (Exception e) {
                ret = false;
            }
        } else {
            ret = value instanceof Comparable;
        }
        return ret;
    }
}

