/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib.protocols.englishauction;

import jadex.bdi.planlib.protocols.AbstractInitiatorPlan;
import jadex.bdi.planlib.protocols.AuctionDescription;
import jadex.bdiv3.runtime.BDIFailureException;
import jadex.bdiv3.runtime.IGoal;
import jadex.bdiv3x.runtime.IMessageEvent;
import jadex.bridge.IComponentIdentifier;
import jadex.commons.SUtil;
import jadex.commons.collection.SCollection;
import jadex.commons.concurrent.TimeoutException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EAInitiatorPlan
extends AbstractInitiatorPlan {
    protected IMessageEvent start;

    @Override
    public void body() {
        super.body();
        AuctionDescription auctiondesc = (AuctionDescription)this.getParameter("auction_description").getValue();
        if (auctiondesc.getRoundTimeout() <= 0L) {
            this.getLogger().warning(this.getComponentName() + "No round timeout specified");
            this.fail();
        }
        long roundtimeout = auctiondesc.getRoundTimeout();
        List receivers = SUtil.arrayToList((Object)this.getParameterSet("receivers").getValues());
        String convid = this.getParameter("conversation_id").getValue() != null ? (String)this.getParameter("conversation_id").getValue() : SUtil.createUniqueId((String)this.getComponentName());
        this.announceAuction(auctiondesc, receivers, convid);
        this.waitForAuctionStart(auctiondesc, receivers);
        boolean running = true;
        Object winning_offer = null;
        IComponentIdentifier winner = null;
        Object cfp = this.getParameter("cfp").getValue();
        Object cfp_info = this.getParameter("cfp_info").getValue();
        ArrayList history = SCollection.createArrayList();
        history.add(cfp);
        while (running && receivers.size() > 0) {
            this.sendCFP(cfp, convid, receivers);
            IComponentIdentifier first = null;
            first = this.waitForProposals(cfp, roundtimeout, receivers);
            if (first != null) {
                winner = first;
                winning_offer = cfp;
                Object[] next = this.decideIteration(cfp_info, history.toArray());
                if (next == null) {
                    running = false;
                    continue;
                }
                cfp = next[0];
                cfp_info = next[1];
                history.add(cfp);
                continue;
            }
            running = false;
        }
        this.evaluateAuctionResults(auctiondesc, cfp_info, history.toArray(), winner, winning_offer);
        this.announceAuctionEnd(receivers, convid, winning_offer, winner);
    }

    public void passed() {
        if (this.start != null) {
            this.getWaitqueue().removeReply(this.start);
        }
        super.passed();
    }

    public void failed() {
        if (this.start != null) {
            this.getWaitqueue().removeReply(this.start);
        }
        super.failed();
    }

    @Override
    public void aborted() {
        if (this.start != null) {
            this.getWaitqueue().removeReply(this.start);
        }
        super.aborted();
    }

    protected void announceAuction(Object auctiondesc, List receivers, String convid) {
        this.start = this.getEventbase().createMessageEvent("ea_inform_start_auction");
        this.start.getParameterSet("receivers").addValues(receivers.toArray());
        this.start.getParameter("content").setValue(auctiondesc);
        this.start.getParameter("conversation_id").setValue((Object)convid);
        this.getLogger().info(this.getComponentName() + ":\tinform_start_auction");
        this.getWaitqueue().addReply(this.start);
        this.sendMessage(this.start);
    }

    protected void waitForAuctionStart(AuctionDescription auctiondesc, List receivers) {
        long timetowait;
        long l = timetowait = auctiondesc.getStarttime() == 0L ? 0L : auctiondesc.getStarttime() - this.getTime();
        while (timetowait > 0L) {
            IMessageEvent removebidder;
            try {
                removebidder = this.waitForReply(this.start, timetowait);
            }
            catch (TimeoutException e) {
                break;
            }
            if (removebidder.getType().equals("ea_not_understood")) {
                receivers.remove(removebidder.getParameter("sender").getValue());
                this.getLogger().info("Removed " + ((IComponentIdentifier)removebidder.getParameter("sender").getValue()).getName() + ".");
            } else {
                this.getLogger().warning("Could not handle message of type " + removebidder.getType() + " from " + ((IComponentIdentifier)removebidder.getParameter("sender").getValue()).getName() + ".");
            }
            timetowait = auctiondesc.getStarttime() - this.getTime();
        }
    }

    protected void sendCFP(Object cfp, String convid, List receivers) {
        IMessageEvent cfpm = this.getEventbase().createMessageEvent("ea_cfp");
        cfpm.getParameterSet("receivers").addValues(receivers.toArray());
        cfpm.getParameter("content").setValue(cfp);
        cfpm.getParameter("conversation_id").setValue((Object)convid);
        this.getLogger().info(this.getComponentName() + ": cfp(" + cfp + ")");
        this.sendMessage(cfpm);
    }

    protected Object[] decideIteration(Object cfp_info, Object[] history) {
        Object[] ret = null;
        IGoal di = this.createGoal("ea_decide_iteration");
        di.getParameter("cfp_info").setValue(cfp_info);
        di.getParameterSet("history").addValues(history);
        try {
            this.dispatchSubgoalAndWait(di);
            ret = new Object[]{di.getParameter("cfp").getValue(), di.getParameter("cfp_info").getValue()};
        }
        catch (BDIFailureException e) {
            this.getLogger().fine("No further iteration: " + (Object)((Object)e));
        }
        return ret;
    }

    protected IComponentIdentifier waitForProposals(Object cfp, long roundtimeout, List receivers) {
        IComponentIdentifier first_proposal = null;
        long roundstart = this.getTime();
        this.getLogger().info(this.getComponentName() + " Waiting for proposals at " + new Date(roundstart));
        try {
            long elapsed = this.getTime() - roundstart;
            while (elapsed < roundtimeout) {
                this.getLogger().info(this.getComponentName() + " Waiting for " + (roundtimeout - elapsed) + " ms");
                IMessageEvent tmp = this.waitForReply(this.start, roundtimeout - elapsed);
                if (tmp.getType().equals("ea_propose")) {
                    if (first_proposal == null) {
                        this.getLogger().info(this.getComponentName() + " got first accept for: " + cfp + " from: " + tmp.getParameter("sender").getValue());
                        IMessageEvent accept = this.getEventbase().createReply(tmp, "ea_accept_proposal");
                        accept.getParameter("content").setValue(cfp);
                        this.sendMessage(accept);
                        first_proposal = (IComponentIdentifier)tmp.getParameter("sender").getValue();
                    } else {
                        this.getLogger().info(this.getComponentName() + " got too late accept for: " + cfp + " from: " + tmp.getParameter("sender").getValue());
                        IMessageEvent reject = this.getEventbase().createReply(tmp, "ea_reject_proposal");
                        this.sendMessage(reject);
                    }
                } else {
                    this.getLogger().info(this.getComponentName() + " removing agent " + tmp.getParameter("sender").getValue());
                    receivers.remove(tmp.getParameter("sender").getValue());
                }
                elapsed = this.getTime() - roundstart;
                this.getLogger().info(this.getComponentName() + " elapsed: " + elapsed + " ms");
            }
        }
        catch (TimeoutException e) {
            this.getLogger().info("Timeout received");
        }
        this.getLogger().info("No further bids in this round");
        return first_proposal;
    }

    protected void evaluateAuctionResults(AuctionDescription auctiondesc, Object cfp_info, Object[] history, IComponentIdentifier winner, Object winning_offer) {
        boolean accept;
        boolean bl = accept = winner != null;
        if (accept) {
            Comparable limit = (Comparable)this.getParameter("limit").getValue();
            if (limit != null) {
                if (limit.compareTo(winning_offer) > 0) {
                    this.getLogger().info("Offer below limit, no winner: " + limit + " " + winning_offer);
                    accept = false;
                }
            } else {
                try {
                    IGoal da = this.createGoal("ea_decide_acceptance");
                    da.getParameter("auction_description").setValue((Object)auctiondesc);
                    da.getParameter("cfp").setValue(winning_offer);
                    da.getParameter("cfp_info").setValue(cfp_info);
                    da.getParameter("winner").setValue((Object)winner);
                    da.getParameterSet("history").addValues(history);
                    this.dispatchSubgoalAndWait(da);
                    accept = (Boolean)da.getParameter("accept").getValue();
                }
                catch (BDIFailureException e) {
                    this.getLogger().info("Decide acceptance goal not handled: " + winning_offer + " " + winner);
                }
            }
        }
        if (accept) {
            this.getLogger().info(this.getComponentName() + ": auction finished (winner: " + winner.getName() + " - price: " + winning_offer + ")");
            this.getParameter("result").setValue((Object)new Object[]{winner, winning_offer});
        } else {
            this.getLogger().info(this.getComponentName() + ": auction finished (no winner - initiator didn't receive any proposals)");
        }
    }

    protected void announceAuctionEnd(List receivers, String convid, Object winning_offer, IComponentIdentifier winner) {
        IMessageEvent end;
        ArrayList losers = SCollection.createArrayList();
        losers.addAll(receivers);
        if (winner != null) {
            end = this.getEventbase().createMessageEvent("ea_inform_end_auction");
            end.getParameter("content").setValue((Object)new Object[]{Boolean.TRUE, winning_offer});
            end.getParameterSet("receivers").addValue((Object)winner);
            end.getParameter("conversation_id").setValue((Object)convid);
            this.sendMessage(end);
            losers.remove(winner);
        }
        if (losers.size() > 0) {
            end = this.getEventbase().createMessageEvent("ea_inform_end_auction");
            end.getParameter("content").setValue((Object)new Object[]{Boolean.FALSE, winning_offer});
            end.getParameterSet("receivers").addValues(losers.toArray());
            end.getParameter("conversation_id").setValue((Object)convid);
            this.sendMessage(end);
        }
        this.getWaitqueue().removeReply(this.start);
    }

    @Override
    protected IMessageEvent getInitialMessage() {
        return this.start;
    }
}

