/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib.protocols.cancelmeta;

import jadex.bdi.planlib.protocols.InteractionState;
import jadex.bdiv3.runtime.IGoal;
import jadex.bdiv3.runtime.impl.GoalFailureException;
import jadex.bdiv3x.runtime.IMessageEvent;
import jadex.bdiv3x.runtime.Plan;

public class CMHandlerPlan
extends Plan {
    protected Object failure_reason;
    protected IMessageEvent cancel_msg;

    public void body() {
        IGoal interaction_goal = (IGoal)this.getParameter("interaction_goal").getValue();
        IMessageEvent inimsg = (IMessageEvent)interaction_goal.getParameter("message").getValue();
        IMessageEvent canceldummy = this.createMessageEvent("cm_cancel");
        canceldummy.getParameter("conversation_id").setValue(inimsg.getParameter("conversation_id").getValue());
        this.cancel_msg = this.waitForReply(canceldummy, "cm_cancel");
        this.getLogger().info("Receiver received cancel: " + this.getComponentName());
        try {
            InteractionState state;
            this.getLogger().info("Receiver approving cancel: " + this.getComponentName());
            IGoal approve_cancel = this.createGoal("cm_approve_cancel");
            approve_cancel.getParameter("conversation_id").setValue(this.cancel_msg.getParameter("conversation_id").getValue());
            approve_cancel.getParameter("protocol").setValue(inimsg.getParameter("protocol").getValue());
            approve_cancel.getParameter("initiator").setValue(this.cancel_msg.getParameter("sender").getValue());
            this.dispatchSubgoalAndWait(approve_cancel);
            this.getLogger().info("Receiver approved cancel: " + this.getComponentName());
            if (!((Boolean)approve_cancel.getParameter("result").getValue()).booleanValue()) {
                this.failure_reason = approve_cancel.getParameter("failure_reason").getValue();
                if (this.failure_reason == null) {
                    this.failure_reason = "Participant did not approve cancel request.";
                }
            }
            if ("running".equals((state = (InteractionState)interaction_goal.getParameter("interaction_state").getValue()).getInteractionState())) {
                state.setInteractionState("cancelled");
            }
            this.getLogger().info("Receiver dropping interaction: " + this.getComponentName() + ", " + interaction_goal);
            interaction_goal.drop();
            try {
                this.waitForGoalFinished(interaction_goal);
            }
            catch (GoalFailureException goalFailureException) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            this.failure_reason = this.failure_reason != null ? this.failure_reason : e.toString();
            IMessageEvent reply = this.getEventbase().createReply(this.cancel_msg, "cm_failure");
            reply.getParameter("content").setValue(this.failure_reason);
            this.sendMessage(reply);
            this.getLogger().info("Receiver sent reply: " + this.getComponentName());
        }
    }

    public void aborted() {
        this.getLogger().info("Receiver aborting: " + this.getComponentName());
        IGoal interaction_goal = (IGoal)this.getParameter("interaction_goal").getValue();
        InteractionState state = (InteractionState)interaction_goal.getParameter("interaction_state").getValue();
        if ("cancelled".equals(state.getInteractionState())) {
            IMessageEvent reply;
            if (this.failure_reason == null) {
                reply = this.getEventbase().createReply(this.cancel_msg, "cm_inform");
            } else {
                reply = this.getEventbase().createReply(this.cancel_msg, "cm_failure");
                reply.getParameter("content").setValue(this.failure_reason);
            }
            this.sendMessage(reply).get();
            this.getLogger().info("Receiver sent reply: " + this.getComponentName());
        } else if ("running".equals(state.getInteractionState())) {
            this.getLogger().info("Receiver cancelling: " + this.getComponentName());
            state.setInteractionState("cancelled");
            IMessageEvent inimsg = (IMessageEvent)interaction_goal.getParameter("message").getValue();
            IMessageEvent reply = this.getEventbase().createReply(inimsg, "cm_not_understood");
            this.sendMessage(reply).get();
            this.getLogger().info("Receiver cancelled: " + this.getComponentName());
        }
        this.getLogger().info("Receiver aborted: " + this.getComponentName());
    }
}

