/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib;

import jadex.bdiv3x.features.IBDIXAgentFeature;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.IComponentDescription;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.IValueFetcher;
import jadex.commons.SUtil;
import jadex.commons.SimplePropertyObject;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.commons.transformation.annotations.Classname;
import jadex.extension.envsupport.environment.IEnvironmentSpace;
import jadex.extension.envsupport.environment.IPerceptProcessor;
import jadex.extension.envsupport.environment.ISpaceObject;
import jadex.extension.envsupport.environment.space2d.Space2D;
import jadex.extension.envsupport.math.IVector1;
import jadex.extension.envsupport.math.IVector2;
import jadex.extension.envsupport.math.Vector1Double;
import jadex.javaparser.IParsedExpression;
import jadex.javaparser.SimpleValueFetcher;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DefaultBDIVisionProcessor
extends SimplePropertyObject
implements IPerceptProcessor {
    public static final String PROPERTY_PERCEPTTYPES = "percepttypes";
    public static final String ADD = "add";
    public static final String REMOVE = "remove";
    public static final String REMOVE_OUTDATED = "remove_outdated";
    public static final String SET = "set";
    public static final String UNSET = "unset";
    public static final String PROPERTY_MAXRANGE = "range";
    public static final String PROPERTY_RANGE = "range_property";
    protected Map percepttypes;

    public void processPercept(final IEnvironmentSpace space, final String type, final Object percept, final IComponentDescription agent, final ISpaceObject avatar) {
        boolean invoke = false;
        final String[][] metainfos = this.getMetaInfos(type);
        for (int i = 0; !invoke && metainfos != null && i < metainfos.length; ++i) {
            invoke = ADD.equals(metainfos[i][0]) || REMOVE.equals(metainfos[i][0]) || SET.equals(metainfos[i][0]) || UNSET.equals(metainfos[i][0]) || REMOVE_OUTDATED.equals(metainfos[i][0]) && percept.equals(avatar);
        }
        if (invoke) {
            SServiceProvider.getService((IExternalAccess)space.getExternalAccess(), IComponentManagementService.class, (String)"platform").addResultListener((IResultListener)new IResultListener<IComponentManagementService>(){

                public void resultAvailable(IComponentManagementService result) {
                    IFuture fut = result.getExternalAccess(agent.getName());
                    fut.addResultListener((IResultListener)new IResultListener<IExternalAccess>(){

                        public void exceptionOccurred(Exception exception) {
                        }

                        public void resultAvailable(IExternalAccess result) {
                            IExternalAccess exta = result;
                            for (int i = 0; i < metainfos.length; ++i) {
                                final IParsedExpression cond = metainfos[i].length == 2 ? null : (IParsedExpression)DefaultBDIVisionProcessor.this.getProperty(metainfos[i][2]);
                                final SimpleValueFetcher fetcher = new SimpleValueFetcher();
                                if (cond != null) {
                                    fetcher.setValue("$space", (Object)space);
                                    fetcher.setValue("$percept", percept);
                                    fetcher.setValue("$avatar", (Object)avatar);
                                    fetcher.setValue("$type", (Object)type);
                                    fetcher.setValue("$aid", (Object)agent);
                                    fetcher.setValue("$scope", (Object)exta);
                                }
                                final String name = metainfos[i][1];
                                if (DefaultBDIVisionProcessor.ADD.equals(metainfos[i][0])) {
                                    exta.scheduleStep((IComponentStep)new IComponentStep<Void>(){

                                        @Classname(value="add")
                                        public IFuture<Void> execute(IInternalAccess ia) {
                                            IBDIXAgentFeature bdif = (IBDIXAgentFeature)ia.getComponentFeature(IBDIXAgentFeature.class);
                                            Object[] facts = bdif.getBeliefbase().getBeliefSet(name).getFacts();
                                            if (cond != null) {
                                                fetcher.setValue("$facts", (Object)facts);
                                            }
                                            if (!SUtil.arrayContains((Object)facts, (Object)percept) && (cond == null || DefaultBDIVisionProcessor.this.evaluate(cond, (IValueFetcher)fetcher))) {
                                                bdif.getBeliefbase().getBeliefSet(name).addFact(percept);
                                            }
                                            return IFuture.DONE;
                                        }
                                    });
                                    continue;
                                }
                                if (DefaultBDIVisionProcessor.REMOVE.equals(metainfos[i][0])) {
                                    exta.scheduleStep((IComponentStep)new IComponentStep<Void>(){

                                        @Classname(value="remove")
                                        public IFuture<Void> execute(IInternalAccess ia) {
                                            IBDIXAgentFeature bdif = (IBDIXAgentFeature)ia.getComponentFeature(IBDIXAgentFeature.class);
                                            Object[] facts = bdif.getBeliefbase().getBeliefSet(name).getFacts();
                                            if (cond != null) {
                                                fetcher.setValue("$facts", (Object)facts);
                                            }
                                            if (SUtil.arrayContains((Object)facts, (Object)percept) && (cond == null || DefaultBDIVisionProcessor.this.evaluate(cond, (IValueFetcher)fetcher))) {
                                                bdif.getBeliefbase().getBeliefSet(name).removeFact(percept);
                                            }
                                            return IFuture.DONE;
                                        }
                                    });
                                    continue;
                                }
                                if (DefaultBDIVisionProcessor.SET.equals(metainfos[i][0])) {
                                    exta.scheduleStep((IComponentStep)new IComponentStep<Void>(){

                                        @Classname(value="set")
                                        public IFuture<Void> execute(IInternalAccess ia) {
                                            IBDIXAgentFeature bdif = (IBDIXAgentFeature)ia.getComponentFeature(IBDIXAgentFeature.class);
                                            Object fact = bdif.getBeliefbase().getBelief(name).getFact();
                                            if (cond != null) {
                                                fetcher.setValue("$fact", fact);
                                            }
                                            if (cond == null || DefaultBDIVisionProcessor.this.evaluate(cond, (IValueFetcher)fetcher)) {
                                                bdif.getBeliefbase().getBelief(name).setFact(percept);
                                            }
                                            return IFuture.DONE;
                                        }
                                    });
                                    continue;
                                }
                                if (DefaultBDIVisionProcessor.UNSET.equals(metainfos[i][0])) {
                                    exta.scheduleStep((IComponentStep)new IComponentStep<Void>(){

                                        @Classname(value="unset")
                                        public IFuture<Void> execute(IInternalAccess ia) {
                                            IBDIXAgentFeature bdif = (IBDIXAgentFeature)ia.getComponentFeature(IBDIXAgentFeature.class);
                                            Object fact = bdif.getBeliefbase().getBelief(name).getFact();
                                            if (cond != null) {
                                                fetcher.setValue("$fact", fact);
                                            }
                                            if (cond == null || DefaultBDIVisionProcessor.this.evaluate(cond, (IValueFetcher)fetcher)) {
                                                bdif.getBeliefbase().getBelief(name).setFact(null);
                                            }
                                            return IFuture.DONE;
                                        }
                                    });
                                    continue;
                                }
                                if (!DefaultBDIVisionProcessor.REMOVE_OUTDATED.equals(metainfos[i][0]) || !percept.equals(avatar)) continue;
                                exta.scheduleStep((IComponentStep)new IComponentStep<Void>(){

                                    @Classname(value="removeoutdated")
                                    public IFuture<Void> execute(IInternalAccess ia) {
                                        IBDIXAgentFeature bdif = (IBDIXAgentFeature)ia.getComponentFeature(IBDIXAgentFeature.class);
                                        Object[] facts = bdif.getBeliefbase().getBeliefSet(name).getFacts();
                                        if (cond != null) {
                                            fetcher.setValue("$facts", (Object)facts);
                                        }
                                        if (cond == null || DefaultBDIVisionProcessor.this.evaluate(cond, (IValueFetcher)fetcher)) {
                                            IVector1 vision = DefaultBDIVisionProcessor.this.getRange(avatar);
                                            Space2D space2d = (Space2D)space;
                                            IVector2 mypos = (IVector2)avatar.getProperty("position");
                                            ISpaceObject[] known = (ISpaceObject[])facts;
                                            Set seen = space2d.getNearObjects(mypos, vision);
                                            for (int j = 0; j < known.length; ++j) {
                                                IVector2 knownpos = (IVector2)known[j].getProperty("position");
                                                if (seen.contains(known[j]) || knownpos != null && vision.less(space2d.getDistance(mypos, knownpos))) continue;
                                                bdif.getBeliefbase().getBeliefSet(name).removeFact((Object)known[j]);
                                            }
                                        }
                                        return IFuture.DONE;
                                    }
                                });
                            }
                        }
                    });
                }

                public void exceptionOccurred(Exception exception) {
                    exception.printStackTrace();
                }
            });
        }
    }

    protected Object[] getPerceptTypes() {
        return (Object[])this.getProperty(PROPERTY_PERCEPTTYPES);
    }

    protected String[][] getMetaInfos(String percepttype) {
        if (this.percepttypes == null) {
            this.percepttypes = new HashMap();
            Object[] percepttypes = this.getPerceptTypes();
            for (int i = 0; i < percepttypes.length; ++i) {
                String[][] stringArrayArray;
                String[] per = (String[])percepttypes[i];
                if (per.length == 3) {
                    String[][] stringArrayArray2 = new String[1][];
                    stringArrayArray = stringArrayArray2;
                    stringArrayArray2[0] = new String[]{per[1], per[2]};
                } else {
                    String[][] stringArrayArray3 = new String[1][];
                    stringArrayArray = stringArrayArray3;
                    stringArrayArray3[0] = new String[]{per[1], per[2], per[3]};
                }
                String[][] newmis = stringArrayArray;
                String[][] oldmis = (String[][])this.percepttypes.get(per[0]);
                if (oldmis != null) {
                    newmis = (String[][])SUtil.joinArrays((Object)oldmis, (Object)newmis);
                }
                this.percepttypes.put(per[0], newmis);
            }
        }
        return (String[][])this.percepttypes.get(percepttype);
    }

    protected IVector1 getRange(ISpaceObject avatar) {
        Object tmp = avatar.getProperty(this.getRangePropertyName());
        return tmp == null ? this.getDefaultRange() : (tmp instanceof Number ? new Vector1Double(((Number)tmp).doubleValue()) : (IVector1)tmp);
    }

    protected IVector1 getDefaultRange() {
        Object tmp = this.getProperty(PROPERTY_MAXRANGE);
        return tmp == null ? Vector1Double.ZERO : (tmp instanceof Number ? new Vector1Double(((Number)tmp).doubleValue()) : (IVector1)tmp);
    }

    protected String getRangePropertyName() {
        Object tmp = this.getProperty(PROPERTY_RANGE);
        return tmp == null ? PROPERTY_MAXRANGE : (String)tmp;
    }

    protected boolean evaluate(IParsedExpression exp, IValueFetcher fetcher) {
        boolean ret = false;
        try {
            ret = (Boolean)exp.getValue(fetcher);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

