/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib.protocols;

import jadex.bdi.planlib.protocols.ParticipantProposal;
import jadex.bridge.IComponentIdentifier;
import jadex.commons.SUtil;
import java.text.SimpleDateFormat;
import java.util.Date;

public class NegotiationRecord {
    protected Object cfp;
    protected Object cfp_info;
    protected ParticipantProposal[] proposals;
    protected long starttime;
    protected long endtime;

    public NegotiationRecord(Object cfp, Object cfp_info, IComponentIdentifier[] participants, long starttime) {
        this.cfp = cfp;
        this.cfp_info = cfp_info;
        this.starttime = starttime;
        this.proposals = new ParticipantProposal[participants.length];
        for (int i = 0; i < this.proposals.length; ++i) {
            this.proposals[i] = new ParticipantProposal(participants[i]);
        }
    }

    public Object getCFP() {
        return this.cfp;
    }

    public void setCFP(Object cfp) {
        this.cfp = cfp;
    }

    public Object getCFPInfo() {
        return this.cfp_info;
    }

    public void setCFPInfo(Object cfp_info) {
        this.cfp_info = cfp_info;
    }

    public long getStarttime() {
        return this.starttime;
    }

    public void setStarttime(long starttime) {
        this.starttime = starttime;
    }

    public long getEndtime() {
        return this.endtime;
    }

    public void setEndtime(long endtime) {
        this.endtime = endtime;
    }

    public ParticipantProposal[] getProposals() {
        return this.proposals;
    }

    public IComponentIdentifier[] getParticipants() {
        IComponentIdentifier[] participants = new IComponentIdentifier[this.proposals.length];
        for (int i = 0; i < participants.length; ++i) {
            participants[i] = this.proposals[i].getParticipant();
        }
        return participants;
    }

    public ParticipantProposal getProposal(IComponentIdentifier participant) {
        ParticipantProposal ret = null;
        for (int i = 0; i < this.proposals.length; ++i) {
            if (!this.proposals[i].getParticipant().equals(participant)) continue;
            if (ret == null) {
                ret = this.proposals[i];
                continue;
            }
            throw new RuntimeException("An agent is not allowed to participate more than once: " + participant);
        }
        return ret;
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy.'-'HH:mm:ss ': '");
        StringBuffer ret = new StringBuffer();
        ret.append("NegotiationRecord(");
        ret.append("starttime: " + sdf.format(new Date(this.starttime)) + ", ");
        ret.append("endtime: " + sdf.format(new Date(this.endtime)) + ", ");
        ret.append("cfp: " + this.cfp + ", ");
        ret.append("proposals: " + SUtil.arrayToString((Object)this.proposals) + ", ");
        ret.append(")");
        return ret.toString();
    }
}

