/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib.protocols;

import jadex.bdi.planlib.protocols.AbstractInitiatorPlan;
import jadex.bdiv3x.runtime.IMessageEvent;
import jadex.commons.SUtil;
import jadex.commons.concurrent.TimeoutException;

public class RPQPInitiatorPlan
extends AbstractInitiatorPlan {
    protected static final String STATUS_TIMEOUT = "timeout";
    protected IMessageEvent request;

    @Override
    public void body() {
        super.body();
        this.getLogger().info("Request/Query initiator action called: " + (Object)((Object)this) + " " + this.getComponentName());
        this.request = this.createMessageEvent(this.getShortProtocolName() + "_request");
        this.request.getParameter("content").setValue(this.getParameter("action").getValue());
        this.request.getParameterSet("receivers").addValue(this.getParameter("receiver").getValue());
        if (this.getParameter("language").getValue() != null) {
            this.request.getParameter("language").setValue(this.getParameter("language").getValue());
        }
        if (this.getParameter("ontology").getValue() != null) {
            this.request.getParameter("ontology").setValue(this.getParameter("ontology").getValue());
        }
        try {
            this.getWaitqueue().addReply(this.request);
            IMessageEvent event = this.sendMessageAndWait(this.request, this.getTimeout());
            event = this.handleFirstAnswer(event);
            this.handleSecondAnswer(event);
        }
        catch (TimeoutException e) {
            this.requestFinished(false, STATUS_TIMEOUT);
        }
        finally {
            this.getWaitqueue().removeReply(this.request);
        }
    }

    protected IMessageEvent handleFirstAnswer(IMessageEvent answer) {
        IMessageEvent ret = null;
        this.getLogger().info("First answer: " + answer + " " + (Object)((Object)this));
        if (answer.getType().equals(this.getShortProtocolName() + "_not_understood") || answer.getType().equals(this.getShortProtocolName() + "_refuse") || answer.getType().equals(this.getShortProtocolName() + "_failure")) {
            Object content = answer.getParameter("content").getValue();
            this.getLogger().info(this.getScope().getAgentName() + ": Received" + answer.getType() + content);
            this.requestFinished(false, new Object[]{answer.getType(), content});
        } else if (answer.getType().equals(this.getShortProtocolName() + "_agree")) {
            this.getLogger().info(this.getScope().getAgentName() + ": Received agree.");
            try {
                ret = this.waitForReply(this.request, this.getTimeout());
            }
            catch (TimeoutException e) {
                this.requestFinished(false, STATUS_TIMEOUT);
            }
        } else if (answer.getType().equals(this.getShortProtocolName() + "_inform")) {
            ret = answer;
        } else assert (false) : "State should not be reached";
        return ret;
    }

    protected void handleSecondAnswer(IMessageEvent answer) {
        this.getLogger().info("Second answer: " + answer + " " + (Object)((Object)this));
        if (answer.getType().equals(this.getShortProtocolName() + "_failure")) {
            Object content = answer.getParameter("content").getValue();
            this.getLogger().info(this.getScope().getAgentName() + ": Received failure: " + content);
            this.requestFinished(false, new Object[]{answer.getType(), content});
        } else if (answer.getType().equals(this.getShortProtocolName() + "_inform")) {
            Object content = answer.getParameter("content").getValue();
            this.getLogger().info(this.getScope().getAgentName() + ": Protocol succeeded.");
            this.requestFinished(true, content);
        } else assert (false) : "State should not be reached";
    }

    protected void requestFinished(boolean success, Object result) {
        this.getLogger().info(this.getShortProtocolName() + " finished with: " + success + " " + SUtil.arrayToString((Object)result) + " " + (Object)((Object)this) + " " + this.getComponentName());
        this.getParameter("result").setValue(result);
        if (!success) {
            this.fail();
        }
    }

    @Override
    protected IMessageEvent getInitialMessage() {
        return this.request;
    }

    protected String getShortProtocolName() {
        String ret = "fipa-request".equals(this.getParameter("protocol").getValue()) ? "rp" : "qp";
        return ret;
    }
}

