/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib.messaging;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class AIM {
    public String tocHost = "toc.oscar.aol.com";
    public int tocPort = 9898;
    public String authHost = "login.oscar.aol.com";
    public int authPort = 5190;
    public String language = "english";
    public String version = "TIC:TOC";
    public String roastString = "Tic/Toc";
    protected short sequence;
    protected Socket connection;
    protected InputStream is;
    protected OutputStream os;
    protected String id;
    private boolean loggedin;
    private String error;
    public static final int SIGNON = 1;
    public static final int DATA = 2;

    public AIM(String id, String password) {
        this.loggedin = this.login(id, password);
    }

    public boolean login(String id, String password) {
        this.id = id;
        try {
            this.connection = new Socket(this.tocHost, this.tocPort);
            this.is = this.connection.getInputStream();
            this.os = this.connection.getOutputStream();
            this.sendRaw("FLAPON\r\n\r\n");
            this.getFlap();
            this.sendFlapSignon();
            String command = "toc2_signon " + this.authHost + " " + this.authPort + " " + id + " " + this.roastPassword(password) + " " + this.language + " \"" + this.version + "\" 160 " + this.calculateCode(id, password);
            this.sendFlap(2, command);
            String str = this.getFlap();
            if (str.toUpperCase().startsWith("ERROR:")) {
                this.error = str;
                return false;
            }
            this.sendFlap(2, "toc_add_buddy " + this.id);
            this.sendFlap(2, "toc_init_done");
            this.sendFlap(2, "toc_set_caps 09461343-4C7F-11D1-8222-444553540000 09461348-4C7F-11D1-8222-444553540000");
            this.sendFlap(2, "toc_add_permit ");
            this.sendFlap(2, "toc_add_deny ");
            return true;
        }
        catch (IOException ioe) {
            this.error = ioe.getMessage();
            return false;
        }
    }

    public void logout() {
        try {
            this.loggedin = false;
            this.connection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String roastPassword(String str) {
        byte[] xor = this.roastString.getBytes();
        int xorIndex = 0;
        String rtn = "0x";
        for (int i = 0; i < str.length(); ++i) {
            String hex = Integer.toHexString(xor[xorIndex] ^ str.charAt(i));
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            rtn = rtn + hex;
            if (++xorIndex != xor.length) continue;
            xorIndex = 0;
        }
        return rtn;
    }

    protected int calculateCode(String uid, String pwd) {
        int sn = uid.charAt(0) - 96;
        int pw = pwd.charAt(0) - 96;
        int a = sn * 7696 + 738816;
        int b = sn * 746512;
        int c = pw * a;
        return c - a + b + 71665152;
    }

    protected void sendRaw(String str) throws IOException {
        this.os.write(str.getBytes());
    }

    protected void writeWord(short word) throws IOException {
        this.os.write((byte)(word >> 8 & 0xFF));
        this.os.write((byte)(word & 0xFF));
    }

    protected void sendFlapSignon() throws IOException {
        int length = 8 + this.id.length();
        this.sequence = (short)(this.sequence + 1);
        this.os.write(42);
        this.os.write(1);
        this.writeWord(this.sequence);
        this.writeWord((short)length);
        this.os.write(0);
        this.os.write(0);
        this.os.write(0);
        this.os.write(1);
        this.os.write(0);
        this.os.write(1);
        this.writeWord((short)this.id.length());
        this.os.write(this.id.getBytes());
        this.os.flush();
    }

    protected void sendFlap(int type, String str) throws IOException {
        int length = str.length() + 1;
        this.sequence = (short)(this.sequence + 1);
        this.os.write(42);
        this.os.write((byte)type);
        this.writeWord(this.sequence);
        this.writeWord((short)length);
        this.os.write(str.getBytes());
        this.os.write(0);
        this.os.flush();
    }

    protected String getFlap() throws IOException {
        if (this.is.read() != 42) {
            return null;
        }
        this.is.read();
        this.is.read();
        this.is.read();
        int length = this.is.read() * 256 + this.is.read();
        byte[] b = new byte[length];
        this.is.read(b);
        return new String(b);
    }

    public void send(String to, String msg) {
        try {
            this.sendFlap(2, "toc_send_im " + this.normalize(to) + " \"" + this.encode(msg) + "\"");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String normalize(String name) {
        String rtn = "";
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == ' ') continue;
            rtn = rtn + Character.toLowerCase(name.charAt(i));
        }
        return rtn;
    }

    protected String encode(String str) {
        String rtn = "";
        block4: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\r': {
                    rtn = rtn + "<br>";
                    continue block4;
                }
                case '\"': 
                case '\\': 
                case '{': 
                case '}': {
                    rtn = rtn + "\\";
                }
                default: {
                    rtn = rtn + str.charAt(i);
                }
            }
        }
        return rtn;
    }

    public String getError() {
        return this.error;
    }

    public boolean isLoggedin() {
        return this.loggedin;
    }
}

