/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib.protocols.contractnet;

import jadex.bdi.planlib.protocols.AbstractInitiatorPlan;
import jadex.bdi.planlib.protocols.NegotiationRecord;
import jadex.bdi.planlib.protocols.ParticipantProposal;
import jadex.bdiv3.runtime.IGoal;
import jadex.bdiv3.runtime.impl.GoalFailureException;
import jadex.bdiv3x.runtime.IMessageEvent;
import jadex.bridge.IComponentIdentifier;
import jadex.commons.SUtil;
import jadex.commons.concurrent.TimeoutException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CNPInitiatorPlan
extends AbstractInitiatorPlan {
    protected IMessageEvent me;

    @Override
    public void body() {
        NegotiationRecord newnr;
        super.body();
        String convid = this.getParameter("conversation_id").getValue() != null ? (String)this.getParameter("conversation_id").getValue() : SUtil.createUniqueId((String)this.getComponentName());
        NegotiationRecord nr = new NegotiationRecord(this.getParameter("cfp").getValue(), this.getParameter("cfp_info").getValue(), (IComponentIdentifier[])this.getParameterSet("receivers").getValues(), this.getTime());
        this.getParameterSet("history").addValue((Object)nr);
        boolean finished = false;
        HashMap proposalmessages = null;
        ParticipantProposal[] acceptables = null;
        while (!finished) {
            this.sendCFP(nr, convid);
            proposalmessages = new HashMap();
            this.collectProposals(nr, proposalmessages);
            acceptables = this.evaluateProposals(nr, proposalmessages);
            nr.setEndtime(this.getTime());
            if (this.isIterated()) {
                newnr = this.queryNextroundInfo(nr);
                if (newnr != null) {
                    this.rejectExcludedProposals(nr, newnr.getParticipants(), proposalmessages);
                    nr = newnr;
                    proposalmessages = null;
                    continue;
                }
                finished = true;
                continue;
            }
            finished = true;
        }
        newnr = (Boolean)this.getParameter("executeall").getValue() != false ? this.acceptAllProposals(nr, acceptables, proposalmessages) : this.acceptOneProposal(nr, acceptables, proposalmessages);
        this.rejectExcludedProposals(nr, newnr.getParticipants(), proposalmessages);
        proposalmessages = null;
        nr = newnr;
        nr.setEndtime(this.getTime());
        this.determineFailure(nr, acceptables);
        for (int i = 0; i < nr.getProposals().length; ++i) {
            if (nr.getProposals()[i].getEvaluation() == null) continue;
            this.getParameterSet("result").addValue(nr.getProposals()[i].getEvaluation());
        }
        this.getParameter("cfp_info").setValue(nr.getCFPInfo());
        this.getLogger().info(this.getComponentName() + "(I)CNPPlan finished: " + convid);
    }

    public void passed() {
        if (this.me != null) {
            this.getWaitqueue().removeReply(this.me);
        }
        super.passed();
    }

    public void failed() {
        if (this.me != null) {
            this.getWaitqueue().removeReply(this.me);
        }
        super.failed();
    }

    @Override
    public void aborted() {
        if (this.me != null) {
            this.getWaitqueue().removeReply(this.me);
        }
        super.aborted();
    }

    protected boolean isIterated() {
        return (Boolean)this.getParameter("iterated").getValue();
    }

    protected String getShortProtocolName() {
        String ret = "cnp";
        if (this.isIterated()) {
            ret = "icnp";
        }
        return ret;
    }

    protected void sendCFP(NegotiationRecord nr, String convid) {
        this.startAtomic();
        if (this.me != null) {
            this.getWaitqueue().removeReply(this.me);
        }
        this.me = this.createMessageEvent(this.getShortProtocolName() + "_cfp");
        this.me.getParameterSet("receivers").addValues((Object[])nr.getParticipants());
        this.me.getParameter("conversation_id").setValue((Object)convid);
        this.me.getParameter("content").setValue(nr.getCFP());
        if (this.getParameter("language").getValue() != null) {
            this.me.getParameter("language").setValue(this.getParameter("language").getValue());
        }
        if (this.getParameter("ontology").getValue() != null) {
            this.me.getParameter("ontology").setValue(this.getParameter("ontology").getValue());
        }
        this.getWaitqueue().addReply(this.me);
        this.endAtomic();
        this.getLogger().info(this.getComponentName() + " (I)CNPPlan initiated: " + convid);
        this.sendMessage(this.me);
    }

    protected void collectProposals(NegotiationRecord nr, Map proposalmessages) {
        List rec = SUtil.arrayToList((Object)nr.getParticipants());
        long time = this.getTime();
        try {
            while (rec.size() > 0) {
                long wait_time;
                if (this.getTimeout() == -1L) {
                    wait_time = -1L;
                } else {
                    wait_time = this.getTimeout() + time - this.getTime();
                    if (wait_time <= 0L) break;
                }
                this.getLogger().info(this.getComponentName() + " (I)CNPPlan: waiting: " + wait_time);
                IMessageEvent reply = this.waitForReply(this.me, wait_time);
                IComponentIdentifier sender = (IComponentIdentifier)reply.getParameter("sender").getValue();
                rec.remove(sender);
                if (!reply.getType().equals(this.getShortProtocolName() + "_propose")) continue;
                this.getLogger().info(this.getComponentName() + " (I)CNPPlan received a proposal reply: " + reply.getParameter("content").getValue());
                ParticipantProposal proposal = nr.getProposal(sender);
                if (proposal != null && proposal.getProposal() == null) {
                    proposal.setProposal(reply.getParameter("content").getValue());
                    proposalmessages.put(proposal, reply);
                    continue;
                }
                this.getLogger().warning(this.getComponentName() + " (I)CNPPlan received an unexpected proposal reply: " + reply);
            }
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    protected ParticipantProposal[] evaluateProposals(NegotiationRecord nr, Map proposalmessages) {
        ParticipantProposal[] acceptables = new ParticipantProposal[]{};
        if (nr.getProposals().length > 0) {
            IGoal sel = this.createGoal(this.getShortProtocolName() + "_evaluate_proposals");
            sel.getParameter("cfp").setValue(nr.getCFP());
            sel.getParameter("cfp_info").setValue(nr.getCFPInfo());
            sel.getParameterSet("history").addValues(this.getParameterSet("history").getValues());
            for (int i = 0; i < nr.getProposals().length; ++i) {
                if (proposalmessages.get(nr.getProposals()[i]) == null) continue;
                sel.getParameterSet("proposals").addValue((Object)nr.getProposals()[i]);
            }
            if (sel.getParameterSet("proposals").size() > 0) {
                try {
                    this.dispatchSubgoalAndWait(sel);
                    acceptables = (ParticipantProposal[])sel.getParameterSet("acceptables").getValues();
                    nr.setCFPInfo(sel.getParameter("cfp_info").getValue());
                    this.getLogger().info(this.getComponentName() + " (I)CNPPlan determined acceptables: " + SUtil.arrayToString((Object)acceptables));
                }
                catch (GoalFailureException e) {
                    this.getLogger().info("(I)CNP: determination of acceptables failed: " + (Object)((Object)e));
                }
            } else {
                this.getLogger().info("(I)CNP: determination of acceptables failed due to no proposals.");
            }
        }
        return acceptables;
    }

    protected NegotiationRecord queryNextroundInfo(NegotiationRecord nr) {
        NegotiationRecord ret = null;
        IGoal sel = this.createGoal(this.getShortProtocolName() + "_nextround_info");
        sel.getParameter("cfp").setValue(nr.getCFP());
        sel.getParameter("cfp_info").setValue(nr.getCFPInfo());
        sel.getParameterSet("participants").addValues((Object[])nr.getParticipants());
        sel.getParameterSet("proposals").addValues((Object[])nr.getProposals());
        sel.getParameterSet("history").addValues(this.getParameterSet("history").getValues());
        try {
            this.dispatchSubgoalAndWait(sel);
            if (((Boolean)sel.getParameter("iterate").getValue()).booleanValue()) {
                Object cfp = sel.getParameter("cfp").getValue();
                Object cfp_info = sel.getParameter("cfp_info").getValue();
                IComponentIdentifier[] participants = (IComponentIdentifier[])sel.getParameterSet("participants").getValues();
                ret = new NegotiationRecord(cfp, cfp_info, participants, this.getTime());
                this.getParameterSet("history").addValue((Object)ret);
                this.getLogger().info("ICNP: perform further negotiation round");
            } else {
                this.getLogger().info("ICNP: perform no further negotiation round");
            }
        }
        catch (GoalFailureException e) {
            this.getLogger().info("ICNP: perform no further negotiation round");
        }
        return ret;
    }

    protected void rejectExcludedProposals(NegotiationRecord nr, IComponentIdentifier[] newparticipants, Map proposalmessages) {
        Set proposals = SUtil.arrayToSet((Object)nr.getProposals());
        Set remaining = SUtil.arrayToSet((Object)newparticipants);
        Iterator it = proposals.iterator();
        while (it.hasNext()) {
            ParticipantProposal proposal = (ParticipantProposal)it.next();
            if (!remaining.contains(proposal.getParticipant())) continue;
            it.remove();
        }
        ParticipantProposal[] reject_proposals = proposals.toArray(new ParticipantProposal[proposals.size()]);
        for (int i = 0; i < reject_proposals.length; ++i) {
            IMessageEvent proposal = (IMessageEvent)proposalmessages.get(reject_proposals[i]);
            if (proposal == null) continue;
            IMessageEvent reject = this.getEventbase().createReply(proposal, this.getShortProtocolName() + "_reject");
            reject.getParameter("content").setValue(reject_proposals[i].getProposal());
            this.sendMessage(reject);
        }
    }

    protected NegotiationRecord acceptAllProposals(NegotiationRecord nr, ParticipantProposal[] acceptables, Map proposalmessages) {
        for (int i = 0; i < acceptables.length; ++i) {
            IMessageEvent proposal = (IMessageEvent)proposalmessages.get(acceptables[i]);
            IMessageEvent accept = this.getEventbase().createReply(proposal, this.getShortProtocolName() + "_accept");
            accept.getParameter("content").setValue(acceptables[i].getProposal());
            this.sendMessage(accept);
        }
        long time = this.getTime();
        HashMap<IComponentIdentifier, Object> results = new HashMap<IComponentIdentifier, Object>();
        try {
            while (results.size() < acceptables.length) {
                long wait_time;
                if (this.getTimeout() == -1L) {
                    wait_time = -1L;
                } else {
                    wait_time = this.getTimeout() + time - this.getTime();
                    if (wait_time <= 0L) break;
                }
                IMessageEvent reply = this.waitForReply(this.me, wait_time);
                IComponentIdentifier sender = (IComponentIdentifier)reply.getParameter("sender").getValue();
                if (reply.getType().equals(this.getShortProtocolName() + "_inform")) {
                    ParticipantProposal proposal = nr.getProposal(sender);
                    if (proposal != null && results.get(sender) == null) {
                        results.put(sender, reply.getParameter("content").getValue());
                        this.getLogger().info("Task was executed: " + (Object)((Object)this) + " " + this.getComponentName() + " " + sender);
                        continue;
                    }
                    this.getLogger().warning(this.getComponentName() + " (I)CNPPlan received an unexpected acceptance reply: " + reply);
                    continue;
                }
                this.getLogger().info("One task was possibly not executed: " + (Object)((Object)this) + " " + this.getComponentName() + " " + sender);
            }
        }
        catch (TimeoutException wait_time) {
            // empty catch block
        }
        IComponentIdentifier[] executed = new IComponentIdentifier[results.size()];
        int index = 0;
        for (int i = 0; i < acceptables.length; ++i) {
            if (!results.containsKey(acceptables[i].getParticipant())) continue;
            executed[index++] = acceptables[i].getParticipant();
        }
        NegotiationRecord ret = new NegotiationRecord(nr.getCFP(), nr.getCFPInfo(), executed, this.getTime());
        this.getParameterSet("history").addValue((Object)ret);
        for (int i = 0; i < ret.getProposals().length; ++i) {
            ret.getProposals()[i].setProposal(nr.getProposal(ret.getProposals()[i].getParticipant()).getProposal());
            ret.getProposals()[i].setEvaluation(results.get(ret.getProposals()[i].getParticipant()));
        }
        return ret;
    }

    protected NegotiationRecord acceptOneProposal(NegotiationRecord nr, ParticipantProposal[] acceptables, Map proposalmessages) {
        IComponentIdentifier[] iComponentIdentifierArray;
        IComponentIdentifier executed = null;
        Object result = null;
        for (int i = 0; i < acceptables.length; ++i) {
            IMessageEvent proposal;
            if (executed == null) {
                try {
                    proposal = (IMessageEvent)proposalmessages.get(acceptables[i]);
                    IMessageEvent accept = this.getEventbase().createReply(proposal, this.getShortProtocolName() + "_accept");
                    accept.getParameter("content").setValue(acceptables[i].getProposal());
                    IMessageEvent reply = this.sendMessageAndWait(accept, this.getTimeout());
                    IComponentIdentifier sender = (IComponentIdentifier)reply.getParameter("sender").getValue();
                    if (reply.getType().equals(this.getShortProtocolName() + "_inform")) {
                        if (nr.getProposal(sender) != null) {
                            executed = sender;
                            result = reply.getParameter("content").getValue();
                            this.getLogger().info("Task was executed: " + (Object)((Object)this) + " " + this.getComponentName() + " " + sender);
                            continue;
                        }
                        this.getLogger().warning(this.getComponentName() + " (I)CNPPlan received an unexpected acceptance reply: " + reply);
                        continue;
                    }
                    this.getLogger().info("One task was possibly not executed: " + (Object)((Object)this) + " " + this.getComponentName() + " " + sender);
                }
                catch (TimeoutException e) {
                    this.getLogger().info("One task was possibly not executed: " + (Object)((Object)this) + " " + this.getComponentName() + " " + acceptables[i].getParticipant());
                }
                continue;
            }
            proposal = (IMessageEvent)proposalmessages.get(acceptables[i]);
            if (proposal == null) continue;
            IMessageEvent reject = this.getEventbase().createReply(proposal, this.getShortProtocolName() + "_reject");
            reject.getParameter("content").setValue(acceptables[i].getProposal());
            this.sendMessage(reject);
        }
        Object object = nr.getCFP();
        Object object2 = nr.getCFPInfo();
        if (executed != null) {
            IComponentIdentifier[] iComponentIdentifierArray2 = new IComponentIdentifier[1];
            iComponentIdentifierArray = iComponentIdentifierArray2;
            iComponentIdentifierArray2[0] = executed;
        } else {
            iComponentIdentifierArray = new IComponentIdentifier[]{};
        }
        NegotiationRecord ret = new NegotiationRecord(object, object2, iComponentIdentifierArray, this.getTime());
        this.getParameterSet("history").addValue((Object)ret);
        if (executed != null) {
            ret.getProposal(executed).setProposal(nr.getProposal(executed).getProposal());
            ret.getProposal(executed).setEvaluation(result);
        }
        return ret;
    }

    protected void determineFailure(NegotiationRecord nr, ParticipantProposal[] acceptables) {
        boolean executeall = (Boolean)this.getParameter("executeall").getValue();
        if (nr.getProposals().length == 0 || executeall && nr.getProposals().length != acceptables.length) {
            this.getLogger().info("(I)CNPPlan failed: ");
            this.fail();
        }
    }

    @Override
    protected IMessageEvent getInitialMessage() {
        return this.me;
    }
}

