/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib.protocols.dutchauction;

import jadex.bdi.planlib.protocols.AbstractInitiatorPlan;
import jadex.bdi.planlib.protocols.AuctionDescription;
import jadex.bdiv3.runtime.BDIFailureException;
import jadex.bdiv3.runtime.IGoal;
import jadex.bdiv3x.runtime.IMessageEvent;
import jadex.bridge.IComponentIdentifier;
import jadex.commons.SUtil;
import jadex.commons.collection.SCollection;
import jadex.commons.concurrent.TimeoutException;
import java.util.ArrayList;
import java.util.List;

public class DAInitiatorPlan
extends AbstractInitiatorPlan {
    protected IMessageEvent start;

    @Override
    public void body() {
        super.body();
        AuctionDescription auctiondesc = (AuctionDescription)this.getParameter("auction_description").getValue();
        if (auctiondesc.getRoundTimeout() <= 0L) {
            this.getLogger().warning(this.getComponentName() + "No round timeout specified");
            this.fail();
        }
        long roundtimeout = auctiondesc.getRoundTimeout();
        List receivers = SUtil.arrayToList((Object)this.getParameterSet("receivers").getValues());
        String convid = this.getParameter("conversation_id").getValue() != null ? (String)this.getParameter("conversation_id").getValue() : SUtil.createUniqueId((String)this.getComponentName());
        this.announceAuction(auctiondesc, receivers, convid);
        this.waitForAuctionStart(auctiondesc, receivers);
        boolean running = true;
        Object winning_offer = null;
        IComponentIdentifier winner = null;
        Object cfp = this.getParameter("cfp").getValue();
        Object cfp_info = this.getParameter("cfp_info").getValue();
        ArrayList history = SCollection.createArrayList();
        history.add(cfp);
        while (running && receivers.size() > 0) {
            this.sendCFP(cfp, convid, receivers);
            winner = this.waitForProposals(cfp, roundtimeout, receivers);
            if (winner != null) {
                winning_offer = cfp;
                running = false;
                continue;
            }
            Object[] next = this.decideIteration(cfp_info, history.toArray());
            if (next == null) {
                running = false;
                continue;
            }
            cfp = next[0];
            cfp_info = next[1];
            history.add(cfp);
        }
        this.evaluateAuctionResults(auctiondesc, cfp_info, history.toArray(), winner, winning_offer);
        this.announceAuctionEnd(receivers, convid, winning_offer, winner);
    }

    public void passed() {
        if (this.start != null) {
            this.getWaitqueue().removeReply(this.start);
        }
        super.passed();
    }

    public void failed() {
        if (this.start != null) {
            this.getWaitqueue().removeReply(this.start);
        }
        super.failed();
    }

    @Override
    public void aborted() {
        if (this.start != null) {
            this.getWaitqueue().removeReply(this.start);
        }
        super.aborted();
    }

    protected void announceAuction(Object auctiondesc, List receivers, String convid) {
        this.start = this.getEventbase().createMessageEvent("da_inform_start_auction");
        this.start.getParameterSet("receivers").addValues(receivers.toArray());
        this.start.getParameter("content").setValue(auctiondesc);
        this.start.getParameter("conversation_id").setValue((Object)convid);
        this.getLogger().info(this.getComponentName() + ": inform_start_auction");
        this.getWaitqueue().addReply(this.start);
        this.sendMessage(this.start);
    }

    protected void waitForAuctionStart(AuctionDescription auctiondesc, List receivers) {
        long timetowait;
        long l = timetowait = auctiondesc.getStarttime() == 0L ? 0L : auctiondesc.getStarttime() - this.getTime();
        while (timetowait > 0L) {
            IMessageEvent removebidder;
            try {
                removebidder = this.waitForReply(this.start, timetowait);
            }
            catch (TimeoutException e) {
                break;
            }
            if (removebidder.getType().equals("da_not_understood")) {
                receivers.remove(removebidder.getParameter("sender").getValue());
                this.getLogger().info("Removed " + ((IComponentIdentifier)removebidder.getParameter("sender").getValue()).getName() + ".");
            } else {
                this.getLogger().warning("Could not handle message of type " + removebidder.getType() + " from " + ((IComponentIdentifier)removebidder.getParameter("sender").getValue()).getName() + ".");
            }
            timetowait = auctiondesc.getStarttime() - this.getTime();
        }
    }

    protected void sendCFP(Object cfp, String convid, List receivers) {
        IMessageEvent cfpm = this.getEventbase().createMessageEvent("da_cfp");
        cfpm.getParameterSet("receivers").addValues(receivers.toArray());
        cfpm.getParameter("content").setValue(cfp);
        cfpm.getParameter("conversation_id").setValue((Object)convid);
        this.getLogger().info(this.getComponentName() + ": cfp(" + cfp + ")");
        this.sendMessage(cfpm);
    }

    protected Object[] decideIteration(Object cfp_info, Object[] history) {
        Object[] ret = null;
        IGoal di = this.createGoal("da_decide_iteration");
        di.getParameter("cfp_info").setValue(cfp_info);
        di.getParameterSet("history").addValues(history);
        try {
            this.dispatchSubgoalAndWait(di);
            ret = new Object[]{di.getParameter("cfp").getValue(), di.getParameter("cfp_info").getValue()};
            this.getLogger().info(this.getComponentName() + "calculated new cfp: " + ret[0]);
        }
        catch (BDIFailureException e) {
            this.getLogger().fine("No further iteration: " + (Object)((Object)e));
        }
        return ret;
    }

    protected IComponentIdentifier waitForProposals(Object cfp, long roundtimeout, List receivers) {
        IComponentIdentifier winner = null;
        long roundstart = this.getTime();
        while (this.getTime() - roundstart < roundtimeout) {
            IMessageEvent tmp = null;
            try {
                tmp = this.waitForReply(this.start, roundtimeout);
                if (tmp.getType().equals("da_propose")) {
                    if (winner == null) {
                        this.sendMessage(this.getEventbase().createReply(tmp, "da_accept_proposal"));
                        this.getLogger().info(this.getComponentName() + " found winner: " + tmp.getParameter("sender").getValue());
                        winner = (IComponentIdentifier)tmp.getParameter("sender").getValue();
                        continue;
                    }
                    this.sendMessage(this.getEventbase().createReply(tmp, "da_reject_proposal"));
                    this.getLogger().info(this.getComponentName() + ": rejected proposal");
                    continue;
                }
                receivers.remove(tmp.getParameter("sender").getValue());
            }
            catch (TimeoutException timeoutException) {}
        }
        return winner;
    }

    protected void evaluateAuctionResults(AuctionDescription auctiondesc, Object cfp_info, Object[] history, IComponentIdentifier winner, Object winning_offer) {
        if (winner == null) {
            this.getLogger().info(this.getComponentName() + ": auction finished (no winner)");
        } else {
            this.getLogger().info(this.getComponentName() + ": auction finished (winner: " + winner.getName() + " - winning offer: " + winning_offer + ")");
            this.getParameter("result").setValue((Object)new Object[]{winner, winning_offer});
        }
    }

    protected void announceAuctionEnd(List receivers, String convid, Object winning_offer, IComponentIdentifier winner) {
        IMessageEvent end;
        ArrayList losers = SCollection.createArrayList();
        losers.addAll(receivers);
        if (winner != null) {
            end = this.getEventbase().createMessageEvent("da_inform_end_auction");
            end.getParameter("content").setValue((Object)new Object[]{Boolean.TRUE, winning_offer});
            end.getParameterSet("receivers").addValue((Object)winner);
            end.getParameter("conversation_id").setValue((Object)convid);
            this.sendMessage(end);
            losers.remove(winner);
        }
        if (losers.size() > 0) {
            end = this.getEventbase().createMessageEvent("da_inform_end_auction");
            end.getParameter("content").setValue((Object)new Object[]{Boolean.FALSE, winning_offer});
            end.getParameterSet("receivers").addValues(losers.toArray());
            end.getParameter("conversation_id").setValue((Object)convid);
            this.sendMessage(end);
        }
        this.getWaitqueue().removeReply(this.start);
    }

    @Override
    protected IMessageEvent getInitialMessage() {
        return this.start;
    }
}

