/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib.protocols;

import jadex.bdi.planlib.protocols.AbstractReceiverPlan;
import jadex.bdiv3.runtime.IGoal;
import jadex.bdiv3.runtime.impl.GoalFailureException;
import jadex.bdiv3x.runtime.IMessageEvent;
import jadex.bridge.IComponentIdentifier;

public class RPQPReceiverPlan
extends AbstractReceiverPlan {
    @Override
    public void body() {
        IMessageEvent reply;
        Object res;
        IMessageEvent me;
        block5: {
            super.body();
            me = (IMessageEvent)this.getParameter("message").getValue();
            this.getLogger().info("Receiver got request: " + me);
            try {
                res = this.decideRequest(me.getParameter("content").getValue(), (IComponentIdentifier)me.getParameter("sender").getValue());
                if (res == null) break block5;
                if (((Boolean)res).booleanValue()) {
                    this.getLogger().info("Receiver sent agree.");
                    reply = this.getEventbase().createReply(me, this.getShortProtocolName() + "_agree");
                    this.sendMessage(reply);
                    break block5;
                }
                this.getLogger().info("Receiver sent refuse.");
                IMessageEvent reply2 = this.getEventbase().createReply(me, this.getShortProtocolName() + "_refuse");
                this.sendMessage(reply2);
                return;
            }
            catch (GoalFailureException e) {
                this.getLogger().info("No agree/refuse sent.");
            }
        }
        try {
            res = this.executeRequest(me.getParameter("content").getValue(), (IComponentIdentifier)me.getParameter("sender").getValue());
            reply = this.getEventbase().createReply(me, this.getShortProtocolName() + "_inform");
            reply.getParameter("content").setValue(res);
            this.getLogger().info("Receiver sent inform.");
            this.sendMessage(reply);
            this.getParameter("result").setValue(res);
        }
        catch (GoalFailureException e) {
            this.getLogger().info("Receiver sent failure: " + (Object)((Object)e));
            reply = this.getEventbase().createReply(me, this.getShortProtocolName() + "_failure");
            this.sendMessage(reply);
        }
    }

    public Boolean decideRequest(Object request, IComponentIdentifier initiator) {
        IGoal decide_request = this.createGoal(this.getShortProtocolName() + "_decide_request");
        decide_request.getParameter("action").setValue(request);
        decide_request.getParameter("initiator").setValue((Object)initiator);
        this.dispatchSubgoalAndWait(decide_request);
        return (Boolean)decide_request.getParameter("accept").getValue();
    }

    public Object executeRequest(Object request, IComponentIdentifier initiator) {
        IGoal execute_request = this.createGoal(this.getShortProtocolName() + "_execute_request");
        execute_request.getParameter("action").setValue(request);
        execute_request.getParameter("initiator").setValue((Object)initiator);
        this.dispatchSubgoalAndWait(execute_request);
        return execute_request.getParameter("result").getValue();
    }

    protected String getShortProtocolName() {
        String ret = "fipa-request".equals(this.getParameter("protocol").getValue()) ? "rp" : "qp";
        return ret;
    }
}

