/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib.protocols;

import jadex.bdi.planlib.protocols.IOfferGenerator;
import jadex.commons.collection.SCollection;
import java.util.List;

public class LinearPriceCalculator
implements IOfferGenerator {
    protected int round;
    protected double startprice;
    protected double limitprice;
    protected List prices;
    protected double variation;
    protected double stepwidth;
    protected double minstepwidth;
    protected boolean increasing;

    public LinearPriceCalculator(double startprice, double limitprice, double base) {
        this(startprice, limitprice, base, 0.0, 0.0);
    }

    public LinearPriceCalculator(double startprice, double limitprice, double stepwidth, double variation, double minstepwidth) {
        this.startprice = startprice;
        this.prices = SCollection.createArrayList();
        this.prices.add(startprice);
        this.limitprice = limitprice;
        this.stepwidth = stepwidth;
        this.variation = variation;
        this.minstepwidth = minstepwidth;
        if (stepwidth < 0.0) {
            throw new IllegalArgumentException("Step width need to be > 0.");
        }
        this.round = 1;
        this.increasing = limitprice > startprice;
    }

    @Override
    public Comparable getCurrentOffer() {
        double ret;
        if (this.prices.size() == this.getRound()) {
            ret = (Double)this.prices.get(this.getRound() - 1);
        } else {
            double lastprice = (Double)this.prices.get(this.getRound() - 2);
            double var = (Math.random() - 0.5) * 2.0 * this.variation;
            ret = this.increasing ? lastprice + this.stepwidth + this.stepwidth * var : lastprice - this.stepwidth + this.stepwidth * var;
            if (this.increasing && ret < lastprice) {
                ret = lastprice + this.minstepwidth;
            } else if (!this.increasing && ret > lastprice) {
                ret = lastprice - this.minstepwidth;
            }
            if (this.increasing && ret > this.limitprice || !this.increasing && ret < this.limitprice) {
                ret = this.limitprice;
            }
            this.prices.add(ret);
        }
        return Double.valueOf(ret);
    }

    @Override
    public Comparable getLastOffer() {
        return this.prices.size() > 1 ? (Comparable)this.prices.get(this.prices.size() - 2) : null;
    }

    @Override
    public Comparable getLimitOffer() {
        return Double.valueOf(this.limitprice);
    }

    @Override
    public Comparable getStartOffer() {
        return Double.valueOf(this.startprice);
    }

    @Override
    public int getRound() {
        return this.round;
    }

    @Override
    public void setNextRound() {
        ++this.round;
    }

    public static void main(String[] args) {
        int i;
        LinearPriceCalculator pc = new LinearPriceCalculator(100.0, 10.0, 10.0, 0.3, 1.0);
        for (i = 0; i < 20; ++i) {
            System.out.println("Price " + i + ": " + pc.getCurrentOffer());
            pc.setNextRound();
        }
        System.out.println();
        pc = new LinearPriceCalculator(100.0, 250.0, 10.0, 0.3, 1.0);
        for (i = 0; i < 20; ++i) {
            System.out.println("Price " + i + ": " + pc.getCurrentOffer());
            pc.setNextRound();
        }
    }
}

