/*
 * Decompiled with CFR 0.152.
 */
package jadex.bdi.planlib.protocols.dutchauction;

import jadex.bdi.planlib.protocols.AbstractReceiverPlan;
import jadex.bdi.planlib.protocols.AuctionDescription;
import jadex.bdiv3.runtime.IGoal;
import jadex.bdiv3.runtime.impl.GoalFailureException;
import jadex.bdiv3x.runtime.IMessageEvent;
import jadex.bridge.IComponentIdentifier;
import jadex.commons.collection.SCollection;
import jadex.commons.concurrent.TimeoutException;
import java.util.ArrayList;
import java.util.List;

public class DAReceiverPlan
extends AbstractReceiverPlan {
    @Override
    public void body() {
        super.body();
        IMessageEvent me = (IMessageEvent)this.getParameter("message").getValue();
        IMessageEvent dummy = this.createMessageEvent("da_propose");
        dummy.getParameter("conversation_id").setValue(me.getParameter("conversation_id").getValue());
        this.getWaitqueue().addReply(dummy);
        AuctionDescription auctiondesc = (AuctionDescription)me.getParameter("content").getValue();
        this.getLogger().info(this.getComponentName() + ": Received inform_start_auction message with auction description " + "start time: " + auctiondesc.getStarttime() + " Round time " + auctiondesc.getRoundTimeout() + " topic: " + auctiondesc.getTopic());
        if (auctiondesc.getRoundTimeout() <= 0L) {
            this.getLogger().warning(this.getComponentName() + "No round timeout specified");
            this.fail();
        }
        Object[] tmp = this.decideParticipation(auctiondesc, (IComponentIdentifier)me.getParameter("sender").getValue());
        boolean participate = (Boolean)tmp[0];
        Object auctioninfo = tmp[1];
        long buftimeout = (long)((double)auctiondesc.getRoundTimeout() * 1.1);
        long firsttimeout = auctiondesc.getStarttime() == 0L || auctiondesc.getStarttime() - this.getTime() <= 0L ? -1L : auctiondesc.getStarttime() - this.getTime() + buftimeout;
        ArrayList offers = SCollection.createArrayList();
        boolean running = true;
        Object winning_offer = null;
        Object auction_wo = null;
        int missing_cnt = 0;
        while (participate && running) {
            try {
                this.getLogger().info(this.getComponentName() + " waiting for: " + (firsttimeout == -1L ? buftimeout : firsttimeout));
                IMessageEvent msg = this.waitForReply(dummy, firsttimeout == -1L ? buftimeout : firsttimeout);
                this.getLogger().info(this.getComponentName() + " received cfp: " + msg.getParameter("content").getValue());
                missing_cnt = 0;
                firsttimeout = -1L;
                if (msg.getType().equals("da_cfp")) {
                    this.handleCFP(msg, auctiondesc, auctioninfo, offers);
                    continue;
                }
                if (msg.getType().equals("da_accept_proposal")) {
                    winning_offer = msg.getParameter("content").getValue();
                    running = false;
                    continue;
                }
                if (msg.getType().equals("da_reject_proposal")) {
                    winning_offer = null;
                    continue;
                }
                if (msg.getType().equals("da_inform_end_auction")) {
                    Object[] res = (Object[])msg.getParameter("content").getValue();
                    if (!((Boolean)res[0]).booleanValue()) {
                        winning_offer = null;
                    }
                    auction_wo = res[1];
                    running = false;
                    continue;
                }
                this.getLogger().warning("Could not understand: " + msg + " " + msg.getType());
            }
            catch (TimeoutException e) {
                this.getLogger().info(this.getComponentName() + " " + e.getMessage());
                if (++missing_cnt != 3) continue;
                running = false;
            }
        }
        if (!running) {
            this.getParameter("result").setValue((Object)new Object[]{winning_offer, auction_wo});
        }
        this.getWaitqueue().removeReply(dummy);
    }

    protected Object[] decideParticipation(AuctionDescription auctiondesc, IComponentIdentifier initiator) {
        Object[] ret = new Object[]{Boolean.TRUE, null};
        try {
            IGoal dp = this.getScope().getGoalbase().createGoal("da_decide_participation");
            dp.getParameter("auction_description").setValue((Object)auctiondesc);
            dp.getParameter("initiator").setValue((Object)initiator);
            this.dispatchSubgoalAndWait(dp);
            ret[1] = dp.getParameter("auction_info").getValue();
            Boolean part = (Boolean)dp.getParameter("participate").getValue();
            ret[0] = part == null ? Boolean.TRUE : part;
        }
        catch (GoalFailureException e) {
            this.getLogger().info("Optional goal ea_decide_request has not been handled.");
        }
        return ret;
    }

    protected Object[] handleCFP(IMessageEvent cfp, AuctionDescription auctiondesc, Object auctioninfo, List offers) {
        Object[] ret = new Object[]{Boolean.TRUE, auctioninfo};
        IGoal mp = this.createGoal("da_make_proposal");
        Object offer = cfp.getParameter("content").getValue();
        offers.add(offer);
        mp.getParameter("cfp").setValue(offer);
        mp.getParameter("auction_description").setValue((Object)auctiondesc);
        mp.getParameter("auction_info").setValue(auctioninfo);
        mp.getParameterSet("history").addValues(offers.toArray());
        try {
            this.dispatchSubgoalAndWait(mp, auctiondesc.getRoundTimeout());
        }
        catch (Exception e) {
            this.getLogger().info(this.getComponentName() + e.getMessage());
        }
        ret[1] = mp.getParameter("auction_info").getValue();
        Boolean leave = (Boolean)mp.getParameter("leave").getValue();
        Boolean accept = (Boolean)mp.getParameter("accept").getValue();
        if (leave != null && leave.booleanValue()) {
            this.getLogger().info(this.getComponentName() + " informs the initiator of the auction " + auctiondesc.getTopic() + " that it doesn't want to participate.");
            this.sendMessage(this.getEventbase().createReply(cfp, "da_not_understood"));
            ret[0] = Boolean.FALSE;
        } else if (accept != null && accept.booleanValue()) {
            this.sendMessage(this.getEventbase().createReply(cfp, "da_propose"));
            this.getLogger().info(this.getComponentName() + " accepted proposal: " + cfp.getParameter("content").getValue());
        } else {
            this.getLogger().info(this.getComponentName() + " does not accept proposal and waits: " + cfp.getParameter("content").getValue());
        }
        return ret;
    }
}

