/*
 * Decompiled with CFR 0.152.
 */
package act.db.morphia.util;

import act.app.App;
import act.db.morphia.util.KVStoreConverter;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.mongodb.morphia.converters.SimpleValueConverter;
import org.mongodb.morphia.converters.TypeConverter;
import org.mongodb.morphia.mapping.MappedField;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.KVStore;
import org.osgl.util.ValueObject;

@Singleton
public class ValueObjectConverter
extends TypeConverter
implements SimpleValueConverter {
    public static final ValueObjectConverter INSTANCE = new ValueObjectConverter();

    public ValueObjectConverter() {
        this.setSupportedTypes(new Class[]{ValueObject.class});
    }

    public Object decode(Class<?> aClass, Object o, MappedField mappedField) {
        if (o instanceof DBObject) {
            if (o instanceof BasicDBObject) {
                BasicDBObject dbObject = (BasicDBObject)o;
                String valueType = dbObject.getString("t");
                Class cls = $.classForName((String)valueType, (ClassLoader)App.instance().classLoader());
                if (Map.class.isAssignableFrom(cls)) {
                    return new KVStoreConverter().decode(cls, dbObject.get("v"));
                }
                if (List.class.isAssignableFrom(cls)) {
                    BasicDBList dbList = (BasicDBList)$.cast((Object)dbObject.get("v"));
                    C.List list = C.newSizedList((int)dbList.size());
                    for (Object item : dbList) {
                        list.add(ValueObject.of((Object)this.decode(ValueObject.class, item)));
                    }
                    return list;
                }
                String valueString = dbObject.getString("v");
                o = ValueObject.decode((String)valueString, (Class)cls);
            } else if (o instanceof BasicDBList) {
                BasicDBList dbList = (BasicDBList)o;
                ArrayList<ValueObject> list = new ArrayList<ValueObject>();
                for (Object element : dbList) {
                    list.add(ValueObject.of(element));
                }
                return list;
            }
        }
        return ValueObject.of((Object)o);
    }

    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (!(value instanceof ValueObject)) {
            return value;
        }
        ValueObject vo = (ValueObject)value;
        if (vo.isUDF()) {
            Object v = vo.value();
            Class<?> type = v.getClass();
            if (Map.class.isAssignableFrom(type)) {
                v = new KVStoreConverter().encode(v, optionalExtraInfo);
            } else if (List.class.isAssignableFrom(type)) {
                BasicDBList dbList = new BasicDBList();
                List list = (List)v;
                for (Object item : list) {
                    dbList.add(this.encode(ValueObject.of(item), optionalExtraInfo));
                }
                v = dbList;
            } else {
                v = ValueObject.encode((Object)v);
            }
            BasicDBObject dbObject = new BasicDBObject();
            dbObject.put("v", v);
            String typeName = type.getName();
            if (JSONObject.class.getName().equals(typeName)) {
                typeName = KVStore.class.getName();
            }
            dbObject.put("t", (Object)typeName);
            return dbObject;
        }
        return vo.value();
    }
}

