/*
 * Decompiled with CFR 0.152.
 */
package act.db.morphia.util;

import act.Act;
import act.app.App;
import act.db.morphia.annotation.PersistAsList;
import act.db.morphia.annotation.PersistAsMap;
import act.db.morphia.util.ValueObjectConverter;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.util.HashMap;
import java.util.Map;
import org.mongodb.morphia.converters.SimpleValueConverter;
import org.mongodb.morphia.converters.TypeConverter;
import org.mongodb.morphia.mapping.MappedField;
import org.mongodb.morphia.utils.IterHelper;
import org.osgl.util.KV;
import org.osgl.util.KVStore;
import org.osgl.util.S;
import org.osgl.util.ValueObject;

public class KVStoreConverter
extends TypeConverter
implements SimpleValueConverter {
    public static final String KEY = "k";
    public static final String VALUE = "v";
    public static final String UDF_TYPE = "t";
    private ValueObjectConverter valueObjectConverter;
    private boolean persistAsList;

    public KVStoreConverter() {
        this.setSupportedTypes(new Class[]{KVStore.class, KV.class});
        this.valueObjectConverter = new ValueObjectConverter();
        Object o = App.instance().config().get("morphia.kvstore.persist.structure");
        if (null != o) {
            this.persistAsList = S.eq((String)S.string((Object)o), (String)"list", (int)4096);
        }
    }

    public Object decode(Class<?> aClass, Object fromDB, MappedField mappedField) {
        KVStore store = new KVStore();
        boolean isStore = aClass.isInstance(store);
        if (null == fromDB) {
            return isStore ? store : Act.app().getInstance(aClass);
        }
        if (fromDB instanceof BasicDBList) {
            BasicDBList dbList = (BasicDBList)fromDB;
            int sz = dbList.size();
            for (int i = 0; i < sz; ++i) {
                BasicDBObject dbObj = (BasicDBObject)dbList.get(i);
                String key = dbObj.getString(KEY);
                Object val = dbObj.get(VALUE);
                store.putValue(key, this.valueObjectConverter.decode(ValueObject.class, val));
            }
        } else if (fromDB instanceof BasicDBObject) {
            new IterHelper().loopMap(fromDB, (IterHelper.MapIterCallback)new IterHelper.MapIterCallback<Object, Object>((KV)store){
                final /* synthetic */ KV val$store;
                {
                    this.val$store = kV;
                }

                public void eval(Object k, Object val) {
                    String key = S.string((Object)k);
                    this.val$store.putValue(key, KVStoreConverter.this.valueObjectConverter.decode(ValueObject.class, val));
                }
            });
        }
        if (isStore) {
            return store;
        }
        Map retVal = (Map)Act.app().getInstance(aClass);
        retVal.putAll(store.toMap());
        return retVal;
    }

    public Object encode(Object value, MappedField optionalExtraInfo) {
        boolean persistAsList;
        if (null == value) {
            return null;
        }
        Map map = (Map)value;
        boolean bl = persistAsList = this.persistAsList || null != optionalExtraInfo && optionalExtraInfo.hasAnnotation(PersistAsList.class) && !optionalExtraInfo.hasAnnotation(PersistAsMap.class);
        if (persistAsList) {
            BasicDBList list = new BasicDBList();
            for (String key : map.keySet()) {
                ValueObject vo = ValueObject.of(map.get(key));
                BasicDBObject dbObject = new BasicDBObject();
                dbObject.put((Object)KEY, (Object)key);
                dbObject.put((Object)VALUE, this.valueObjectConverter.encode(vo, optionalExtraInfo));
                list.add((Object)dbObject);
            }
            return list;
        }
        return this.encodeAsMap(map);
    }

    public Map<String, Object> encodeAsMap(Map<String, ?> map) {
        HashMap<String, Object> mapForDb = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            mapForDb.put(entry.getKey(), this.valueObjectConverter.encode(entry.getValue(), null));
        }
        return mapForDb;
    }
}

